/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.command.AuthenticationCommandBase;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.mysqlclient.impl.util.RsaPublicKeyEncryptor;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;

abstract class AuthenticationCommandBaseCodec<R, C extends AuthenticationCommandBase<R>>
extends CommandCodec<R, C> {
    protected static final int NONCE_LENGTH = 20;
    protected static final int AUTH_SWITCH_REQUEST_STATUS_FLAG = 254;
    protected static final int AUTH_MORE_DATA_STATUS_FLAG = 1;
    protected static final int AUTH_PUBLIC_KEY_REQUEST_FLAG = 2;
    protected static final int FAST_AUTH_STATUS_FLAG = 3;
    protected static final int FULL_AUTHENTICATION_STATUS_FLAG = 4;
    protected byte[] authPluginData;
    private boolean isWaitingForRsaPublicKey = false;

    AuthenticationCommandBaseCodec(C cmd) {
        super(cmd);
    }

    protected final void handleAuthMoreData(byte[] password, ByteBuf payload) {
        payload.skipBytes(1);
        if (this.isWaitingForRsaPublicKey) {
            String serverRsaPublicKey = this.readRestOfPacketString(payload, StandardCharsets.UTF_8);
            this.sendEncryptedPasswordWithServerRsaPublicKey(password, serverRsaPublicKey);
        } else {
            byte flag = payload.readByte();
            if (flag == 4) {
                if (this.encoder.socketConnection.isSsl()) {
                    int nonScrambledPasswordPacketLength = password.length + 1;
                    ByteBuf nonScrambledPasswordPacket = this.allocateBuffer(nonScrambledPasswordPacketLength + 4);
                    nonScrambledPasswordPacket.writeMediumLE(nonScrambledPasswordPacketLength);
                    nonScrambledPasswordPacket.writeByte(this.sequenceId);
                    nonScrambledPasswordPacket.writeBytes(password);
                    nonScrambledPasswordPacket.writeByte(0);
                    this.sendNonSplitPacket(nonScrambledPasswordPacket);
                } else {
                    Buffer serverRsaPublicKey = ((AuthenticationCommandBase)this.cmd).serverRsaPublicKey();
                    if (serverRsaPublicKey == null) {
                        this.isWaitingForRsaPublicKey = true;
                        ByteBuf rsaPublicKeyRequest = this.allocateBuffer(5);
                        rsaPublicKeyRequest.writeMediumLE(1);
                        rsaPublicKeyRequest.writeByte(this.sequenceId);
                        rsaPublicKeyRequest.writeByte(2);
                        this.sendNonSplitPacket(rsaPublicKeyRequest);
                    } else {
                        this.sendEncryptedPasswordWithServerRsaPublicKey(password, serverRsaPublicKey.toString());
                    }
                }
            } else if (flag != 3) {
                this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)new UnsupportedOperationException("Unsupported flag for AuthMoreData : " + flag)));
            }
        }
    }

    protected final void sendEncryptedPasswordWithServerRsaPublicKey(byte[] password, String serverRsaPublicKeyContent) {
        byte[] encryptedPassword;
        try {
            byte[] passwordInput = Arrays.copyOf(password, password.length + 1);
            encryptedPassword = RsaPublicKeyEncryptor.encrypt(passwordInput, this.authPluginData, serverRsaPublicKeyContent);
        }
        catch (Exception e) {
            this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)e));
            return;
        }
        this.sendBytesAsPacket(encryptedPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void encodeConnectionAttributes(Map<String, String> clientConnectionAttributes, ByteBuf packet) {
        ByteBuf kv = null;
        try {
            kv = this.allocateBuffer();
            for (Map.Entry<String, String> attribute : clientConnectionAttributes.entrySet()) {
                BufferUtils.writeLengthEncodedString(kv, attribute.getKey(), StandardCharsets.UTF_8);
                BufferUtils.writeLengthEncodedString(kv, attribute.getValue(), StandardCharsets.UTF_8);
            }
            BufferUtils.writeLengthEncodedInteger(packet, kv.readableBytes());
            packet.writeBytes(kv);
        }
        finally {
            if (kv != null) {
                ReferenceCountUtil.release((Object)kv);
            }
        }
    }
}

