/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.data;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class NullValue {
    private static final Map<Class<?>, NullValue> cached = new HashMap();
    public static final NullValue Boolean = NullValue.createAndCache(Boolean.class);
    public static final NullValue Short = NullValue.createAndCache(Short.class);
    public static final NullValue Integer = NullValue.createAndCache(Integer.class);
    public static final NullValue Long = NullValue.createAndCache(Long.class);
    public static final NullValue Float = NullValue.createAndCache(Float.class);
    public static final NullValue Double = NullValue.createAndCache(Double.class);
    public static final NullValue String = NullValue.createAndCache(String.class);
    public static final NullValue JsonObject = NullValue.createAndCache(JsonObject.class);
    public static final NullValue JsonArray = NullValue.createAndCache(JsonArray.class);
    public static final NullValue Temporal = NullValue.createAndCache(Temporal.class);
    public static final NullValue LocalDate = NullValue.createAndCache(LocalDate.class);
    public static final NullValue LocalTime = NullValue.createAndCache(LocalTime.class);
    public static final NullValue LocalDateTime = NullValue.createAndCache(LocalDateTime.class);
    public static final NullValue OffsetTime = NullValue.createAndCache(OffsetTime.class);
    public static final NullValue OffsetDateTime = NullValue.createAndCache(OffsetDateTime.class);
    public static final NullValue Buffer = NullValue.createAndCache(Buffer.class);
    public static final NullValue UUID = NullValue.createAndCache(UUID.class);
    public static final NullValue BigDecimal = NullValue.createAndCache(BigDecimal.class);
    public static final NullValue ArrayOfBoolean = NullValue.createAndCache(Boolean[].class);
    public static final NullValue ArrayOfShort = NullValue.createAndCache(Short[].class);
    public static final NullValue ArrayOfInteger = NullValue.createAndCache(Integer[].class);
    public static final NullValue ArrayOfLong = NullValue.createAndCache(Long[].class);
    public static final NullValue ArrayOfFloat = NullValue.createAndCache(Float[].class);
    public static final NullValue ArrayOfDouble = NullValue.createAndCache(Double[].class);
    public static final NullValue ArrayOfString = NullValue.createAndCache(String[].class);
    public static final NullValue ArrayOfJsonObject = NullValue.createAndCache(JsonObject[].class);
    public static final NullValue ArrayOfJsonArray = NullValue.createAndCache(JsonArray[].class);
    public static final NullValue ArrayOfTemporal = NullValue.createAndCache(Temporal[].class);
    public static final NullValue ArrayOfLocalDate = NullValue.createAndCache(LocalDate[].class);
    public static final NullValue ArrayOfLocalTime = NullValue.createAndCache(LocalTime[].class);
    public static final NullValue ArrayOfLocalDateTime = NullValue.createAndCache(LocalDateTime[].class);
    public static final NullValue ArrayOfOffsetTime = NullValue.createAndCache(OffsetTime[].class);
    public static final NullValue ArrayOfOffsetDateTime = NullValue.createAndCache(OffsetDateTime[].class);
    public static final NullValue ArrayOfBuffer = NullValue.createAndCache(Buffer[].class);
    public static final NullValue ArrayOfUUID = NullValue.createAndCache(UUID[].class);
    public static final NullValue ArrayOfBigDecimal = NullValue.createAndCache(BigDecimal[].class);
    private final Class<?> type;

    private static NullValue createAndCache(Class<?> type) {
        NullValue instance = new NullValue(type);
        cached.put(type, instance);
        return instance;
    }

    private NullValue(Class<?> type) {
        this.type = type;
    }

    public static NullValue of(Class<?> type) {
        NullValue instance = cached.get(Objects.requireNonNull(type, "type cannot be null"));
        if (instance == null) {
            Class<?> c;
            boolean array = type.isArray();
            Class<?> clazz = c = array ? type.getComponentType() : type;
            instance = Temporal.class.isAssignableFrom(c) ? (array ? ArrayOfTemporal : Temporal) : (Buffer.class.isAssignableFrom(c) ? (array ? ArrayOfBuffer : Buffer) : new NullValue(type));
        }
        return instance;
    }

    public Class<?> type() {
        return this.type;
    }
}

