/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public abstract class ConnectionFactoryBase
implements ConnectionFactory {
    public static final String NATIVE_TRANSPORT_REQUIRED = "The Vertx instance must use a native transport in order to connect to connect through domain sockets";
    protected final VertxInternal vertx;
    protected final NetClient netClient;
    protected final Map<String, String> properties;
    protected final SqlConnectOptions options;
    protected final SocketAddress server;
    protected final String user;
    protected final String password;
    protected final String database;
    protected final boolean cachePreparedStatements;
    protected final int preparedStatementCacheSize;
    protected final Predicate<String> preparedStatementCacheSqlFilter;
    protected final CloseFuture clientCloseFuture = new CloseFuture();
    private final int reconnectAttempts;
    private final long reconnectInterval;

    protected ConnectionFactoryBase(VertxInternal vertx, SqlConnectOptions options) {
        if (options.isUsingDomainSocket() && !vertx.isNativeTransportEnabled()) {
            throw new IllegalArgumentException(NATIVE_TRANSPORT_REQUIRED);
        }
        this.vertx = vertx;
        this.properties = options.getProperties() == null ? null : Collections.unmodifiableMap(options.getProperties());
        this.server = options.getSocketAddress();
        this.options = options;
        this.user = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        this.reconnectAttempts = options.getReconnectAttempts();
        this.reconnectInterval = options.getReconnectInterval();
        this.initializeConfiguration(options);
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.configureNetClientOptions(netClientOptions);
        netClientOptions.setReconnectAttempts(0);
        this.netClient = vertx.createNetClient(netClientOptions, this.clientCloseFuture);
    }

    public static EventLoopContext asEventLoopContext(ContextInternal ctx) {
        if (ctx instanceof EventLoopContext) {
            return (EventLoopContext)ctx;
        }
        return ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
    }

    public Future<Connection> connect(EventLoopContext context) {
        PromiseInternal promise = context.promise();
        context.emit((Object)promise, p -> this.doConnectWithRetry(this.server, this.user, this.password, this.database, (PromiseInternal<Connection>)p, this.reconnectAttempts));
        return promise.future();
    }

    public void close(Promise<Void> promise) {
        this.clientCloseFuture.close(promise);
    }

    private void doConnectWithRetry(SocketAddress server, String username, String password, String database, PromiseInternal<Connection> promise, int remainingAttempts) {
        EventLoopContext ctx = (EventLoopContext)promise.context();
        this.doConnectInternal(server, username, password, database, ctx).onComplete(ar -> {
            if (ar.succeeded()) {
                promise.complete(ar.result());
            } else if (remainingAttempts > 0) {
                ctx.owner().setTimer(this.reconnectInterval, id -> this.doConnectWithRetry(server, username, password, database, promise, remainingAttempts - 1));
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    protected abstract void initializeConfiguration(SqlConnectOptions var1);

    protected abstract void configureNetClientOptions(NetClientOptions var1);

    protected abstract Future<Connection> doConnectInternal(SocketAddress var1, String var2, String var3, String var4, EventLoopContext var5);
}

