/*
 * Decompiled with CFR 0.152.
 */
package brave.context.log4j12;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.apache.log4j.MDC;

public final class MDCCurrentTraceContext
extends CurrentTraceContext {
    final CurrentTraceContext delegate;

    public static MDCCurrentTraceContext create() {
        return MDCCurrentTraceContext.create(CurrentTraceContext.Default.inheritable());
    }

    public static MDCCurrentTraceContext create(CurrentTraceContext delegate) {
        return new MDCCurrentTraceContext(delegate);
    }

    MDCCurrentTraceContext(CurrentTraceContext delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public TraceContext get() {
        return this.delegate.get();
    }

    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        return this.newScope(currentSpan, MDCCurrentTraceContext.getIfString("traceId"), MDCCurrentTraceContext.getIfString("spanId"));
    }

    public CurrentTraceContext.Scope maybeScope(@Nullable TraceContext currentSpan) {
        String previousTraceId = MDCCurrentTraceContext.getIfString("traceId");
        String previousSpanId = MDCCurrentTraceContext.getIfString("spanId");
        if (currentSpan == null) {
            if (previousTraceId == null) {
                return CurrentTraceContext.Scope.NOOP;
            }
            return this.newScope(null, previousTraceId, previousSpanId);
        }
        if (HexCodec.lowerHexEqualsTraceId((CharSequence)previousTraceId, (TraceContext)currentSpan) && HexCodec.lowerHexEqualsUnsignedLong((CharSequence)previousSpanId, (long)currentSpan.spanId())) {
            return CurrentTraceContext.Scope.NOOP;
        }
        return this.newScope(currentSpan, previousTraceId, previousSpanId);
    }

    CurrentTraceContext.Scope newScope(TraceContext currentSpan, final String previousTraceId, final String previousSpanId) {
        final String previousParentId = MDCCurrentTraceContext.getIfString("parentId");
        if (currentSpan != null) {
            this.maybeReplaceTraceContext(currentSpan, previousTraceId, previousParentId, previousSpanId);
        } else {
            MDC.remove((String)"traceId");
            MDC.remove((String)"parentId");
            MDC.remove((String)"spanId");
        }
        final CurrentTraceContext.Scope scope = this.delegate.newScope(currentSpan);
        class MDCCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            MDCCurrentTraceContextScope() {
            }

            public void close() {
                scope.close();
                MDCCurrentTraceContext.replace("traceId", previousTraceId);
                MDCCurrentTraceContext.replace("parentId", previousParentId);
                MDCCurrentTraceContext.replace("spanId", previousSpanId);
            }
        }
        return new MDCCurrentTraceContextScope();
    }

    void maybeReplaceTraceContext(TraceContext currentSpan, String previousTraceId, @Nullable String previousParentId, String previousSpanId) {
        long parentId;
        boolean sameTraceId = HexCodec.lowerHexEqualsTraceId((CharSequence)previousTraceId, (TraceContext)currentSpan);
        if (!sameTraceId) {
            MDC.put((String)"traceId", (Object)currentSpan.traceIdString());
        }
        if ((parentId = currentSpan.parentIdAsLong()) == 0L) {
            MDC.remove((String)"parentId");
        } else {
            boolean sameParentId = HexCodec.lowerHexEqualsUnsignedLong((CharSequence)previousParentId, (long)parentId);
            if (!sameParentId) {
                MDC.put((String)"parentId", (Object)HexCodec.toLowerHex((long)parentId));
            }
        }
        boolean sameSpanId = HexCodec.lowerHexEqualsUnsignedLong((CharSequence)previousSpanId, (long)currentSpan.spanId());
        if (!sameSpanId) {
            MDC.put((String)"spanId", (Object)HexCodec.toLowerHex((long)currentSpan.spanId()));
        }
    }

    static String getIfString(String key) {
        Object result = MDC.get((String)key);
        return result instanceof String ? (String)result : null;
    }

    static void replace(String key, @Nullable Object value) {
        if (value != null) {
            MDC.put((String)key, (Object)value);
        } else {
            MDC.remove((String)key);
        }
    }
}

