/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.zipkin.gen;

import com.github.kristofa.brave.internal.Util;
import java.io.Serializable;
import java.util.Arrays;

public class Endpoint
implements Serializable {
    static final long serialVersionUID = 1L;
    public final int ipv4;
    public final byte[] ipv6;
    public final Short port;
    public final String service_name;

    @Deprecated
    public static Endpoint create(String serviceName, int ipv4, int port) {
        return new Endpoint(serviceName, ipv4, null, port == 0 ? null : Short.valueOf((short)(port & 0xFFFF)));
    }

    public static Endpoint create(String serviceName, int ipv4) {
        return new Endpoint(serviceName, ipv4, null, null);
    }

    Endpoint(String service_name, int ipv4, byte[] ipv6, Short port) {
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
        this.port = port;
        service_name = service_name != null ? service_name.toLowerCase() : "";
        this.service_name = service_name;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            Endpoint that = (Endpoint)o;
            return Util.equal(this.service_name, that.service_name) && this.ipv4 == that.ipv4 && Arrays.equals(this.ipv6, that.ipv6) && Util.equal(this.port, that.port);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.service_name.hashCode();
        h *= 1000003;
        h ^= this.ipv4;
        h *= 1000003;
        h ^= Arrays.hashCode(this.ipv6);
        h *= 1000003;
        return h ^= this.port == null ? 0 : this.port.hashCode();
    }

    public String toString() {
        return zipkin.Endpoint.builder().serviceName(this.service_name).port(this.port).ipv4(this.ipv4).ipv6(this.ipv6).build().toString();
    }

    public static final class Builder {
        private String serviceName;
        private Integer ipv4;
        private byte[] ipv6;
        private Short port;

        Builder() {
        }

        Builder(Endpoint source) {
            this.serviceName = source.service_name;
            this.ipv4 = source.ipv4;
            this.ipv6 = source.ipv6;
            this.port = source.port;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder ipv4(int ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public Builder ipv6(byte[] ipv6) {
            if (ipv6 != null) {
                zipkin.internal.Util.checkArgument((ipv6.length == 16 ? 1 : 0) != 0, (String)("ipv6 addresses are 16 bytes: " + ipv6.length), (Object[])new Object[0]);
                this.ipv6 = ipv6;
            }
            return this;
        }

        public Builder port(int port) {
            zipkin.internal.Util.checkArgument((port >= 0 && port <= 65535 ? 1 : 0) != 0, (String)"invalid port %s", (Object[])new Object[]{port});
            this.port = port == 0 ? null : Short.valueOf((short)(port & 0xFFFF));
            return this;
        }

        public Builder port(Short port) {
            if (port == null || port != 0) {
                this.port = port;
            }
            return this;
        }

        public Endpoint build() {
            Util.checkNotNull(this.serviceName, "serviceName", new Object[0]);
            return new Endpoint(this.serviceName, this.ipv4 == null ? 0 : this.ipv4, this.ipv6, this.port);
        }
    }
}

