/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpHandler;
import brave.http.HttpSampler;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import zipkin2.Endpoint;

public final class HttpClientHandler<Req, Resp>
extends HttpHandler<Req, Resp, HttpClientAdapter<Req, Resp>> {
    final Tracer tracer;
    final Sampler sampler;
    final HttpSampler httpSampler;
    final String serverName;
    final boolean serverNameSet;

    public static <Req, Resp> HttpClientHandler<Req, Resp> create(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        return new HttpClientHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpClientHandler(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        super(httpTracing.tracing().currentTraceContext(), adapter, httpTracing.clientParser());
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.tracing().sampler();
        this.httpSampler = httpTracing.clientSampler();
        this.serverName = httpTracing.serverName();
        this.serverNameSet = !this.serverName.equals("");
    }

    public Span handleSend(TraceContext.Injector<Req> injector, Req request) {
        return this.handleSend(injector, request, request);
    }

    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request) {
        return this.handleSend(injector, carrier, request, this.nextSpan(request));
    }

    public Span handleSend(TraceContext.Injector<Req> injector, Req request, Span span) {
        return this.handleSend(injector, request, request, span);
    }

    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request, Span span) {
        injector.inject(span.context(), carrier);
        span.kind(Span.Kind.CLIENT);
        return this.handleStart(request, span);
    }

    @Override
    boolean parseRemoteEndpoint(Req request, Endpoint.Builder remoteEndpoint) {
        remoteEndpoint.serviceName(this.serverName);
        return ((HttpClientAdapter)this.adapter).parseServerAddress(request, remoteEndpoint) || this.serverNameSet;
    }

    public Span nextSpan(Req request) {
        Sampler override = this.httpSampler.toSampler(this.adapter, request, this.sampler);
        return this.tracer.withSampler(override).nextSpan();
    }

    public void handleReceive(@Nullable Resp response, @Nullable Throwable error, Span span) {
        this.handleFinish(response, error, span);
    }
}

