/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.Span;
import brave.Tracer;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.rpc.RpcClientRequest;
import brave.rpc.RpcClientResponse;
import brave.rpc.RpcHandler;
import brave.rpc.RpcRequest;
import brave.rpc.RpcTracing;
import brave.sampler.SamplerFunction;

public final class RpcClientHandler
extends RpcHandler<RpcClientRequest, RpcClientResponse> {
    final Tracer tracer;
    final SamplerFunction<RpcRequest> sampler;
    final TraceContext.Injector<RpcClientRequest> injector;

    public static RpcClientHandler create(RpcTracing rpcTracing) {
        if (rpcTracing == null) {
            throw new NullPointerException("rpcTracing == null");
        }
        return new RpcClientHandler(rpcTracing);
    }

    RpcClientHandler(RpcTracing rpcTracing) {
        super(rpcTracing.clientRequestParser(), rpcTracing.clientResponseParser());
        this.tracer = rpcTracing.tracing().tracer();
        this.injector = rpcTracing.propagation().injector(RpcClientRequest.SETTER);
        this.sampler = rpcTracing.clientSampler();
    }

    public Span handleSend(RpcClientRequest request) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        return this.handleSend(request, this.tracer.nextSpan(this.sampler, (Object)request));
    }

    public Span handleSendWithParent(RpcClientRequest request, @Nullable TraceContext parent) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        return this.handleSend(request, this.tracer.nextSpanWithParent(this.sampler, (Object)request, parent));
    }

    public Span handleSend(RpcClientRequest request, Span span) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        this.injector.inject(span.context(), (Object)request);
        return this.handleStart(request, span);
    }

    public void handleReceive(RpcClientResponse response, Span span) {
        this.handleFinish(response, span);
    }
}

