/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class TracingClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    public static ClientHttpRequestInterceptor create(Tracing tracing) {
        return TracingClientHttpRequestInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static ClientHttpRequestInterceptor create(HttpTracing httpTracing) {
        return new TracingClientHttpRequestInterceptor(httpTracing);
    }

    @Autowired
    TracingClientHttpRequestInterceptor(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    /*
     * Loose catch block
     */
    public ClientHttpResponse intercept(HttpRequest req, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse clientHttpResponse;
        CurrentTraceContext.Scope ws;
        Throwable error;
        ClientHttpResponse result;
        Span span;
        HttpRequestWrapper request;
        block10: {
            request = new HttpRequestWrapper(req);
            span = this.handler.handleSend((HttpClientRequest)request);
            result = null;
            error = null;
            ws = this.currentTraceContext.newScope(span.context());
            clientHttpResponse = result = execution.execute(req, body);
            if (ws == null) break block10;
            ws.close();
        }
        ClientHttpResponseWrapper response = result != null ? new ClientHttpResponseWrapper(request, result, error) : null;
        this.handler.handleReceive((Object)response, error, span);
        return clientHttpResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    ClientHttpResponseWrapper response2 = result != null ? new ClientHttpResponseWrapper(request, result, error) : null;
                    this.handler.handleReceive((Object)response2, error, span);
                    throw throwable3;
                }
            }
        }
    }

    static final class HttpRequestWrapper
    extends HttpClientRequest {
        final HttpRequest delegate;

        HttpRequestWrapper(HttpRequest delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethod().name();
        }

        public String path() {
            return this.delegate.getURI().getPath();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            String result = this.delegate.getHeaders().getFirst(name);
            return result != null ? result.toString() : null;
        }

        public void header(String name, String value) {
            this.delegate.getHeaders().set(name, value);
        }
    }

    static final class ClientHttpResponseWrapper
    extends HttpClientResponse {
        final HttpRequestWrapper request;
        final ClientHttpResponse response;
        @Nullable
        final Throwable error;

        ClientHttpResponseWrapper(HttpRequestWrapper request, ClientHttpResponse response, @Nullable Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public Object unwrap() {
            return this.response;
        }

        public HttpRequestWrapper request() {
            return this.request;
        }

        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            try {
                return this.response.getRawStatusCode();
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

