/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.webmvc;

import brave.http.HttpTracing;
import brave.servlet.TracingFilter;
import brave.spring.webmvc.WebMvcRuntime;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class DelegatingTracingFilter
implements Filter {
    Filter delegate;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Filter tracingFilter = this.delegate;
        if (tracingFilter == null) {
            chain.doFilter(request, response);
        } else {
            tracingFilter.doFilter(request, response, chain);
        }
    }

    public void init(FilterConfig filterConfig) {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        HttpTracing httpTracing = WebMvcRuntime.get().httpTracing((ApplicationContext)ctx);
        this.delegate = TracingFilter.create((HttpTracing)httpTracing);
    }

    public void destroy() {
    }
}

