/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.collector.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin.collector.rabbitmq.RabbitMQCollector;

@ConfigurationProperties(value="zipkin.collector.rabbitmq")
public class ZipkinRabbitMQCollectorProperties {
    private List<String> addresses;
    private Integer concurrency = 1;
    private Integer connectionTimeout;
    private String password;
    private String queue;
    private String username;
    private String virtualHost;

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public RabbitMQCollector.Builder toBuilder() {
        RabbitMQCollector.Builder result = RabbitMQCollector.builder();
        ConnectionFactory connectionFactory = new ConnectionFactory();
        if (this.addresses != null) {
            result.addresses(this.addresses);
        }
        if (this.concurrency != null) {
            result.concurrency(this.concurrency.intValue());
        }
        if (this.connectionTimeout != null) {
            connectionFactory.setConnectionTimeout(this.connectionTimeout.intValue());
        }
        if (this.password != null) {
            connectionFactory.setPassword(this.password);
        }
        if (this.queue != null) {
            result.queue(this.queue);
        }
        if (this.username != null) {
            connectionFactory.setUsername(this.username);
        }
        if (this.virtualHost != null) {
            connectionFactory.setVirtualHost(this.virtualHost);
        }
        result.connectionFactory(connectionFactory);
        return result;
    }
}

