/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.cassandra3;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin.autoconfigure.storage.cassandra3.ZipkinCassandra3StorageProperties;
import zipkin.storage.StorageComponent;
import zipkin.storage.cassandra3.Cassandra3Storage;

@Configuration
@EnableConfigurationProperties(value={ZipkinCassandra3StorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="cassandra3")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinCassandra3StorageAutoConfiguration {
    @Autowired(required=false)
    @Qualifier(value="tracingSessionFactory")
    Cassandra3Storage.SessionFactory tracingSessionFactory;

    @Bean
    StorageComponent storage(ZipkinCassandra3StorageProperties properties, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId) {
        Cassandra3Storage.Builder builder = properties.toBuilder().strictTraceId(strictTraceId);
        return this.tracingSessionFactory == null ? builder.build() : builder.sessionFactory(this.tracingSessionFactory).build();
    }
}

