/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.cassandra3.brave;

import com.datastax.driver.core.Session;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.SpanCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import zipkin.autoconfigure.storage.cassandra3.brave.TracedSession;
import zipkin.storage.cassandra3.Cassandra3Storage;

@ConditionalOnBean(value={Brave.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="cassandra3")
@Configuration
public class TraceZipkinCassandra3StorageAutoConfiguration {
    final Cassandra3Storage.SessionFactory delegate = Cassandra3Storage.SessionFactory.DEFAULT;
    @Autowired
    @Lazy
    Brave brave;
    @Autowired
    @Lazy
    SpanCollector collector;

    @Bean
    Cassandra3Storage.SessionFactory tracingSessionFactory() {
        return new Cassandra3Storage.SessionFactory(){

            public Session create(Cassandra3Storage storage) {
                return TracedSession.create(TraceZipkinCassandra3StorageAutoConfiguration.this.delegate.create(storage), TraceZipkinCassandra3StorageAutoConfiguration.this.brave, TraceZipkinCassandra3StorageAutoConfiguration.this.collector);
            }
        };
    }
}

