/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.cassandra3.brave;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanId;
import com.google.common.collect.Maps;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.internal.Util;

public final class TracedSession
extends AbstractInvocationHandler
implements LatencyTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TracedSession.class);
    private final ProtocolVersion version;
    final Session target;
    final Brave brave;
    final SpanCollector collector;
    final Map<BoundStatement, Span> cache = Maps.newConcurrentMap();

    public static Session create(Session target, Brave brave, SpanCollector collector) {
        return (Session)Reflection.newProxy(Session.class, (InvocationHandler)((Object)new TracedSession(target, brave, collector)));
    }

    TracedSession(Session target, Brave brave, SpanCollector collector) {
        this.target = (Session)Util.checkNotNull((Object)target, (String)"target");
        this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave");
        this.collector = (SpanCollector)Util.checkNotNull((Object)collector, (String)"collector");
        this.version = target.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        target.getCluster().register((LatencyTracker)this);
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.brave.serverSpanThreadBinder().getCurrentServerSpan() != null && this.brave.serverSpanThreadBinder().getCurrentServerSpan().getSpan() != null && method.getName().equals("executeAsync") && args[0] instanceof BoundStatement) {
            BoundStatement statement = (BoundStatement)args[0];
            SpanId spanId = this.brave.clientTracer().startNewSpan(statement.toString());
            if (this.version.compareTo((Enum)ProtocolVersion.V4) >= 0) {
                statement.enableTracing();
                statement.setOutgoingPayload(Collections.singletonMap("zipkin", ByteBuffer.wrap(spanId.bytes())));
            }
            this.brave.clientTracer().setClientSent();
            this.brave.clientTracer().submitBinaryAnnotation("cql.query", statement.preparedStatement().getQueryString());
            this.cache.put(statement, this.brave.clientSpanThreadBinder().getCurrentClientSpan());
            this.brave.clientSpanThreadBinder().setCurrentSpan(null);
            return new BraveResultSetFuture(this.target.executeAsync((Statement)statement), this.brave);
        }
        try {
            return method.invoke((Object)this.target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public void update(Host host, Statement statement, Exception e, long nanos) {
        if (!(statement instanceof BoundStatement)) {
            return;
        }
        Span span = this.cache.remove(statement);
        if (span == null) {
            if (statement.isTracing()) {
                LOG.warn("{} not in the cache eventhough tracing is on", (Object)statement);
            }
            return;
        }
        span.setDuration(Long.valueOf(nanos / 1000L));
        Endpoint local = ((Annotation)span.getAnnotations().get((int)0)).host;
        long endTs = span.getTimestamp() + span.getDuration();
        span.addToAnnotations(Annotation.create((long)endTs, (String)"cr", (Endpoint)local));
        if (e != null) {
            span.addToBinary_annotations(BinaryAnnotation.create((String)"error", (String)e.getMessage(), (Endpoint)local));
        }
        int ipv4 = ByteBuffer.wrap(host.getAddress().getAddress()).getInt();
        Endpoint endpoint = Endpoint.create((String)"cassandra3", (int)ipv4, (int)host.getSocketAddress().getPort());
        span.addToBinary_annotations(BinaryAnnotation.address((String)"sa", (Endpoint)endpoint));
        this.collector.collect(span);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TracedSession) {
            TracedSession other = (TracedSession)((Object)obj);
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    public void onRegister(Cluster cluster) {
    }

    public void onUnregister(Cluster cluster) {
    }

    static class BraveResultSetFuture<T>
    implements ResultSetFuture {
        final ResultSetFuture delegate;
        final ServerSpanThreadBinder threadBinder;
        final ServerSpan parent;

        BraveResultSetFuture(ResultSetFuture delegate, Brave brave) {
            this.delegate = delegate;
            this.threadBinder = brave.serverSpanThreadBinder();
            this.parent = this.threadBinder.getCurrentServerSpan();
        }

        public ResultSet getUninterruptibly() {
            return this.delegate.getUninterruptibly();
        }

        public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
            return this.delegate.getUninterruptibly(timeout, unit);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        public ResultSet get() throws InterruptedException, ExecutionException {
            return (ResultSet)this.delegate.get();
        }

        public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (ResultSet)this.delegate.get(timeout, unit);
        }

        public void addListener(Runnable listener, Executor executor) {
            this.delegate.addListener(() -> {
                this.threadBinder.setCurrentSpan(this.parent);
                try {
                    listener.run();
                }
                finally {
                    this.threadBinder.setCurrentSpan(null);
                }
            }, executor);
        }
    }
}

