/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.http.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.BraveExecutorService;
import com.github.kristofa.brave.okhttp.BraveTracingInterceptor;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@ConditionalOnBean(value={Brave.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
@Configuration
public class TraceZipkinElasticsearchHttpStorageAutoConfiguration {
    @Autowired
    @Lazy
    Brave brave;

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @ConditionalOnMissingBean
    OkHttpClient.Builder elasticsearchOkHttpClientBuilder() {
        Interceptor tracingInterceptor = new Interceptor(){
            Interceptor delegate;
            {
                this.delegate = BraveTracingInterceptor.builder((Brave)TraceZipkinElasticsearchHttpStorageAutoConfiguration.this.brave).serverName("elasticsearch").build();
            }

            public Response intercept(Interceptor.Chain chain) throws IOException {
                if (TraceZipkinElasticsearchHttpStorageAutoConfiguration.this.brave.serverSpanThreadBinder().getCurrentServerSpan() != null && TraceZipkinElasticsearchHttpStorageAutoConfiguration.this.brave.serverSpanThreadBinder().getCurrentServerSpan().getSpan() != null) {
                    return this.delegate.intercept(chain);
                }
                return chain.proceed(chain.request());
            }
        };
        BraveExecutorService tracePropagatingExecutor = BraveExecutorService.wrap((ExecutorService)new Dispatcher().executorService(), (Brave)this.brave);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor(tracingInterceptor);
        builder.addNetworkInterceptor(tracingInterceptor);
        builder.dispatcher(new Dispatcher((ExecutorService)tracePropagatingExecutor));
        return builder;
    }
}

