/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class ActuateCollectorMetrics
implements CollectorMetrics,
PublicMetrics {
    private final ConcurrentHashMap<String, CounterBuffer> counterBuffers;
    private final ConcurrentHashMap<String, GaugeBuffer> gaugeBuffers;
    private final String messages;
    private final String messagesDropped;
    private final String messageBytes;
    private final String messageSpans;
    private final String bytes;
    private final String spans;
    private final String spansDropped;

    public ActuateCollectorMetrics() {
        this(new ConcurrentHashMap<String, CounterBuffer>(), new ConcurrentHashMap<String, GaugeBuffer>(), null);
    }

    ActuateCollectorMetrics(ConcurrentHashMap<String, CounterBuffer> counterBuffers, ConcurrentHashMap<String, GaugeBuffer> gaugeBuffers, @Nullable String transport) {
        this.counterBuffers = counterBuffers;
        this.gaugeBuffers = gaugeBuffers;
        String footer = transport == null ? "" : "." + transport;
        this.messages = "counter.zipkin_collector.messages" + footer;
        this.messagesDropped = "counter.zipkin_collector.messages_dropped" + footer;
        this.messageBytes = "gauge.zipkin_collector.message_bytes" + footer;
        this.messageSpans = "gauge.zipkin_collector.message_spans" + footer;
        this.bytes = "counter.zipkin_collector.bytes" + footer;
        this.spans = "counter.zipkin_collector.spans" + footer;
        this.spansDropped = "counter.zipkin_collector.spans_dropped" + footer;
    }

    public ActuateCollectorMetrics forTransport(String transportType) {
        Util.checkNotNull((Object)transportType, (String)"transportType");
        return new ActuateCollectorMetrics(this.counterBuffers, this.gaugeBuffers, transportType);
    }

    public void incrementMessages() {
        this.increment(this.messages, 1L);
    }

    public void incrementMessagesDropped() {
        this.increment(this.messagesDropped, 1L);
    }

    public void incrementSpans(int quantity) {
        this.set(this.messageSpans, quantity);
        this.increment(this.spans, quantity);
    }

    public void incrementBytes(int quantity) {
        this.set(this.messageBytes, quantity);
        this.increment(this.bytes, quantity);
    }

    public void incrementSpansDropped(int quantity) {
        this.increment(this.spansDropped, quantity);
    }

    void clear() {
        this.counterBuffers.clear();
        this.gaugeBuffers.clear();
    }

    public Collection<Metric<?>> metrics() {
        ArrayList metrics = new ArrayList();
        this.gaugeBuffers.forEach((key, gauge) -> metrics.add(gauge.toMetric((String)key)));
        this.counterBuffers.forEach((key, counter) -> metrics.add(counter.toMetric((String)key)));
        return metrics;
    }

    void increment(String name, long delta) {
        CounterBuffer buffer = ActuateCollectorMetrics.computeIfAbsent(this.counterBuffers, name, CounterBuffer::new);
        buffer.timestamp = System.currentTimeMillis();
        buffer.count.add(delta);
    }

    void set(String name, double value) {
        GaugeBuffer buffer = ActuateCollectorMetrics.computeIfAbsent(this.gaugeBuffers, name, GaugeBuffer::new);
        buffer.timestamp = System.currentTimeMillis();
        buffer.value = value;
    }

    static <K, V> V computeIfAbsent(ConcurrentHashMap<K, V> map, K key, Supplier<V> valueFunction) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        return (V)map.computeIfAbsent(key, ignored -> valueFunction.get());
    }

    static class GaugeBuffer {
        volatile long timestamp;
        volatile double value;

        GaugeBuffer() {
        }

        Metric<Double> toMetric(String key) {
            return new Metric(key, (Number)this.value, new Date(this.timestamp));
        }
    }

    static class CounterBuffer {
        volatile long timestamp;
        final LongAdder count = new LongAdder();

        CounterBuffer() {
        }

        Metric<Long> toMetric(String key) {
            return new Metric(key, (Number)this.count.sum(), new Date(this.timestamp));
        }
    }
}

