/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra3;

import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.Future;
import zipkin.Component;
import zipkin.internal.LazyCloseable;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.StorageComponent;
import zipkin.storage.cassandra3.CassandraSpanConsumer;
import zipkin.storage.cassandra3.CassandraSpanStore;
import zipkin.storage.cassandra3.DefaultSessionFactory;
import zipkin.storage.guava.LazyGuavaStorageComponent;

public final class Cassandra3Storage
extends LazyGuavaStorageComponent<CassandraSpanStore, CassandraSpanConsumer> {
    final int maxTraceCols;
    final String contactPoints;
    final int maxConnections;
    final String localDc;
    final String username;
    final String password;
    final boolean ensureSchema;
    final boolean useSsl;
    final String keyspace;
    final int indexFetchMultiplier;
    final boolean strictTraceId;
    final LazyCloseable<Session> session;

    public static Builder builder() {
        return new Builder();
    }

    Cassandra3Storage(Builder builder) {
        this.contactPoints = builder.contactPoints;
        this.maxConnections = builder.maxConnections;
        this.localDc = builder.localDc;
        this.username = builder.username;
        this.password = builder.password;
        this.ensureSchema = builder.ensureSchema;
        this.useSsl = builder.useSsl;
        this.keyspace = builder.keyspace;
        this.maxTraceCols = builder.maxTraceCols;
        this.indexFetchMultiplier = builder.indexFetchMultiplier;
        this.strictTraceId = builder.strictTraceId;
        final SessionFactory sessionFactory = builder.sessionFactory;
        this.session = new LazyCloseable<Session>(){

            protected Session compute() {
                return sessionFactory.create(Cassandra3Storage.this);
            }
        };
    }

    public Session session() {
        return (Session)this.session.get();
    }

    protected CassandraSpanStore computeGuavaSpanStore() {
        return new CassandraSpanStore((Session)this.session.get(), this.maxTraceCols, this.indexFetchMultiplier, this.strictTraceId);
    }

    protected CassandraSpanConsumer computeGuavaSpanConsumer() {
        return new CassandraSpanConsumer((Session)this.session.get(), this.strictTraceId);
    }

    public Component.CheckResult check() {
        try {
            ((Session)this.session.get()).execute((Statement)QueryBuilder.select((String[])new String[]{"trace_id"}).from("traces").limit(1));
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
        return Component.CheckResult.OK;
    }

    public void close() throws IOException {
        this.session.close();
    }

    @VisibleForTesting
    void clear() {
        LinkedList<ResultSetFuture> futures = new LinkedList<ResultSetFuture>();
        for (String cf : ImmutableList.of((Object)"traces", (Object)"trace_by_service_span", (Object)"span_name_by_service", (Object)"dependencies")) {
            futures.add(((Session)this.session.get()).executeAsync(String.format("TRUNCATE %s", cf)));
        }
        Futures.getUnchecked((Future)Futures.allAsList(futures));
    }

    public static final class Builder
    implements StorageComponent.Builder {
        boolean strictTraceId = true;
        String keyspace = "zipkin3";
        String contactPoints = "localhost";
        String localDc;
        int maxConnections = 8;
        boolean ensureSchema = true;
        boolean useSsl = false;
        String username;
        String password;
        int maxTraceCols = 100000;
        int indexFetchMultiplier = 3;
        SessionFactory sessionFactory = SessionFactory.DEFAULT;

        public Builder strictTraceId(boolean strictTraceId) {
            this.strictTraceId = strictTraceId;
            return this;
        }

        public Builder sessionFactory(SessionFactory sessionFactory) {
            this.sessionFactory = (SessionFactory)Util.checkNotNull((Object)sessionFactory, (String)"sessionFactory");
            return this;
        }

        public Builder keyspace(String keyspace) {
            this.keyspace = (String)Util.checkNotNull((Object)keyspace, (String)"keyspace");
            return this;
        }

        public Builder contactPoints(String contactPoints) {
            this.contactPoints = (String)Util.checkNotNull((Object)contactPoints, (String)"contactPoints");
            return this;
        }

        public Builder localDc(@Nullable String localDc) {
            this.localDc = localDc;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder ensureSchema(boolean ensureSchema) {
            this.ensureSchema = ensureSchema;
            return this;
        }

        public Builder useSsl(boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder maxTraceCols(int maxTraceCols) {
            this.maxTraceCols = maxTraceCols;
            return this;
        }

        public Builder indexFetchMultiplier(int indexFetchMultiplier) {
            this.indexFetchMultiplier = indexFetchMultiplier;
            return this;
        }

        public Cassandra3Storage build() {
            return new Cassandra3Storage(this);
        }

        Builder() {
        }
    }

    public static interface SessionFactory {
        public static final SessionFactory DEFAULT = new DefaultSessionFactory();

        public Session create(Cassandra3Storage var1);
    }
}

