/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra3;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.UUIDs;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.storage.cassandra3.CassandraUtil;
import zipkin.storage.cassandra3.Schema;
import zipkin.storage.guava.GuavaSpanConsumer;

final class CassandraSpanConsumer
implements GuavaSpanConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSpanConsumer.class);
    private static final Function<Object, Void> TO_VOID = Functions.constant(null);
    private final Session session;
    private final boolean strictTraceId;
    private final PreparedStatement insertSpan;
    private final PreparedStatement insertTraceServiceSpanName;
    private final PreparedStatement insertServiceSpanName;
    private final Schema.Metadata metadata;

    CassandraSpanConsumer(Session session, boolean strictTraceId) {
        this.session = session;
        this.strictTraceId = strictTraceId;
        this.metadata = Schema.readMetadata(session);
        this.insertSpan = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"traces").value("trace_id", (Object)QueryBuilder.bindMarker((String)"trace_id")).value("ts_uuid", (Object)QueryBuilder.bindMarker((String)"ts_uuid")).value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("ts", (Object)QueryBuilder.bindMarker((String)"ts")).value("span_name", (Object)QueryBuilder.bindMarker((String)"span_name")).value("parent_id", (Object)QueryBuilder.bindMarker((String)"parent_id")).value("duration", (Object)QueryBuilder.bindMarker((String)"duration")).value("annotations", (Object)QueryBuilder.bindMarker((String)"annotations")).value("binary_annotations", (Object)QueryBuilder.bindMarker((String)"binary_annotations")).value("all_annotations", (Object)QueryBuilder.bindMarker((String)"all_annotations")));
        this.insertTraceServiceSpanName = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"trace_by_service_span").value("service_name", (Object)QueryBuilder.bindMarker((String)"service_name")).value("span_name", (Object)QueryBuilder.bindMarker((String)"span_name")).value("bucket", (Object)QueryBuilder.bindMarker((String)"bucket")).value("ts", (Object)QueryBuilder.bindMarker((String)"ts")).value("trace_id", (Object)QueryBuilder.bindMarker((String)"trace_id")).value("duration", (Object)QueryBuilder.bindMarker((String)"duration")));
        this.insertServiceSpanName = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"span_name_by_service").value("service_name", (Object)QueryBuilder.bindMarker((String)"service_name")).value("span_name", (Object)QueryBuilder.bindMarker((String)"span_name")));
    }

    public ListenableFuture<Void> accept(List<Span> rawSpans) {
        ImmutableSet.Builder futures = ImmutableSet.builder();
        for (Span span : rawSpans) {
            Long timestamp = ApplyTimestampAndDuration.guessTimestamp((Span)span);
            Schema.TraceIdUDT traceId = new Schema.TraceIdUDT(span.traceIdHigh, span.traceId);
            futures.add(this.storeSpan(span, traceId, timestamp));
            for (String serviceName : span.serviceNames()) {
                if (timestamp == null) continue;
                futures.add(this.storeTraceServiceSpanName(serviceName, span.name, timestamp, span.duration, traceId));
                if (!span.name.isEmpty()) {
                    futures.add(this.storeTraceServiceSpanName(serviceName, "", timestamp, span.duration, traceId));
                }
                futures.add(this.storeServiceSpanName(serviceName, span.name));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)futures.build()), TO_VOID);
    }

    ListenableFuture<?> storeSpan(Span span, Schema.TraceIdUDT traceId, Long timestamp) {
        try {
            if ((null == timestamp || 0L == timestamp) && this.metadata.compactionClass.contains("TimeWindowCompactionStrategy")) {
                LOG.warn("Span {} in trace {} had no timestamp. If this happens a lot consider switching back to SizeTieredCompactionStrategy for {}.traces", new Object[]{span.id, span.traceId, this.session.getLoggedKeyspace()});
            }
            ArrayList<Schema.AnnotationUDT> annotations = new ArrayList<Schema.AnnotationUDT>(span.annotations.size());
            for (Object annotation : span.annotations) {
                annotations.add(new Schema.AnnotationUDT((Annotation)annotation));
            }
            ArrayList<Schema.BinaryAnnotationUDT> binaryAnnotations = new ArrayList<Schema.BinaryAnnotationUDT>(span.binaryAnnotations.size());
            for (BinaryAnnotation annotation : span.binaryAnnotations) {
                binaryAnnotations.add(new Schema.BinaryAnnotationUDT(annotation));
            }
            Set<String> annotationKeys = CassandraUtil.annotationKeys(span);
            if (!this.strictTraceId && traceId.getHigh() != 0L) {
                this.storeSpan(span, new Schema.TraceIdUDT(0L, traceId.getLow()), timestamp);
            }
            BoundStatement bound = CassandraUtil.bindWithName(this.insertSpan, "insert-span").set("trace_id", (Object)traceId, Schema.TraceIdUDT.class).setUUID("ts_uuid", new UUID(UUIDs.startOf((long)(null != timestamp ? timestamp / 1000L : 0L)).getMostSignificantBits(), UUIDs.random().getLeastSignificantBits())).setLong("id", span.id).setString("span_name", span.name).setList("annotations", annotations).setList("binary_annotations", binaryAnnotations).setString("all_annotations", Joiner.on((char)',').join(annotationKeys));
            if (null != span.timestamp) {
                bound = bound.setLong("ts", span.timestamp.longValue());
            }
            if (null != span.duration) {
                bound = bound.setLong("duration", span.duration.longValue());
            }
            if (null != span.parentId) {
                bound = bound.setLong("parent_id", span.parentId.longValue());
            }
            return this.session.executeAsync((Statement)bound);
        }
        catch (RuntimeException ex) {
            return Futures.immediateFailedFuture((Throwable)ex);
        }
    }

    ListenableFuture<?> storeTraceServiceSpanName(String serviceName, String spanName, long timestamp_micro, Long duration, Schema.TraceIdUDT traceId) {
        int bucket = CassandraUtil.durationIndexBucket(timestamp_micro);
        UUID ts = new UUID(UUIDs.startOf((long)(timestamp_micro / 1000L)).getMostSignificantBits(), UUIDs.random().getLeastSignificantBits());
        try {
            BoundStatement bound = CassandraUtil.bindWithName(this.insertTraceServiceSpanName, "insert-trace-service-span-name").setString("service_name", serviceName).setString("span_name", spanName).setInt("bucket", bucket).setUUID("ts", ts).set("trace_id", (Object)traceId, Schema.TraceIdUDT.class);
            if (null != duration) {
                bound = bound.setLong("duration", duration.longValue());
            }
            return this.session.executeAsync((Statement)bound);
        }
        catch (RuntimeException ex) {
            return Futures.immediateFailedFuture((Throwable)ex);
        }
    }

    ListenableFuture<?> storeServiceSpanName(String serviceName, String spanName) {
        try {
            BoundStatement bound = CassandraUtil.bindWithName(this.insertServiceSpanName, "insert-service-span-name").setString("service_name", serviceName).setString("span_name", spanName);
            return this.session.executeAsync((Statement)bound);
        }
        catch (RuntimeException ex) {
            return Futures.immediateFailedFuture((Throwable)ex);
        }
    }
}

