/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra3;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Constants;
import zipkin.Span;
import zipkin.internal.Util;
import zipkin.storage.QueryRequest;
import zipkin.storage.cassandra3.Schema;

final class CassandraUtil {
    static final int LONGEST_VALUE_TO_INDEX = 256;
    private static final long DURATION_INDEX_BUCKET_WINDOW_SECONDS = Long.getLong("zipkin.store.cassandra.internal.durationIndexBucket", 86400L);

    CassandraUtil() {
    }

    public static int durationIndexBucket(long ts_micro) {
        return (int)(ts_micro / DURATION_INDEX_BUCKET_WINDOW_SECONDS / 1000000L);
    }

    static Set<String> annotationKeys(Span span) {
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (Annotation a : span.annotations) {
            if (Constants.CORE_ANNOTATIONS.contains(a.value) || a.endpoint == null || a.endpoint.serviceName.isEmpty()) continue;
            annotationKeys.add(a.endpoint.serviceName + ":" + a.value);
        }
        for (BinaryAnnotation b : span.binaryAnnotations) {
            String value;
            if (b.type != BinaryAnnotation.Type.STRING || b.endpoint == null || b.endpoint.serviceName.isEmpty() || b.value.length > 1024 || (value = new String(b.value, Util.UTF_8)).length() > 256) continue;
            annotationKeys.add(b.endpoint.serviceName + ";" + b.key + ";" + new String(b.value, Util.UTF_8));
        }
        return annotationKeys;
    }

    static List<String> annotationKeys(QueryRequest request) {
        if (request.annotations.isEmpty() && request.binaryAnnotations.isEmpty()) {
            return Collections.emptyList();
        }
        Util.checkArgument((request.serviceName != null ? 1 : 0) != 0, (String)"serviceName needed with annotation query", (Object[])new Object[0]);
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (String string : request.annotations) {
            annotationKeys.add(request.serviceName + ":" + string);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            annotationKeys.add(request.serviceName + ";" + (String)entry.getKey() + ";" + (String)entry.getValue());
        }
        return Util.sortedList(annotationKeys);
    }

    static BoundStatement bindWithName(PreparedStatement prepared, String name) {
        return new NamedBoundStatement(prepared, name);
    }

    static Function<List<Map<Schema.TraceIdUDT, Long>>, Collection<Schema.TraceIdUDT>> intersectKeySets() {
        return IntersectKeySets.INSTANCE;
    }

    static Function<Map<Schema.TraceIdUDT, Long>, Collection<Schema.TraceIdUDT>> traceIdsSortedByDescTimestamp() {
        return TraceIdsSortedByDescTimestamp.INSTANCE;
    }

    static enum TraceIdsSortedByDescTimestamp implements Function<Map<Schema.TraceIdUDT, Long>, Collection<Schema.TraceIdUDT>>
    {
        INSTANCE;

        private static final Random RAND;
        private static final BigInteger OFFSET;

        public Collection<Schema.TraceIdUDT> apply(Map<Schema.TraceIdUDT, Long> map) {
            TreeMap sorted = new TreeMap(Collections.reverseOrder());
            for (Map.Entry<Schema.TraceIdUDT, Long> e : map.entrySet()) {
                sorted.put(BigInteger.valueOf(e.getValue()).multiply(OFFSET).add(BigInteger.valueOf(RAND.nextInt())), e.getKey());
            }
            return sorted.values();
        }

        static {
            RAND = new Random(System.nanoTime());
            OFFSET = BigInteger.valueOf(Integer.MAX_VALUE);
        }
    }

    static enum IntersectKeySets implements Function<List<Map<Object, ?>>, Collection<Object>>
    {
        INSTANCE;


        public Collection<Object> apply(List<Map<Object, ?>> input) {
            LinkedHashSet traceIds = Sets.newLinkedHashSet(input.get(0).keySet());
            for (int i = 1; i < input.size(); ++i) {
                traceIds.retainAll(input.get(i).keySet());
            }
            return traceIds;
        }
    }

    static enum KeySet implements Function<Map<Object, ?>, Set<Object>>
    {
        INSTANCE;


        public Set<Object> apply(Map<Object, ?> input) {
            return input.keySet();
        }
    }

    static final class NamedBoundStatement
    extends BoundStatement {
        final String name;

        NamedBoundStatement(PreparedStatement statement, String name) {
            super(statement);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

