/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryLogger;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.mapping.MappingManager;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import zipkin.storage.cassandra3.Cassandra3Storage;
import zipkin.storage.cassandra3.Schema;
import zipkin.storage.cassandra3.ZipkinRetryPolicy;

final class DefaultSessionFactory
implements Cassandra3Storage.SessionFactory {
    DefaultSessionFactory() {
    }

    @Override
    public Session create(Cassandra3Storage cassandra) {
        Closer closer = Closer.create();
        try {
            Session session;
            Cluster cluster = (Cluster)closer.register((Closeable)DefaultSessionFactory.buildCluster(cassandra));
            cluster.register((LatencyTracker)new QueryLogger.Builder().build());
            if (cassandra.ensureSchema) {
                session = (Session)closer.register((Closeable)cluster.connect());
                Schema.ensureExists(cassandra.keyspace, session);
                session.execute("USE " + cassandra.keyspace);
            } else {
                session = cluster.connect(cassandra.keyspace);
            }
            DefaultSessionFactory.initializeUDTs(session);
            return session;
        }
        catch (RuntimeException e) {
            try {
                closer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private static void initializeUDTs(Session session) {
        Schema.ensureExists("zipkin3_udts", session);
        MappingManager mapping = new MappingManager(session);
        TypeCodec traceIdCodec = mapping.udtCodec(Schema.TraceIdUDT.class);
        TypeCodec endpointCodec = mapping.udtCodec(Schema.EndpointUDT.class);
        TypeCodec annoCodec = mapping.udtCodec(Schema.AnnotationUDT.class);
        TypeCodec bAnnoCodec = mapping.udtCodec(Schema.BinaryAnnotationUDT.class);
        KeyspaceMetadata keyspace = session.getCluster().getMetadata().getKeyspace(session.getLoggedKeyspace());
        session.getCluster().getConfiguration().getCodecRegistry().register(new Schema.TypeCodecImpl<Schema.TraceIdUDT>((DataType)keyspace.getUserType("trace_id"), Schema.TraceIdUDT.class, traceIdCodec)).register(new Schema.TypeCodecImpl<Schema.EndpointUDT>((DataType)keyspace.getUserType("endpoint"), Schema.EndpointUDT.class, endpointCodec)).register(new Schema.TypeCodecImpl<Schema.AnnotationUDT>((DataType)keyspace.getUserType("annotation"), Schema.AnnotationUDT.class, annoCodec)).register(new Schema.TypeCodecImpl<Schema.BinaryAnnotationUDT>((DataType)keyspace.getUserType("binary_annotation"), Schema.BinaryAnnotationUDT.class, bAnnoCodec));
    }

    static Cluster buildCluster(Cassandra3Storage cassandra) {
        Cluster.Builder builder = Cluster.builder();
        List<InetSocketAddress> contactPoints = DefaultSessionFactory.parseContactPoints(cassandra);
        int defaultPort = DefaultSessionFactory.findConnectPort(contactPoints);
        builder.addContactPointsWithPorts(contactPoints);
        builder.withPort(defaultPort);
        if (cassandra.username != null && cassandra.password != null) {
            builder.withCredentials(cassandra.username, cassandra.password);
        }
        builder.withRetryPolicy((RetryPolicy)ZipkinRetryPolicy.INSTANCE);
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new LatencyAwarePolicy.Builder((LoadBalancingPolicy)(cassandra.localDc != null ? DCAwareRoundRobinPolicy.builder().withLocalDc(cassandra.localDc).build() : new RoundRobinPolicy())).build()));
        builder.withPoolingOptions(new PoolingOptions().setMaxConnectionsPerHost(HostDistance.LOCAL, cassandra.maxConnections));
        if (cassandra.useSsl) {
            builder = builder.withSSL();
        }
        return builder.build();
    }

    static List<InetSocketAddress> parseContactPoints(Cassandra3Storage cassandra) {
        LinkedList<InetSocketAddress> result = new LinkedList<InetSocketAddress>();
        for (String contactPoint : cassandra.contactPoints.split(",")) {
            HostAndPort parsed = HostAndPort.fromString((String)contactPoint);
            result.add(new InetSocketAddress(parsed.getHostText(), parsed.getPortOrDefault(9042)));
        }
        return result;
    }

    static int findConnectPort(List<InetSocketAddress> contactPoints) {
        LinkedHashSet ports = Sets.newLinkedHashSet();
        for (InetSocketAddress contactPoint : contactPoints) {
            ports.add(contactPoint.getPort());
        }
        return ports.size() == 1 ? (Integer)ports.iterator().next() : 9042;
    }
}

