/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSource;
import zipkin.Component;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.moshi.JsonReaders;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageAdapters;
import zipkin.storage.StorageComponent;
import zipkin.storage.elasticsearch.http.;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpSpanConsumer;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpSpanStore;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage$$Lambda$1;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage$$Lambda$2;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage$$Lambda$3;
import zipkin.storage.elasticsearch.http.EnsureIndexTemplate;
import zipkin.storage.elasticsearch.http.IndexNameFormatter;
import zipkin.storage.elasticsearch.http.PseudoAddressRecordSet;
import zipkin.storage.elasticsearch.http.VersionSpecificTemplate;
import zipkin.storage.elasticsearch.http.internal.client.HttpCall;

public abstract class ElasticsearchHttpStorage
implements StorageComponent {
    static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");

    public static Builder builder(OkHttpClient client) {
        return new .AutoValue_ElasticsearchHttpStorage.Builder().client(client).hosts(Collections.singletonList("http://localhost:9200")).maxRequests(64).strictTraceId(true).index("zipkin").dateSeparator('-').indexShards(5).indexReplicas(1).namesLookback(86400000).shutdownClientOnClose(false).flushOnWrites(false);
    }

    public static Builder builder() {
        Builder result = ElasticsearchHttpStorage.builder(new OkHttpClient());
        result.shutdownClientOnClose(true);
        return result;
    }

    abstract OkHttpClient client();

    abstract boolean shutdownClientOnClose();

    abstract HostsSupplier hostsSupplier();

    @Nullable
    abstract String pipeline();

    abstract boolean flushOnWrites();

    abstract int maxRequests();

    abstract boolean strictTraceId();

    abstract int indexShards();

    abstract int indexReplicas();

    abstract IndexNameFormatter indexNameFormatter();

    abstract int namesLookback();

    public SpanStore spanStore() {
        return StorageAdapters.asyncToBlocking((AsyncSpanStore)this.asyncSpanStore());
    }

    public AsyncSpanStore asyncSpanStore() {
        this.ensureIndexTemplate();
        return new ElasticsearchHttpSpanStore(this);
    }

    public AsyncSpanConsumer asyncSpanConsumer() {
        this.ensureIndexTemplate();
        return new ElasticsearchHttpSpanConsumer(this);
    }

    void clear() throws IOException {
        this.clear(this.indexNameFormatter().allIndices());
    }

    void clear(String index) throws IOException {
        Request deleteRequest = new Request.Builder().url(this.http().baseUrl.newBuilder().addPathSegment(index).build()).delete().tag((Object)"delete-index").build();
        this.http().execute(deleteRequest, ElasticsearchHttpStorage$$Lambda$1.lambdaFactory$());
        ElasticsearchHttpStorage.flush(this.http(), index);
    }

    static void flush(HttpCall.Factory factory, String index) throws IOException {
        Request flushRequest = new Request.Builder().url(factory.baseUrl.newBuilder().addPathSegment(index).addPathSegment("_flush").build()).post(RequestBody.create((MediaType)APPLICATION_JSON, (String)"")).tag((Object)"flush-index").build();
        factory.execute(flushRequest, ElasticsearchHttpStorage$$Lambda$2.lambdaFactory$());
    }

    public Component.CheckResult check() {
        return this.ensureClusterReady(this.indexNameFormatter().allIndices());
    }

    Component.CheckResult ensureClusterReady(String index) {
        Request request = new Request.Builder().url(this.http().baseUrl.resolve("/_cluster/health/" + index)).tag((Object)"get-cluster-health").build();
        try {
            return (Component.CheckResult)this.http().execute(request, ElasticsearchHttpStorage$$Lambda$3.lambdaFactory$());
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    String indexTemplate() {
        return new VersionSpecificTemplate(this).get(this.http());
    }

    boolean ensureIndexTemplate() {
        EnsureIndexTemplate.apply(this.http(), this.indexNameFormatter().index() + "_template", this.indexTemplate());
        return true;
    }

    HttpCall.Factory http() {
        List<String> hosts = this.hostsSupplier().get();
        if (hosts.isEmpty()) {
            throw new IllegalArgumentException("no hosts configured");
        }
        OkHttpClient ok = hosts.size() == 1 ? this.client() : this.client().newBuilder().dns(PseudoAddressRecordSet.create(hosts, this.client().dns())).build();
        ok.dispatcher().setMaxRequests(this.maxRequests());
        ok.dispatcher().setMaxRequestsPerHost(this.maxRequests());
        return new HttpCall.Factory(ok, HttpUrl.parse((String)hosts.get(0)));
    }

    public void close() {
        if (!this.shutdownClientOnClose()) {
            return;
        }
        this.http().close();
    }

    ElasticsearchHttpStorage() {
    }

    static /* synthetic */ Component.CheckResult lambda$ensureClusterReady$2(BufferedSource b) throws IOException {
        b.request(Long.MAX_VALUE);
        Buffer body = b.buffer();
        JsonReader status = JsonReaders.enterPath(JsonReader.of((BufferedSource)body.clone()), "status");
        if (status == null) {
            throw new IllegalStateException("Health status couldn't be read " + body.readUtf8());
        }
        if ("RED".equalsIgnoreCase(status.nextString())) {
            throw new IllegalStateException("Health status is RED");
        }
        return Component.CheckResult.OK;
    }

    static /* synthetic */ Object lambda$flush$1(BufferedSource b) throws IOException {
        return null;
    }

    static /* synthetic */ Object lambda$clear$0(BufferedSource b) throws IOException {
        return null;
    }

    public static abstract class Builder
    implements StorageComponent.Builder {
        abstract Builder client(OkHttpClient var1);

        abstract Builder shutdownClientOnClose(boolean var1);

        public final Builder hosts(final List<String> hosts) {
            Util.checkNotNull(hosts, (String)"hosts");
            return this.hostsSupplier(new HostsSupplier(){

                @Override
                public List<String> get() {
                    return hosts;
                }

                public String toString() {
                    return hosts.toString();
                }
            });
        }

        public abstract Builder hostsSupplier(HostsSupplier var1);

        public abstract Builder maxRequests(int var1);

        public abstract Builder pipeline(String var1);

        public abstract Builder namesLookback(int var1);

        abstract Builder flushOnWrites(boolean var1);

        public final Builder index(String index) {
            this.indexNameFormatterBuilder().index(index);
            return this;
        }

        public final Builder dateSeparator(char dateSeparator) {
            this.indexNameFormatterBuilder().dateSeparator(dateSeparator);
            return this;
        }

        public abstract Builder indexShards(int var1);

        public abstract Builder indexReplicas(int var1);

        public abstract Builder strictTraceId(boolean var1);

        public abstract ElasticsearchHttpStorage build();

        abstract IndexNameFormatter.Builder indexNameFormatterBuilder();

        Builder() {
        }
    }

    public static interface HostsSupplier {
        public List<String> get();
    }
}

