/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import okhttp3.Request;
import okio.BufferedSource;
import zipkin.moshi.JsonReaders;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.elasticsearch.http.VersionSpecificTemplate$$Lambda$1;
import zipkin.storage.elasticsearch.http.internal.client.HttpCall;

final class VersionSpecificTemplate {
    final String indexTemplate;
    static final String INDEX_TEMPLATE = "{\n  \"template\": \"${__INDEX__}-*\",\n  \"settings\": {\n    \"index.number_of_shards\": ${__NUMBER_OF_SHARDS__},\n    \"index.number_of_replicas\": ${__NUMBER_OF_REPLICAS__},\n    \"index.requests.cache.enable\": true,\n    \"index.mapper.dynamic\": false,\n    \"analysis\": {\n      \"analyzer\": {\n        \"traceId_analyzer\": {\n          \"type\": \"custom\",\n          \"tokenizer\": \"keyword\",\n          \"filter\": \"traceId_filter\"\n        }\n      },\n      \"filter\": {\n        \"traceId_filter\": {\n          \"type\": \"pattern_capture\",\n          \"patterns\": [\"([0-9a-f]{1,16})$\"],\n          \"preserve_original\": true\n        }\n      }\n    }\n  },\n  \"mappings\": {\n    \"_default_\": {\n      \"_all\": {\n        \"enabled\": false\n      }\n    },\n    \"span\": {\n      \"properties\": {\n        \"traceId\": ${__TRACE_ID_MAPPING__},\n        \"name\": { KEYWORD },\n        \"timestamp_millis\": {\n          \"type\":   \"date\",\n          \"format\": \"epoch_millis\"\n        },\n        \"duration\": { \"type\": \"long\" },\n        \"annotations\": {\n          \"type\": \"nested\",\n          \"dynamic\": false,\n          \"properties\": {\n            \"value\": { KEYWORD },\n            \"endpoint\": {\n              \"type\": \"object\",\n              \"dynamic\": false,\n              \"properties\": { \"serviceName\": { KEYWORD } }\n            }\n          }\n        },\n        \"binaryAnnotations\": {\n          \"type\": \"nested\",\n          \"dynamic\": false,\n          \"properties\": {\n            \"key\": { KEYWORD },\n            \"value\": { KEYWORD },\n            \"endpoint\": {\n              \"type\": \"object\",\n              \"dynamic\": false,\n              \"properties\": { \"serviceName\": { KEYWORD } }\n            }\n          }\n        }\n      }\n    },\n    \"dependencylink\": { \"enabled\": false },\n    \"servicespan\": {\n      \"properties\": {\n        \"serviceName\": { KEYWORD },\n        \"spanName\": { KEYWORD }\n      }\n    }\n  }\n}";

    VersionSpecificTemplate(ElasticsearchHttpStorage es) {
        this.indexTemplate = INDEX_TEMPLATE.replace("${__INDEX__}", es.indexNameFormatter().index()).replace("${__NUMBER_OF_SHARDS__}", String.valueOf(es.indexShards())).replace("${__NUMBER_OF_REPLICAS__}", String.valueOf(es.indexReplicas())).replace("${__TRACE_ID_MAPPING__}", es.strictTraceId() ? "{ KEYWORD }" : "{ \"type\": \"string\", \"analyzer\": \"traceId_analyzer\" }");
    }

    String get(HttpCall.Factory callFactory) {
        String version = VersionSpecificTemplate.getVersion(callFactory);
        return this.versionSpecificTemplate(version);
    }

    static String getVersion(HttpCall.Factory callFactory) {
        Request getNode = new Request.Builder().url(callFactory.baseUrl).tag((Object)"get-node").build();
        return (String)callFactory.execute(getNode, VersionSpecificTemplate$$Lambda$1.lambdaFactory$());
    }

    private String versionSpecificTemplate(String version) {
        if (version.startsWith("2")) {
            return this.indexTemplate.replace("KEYWORD", "\"type\": \"string\", \"ignore_above\": 256, \"norms\": {\"enabled\": false }, \"index\": \"not_analyzed\"");
        }
        if (version.startsWith("5")) {
            return this.indexTemplate.replace("KEYWORD", "\"type\": \"keyword\", \"ignore_above\": 256, \"norms\": false").replace("\"analyzer\": \"traceId_analyzer\" }", "\"fielddata\": \"true\", \"analyzer\": \"traceId_analyzer\" }");
        }
        throw new IllegalStateException("Elasticsearch 2.x and 5.x are supported, was: " + version);
    }

    static /* synthetic */ String lambda$getVersion$0(BufferedSource b) throws IOException {
        JsonReader version = JsonReaders.enterPath(JsonReader.of((BufferedSource)b), "version", "number");
        if (version == null) {
            throw new IllegalStateException(".version.number not in response");
        }
        return version.nextString();
    }
}

