/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http.internal.client;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import zipkin.storage.elasticsearch.http.internal.client.HttpCall;
import zipkin.storage.elasticsearch.http.internal.client.SearchRequest;

public class SearchCallFactory {
    static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    final HttpCall.Factory http;
    final JsonAdapter<SearchRequest> searchRequest = new Moshi.Builder().build().adapter(SearchRequest.class);

    public SearchCallFactory(HttpCall.Factory http) {
        this.http = http;
    }

    public <V> HttpCall<V> newCall(SearchRequest request, HttpCall.BodyConverter<V> bodyConverter) {
        Request httpRequest = new Request.Builder().url(this.lenientSearch(request.indices, request.type)).post(RequestBody.create((MediaType)APPLICATION_JSON, (String)this.searchRequest.toJson((Object)request))).header("Accept-Encoding", "gzip").tag((Object)request.tag()).build();
        return this.http.newCall(httpRequest, bodyConverter);
    }

    public HttpUrl lenientSearch(List<String> indices, String type) {
        return this.http.baseUrl.newBuilder().addPathSegment(SearchCallFactory.join(indices)).addPathSegment(type).addPathSegment("_search").addQueryParameter("allow_no_indices", "true").addQueryParameter("expand_wildcards", "open").addQueryParameter("ignore_unavailable", "true").build();
    }

    static String join(List<String> parts) {
        StringBuilder to = new StringBuilder();
        int length = parts.size();
        for (int i = 0; i < length; ++i) {
            to.append(parts.get(i));
            if (i + 1 >= length) continue;
            to.append(',');
        }
        return to.toString();
    }
}

