/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import zipkin.reporter.Encoding;

enum RequestBodyMessageEncoder {
    THRIFT{

        @Override
        public RequestBody encode(List<byte[]> values) {
            return new ThriftRequestBody(values);
        }
    }
    ,
    JSON{

        @Override
        public RequestBody encode(List<byte[]> values) {
            return new JsonRequestBody(values);
        }
    };


    abstract RequestBody encode(List<byte[]> var1);

    static final class JsonRequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json");

        JsonRequestBody(List<byte[]> values) {
            super(Encoding.JSON, CONTENT_TYPE, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.writeByte(91);
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink.write(next);
                if (i >= length) continue;
                sink.writeByte(44);
            }
            sink.writeByte(93);
        }
    }

    static final class ThriftRequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/x-thrift");

        ThriftRequestBody(List<byte[]> values) {
            super(Encoding.THRIFT, CONTENT_TYPE, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.writeByte(11);
            int length = this.values.size();
            sink.writeInt(length);
            for (int i = 0; i < length; ++i) {
                sink.write((byte[])this.values.get(i));
            }
        }
    }

    static abstract class StreamingRequestBody
    extends RequestBody {
        final MediaType contentType;
        final List<byte[]> values;
        final long contentLength;

        StreamingRequestBody(Encoding encoding, MediaType contentType, List<byte[]> values) {
            this.contentType = contentType;
            this.values = values;
            this.contentLength = encoding.listSizeInBytes(values);
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }
    }
}

