/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import me.ahoo.cosid.converter.RadixIdConverter;

public final class Radix36IdConverter
extends RadixIdConverter {
    public static final int MAX_CHAR_SIZE = 13;
    public static final int RADIX = 36;
    public static final Radix36IdConverter INSTANCE = new Radix36IdConverter(false, 13);
    public static final Radix36IdConverter PAD_START = new Radix36IdConverter(true, 13);

    public static Radix36IdConverter of(boolean padStart, int charSize) {
        if (INSTANCE.isPadStart() == padStart && INSTANCE.getCharSize() == charSize) {
            return INSTANCE;
        }
        if (PAD_START.isPadStart() == padStart && PAD_START.getCharSize() == charSize) {
            return PAD_START;
        }
        return new Radix36IdConverter(padStart, charSize);
    }

    public Radix36IdConverter(boolean padStart, int charSize) {
        super(padStart, charSize);
    }

    @Override
    int getRadix() {
        return 36;
    }

    @Override
    int getMaxCharSize() {
        return 13;
    }
}

