/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Range;
import java.util.Collection;
import me.ahoo.cosid.sharding.Sharding;

@Beta
public class CachedSharding<T extends Comparable<?>>
implements Sharding<T> {
    private final Sharding<T> actual;
    private final LoadingCache<Range<T>, Collection<String>> shardingCache;

    public CachedSharding(Sharding<T> actual) {
        this.actual = actual;
        this.shardingCache = CacheBuilder.newBuilder().build((CacheLoader)new LoadShardingCache());
    }

    @Override
    public String sharding(T shardingValue) {
        return this.actual.sharding(shardingValue);
    }

    @Override
    public Collection<String> sharding(Range<T> shardingValue) {
        return (Collection)this.shardingCache.getUnchecked(shardingValue);
    }

    @Override
    public Collection<String> getEffectiveNodes() {
        return this.actual.getEffectiveNodes();
    }

    private class LoadShardingCache
    extends CacheLoader<Range<T>, Collection<String>> {
        private LoadShardingCache() {
        }

        public Collection<String> load(Range<T> key) throws Exception {
            return CachedSharding.this.actual.sharding(key);
        }
    }
}

