/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.uncertainty;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.IdGeneratorDecorator;
import me.ahoo.cosid.uncertainty.OriginalIdOverflowException;

@Beta
public class UncertaintyIdGenerator
implements IdGeneratorDecorator {
    protected final IdGenerator actual;
    private final int uncertaintyBits;
    private final int originalIdBits;
    private final long uncertaintyBound;
    private final long maxOriginalId;

    public UncertaintyIdGenerator(IdGenerator actual, int uncertaintyBits) {
        Preconditions.checkArgument((uncertaintyBits > 0 && uncertaintyBits < 63 ? 1 : 0) != 0, (Object)"uncertaintyBits[%s] must be greater than 0 and less than 63.");
        this.actual = actual;
        this.uncertaintyBits = uncertaintyBits;
        this.originalIdBits = 63 - uncertaintyBits;
        this.maxOriginalId = -1L << this.originalIdBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.uncertaintyBound = (-1L << uncertaintyBits ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
    }

    public int uncertaintyBits() {
        return this.uncertaintyBits;
    }

    public int originalIdBits() {
        return this.originalIdBits;
    }

    public long uncertaintyBound() {
        return this.uncertaintyBound;
    }

    public long maxOriginalId() {
        return this.maxOriginalId;
    }

    private long uncertainty() {
        return ThreadLocalRandom.current().nextLong(0L, this.uncertaintyBound);
    }

    @Override
    public IdGenerator getActual() {
        return this.actual;
    }

    @Override
    public long generate() {
        long originalId = this.getActual().generate();
        if (originalId > this.maxOriginalId) {
            throw new OriginalIdOverflowException(originalId, this.originalIdBits, this.maxOriginalId);
        }
        return originalId << this.uncertaintyBits | this.uncertainty();
    }
}

