/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.ahoo.cosid.IdConverter;

public class SuffixIdConverter
implements IdConverter {
    private final String suffix;
    private final IdConverter idConverter;

    public SuffixIdConverter(String suffix, IdConverter idConverter) {
        Preconditions.checkNotNull((Object)suffix, (Object)"suffix can not be null!");
        this.suffix = suffix;
        this.idConverter = idConverter;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        String idStr = this.idConverter.asString(id);
        if (this.suffix.isEmpty()) {
            return idStr;
        }
        return idStr + this.suffix;
    }

    @Override
    public long asLong(@Nonnull String idString) {
        String idStr = idString.substring(0, idString.length() - this.suffix.length());
        return this.idConverter.asLong(idStr);
    }
}

