/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import me.ahoo.cosid.IdConverter;

public class ToStringIdConverter
implements IdConverter {
    public static final ToStringIdConverter INSTANCE = new ToStringIdConverter(false, 0);
    private final boolean padStart;
    private final int charSize;

    public ToStringIdConverter(boolean padStart, int charSize) {
        this.padStart = padStart;
        this.charSize = charSize;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        String idStr = String.valueOf(id);
        if (!this.padStart) {
            return idStr;
        }
        return Strings.padStart((String)idStr, (int)this.charSize, (char)'0');
    }

    @Override
    public long asLong(@Nonnull String idString) {
        return Long.parseLong(idString);
    }
}

