/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import me.ahoo.cosid.sharding.ExactCollection;
import me.ahoo.cosid.sharding.IntervalStep;
import me.ahoo.cosid.sharding.Sharding;

@ThreadSafe
public class IntervalTimeline
implements Sharding<LocalDateTime> {
    private final Range<LocalDateTime> effectiveInterval;
    private final IntervalStep step;
    private final Interval startInterval;
    private final Interval[] effectiveIntervals;
    private final String logicNamePrefix;
    private final DateTimeFormatter suffixFormatter;
    private final ExactCollection<String> effectiveNodes;

    public IntervalTimeline(String logicNamePrefix, Range<LocalDateTime> effectiveInterval, IntervalStep step, DateTimeFormatter suffixFormatter) {
        this.effectiveInterval = effectiveInterval;
        this.step = step;
        this.logicNamePrefix = logicNamePrefix;
        this.suffixFormatter = suffixFormatter;
        this.effectiveIntervals = IntervalTimeline.initIntervals(effectiveInterval, step, logicNamePrefix, suffixFormatter);
        this.startInterval = this.effectiveIntervals[0];
        this.effectiveNodes = IntervalTimeline.initEffectiveNodes(this.effectiveIntervals);
    }

    private static Interval[] initIntervals(Range<LocalDateTime> effectiveInterval, IntervalStep step, String logicNamePrefix, DateTimeFormatter suffixFormatter) {
        LocalDateTime lower = step.floorUnit((LocalDateTime)effectiveInterval.lowerEndpoint());
        LocalDateTime upper = step.floorUnit((LocalDateTime)effectiveInterval.upperEndpoint());
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        while (!lower.isAfter(upper)) {
            String nodeName = logicNamePrefix + lower.format(suffixFormatter);
            intervalList.add(new Interval(lower, nodeName));
            lower = step.next(lower);
        }
        return intervalList.toArray(new Interval[0]);
    }

    private static ExactCollection<String> initEffectiveNodes(Interval[] effectiveIntervals) {
        ExactCollection<String> effectiveNodes = new ExactCollection<String>(effectiveIntervals.length);
        for (int i = 0; i < effectiveIntervals.length; ++i) {
            effectiveNodes.add(i, effectiveIntervals[i].getNode());
        }
        return effectiveNodes;
    }

    public int size() {
        return this.effectiveIntervals.length;
    }

    public boolean contains(LocalDateTime time) {
        return this.effectiveInterval.contains((Comparable)time);
    }

    public Interval getStartInterval() {
        return this.startInterval;
    }

    @Override
    @Nonnull
    public Collection<String> getEffectiveNodes() {
        return this.effectiveNodes;
    }

    @Override
    @Nonnull
    public String sharding(LocalDateTime shardingValue) {
        Preconditions.checkArgument((boolean)this.contains(shardingValue), (String)"Sharding value:[%s]: out of bounds:[%s].", (Object)shardingValue, this.effectiveInterval);
        int offset = this.step.offsetUnit(this.startInterval.getLower(), shardingValue);
        return this.effectiveIntervals[offset].getNode();
    }

    @Override
    @Nonnull
    public Collection<String> sharding(Range<LocalDateTime> shardingValue) {
        LocalDateTime upperEndpoint;
        LocalDateTime lowerEndpoint;
        if (!this.effectiveInterval.isConnected(shardingValue)) {
            return ExactCollection.empty();
        }
        if (Range.all().equals(shardingValue)) {
            return this.effectiveNodes;
        }
        int maxOffset = this.size() - 1;
        int lowerOffset = 0;
        int upperOffset = maxOffset;
        if (shardingValue.hasLowerBound() && !(lowerEndpoint = (LocalDateTime)shardingValue.lowerEndpoint()).isBefore(this.startInterval.getLower())) {
            lowerOffset = this.step.offsetUnit(this.startInterval.getLower(), lowerEndpoint);
        }
        if (shardingValue.hasUpperBound() && !(upperEndpoint = (LocalDateTime)shardingValue.upperEndpoint()).isAfter((ChronoLocalDateTime)this.effectiveInterval.upperEndpoint())) {
            upperOffset = this.step.offsetUnit(this.startInterval.getLower(), (LocalDateTime)shardingValue.upperEndpoint());
            Interval lastInterval = this.effectiveIntervals[upperOffset];
            if (BoundType.OPEN.equals((Object)shardingValue.upperBoundType()) && lastInterval.getLower().equals(upperEndpoint)) {
                if (upperOffset == 0) {
                    return ExactCollection.empty();
                }
                --upperOffset;
            }
        }
        Interval lastInterval = this.effectiveIntervals[upperOffset];
        if (lowerOffset == upperOffset) {
            return new ExactCollection<String>(lastInterval.getNode());
        }
        if (lowerOffset == 0 && upperOffset == maxOffset) {
            return this.effectiveNodes;
        }
        int nodeSize = upperOffset - lowerOffset + 1;
        ExactCollection<String> nodes = new ExactCollection<String>(nodeSize);
        int idx = 0;
        while (lowerOffset <= upperOffset) {
            Interval interval = this.effectiveIntervals[lowerOffset];
            nodes.add(idx, interval.getNode());
            ++lowerOffset;
            ++idx;
        }
        return nodes;
    }

    public static class Interval {
        private final LocalDateTime lower;
        private final String node;

        public Interval(LocalDateTime lower, String node) {
            this.lower = lower;
            this.node = node;
        }

        public LocalDateTime getLower() {
            return this.lower;
        }

        public String getNode() {
            return this.node;
        }
    }
}

