/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Collection;
import javax.annotation.Nonnull;
import me.ahoo.cosid.sharding.ExactCollection;
import me.ahoo.cosid.sharding.Sharding;

public class ModCycle<T extends Number>
implements Sharding<T> {
    private final int divisor;
    private final String logicNamePrefix;
    private final ExactCollection<String> effectiveNodes;

    public ModCycle(int divisor, String logicNamePrefix) {
        Preconditions.checkArgument((divisor > 0 ? 1 : 0) != 0, (Object)"divisor must be greater than 0!");
        this.divisor = divisor;
        this.logicNamePrefix = logicNamePrefix;
        this.effectiveNodes = ModCycle.initNodes(divisor, logicNamePrefix);
    }

    private static ExactCollection<String> initNodes(int divisor, String logicNamePrefix) {
        ExactCollection<String> modNodes = new ExactCollection<String>(divisor);
        for (int i = 0; i < divisor; ++i) {
            String nodeName = logicNamePrefix + i;
            modNodes.add(i, nodeName);
        }
        return modNodes;
    }

    public int getDivisor() {
        return this.divisor;
    }

    @Override
    @Nonnull
    public String sharding(T shardingValue) {
        int nodeIdx = (int)(((Number)shardingValue).longValue() % (long)this.divisor);
        return this.effectiveNodes.get(nodeIdx);
    }

    @Override
    @Nonnull
    public Collection<String> sharding(Range<T> shardingValue) {
        if (Range.all().equals(shardingValue)) {
            return this.effectiveNodes;
        }
        if (!shardingValue.hasUpperBound()) {
            return this.effectiveNodes;
        }
        long lower = 0L;
        if (shardingValue.hasLowerBound()) {
            long lowerEndpoint = ((Number)((Object)shardingValue.lowerEndpoint())).longValue();
            lower = BoundType.OPEN.equals((Object)shardingValue.lowerBoundType()) ? lowerEndpoint + 1L : lowerEndpoint;
        }
        long upperEndpoint = ((Number)((Object)shardingValue.upperEndpoint())).longValue();
        long upper = BoundType.OPEN.equals((Object)shardingValue.upperBoundType()) ? upperEndpoint - 1L : upperEndpoint;
        int nodeSize = (int)(upper - lower + 1L);
        if (nodeSize == 0) {
            return ExactCollection.empty();
        }
        if (nodeSize >= this.divisor) {
            return this.effectiveNodes;
        }
        ExactCollection<String> nodes = new ExactCollection<String>(nodeSize);
        int idx = 0;
        while (lower <= upper) {
            int modValue = (int)(lower % (long)this.divisor);
            String matchedNode = this.effectiveNodes.get(modValue);
            nodes.add(idx, matchedNode);
            ++lower;
            ++idx;
        }
        return nodes;
    }

    @Override
    @Nonnull
    public Collection<String> getEffectiveNodes() {
        return this.effectiveNodes;
    }
}

