/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LocalDateTimeConvert {
    private LocalDateTimeConvert() {
    }

    @Nonnull
    public static LocalDateTime fromDate(Date date, ZoneId zoneId) {
        return LocalDateTimeConvert.fromTimestamp(date.getTime(), zoneId);
    }

    @Nonnull
    public static LocalDateTime fromTimestamp(long timestamp, ZoneId zoneId) {
        return LocalDateTimeConvert.fromInstant(Instant.ofEpochMilli(timestamp), zoneId);
    }

    @Nonnull
    public static LocalDateTime fromTimestampSecond(long timestamp, ZoneId zoneId) {
        return LocalDateTimeConvert.fromInstant(Instant.ofEpochSecond(timestamp), zoneId);
    }

    @Nonnull
    public static LocalDateTime fromInstant(Instant instant, ZoneId zoneId) {
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    @Nonnull
    public static LocalDateTime fromString(String dateTime, DateTimeFormatter dateTimeFormatter) {
        TemporalAccessor temporalAccessor = dateTimeFormatter.parseBest(dateTime, LocalDateTime::from, LocalDate::from);
        if (temporalAccessor instanceof LocalDateTime) {
            return (LocalDateTime)temporalAccessor;
        }
        return LocalDateTime.of((LocalDate)temporalAccessor, LocalTime.MIN);
    }
}

