/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.model;

public class AuthToken {
    private String accessToken;
    private int expireIn;
    private String refreshToken;
    private String uid;
    private String openId;
    private String accessCode;
    private String unionId;
    private String scope;
    private String tokenType;
    private String idToken;
    private String macAlgorithm;
    private String macKey;
    private String code;

    AuthToken(String accessToken, int expireIn, String refreshToken, String uid, String openId, String accessCode, String unionId, String scope, String tokenType, String idToken, String macAlgorithm, String macKey, String code) {
        this.accessToken = accessToken;
        this.expireIn = expireIn;
        this.refreshToken = refreshToken;
        this.uid = uid;
        this.openId = openId;
        this.accessCode = accessCode;
        this.unionId = unionId;
        this.scope = scope;
        this.tokenType = tokenType;
        this.idToken = idToken;
        this.macAlgorithm = macAlgorithm;
        this.macKey = macKey;
        this.code = code;
    }

    public static AuthTokenBuilder builder() {
        return new AuthTokenBuilder();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getExpireIn() {
        return this.expireIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getUid() {
        return this.uid;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public String getMacKey() {
        return this.macKey;
    }

    public String getCode() {
        return this.code;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setExpireIn(int expireIn) {
        this.expireIn = expireIn;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public void setMacKey(String macKey) {
        this.macKey = macKey;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static class AuthTokenBuilder {
        private String accessToken;
        private int expireIn;
        private String refreshToken;
        private String uid;
        private String openId;
        private String accessCode;
        private String unionId;
        private String scope;
        private String tokenType;
        private String idToken;
        private String macAlgorithm;
        private String macKey;
        private String code;

        AuthTokenBuilder() {
        }

        public AuthTokenBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AuthTokenBuilder expireIn(int expireIn) {
            this.expireIn = expireIn;
            return this;
        }

        public AuthTokenBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AuthTokenBuilder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public AuthTokenBuilder openId(String openId) {
            this.openId = openId;
            return this;
        }

        public AuthTokenBuilder accessCode(String accessCode) {
            this.accessCode = accessCode;
            return this;
        }

        public AuthTokenBuilder unionId(String unionId) {
            this.unionId = unionId;
            return this;
        }

        public AuthTokenBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public AuthTokenBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public AuthTokenBuilder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public AuthTokenBuilder macAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
            return this;
        }

        public AuthTokenBuilder macKey(String macKey) {
            this.macKey = macKey;
            return this;
        }

        public AuthTokenBuilder code(String code) {
            this.code = code;
            return this;
        }

        public AuthToken build() {
            return new AuthToken(this.accessToken, this.expireIn, this.refreshToken, this.uid, this.openId, this.accessCode, this.unionId, this.scope, this.tokenType, this.idToken, this.macAlgorithm, this.macKey, this.code);
        }

        public String toString() {
            return "AuthToken.AuthTokenBuilder(accessToken=" + this.accessToken + ", expireIn=" + this.expireIn + ", refreshToken=" + this.refreshToken + ", uid=" + this.uid + ", openId=" + this.openId + ", accessCode=" + this.accessCode + ", unionId=" + this.unionId + ", scope=" + this.scope + ", tokenType=" + this.tokenType + ", idToken=" + this.idToken + ", macAlgorithm=" + this.macAlgorithm + ", macKey=" + this.macKey + ", code=" + this.code + ")";
        }
    }
}

