package com.sinosoftgz.monitor.common;

import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

/**
 * Created by xiaoqian on 2016/6/7.
 */
public class MailUtils {
    public MailUtils() {
    }

    public MailUtils(String emailHost, int emailPort, String emailUserName, String emailPassword, boolean emailSslFlag, String emailFrom, String emailTo) {
        this.emailHost = emailHost;
        this.emailPort = emailPort;
        this.emailUserName = emailUserName;
        this.emailPassword = emailPassword;
        this.emailSslFlag = emailSslFlag;
        this.emailFrom = emailFrom;
        this.emailTo = emailTo;
    }

    private String emailHost;
    private int   emailPort =25;
    private String emailUserName;
    private String emailPassword;
    private boolean emailSslFlag =false;
    private String emailFrom;
    private String emailTo;

    public String getEmailHost() {
        return emailHost;
    }

    public void setEmailHost(String emailHost) {
        this.emailHost = emailHost;
    }

    public int getEmailPort() {
        return emailPort;
    }

    public void setEmailPort(int emailPort) {
        this.emailPort = emailPort;
    }

    public String getEmailUserName() {
        return emailUserName;
    }

    public void setEmailUserName(String emailUserName) {
        this.emailUserName = emailUserName;
    }

    public String getEmailPassword() {
        return emailPassword;
    }

    public void setEmailPassword(String emailPassword) {
        this.emailPassword = emailPassword;
    }

    public boolean isEmailSslFlag() {
        return emailSslFlag;
    }

    public void setEmailSslFlag(boolean emailSslFlag) {
        this.emailSslFlag = emailSslFlag;
    }

    public String getEmailFrom() {
        return emailFrom;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public String getEmailTo() {
        return emailTo;
    }

    public void setEmailTo(String emailTo) {
        this.emailTo = emailTo;
    }

    public void sendMail(String emailSubject,String htmlcontent){
        try {
            HtmlEmail email = new HtmlEmail();
            email.setHostName(emailHost);
            email.setSmtpPort(emailPort);
            email.setAuthenticator(new DefaultAuthenticator(emailUserName, emailPassword));
            email.setSSLOnConnect(emailSslFlag);
            email.setFrom(emailFrom);
            email.setSubject(emailSubject);
            email.setHtmlMsg(htmlcontent);
            email.setCharset("utf-8");
            for (String s : emailTo.split(";")) {
                if(s!=null && !s.trim().equals("")){
                    email.addTo(s);
                }
            }
            email.send();
        } catch (EmailException e) {
            e.printStackTrace();
        }
    }
}
