package com.sinosoftgz.monitor.datasource;

import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.sinosoftgz.monitor.common.FiFoMap;
import com.sinosoftgz.monitor.common.FreeMarkers;
import com.sinosoftgz.monitor.common.IoUtils;
import com.sinosoftgz.monitor.common.MailUtils;
import org.apache.commons.mail.*;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created by xiaoqian on 2016/6/6.
 */
public class SlowSqlFilter extends FilterEventAdapter {

    private final AtomicBoolean lockToken = new AtomicBoolean(false);

    ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    private String emailTemplateStr = "";
    private String emailSubject = "长sql监控结果";
    private MailUtils mailUtils;

    /**
     * 长sql报警个数
     */
    private long maxSlowSqlCount = 20L;

    /**
     * 长sql用时
     */
    private long slowSqlTime =30*1000L;

    /**
     * 统计时长
     */
    private long timeInterval = 5 * 60 *1000L;

    private long lastcheck = System.currentTimeMillis();


    public SlowSqlFilter(){
        super();
        InputStream inputStream = null;
        try {
            inputStream = SlowSqlFilter.class.getResource("/monitor_template/email.ftl").openStream();
            emailTemplateStr = IoUtils.inputStreamToString(inputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            try {
                if(inputStream!=null)
                inputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Map<Long,String> map = new FiFoMap(1000);

    @Override
    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean result) {
        logSlowSql(statement, sql);
    }

    @Override
    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        logSlowSql(statement, statement.getLastExecuteSql());
    }


    @Override
    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        logSlowSql(statement, sql);
    }

    @Override
    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        logSlowSql(statement, sql);
    }

    private void logSlowSql(StatementProxy statement, String sql) {
        final long nowNano = System.nanoTime();
        long usetime = (nowNano - statement.getLastExecuteStartNano())/(1000*1000);
        if(usetime>=slowSqlTime){
            map.put(nowNano,new Date(statement.getLastExecuteStartNano()/(1000*1000))+","+sql+",use time :"+usetime +"ms");
            if(map.size()>maxSlowSqlCount){
                final SlowSqlFilter _this = this;
                singleThreadExecutor.execute(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            boolean checkFlag = (System.currentTimeMillis()-timeInterval)>lastcheck;
                            if(checkFlag  && lockToken.compareAndSet(false,true)){
                                long time = nowNano - timeInterval*(1000*1000);
                                lastcheck = System.currentTimeMillis();
                                //remove all oldest sql ; 删除统计时间内的sql
                                Set<Long> keySet = new HashSet<Long>();
                                for (Long key : map.keySet()) {
                                    keySet.add(key);
                                }
                                for (Long aLong : keySet) {
                                    if(aLong<time){//在当前统计时间外
                                        map.remove(aLong);
                                    }
                                }

                                //统计是否大于 @maxSlowSqlCount
                                if(map.size()>maxSlowSqlCount){
                                    //发送报警邮件
                                    Map tmap = new HashMap();
                                    tmap.put("f",_this);
                                    tmap.put("sqls",map.values());
                                    String htmlcontent = FreeMarkers.renderString(emailTemplateStr, tmap);

                                    mailUtils.sendMail(emailSubject,htmlcontent);
                                }
                            }
                        } finally {
                            lockToken.set(false);
                        }
                    }
                });

            }
        }
    }


    public long getMaxSlowSqlCount() {
        return maxSlowSqlCount;
    }

    public void setMaxSlowSqlCount(long maxSlowSqlCount) {
        this.maxSlowSqlCount = maxSlowSqlCount;
    }

    public long getSlowSqlTime() {
        return slowSqlTime;
    }

    public void setSlowSqlTime(long slowSqlTime) {
        this.slowSqlTime = slowSqlTime;
    }

    public long getTimeInterval() {
        return timeInterval;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public Map getMap() {
        return map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public void setEmailTemplateStr(String emailTemplateStr) {
        this.emailTemplateStr = emailTemplateStr;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public MailUtils getMailUtils() {
        return mailUtils;
    }

    public void setMailUtils(MailUtils mailUtils) {
        this.mailUtils = mailUtils;
    }
}
