package com.sinosoftgz.monitor.exception;

import com.sinosoftgz.monitor.common.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by xiaoqian on 2016/6/7.
 */
public class ExceptionFilter implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionFilter.class);

    public static final String ALREADY_FILTERED_SUFFIX = "ExceptionFilter.FILTERED";
    private FilterConfig filterConfig;
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig = filterConfig;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if(request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
            boolean hasAlreadyFilteredAttribute = request.getAttribute(alreadyFilteredAttributeName) != null;
            if(!hasAlreadyFilteredAttribute) {
                request.setAttribute(alreadyFilteredAttributeName, Boolean.TRUE);
                try {
                    long start = System.currentTimeMillis();
                    try {
                        filterChain.doFilter(request, response);
                    } catch (Throwable e) {
                        String body ="";
                        try {
                            body = IoUtils.inputStreamToString(request.getInputStream());
                        } catch (IOException e1) {}
                        StringBuffer stringBuffer = new StringBuffer();
                        logger.error("url :{},usetime:{} ms,prams:{},body:{}",new Object[]{httpRequest.getRequestURI()
                                ,String.valueOf(System.currentTimeMillis() - start), transMapToString(httpRequest.getParameterMap()),body});
                        logger.error(e.getMessage(),e);
                        throw new RuntimeException(e);
                    }


                } finally {
                    request.removeAttribute(alreadyFilteredAttributeName);
                }
            } else {
                filterChain.doFilter(request, response);
            }

        } else {
            throw new ServletException("OncePerRequestFilter just supports HTTP requests");
        }
    }

    @Override
    public void destroy() {

    }

    protected String getAlreadyFilteredAttributeName() {
        String name =  this.getClass().getName();
        return name + ".FILTERED";
    }

    /**
     * 方法名称:transMapToString
     * 传入参数:map
     * 返回值:String 形如 username'chenziwen^password'1234
     */
    public static String transMapToString(Map map){
        java.util.Map.Entry entry;
        StringBuffer sb = new StringBuffer();
        for(Iterator iterator = map.entrySet().iterator(); iterator.hasNext();)
        {
            entry = (java.util.Map.Entry)iterator.next();
            sb.append(entry.getKey().toString()).append( "'" ).append(null==entry.getValue()?"":
                    entry.getValue().toString()).append (iterator.hasNext() ? "^" : "");
        }
        return sb.toString();
    }
}
