/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.monitor.datasource;

import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.sinosoftgz.monitor.common.FiFoMap;
import com.sinosoftgz.monitor.common.FreeMarkers;
import com.sinosoftgz.monitor.common.IoUtils;
import com.sinosoftgz.monitor.common.MailUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class SlowSqlFilter
extends FilterEventAdapter {
    private final AtomicBoolean lockToken = new AtomicBoolean(false);
    ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private String emailTemplateStr = "";
    private String emailSubject = "\u957fsql\u76d1\u63a7\u7ed3\u679c";
    private MailUtils mailUtils;
    private long maxSlowSqlCount = 20L;
    private long slowSqlTime = 30000L;
    private long timeInterval = 300000L;
    private long lastcheck = System.currentTimeMillis();
    private Map<Long, String> map = new FiFoMap<Long, String>(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlowSqlFilter() {
        InputStream inputStream = null;
        try {
            inputStream = SlowSqlFilter.class.getResource("/monitor_template/email.ftl").openStream();
            this.emailTemplateStr = IoUtils.inputStreamToString(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean result) {
        this.logSlowSql(statement, sql);
    }

    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        this.logSlowSql(statement, statement.getLastExecuteSql());
    }

    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        this.logSlowSql(statement, sql);
    }

    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        this.logSlowSql(statement, sql);
    }

    private void logSlowSql(StatementProxy statement, String sql) {
        final long nowNano = System.nanoTime();
        long usetime = (nowNano - statement.getLastExecuteStartNano()) / 1000000L;
        if (usetime >= this.slowSqlTime) {
            this.map.put(nowNano, new Date(statement.getLastExecuteStartNano() / 1000000L) + "," + sql + ",use time :" + usetime + "ms");
            if ((long)this.map.size() > this.maxSlowSqlCount) {
                final SlowSqlFilter _this = this;
                this.singleThreadExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            boolean checkFlag;
                            boolean bl = checkFlag = System.currentTimeMillis() - SlowSqlFilter.this.timeInterval > SlowSqlFilter.this.lastcheck;
                            if (checkFlag && SlowSqlFilter.this.lockToken.compareAndSet(false, true)) {
                                long time = nowNano - SlowSqlFilter.this.timeInterval * 1000000L;
                                SlowSqlFilter.this.lastcheck = System.currentTimeMillis();
                                HashSet<Long> keySet = new HashSet<Long>();
                                for (Long key : SlowSqlFilter.this.map.keySet()) {
                                    keySet.add(key);
                                }
                                for (Long aLong : keySet) {
                                    if (aLong >= time) continue;
                                    SlowSqlFilter.this.map.remove(aLong);
                                }
                                if ((long)SlowSqlFilter.this.map.size() > SlowSqlFilter.this.maxSlowSqlCount) {
                                    HashMap<String, Object> tmap = new HashMap<String, Object>();
                                    tmap.put("f", (Object)_this);
                                    tmap.put("sqls", SlowSqlFilter.this.map.values());
                                    String htmlcontent = FreeMarkers.renderString(SlowSqlFilter.this.emailTemplateStr, tmap);
                                    SlowSqlFilter.this.mailUtils.sendMail(SlowSqlFilter.this.emailSubject, htmlcontent);
                                }
                            }
                        }
                        finally {
                            SlowSqlFilter.this.lockToken.set(false);
                        }
                    }
                });
            }
        }
    }

    public long getMaxSlowSqlCount() {
        return this.maxSlowSqlCount;
    }

    public void setMaxSlowSqlCount(long maxSlowSqlCount) {
        this.maxSlowSqlCount = maxSlowSqlCount;
    }

    public long getSlowSqlTime() {
        return this.slowSqlTime;
    }

    public void setSlowSqlTime(long slowSqlTime) {
        this.slowSqlTime = slowSqlTime;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public void setEmailTemplateStr(String emailTemplateStr) {
        this.emailTemplateStr = emailTemplateStr;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public MailUtils getMailUtils() {
        return this.mailUtils;
    }

    public void setMailUtils(MailUtils mailUtils) {
        this.mailUtils = mailUtils;
    }
}

