/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.monitor.exception;

import com.sinosoftgz.monitor.common.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionFilter.class);
    public static final String ALREADY_FILTERED_SUFFIX = "ExceptionFilter.FILTERED";
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        block10: {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                boolean hasAlreadyFilteredAttribute;
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
                boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(alreadyFilteredAttributeName) != null;
                if (!hasAlreadyFilteredAttribute) {
                    request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
                    try {
                        long start = System.currentTimeMillis();
                        try {
                            filterChain.doFilter(request, response);
                            break block10;
                        }
                        catch (Throwable e) {
                            String body = "";
                            try {
                                body = IoUtils.inputStreamToString((InputStream)request.getInputStream());
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            logger.error("url :{},usetime:{} ms,prams:{},body:{}", new Object[]{httpRequest.getRequestURI(), String.valueOf(System.currentTimeMillis() - start), ExceptionFilter.transMapToString(httpRequest.getParameterMap()), body});
                            logger.error(e.getMessage(), e);
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        request.removeAttribute(alreadyFilteredAttributeName);
                    }
                }
                filterChain.doFilter(request, response);
            } else {
                throw new ServletException("OncePerRequestFilter just supports HTTP requests");
            }
        }
    }

    public void destroy() {
    }

    protected String getAlreadyFilteredAttributeName() {
        String name = this.getClass().getName();
        return name + ".FILTERED";
    }

    public static String transMapToString(Map map) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            sb.append(entry.getKey().toString()).append("'").append(null == entry.getValue() ? "" : entry.getValue().toString()).append(iterator.hasNext() ? "^" : "");
        }
        return sb.toString();
    }
}

