/*
 * Decompiled with CFR 0.152.
 */
package config.client;

import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import com.weibo.api.motan.filter.sleuth.SleuthTracerFactory;
import com.weibo.api.motan.filter.sleuth.SleuthTracingContext;
import config.common.MotanCommonConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@ImportAutoConfiguration(value={MotanCommonConfig.class})
@Configuration
public class MotanClientConfig {
    @Bean(name={"motanClientBasicConfig"})
    public BasicRefererConfigBean baseRefererConfig(@Value(value="${motan.client.group:sinomall}") String motanClientGroup, @Value(value="${motan.client.access.log:false}") Boolean motanClientAccessLog, @Value(value="${spring.sleuth.enabled:false}") Boolean tracing) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (StringUtils.isEmpty((Object)motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanClientGroup);
        }
        if (StringUtils.isEmpty((Object)motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(Integer.valueOf(360000));
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        if (tracing.booleanValue()) {
            config.setFilter("sleuth-tracing");
        }
        return config;
    }

    @Bean(name={"motanClientFastFailConfig"})
    public BasicRefererConfigBean motanClientFastFailConfig(@Value(value="${motan.client.group:sinomall}") String motanClientGroup, @Value(value="${motan.client.access.log:false}") Boolean motanClientAccessLog, @Value(value="${spring.sleuth.enabled:false}") Boolean tracing) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (StringUtils.isEmpty((Object)motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanClientGroup);
        }
        if (StringUtils.isEmpty((Object)motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(Integer.valueOf(60000));
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        if (tracing.booleanValue()) {
            config.setFilter("sleuth-tracing");
        }
        return config;
    }

    @Bean
    @ConditionalOnExpression(value="${spring.sleuth.enabled:false}")
    SleuthTracingContext sleuthTracingContext(final @Autowired(required=false) Tracer tracer) {
        SleuthTracingContext context = new SleuthTracingContext();
        context.setTracerFactory(new SleuthTracerFactory(){

            public Tracer getTracer() {
                return tracer;
            }
        });
        return context;
    }
}

