/*
 * Decompiled with CFR 0.152.
 */
package config.common;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.springsupport.AnnotationBean;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=-1)
@Configuration
public class MotanCommonConfig {
    @Bean
    @ConditionalOnMissingBean
    public AnnotationBean motanAnnotationBean(@Value(value="${motan.beans.package:}") String motanBeansPackage) {
        AnnotationBean motanAnnotationBean = new AnnotationBean();
        if (StringUtils.hasLength((String)motanBeansPackage)) {
            motanAnnotationBean.setPackage(motanBeansPackage);
        }
        if (motanAnnotationBean.getPackage() == null && !"close".equals(motanBeansPackage)) {
            throw new RuntimeException("\u8bf7\u914d\u7f6ematon api \u5305");
        }
        return motanAnnotationBean;
    }

    @Bean(name={"motan"})
    @ConditionalOnMissingBean
    public ProtocolConfigBean protocolConfig(@Value(value="${motan.service.maxWorkerThread:200}") Integer maxWorkerThread, @Value(value="${motan.service.minWorkerThread:20}") Integer minWorkerThread) {
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(true);
        config.setSerialization("hessian2Extension");
        config.setName("motan");
        config.setMaxContentLength(Integer.valueOf(0xA00000));
        config.setMaxWorkerThread(Integer.valueOf(maxWorkerThread == null ? 200 : maxWorkerThread));
        config.setMinWorkerThread(Integer.valueOf(minWorkerThread == null ? 20 : minWorkerThread));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(URLParamType.endpointFactory.getName(), "eleganceMotan");
        config.setParameters(parameters);
        return config;
    }

    @Bean(name={"registry"})
    @ConditionalOnMissingBean
    public RegistryConfigBean registryConfigSit(@Value(value="${motan.zookeeper.host:}") String zookeeperAddress) {
        RegistryConfigBean config = new RegistryConfigBean();
        config.setDefault(true);
        config.setRegProtocol("zookeeper");
        config.setAddress(zookeeperAddress);
        config.setConnectTimeout(Integer.valueOf(30000));
        return config;
    }
}

