/*
 * Decompiled with CFR 0.152.
 */
package config.service;

import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.filter.sleuth.SleuthTracerFactory;
import com.weibo.api.motan.filter.sleuth.SleuthTracingContext;
import config.common.MotanCommonConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@ImportAutoConfiguration(value={MotanCommonConfig.class})
@Configuration
public class MotanServiceConfig {
    @Bean(name={"motanServerBasicConfig"})
    @ConditionalOnMissingBean
    public BasicServiceConfigBean baseServiceConfig(@Value(value="${motan.export.port}") String port, @Value(value="${motan.service.group:sinomall}") String motanServerGroup, @Value(value="${motan.service.access.log:false}") Boolean motanServerAccessLog, @Value(value="${spring.sleuth.enabled:false}") Boolean tracing) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        config.setExport("motan:" + port);
        if (StringUtils.isEmpty((Object)motanServerGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanServerGroup);
        }
        if (StringUtils.isEmpty((Object)motanServerAccessLog)) {
            config.setAccessLog(true);
        } else {
            config.setAccessLog(motanServerAccessLog.booleanValue());
        }
        config.setShareChannel(Boolean.valueOf(true));
        config.setRequestTimeout(Integer.valueOf(60000));
        config.setRegistry("registry");
        if (tracing.booleanValue()) {
            config.setFilter("sleuth-tracing");
        }
        return config;
    }

    @Bean
    @ConditionalOnExpression(value="${spring.sleuth.enabled:false}")
    SleuthTracingContext sleuthTracingContext(final @Autowired(required=false) Tracer tracer) {
        SleuthTracingContext context = new SleuthTracingContext();
        context.setTracerFactory(new SleuthTracerFactory(){

            public Tracer getTracer() {
                return tracer;
            }
        });
        return context;
    }
}

