/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Util;
import java.sql.SQLException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    Field[] fields;
    boolean useOldAliasBehavior = false;

    private static int clampedGetLength(Field f) {
        long fieldLength = f.getLength();
        if (fieldLength > Integer.MAX_VALUE) {
            fieldLength = Integer.MAX_VALUE;
        }
        return (int)fieldLength;
    }

    private static final boolean isDecimalType(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public ResultSetMetaData(Field[] fields, boolean useOldAliasBehavior) {
        this.fields = fields;
        this.useOldAliasBehavior = useOldAliasBehavior;
    }

    public String getCatalogName(int column) throws SQLException {
        Field f = this.getField(column);
        String database = f.getDatabaseName();
        return database == null ? "" : database;
    }

    public String getColumnCharacterEncoding(int column) throws SQLException {
        String mysqlName = this.getColumnCharacterSet(column);
        String javaName = null;
        if (mysqlName != null) {
            javaName = CharsetMapping.getJavaEncodingForMysqlEncoding(mysqlName, null);
        }
        return javaName;
    }

    public String getColumnCharacterSet(int column) throws SQLException {
        return this.getField(column).getCharacterSet();
    }

    public String getColumnClassName(int column) throws SQLException {
        Field f = this.getField(column);
        return ResultSetMetaData.getClassNameForJavaType(f.getSQLType(), f.isUnsigned(), f.getMysqlType(), f.isBinary() || f.isBlob(), f.isOpaqueBinary());
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        Field f = this.getField(column);
        int lengthInBytes = ResultSetMetaData.clampedGetLength(f);
        return lengthInBytes / f.getMaxBytesPerCharacter();
    }

    public String getColumnLabel(int column) throws SQLException {
        if (this.useOldAliasBehavior) {
            return this.getColumnName(column);
        }
        return this.getField(column).getColumnLabel();
    }

    public String getColumnName(int column) throws SQLException {
        if (this.useOldAliasBehavior) {
            return this.getField(column).getName();
        }
        String name = this.getField(column).getNameNoAliases();
        if (name != null && name.length() == 0) {
            return this.getField(column).getName();
        }
        return name;
    }

    public int getColumnType(int column) throws SQLException {
        return this.getField(column).getSQLType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        Field field = this.getField(column);
        int mysqlType = field.getMysqlType();
        int jdbcType = field.getSQLType();
        switch (mysqlType) {
            case 16: {
                return "BIT";
            }
            case 0: 
            case 246: {
                return field.isUnsigned() ? "DECIMAL UNSIGNED" : "DECIMAL";
            }
            case 1: {
                return field.isUnsigned() ? "TINYINT UNSIGNED" : "TINYINT";
            }
            case 2: {
                return field.isUnsigned() ? "SMALLINT UNSIGNED" : "SMALLINT";
            }
            case 3: {
                return field.isUnsigned() ? "INTEGER UNSIGNED" : "INTEGER";
            }
            case 4: {
                return field.isUnsigned() ? "FLOAT UNSIGNED" : "FLOAT";
            }
            case 5: {
                return field.isUnsigned() ? "DOUBLE UNSIGNED" : "DOUBLE";
            }
            case 6: {
                return "NULL";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return field.isUnsigned() ? "BIGINT UNSIGNED" : "BIGINT";
            }
            case 9: {
                return field.isUnsigned() ? "MEDIUMINT UNSIGNED" : "MEDIUMINT";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIME";
            }
            case 12: {
                return "DATETIME";
            }
            case 249: {
                return "TINYBLOB";
            }
            case 250: {
                return "MEDIUMBLOB";
            }
            case 251: {
                return "LONGBLOB";
            }
            case 252: {
                if (this.getField(column).isBinary()) {
                    return "BLOB";
                }
                return "TEXT";
            }
            case 15: {
                return "VARCHAR";
            }
            case 253: {
                if (jdbcType == -3) {
                    return "VARBINARY";
                }
                return "VARCHAR";
            }
            case 254: {
                if (jdbcType == -2) {
                    return "BINARY";
                }
                return "CHAR";
            }
            case 247: {
                return "ENUM";
            }
            case 13: {
                return "YEAR";
            }
            case 248: {
                return "SET";
            }
        }
        return "UNKNOWN";
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw SQLError.createSQLException(Messages.getString("ResultSetMetaData.46"), "S1002");
        }
        return this.fields[columnIndex - 1];
    }

    public int getPrecision(int column) throws SQLException {
        Field f = this.getField(column);
        if (ResultSetMetaData.isDecimalType(f.getSQLType())) {
            if (f.getDecimals() > 0) {
                return ResultSetMetaData.clampedGetLength(f) - 1 + f.getPrecisionAdjustFactor();
            }
            return ResultSetMetaData.clampedGetLength(f) + f.getPrecisionAdjustFactor();
        }
        switch (f.getMysqlType()) {
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                return ResultSetMetaData.clampedGetLength(f);
            }
        }
        return ResultSetMetaData.clampedGetLength(f) / f.getMaxBytesPerCharacter();
    }

    public int getScale(int column) throws SQLException {
        Field f = this.getField(column);
        if (ResultSetMetaData.isDecimalType(f.getSQLType())) {
            return f.getDecimals();
        }
        return 0;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public String getTableName(int column) throws SQLException {
        if (this.useOldAliasBehavior) {
            return this.getField(column).getTableName();
        }
        return this.getField(column).getTableNameNoAliases();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        Field f = this.getField(column);
        return f.isAutoIncrement();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                if (field.isBinary()) {
                    return true;
                }
                String collationName = field.getCollation();
                return collationName != null && !collationName.endsWith("_ci");
            }
        }
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    public int isNullable(int column) throws SQLException {
        if (!this.getField(column).isNotNull()) {
            return 1;
        }
        return 0;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return this.getField(column).isReadOnly();
    }

    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    public boolean isSigned(int column) throws SQLException {
        Field f = this.getField(column);
        int sqlType = f.getSQLType();
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return !f.isUnsigned();
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append(super.toString());
        toStringBuf.append(" - Field level information: ");
        for (int i = 0; i < this.fields.length; ++i) {
            toStringBuf.append("\n\t");
            toStringBuf.append(this.fields[i].toString());
        }
        return toStringBuf.toString();
    }

    static String getClassNameForJavaType(int javaType, boolean isUnsigned, int mysqlTypeIfKnown, boolean isBinaryOrBlob, boolean isOpaqueBinary) {
        switch (javaType) {
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -6: {
                if (isUnsigned) {
                    return "java.lang.Integer";
                }
                return "java.lang.Integer";
            }
            case 5: {
                if (isUnsigned) {
                    return "java.lang.Integer";
                }
                return "java.lang.Integer";
            }
            case 4: {
                if (!isUnsigned || mysqlTypeIfKnown == 9) {
                    return "java.lang.Integer";
                }
                return "java.lang.Long";
            }
            case -5: {
                if (!isUnsigned) {
                    return "java.lang.Long";
                }
                return "java.math.BigInteger";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -1: 
            case 1: 
            case 12: {
                if (!isOpaqueBinary) {
                    return "java.lang.String";
                }
                return "[B";
            }
            case -4: 
            case -3: 
            case -2: {
                if (mysqlTypeIfKnown == 255) {
                    return "[B";
                }
                if (isBinaryOrBlob) {
                    return "[B";
                }
                return "java.lang.String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return iface.isInstance(this);
    }

    public Object unwrap(Class iface) throws SQLException {
        try {
            return Util.cast(iface, this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009");
        }
    }
}

