/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.CacheAdapter;
import com.mysql.cj.api.CacheAdapterFactory;
import com.mysql.cj.api.Extension;
import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.conf.ModifiableProperty;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.jdbc.ClientInfoProvider;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.ResultSetInternalMethods;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.interceptors.ConnectionLifecycleInterceptor;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptor;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptorV2;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.core.CharsetMapping;
import com.mysql.cj.core.ConnectionString;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.LicenseConfiguration;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ConnectionIsClosedException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.PasswordExpiredException;
import com.mysql.cj.core.exceptions.UnableToConnectException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.SocksProxySocketFactory;
import com.mysql.cj.core.log.LogFactory;
import com.mysql.cj.core.log.StandardLogger;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.LRUCache;
import com.mysql.cj.core.util.LogUtils;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.AbstractJdbcConnection;
import com.mysql.cj.jdbc.Blob;
import com.mysql.cj.jdbc.CachedResultSetMetaData;
import com.mysql.cj.jdbc.CallableStatement;
import com.mysql.cj.jdbc.Clob;
import com.mysql.cj.jdbc.DatabaseMetaData;
import com.mysql.cj.jdbc.EscapeProcessor;
import com.mysql.cj.jdbc.EscapeProcessorResult;
import com.mysql.cj.jdbc.IterateBlock;
import com.mysql.cj.jdbc.MysqlSQLXML;
import com.mysql.cj.jdbc.MysqlSavepoint;
import com.mysql.cj.jdbc.NClob;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import com.mysql.cj.jdbc.PreparedStatement;
import com.mysql.cj.jdbc.ServerPreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.UpdatableResultSet;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.ha.MultiHostMySQLConnection;
import com.mysql.cj.jdbc.interceptors.NoSubInterceptorWrapper;
import com.mysql.cj.jdbc.interceptors.ReflectiveStatementInterceptorAdapter;
import com.mysql.cj.jdbc.interceptors.V1toV2StatementInterceptorAdapter;
import com.mysql.cj.jdbc.util.ResultSetUtil;
import com.mysql.cj.mysqla.MysqlaSession;
import com.mysql.cj.mysqla.MysqlaUtils;
import com.mysql.cj.mysqla.io.Buffer;
import java.lang.reflect.InvocationHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Array;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;
import java.util.Timer;
import java.util.TreeMap;
import java.util.concurrent.Executor;

public class ConnectionImpl
extends AbstractJdbcConnection
implements JdbcConnection {
    private static final long serialVersionUID = 2877471301981509474L;
    private static final SQLPermission SET_NETWORK_TIMEOUT_PERM = new SQLPermission("setNetworkTimeout");
    private static final SQLPermission ABORT_PERM = new SQLPermission("abort");
    public static final String JDBC_LOCAL_CHARACTER_SET_RESULTS = "jdbc.local.character_set_results";
    private JdbcConnection proxy = null;
    private InvocationHandler realProxy = null;
    public static Map<?, ?> charsetMap;
    protected static final String DEFAULT_LOGGER_CLASS;
    private static final int HISTOGRAM_BUCKETS = 20;
    private static Map<String, Integer> mapTransIsolationNameToValue;
    protected static Map<?, ?> roundRobinStatsMap;
    private static final Map<String, Map<Long, String>> dynamicIndexToCollationMapByUrl;
    private static final Map<String, Map<Integer, String>> dynamicIndexToCharsetMapByUrl;
    private static final Map<String, Map<Integer, String>> customIndexToCharsetMapByUrl;
    private static final Map<String, Map<String, Integer>> customCharsetToMblenMapByUrl;
    private CacheAdapter<String, Map<String, String>> serverConfigCache;
    private long queryTimeCount;
    private double queryTimeSum;
    private double queryTimeSumSquares;
    private double queryTimeMean;
    private transient Timer cancelTimer;
    private List<Extension> connectionLifecycleInterceptors;
    private static final int DEFAULT_RESULT_SET_TYPE = 1003;
    private static final int DEFAULT_RESULT_SET_CONCURRENCY = 1007;
    private static final Random random;
    private boolean autoCommit = true;
    private CacheAdapter<String, PreparedStatement.ParseInfo> cachedPreparedStatementParams;
    private String characterSetMetadata = null;
    private String characterSetResultsOnServer = null;
    private long connectionCreationTimeMillis = 0L;
    private long connectionId;
    private String database = null;
    private java.sql.DatabaseMetaData dbmd = null;
    private Throwable forceClosedReason;
    private MysqlaSession session = null;
    private boolean isClosed = true;
    private boolean isInGlobalTx = false;
    private int isolationLevel = 2;
    private long lastQueryFinishedTime = 0L;
    private long longestQueryTimeMs = 0L;
    private boolean lowerCaseTableNames = false;
    private long maximumNumberTablesAccessed = 0L;
    private long metricsLastReportedMs;
    private long minimumNumberTablesAccessed = Long.MAX_VALUE;
    private boolean needsPing = false;
    private boolean noBackslashEscapes = false;
    private long numberOfPreparedExecutes = 0L;
    private long numberOfPrepares = 0L;
    private long numberOfQueriesIssued = 0L;
    private long numberOfResultSetsCreated = 0L;
    private long[] numTablesMetricsHistBreakpoints;
    private int[] numTablesMetricsHistCounts;
    private long[] oldHistBreakpoints = null;
    private int[] oldHistCounts = null;
    private Map<Statement, Statement> openStatements = new HashMap<Statement, Statement>();
    private LRUCache parsedCallableStatementCache;
    private String password = null;
    private long[] perfMetricsHistBreakpoints;
    private int[] perfMetricsHistCounts;
    private String pointOfOrigin;
    protected Properties props = null;
    private boolean readInfoMsg = false;
    private boolean readOnly = false;
    protected LRUCache resultSetMetadataCache;
    private long shortestQueryTimeMs = Long.MAX_VALUE;
    private double totalQueryTimeMs = 0.0;
    private Map<String, Class<?>> typeMap;
    private boolean useAnsiQuotes = false;
    private String user = null;
    private boolean useServerPreparedStmts = false;
    private LRUCache serverSideStatementCheckCache;
    private LRUCache serverSideStatementCache;
    private ConnectionString origConnectionString;
    private String origHostToConnectTo;
    private int origPortToConnectTo;
    private boolean hasTriedMasterFlag = false;
    private String statementComment = null;
    private boolean storesLowerCaseTableName;
    private List<StatementInterceptorV2> statementInterceptors;
    private boolean requiresEscapingEncoder;
    private ModifiableProperty<String> characterEncoding;
    private ReadableProperty<Boolean> autoReconnectForPools;
    private ReadableProperty<Boolean> cachePrepStmts;
    private ReadableProperty<Boolean> cacheServerConfiguration;
    private ModifiableProperty<Boolean> autoReconnect;
    private ModifiableProperty<Boolean> profileSQL;
    private ReadableProperty<Boolean> useUsageAdvisor;
    private ReadableProperty<Boolean> reconnectAtTxEnd;
    private ReadableProperty<Boolean> useOldUTF8Behavior;
    private ReadableProperty<Boolean> maintainTimeStats;
    private ReadableProperty<Boolean> emulateUnsupportedPstmts;
    private ReadableProperty<Boolean> gatherPerfMetrics;
    private ReadableProperty<Boolean> ignoreNonTxTables;
    private ReadableProperty<Boolean> pedantic;
    private ReadableProperty<Integer> prepStmtCacheSqlLimit;
    private ReadableProperty<Boolean> useLocalSessionState;
    private ReadableProperty<Boolean> useServerPrepStmts;
    private ReadableProperty<Boolean> processEscapeCodesForPrepStmts;
    private ReadableProperty<Boolean> useLocalTransactionState;
    protected ModifiableProperty<Integer> maxAllowedPacket;
    private ReadableProperty<Boolean> disconnectOnExpiredPasswords;
    private ReadableProperty<Boolean> readOnlyPropagatesToServer;
    private static final String SERVER_VERSION_STRING_VAR_NAME = "server_version_string";
    private int autoIncrementIncrement = 0;
    private ExceptionInterceptor exceptionInterceptor;
    private ClientInfoProvider infoProvider;

    @Override
    public String getHost() {
        return this.session.getHostInfo().getHost();
    }

    @Override
    public boolean isProxySet() {
        return this.proxy != null;
    }

    @Override
    public void setProxy(JdbcConnection proxy) {
        this.proxy = proxy;
        this.realProxy = this.proxy instanceof MultiHostMySQLConnection ? ((MultiHostMySQLConnection)proxy).getThisAsProxy() : null;
    }

    private JdbcConnection getProxy() {
        return this.proxy != null ? this.proxy : this;
    }

    @Override
    public JdbcConnection getMultiHostSafeProxy() {
        return this.getProxy();
    }

    @Override
    public Object getConnectionMutex() {
        return this.realProxy != null ? this.realProxy : this.getProxy();
    }

    protected static SQLException appendMessageToException(SQLException sqlEx, String messageToAppend, ExceptionInterceptor interceptor) {
        String origMessage = sqlEx.getMessage();
        String sqlState = sqlEx.getSQLState();
        int vendorErrorCode = sqlEx.getErrorCode();
        StringBuilder messageBuf = new StringBuilder(origMessage.length() + messageToAppend.length());
        messageBuf.append(origMessage);
        messageBuf.append(messageToAppend);
        SQLException sqlExceptionWithNewMessage = SQLError.createSQLException(messageBuf.toString(), sqlState, vendorErrorCode, interceptor);
        sqlExceptionWithNewMessage.setStackTrace(sqlEx.getStackTrace());
        return sqlExceptionWithNewMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timer getCancelTimer() {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            if (this.cancelTimer == null) {
                this.cancelTimer = new Timer("MySQL Statement Cancellation Timer", Boolean.TRUE);
            }
            return this.cancelTimer;
        }
    }

    public static JdbcConnection getInstance(ConnectionString connectionString, String hostToConnectTo, int portToConnectTo, Properties info) throws SQLException {
        return new ConnectionImpl(connectionString, hostToConnectTo, portToConnectTo, info);
    }

    protected static synchronized int getNextRoundRobinHostIndex(String url, List<?> hostList) {
        int indexRange = hostList.size();
        int index = random.nextInt(indexRange);
        return index;
    }

    private static boolean nullSafeCompare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1 != null && s1.equals(s2);
    }

    protected ConnectionImpl() {
    }

    public ConnectionImpl(ConnectionString connectionString, String hostToConnectTo, int portToConnectTo, Properties info) throws SQLException {
        try {
            this.connectionCreationTimeMillis = System.currentTimeMillis();
            this.origConnectionString = connectionString;
            this.origHostToConnectTo = hostToConnectTo;
            this.origPortToConnectTo = portToConnectTo;
            this.session = new MysqlaSession(this.origConnectionString, hostToConnectTo, portToConnectTo, info, this.getPropertySet());
            this.characterEncoding = this.getPropertySet().getJdbcModifiableProperty("characterEncoding");
            this.autoReconnectForPools = this.getPropertySet().getBooleanReadableProperty("autoReconnectForPools");
            this.cachePrepStmts = this.getPropertySet().getBooleanReadableProperty("cachePrepStmts");
            this.cacheServerConfiguration = this.getPropertySet().getBooleanReadableProperty("cacheServerConfiguration");
            this.autoReconnect = this.getPropertySet().getModifiableProperty("autoReconnect");
            this.profileSQL = this.getPropertySet().getModifiableProperty("profileSQL");
            this.useUsageAdvisor = this.getPropertySet().getBooleanReadableProperty("useUsageAdvisor");
            this.reconnectAtTxEnd = this.getPropertySet().getBooleanReadableProperty("reconnectAtTxEnd");
            this.useOldUTF8Behavior = this.getPropertySet().getBooleanReadableProperty("useOldUTF8Behavior");
            this.maintainTimeStats = this.getPropertySet().getBooleanReadableProperty("maintainTimeStats");
            this.emulateUnsupportedPstmts = this.getPropertySet().getBooleanReadableProperty("emulateUnsupportedPstmts");
            this.gatherPerfMetrics = this.getPropertySet().getBooleanReadableProperty("gatherPerfMetrics");
            this.ignoreNonTxTables = this.getPropertySet().getBooleanReadableProperty("ignoreNonTxTables");
            this.pedantic = this.getPropertySet().getBooleanReadableProperty("pedantic");
            this.prepStmtCacheSqlLimit = this.getPropertySet().getIntegerReadableProperty("prepStmtCacheSqlLimit");
            this.useLocalSessionState = this.getPropertySet().getBooleanReadableProperty("useLocalSessionState");
            this.useServerPrepStmts = this.getPropertySet().getBooleanReadableProperty("useServerPrepStmts");
            this.processEscapeCodesForPrepStmts = this.getPropertySet().getBooleanReadableProperty("processEscapeCodesForPrepStmts");
            this.useLocalTransactionState = this.getPropertySet().getBooleanReadableProperty("useLocalTransactionState");
            this.maxAllowedPacket = this.getPropertySet().getModifiableProperty("maxAllowedPacket");
            this.disconnectOnExpiredPasswords = this.getPropertySet().getBooleanReadableProperty("disconnectOnExpiredPasswords");
            this.readOnlyPropagatesToServer = this.getPropertySet().getBooleanReadableProperty("readOnlyPropagatesToServer");
            this.database = this.origConnectionString.getDatabase();
            this.user = info.getProperty("user");
            this.password = info.getProperty("password");
            if (this.user == null || this.user.equals("")) {
                this.user = "";
            }
            if (this.password == null) {
                this.password = "";
            }
            this.props = info;
            this.initializeDriverProperties(info);
            this.pointOfOrigin = this.useUsageAdvisor.getValue() != false ? LogUtils.findCallingClassAndMethod(new Throwable()) : "";
            this.dbmd = this.getMetaData(false, false);
            this.initializeSafeStatementInterceptors();
        }
        catch (CJException e1) {
            throw SQLExceptionsMapping.translateException(e1, this.getExceptionInterceptor());
        }
        try {
            this.createNewIO(false);
            this.unSafeStatementInterceptors();
            NonRegisteringDriver.trackConnection(this);
        }
        catch (SQLException ex) {
            this.cleanup(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.cleanup(ex);
            throw SQLError.createSQLException(this.propertySet.getBooleanReadableProperty("paranoid").getValue() != false ? Messages.getString("Connection.0") : Messages.getString("Connection.1", new Object[]{this.session.getHostInfo().getHost(), this.session.getHostInfo().getPort()}), "08S01", ex, this.getExceptionInterceptor());
        }
    }

    @Override
    public void unSafeStatementInterceptors() throws SQLException {
        try {
            ArrayList<StatementInterceptorV2> unSafedStatementInterceptors = new ArrayList<StatementInterceptorV2>(this.statementInterceptors.size());
            for (int i = 0; i < this.statementInterceptors.size(); ++i) {
                NoSubInterceptorWrapper wrappedInterceptor = (NoSubInterceptorWrapper)this.statementInterceptors.get(i);
                unSafedStatementInterceptors.add(wrappedInterceptor.getUnderlyingInterceptor());
            }
            this.statementInterceptors = unSafedStatementInterceptors;
            if (this.session != null) {
                this.session.setStatementInterceptors(this.statementInterceptors);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void initializeSafeStatementInterceptors() throws SQLException {
        try {
            this.isClosed = false;
            List<Extension> unwrappedInterceptors = Util.loadExtensions(this, this.props, this.getPropertySet().getStringReadableProperty("statementInterceptors").getStringValue(), "MysqlIo.BadStatementInterceptor", this.getExceptionInterceptor(), this.session.getLog());
            this.statementInterceptors = new ArrayList<StatementInterceptorV2>(unwrappedInterceptors.size());
            for (int i = 0; i < unwrappedInterceptors.size(); ++i) {
                Extension interceptor = unwrappedInterceptors.get(i);
                if (interceptor instanceof StatementInterceptor) {
                    if (ReflectiveStatementInterceptorAdapter.getV2PostProcessMethod(interceptor.getClass()) != null) {
                        this.statementInterceptors.add(new NoSubInterceptorWrapper(new ReflectiveStatementInterceptorAdapter((StatementInterceptor)interceptor)));
                        continue;
                    }
                    this.statementInterceptors.add(new NoSubInterceptorWrapper(new V1toV2StatementInterceptorAdapter((StatementInterceptor)interceptor)));
                    continue;
                }
                this.statementInterceptors.add(new NoSubInterceptorWrapper((StatementInterceptorV2)interceptor));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public List<StatementInterceptorV2> getStatementInterceptorsInstances() {
        return this.statementInterceptors;
    }

    private void addToHistogram(int[] histogramCounts, long[] histogramBreakpoints, long value, int numberOfTimes, long currentLowerBound, long currentUpperBound) {
        if (histogramCounts == null) {
            this.createInitialHistogram(histogramBreakpoints, currentLowerBound, currentUpperBound);
        } else {
            for (int i = 0; i < 20; ++i) {
                if (histogramBreakpoints[i] < value) continue;
                int n = i;
                histogramCounts[n] = histogramCounts[n] + numberOfTimes;
                break;
            }
        }
    }

    private void addToPerformanceHistogram(long value, int numberOfTimes) {
        this.checkAndCreatePerformanceHistogram();
        this.addToHistogram(this.perfMetricsHistCounts, this.perfMetricsHistBreakpoints, value, numberOfTimes, this.shortestQueryTimeMs == Long.MAX_VALUE ? 0L : this.shortestQueryTimeMs, this.longestQueryTimeMs);
    }

    private void addToTablesAccessedHistogram(long value, int numberOfTimes) {
        this.checkAndCreateTablesAccessedHistogram();
        this.addToHistogram(this.numTablesMetricsHistCounts, this.numTablesMetricsHistBreakpoints, value, numberOfTimes, this.minimumNumberTablesAccessed == Long.MAX_VALUE ? 0L : this.minimumNumberTablesAccessed, this.maximumNumberTablesAccessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void buildCollationMapping() throws SQLException {
        indexToCharset = null;
        sortedCollationMap = null;
        customCharset = null;
        customMblen = null;
        if (this.cacheServerConfiguration.getValue().booleanValue()) {
            var5_5 = ConnectionImpl.dynamicIndexToCharsetMapByUrl;
            synchronized (var5_5) {
                indexToCharset = ConnectionImpl.dynamicIndexToCharsetMapByUrl.get(this.getURL());
                sortedCollationMap = ConnectionImpl.dynamicIndexToCollationMapByUrl.get(this.getURL());
                customCharset = ConnectionImpl.customIndexToCharsetMapByUrl.get(this.getURL());
                customMblen = ConnectionImpl.customCharsetToMblenMapByUrl.get(this.getURL());
            }
        }
        if (indexToCharset == null) {
            indexToCharset = new HashMap<Integer, String>();
            if (this.getPropertySet().getBooleanReadableProperty("detectCustomCollations").getValue().booleanValue()) {
                stmt = null;
                results = null;
                try {
                    block44: {
                        block43: {
                            sortedCollationMap = new TreeMap<Long, String>();
                            customCharset = new HashMap<Integer, String>();
                            customMblen = new HashMap<String, Integer>();
                            stmt = this.getMetadataSafeStatement();
                            try {
                                results = stmt.executeQuery("SHOW COLLATION");
                                ResultSetUtil.resultSetToMap(sortedCollationMap, results, 3, 2);
                            }
                            catch (PasswordExpiredException ex) {
                                if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                                    throw ex;
                                }
                            }
                            catch (SQLException ex) {
                                if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block43;
                                throw ex;
                            }
                        }
                        for (Map.Entry<Long, String> indexEntry : sortedCollationMap.entrySet()) {
                            collationIndex = indexEntry.getKey().intValue();
                            charsetName = indexEntry.getValue();
                            indexToCharset.put(collationIndex, charsetName);
                            if (collationIndex >= 255 || !charsetName.equals(CharsetMapping.getMysqlCharsetNameForCollationIndex(collationIndex))) {
                                customCharset.put(collationIndex, charsetName);
                            }
                            if (CharsetMapping.CHARSET_NAME_TO_CHARSET.containsKey(charsetName)) continue;
                            customMblen.put(charsetName, null);
                        }
                        if (customMblen.size() > 0) {
                            try {
                                results = stmt.executeQuery("SHOW CHARACTER SET");
                                while (results.next()) {
                                    charsetName = results.getString("Charset");
                                    if (!customMblen.containsKey(charsetName)) continue;
                                    customMblen.put(charsetName, results.getInt("Maxlen"));
                                }
                            }
                            catch (PasswordExpiredException ex) {
                                if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                                    throw ex;
                                }
                            }
                            catch (SQLException ex) {
                                if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block44;
                                throw ex;
                            }
                        }
                    }
                    if (!this.cacheServerConfiguration.getValue().booleanValue()) ** GOTO lbl115
                    ex = ConnectionImpl.dynamicIndexToCharsetMapByUrl;
                    synchronized (ex) {
                        ConnectionImpl.dynamicIndexToCharsetMapByUrl.put(this.getURL(), indexToCharset);
                        ConnectionImpl.dynamicIndexToCollationMapByUrl.put(this.getURL(), sortedCollationMap);
                        ConnectionImpl.customIndexToCharsetMapByUrl.put(this.getURL(), customCharset);
                        ConnectionImpl.customCharsetToMblenMapByUrl.put(this.getURL(), customMblen);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    sqlEx = SQLError.createSQLException(ex.toString(), "S1009", null);
                    sqlEx.initCause(ex);
                    throw sqlEx;
                }
                finally {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException var13_25) {}
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException var13_26) {}
                    }
                }
            } else {
                for (i = 1; i < 255; ++i) {
                    indexToCharset.put(i, CharsetMapping.getMysqlCharsetNameForCollationIndex(i));
                }
                if (this.cacheServerConfiguration.getValue().booleanValue()) {
                    var5_7 = ConnectionImpl.dynamicIndexToCharsetMapByUrl;
                    synchronized (var5_7) {
                        ConnectionImpl.dynamicIndexToCharsetMapByUrl.put(this.getURL(), indexToCharset);
                    }
                }
            }
        }
lbl115:
        // 7 sources

        this.session.setCharsetMaps(indexToCharset, customCharset, customMblen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canHandleAsServerPreparedStatement(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            return true;
        }
        if (!this.useServerPreparedStmts) {
            return false;
        }
        if (this.cachePrepStmts.getValue().booleanValue()) {
            LRUCache lRUCache = this.serverSideStatementCheckCache;
            synchronized (lRUCache) {
                Boolean flag = (Boolean)this.serverSideStatementCheckCache.get(sql);
                if (flag != null) {
                    return flag;
                }
                boolean canHandle = StringUtils.canHandleAsServerPreparedStatementNoCache(sql);
                if (sql.length() < this.prepStmtCacheSqlLimit.getValue()) {
                    this.serverSideStatementCheckCache.put(sql, canHandle ? Boolean.TRUE : Boolean.FALSE);
                }
                return canHandle;
            }
        }
        return StringUtils.canHandleAsServerPreparedStatementNoCache(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeUser(String userName, String newPassword) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                if (userName == null || userName.equals("")) {
                    userName = "";
                }
                if (newPassword == null) {
                    newPassword = "";
                }
                try {
                    this.session.changeUser(userName, newPassword, this.database);
                }
                catch (CJException ex) {
                    if ("28000".equals(ex.getSQLState())) {
                        this.cleanup(ex);
                    }
                    throw ex;
                }
                this.user = userName;
                this.password = newPassword;
                this.configureClientCharacterSet(true);
                this.setSessionVariables();
                this.setupServerForTruncationChecks();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void checkAndCreatePerformanceHistogram() {
        if (this.perfMetricsHistCounts == null) {
            this.perfMetricsHistCounts = new int[20];
        }
        if (this.perfMetricsHistBreakpoints == null) {
            this.perfMetricsHistBreakpoints = new long[20];
        }
    }

    private void checkAndCreateTablesAccessedHistogram() {
        if (this.numTablesMetricsHistCounts == null) {
            this.numTablesMetricsHistCounts = new int[20];
        }
        if (this.numTablesMetricsHistBreakpoints == null) {
            this.numTablesMetricsHistBreakpoints = new long[20];
        }
    }

    @Override
    public void checkClosed() {
        if (this.isClosed) {
            throw ExceptionFactory.createException(ConnectionIsClosedException.class, Messages.getString("Connection.2"), this.forceClosedReason, this.getExceptionInterceptor());
        }
    }

    @Override
    public void throwConnectionClosedException() throws SQLException {
        try {
            SQLException ex = SQLError.createSQLException(Messages.getString("Connection.2"), "08003", this.getExceptionInterceptor());
            if (this.forceClosedReason != null) {
                ex.initCause(this.forceClosedReason);
            }
            throw ex;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer intTI;
        String s = this.session.getServerVariable("tx_isolation");
        if (s != null && (intTI = mapTransIsolationNameToValue.get(s)) != null) {
            this.isolationLevel = intTI;
        }
    }

    @Override
    public void abortInternal() throws SQLException {
        try {
            this.session.abortInternal();
            this.isClosed = true;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void cleanup(Throwable whyCleanedUp) {
        try {
            if (this.session != null) {
                if (this.isClosed()) {
                    this.session.forceClose();
                } else {
                    this.realClose(false, false, false, whyCleanedUp);
                }
            }
        }
        catch (CJException | SQLException exception) {
            // empty catch block
        }
        this.isClosed = true;
    }

    @Override
    @Deprecated
    public void clearHasTriedMaster() {
        this.hasTriedMasterFlag = false;
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement clientPrepareStatement(String sql) throws SQLException {
        try {
            return this.clientPrepareStatement(sql, 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement clientPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            java.sql.PreparedStatement pStmt = this.clientPrepareStatement(sql);
            ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.clientPrepareStatement(sql, resultSetType, resultSetConcurrency, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public java.sql.PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, boolean processEscapeCodesIfNeeded) throws SQLException {
        try {
            this.checkClosed();
            String nativeSql = processEscapeCodesIfNeeded && this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            PreparedStatement pStmt = null;
            if (this.cachePrepStmts.getValue().booleanValue()) {
                PreparedStatement.ParseInfo pStmtInfo = this.cachedPreparedStatementParams.get(nativeSql);
                if (pStmtInfo == null) {
                    pStmt = PreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.database);
                    this.cachedPreparedStatementParams.put(nativeSql, pStmt.getParseInfo());
                } else {
                    pStmt = new PreparedStatement(this.getMultiHostSafeProxy(), nativeSql, this.database, pStmtInfo);
                }
            } else {
                pStmt = PreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.database);
            }
            pStmt.setResultSetType(resultSetType);
            pStmt.setResultSetConcurrency(resultSetConcurrency);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement clientPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            PreparedStatement pStmt = (PreparedStatement)this.clientPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement clientPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            PreparedStatement pStmt = (PreparedStatement)this.clientPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.clientPrepareStatement(sql, resultSetType, resultSetConcurrency, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (this.connectionLifecycleInterceptors != null) {
                    new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                        @Override
                        void forEach(Extension each) throws SQLException {
                            ((ConnectionLifecycleInterceptor)each).close();
                        }
                    }.doForAll();
                }
                this.realClose(true, true, false, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void closeAllOpenStatements() throws SQLException {
        SQLException postponedException = null;
        if (this.openStatements != null) {
            ArrayList<Statement> currentlyOpenStatements = new ArrayList<Statement>();
            Iterator<Statement> iter = this.openStatements.keySet().iterator();
            while (iter.hasNext()) {
                currentlyOpenStatements.add(iter.next());
            }
            int numStmts = currentlyOpenStatements.size();
            for (int i = 0; i < numStmts; ++i) {
                StatementImpl stmt = (StatementImpl)currentlyOpenStatements.get(i);
                try {
                    stmt.realClose(false, true);
                    continue;
                }
                catch (SQLException sqlEx) {
                    postponedException = sqlEx;
                }
            }
            if (postponedException != null) {
                throw postponedException;
            }
        }
    }

    private void closeStatement(java.sql.Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                try {
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock<Extension> iter = new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                            @Override
                            void forEach(Extension each) throws SQLException {
                                if (!((ConnectionLifecycleInterceptor)each).commit()) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            return;
                        }
                    }
                    if (this.autoCommit) {
                        throw SQLError.createSQLException(Messages.getString("Connection.3"), this.getExceptionInterceptor());
                    }
                    if (this.useLocalTransactionState.getValue().booleanValue() && !this.session.inTransactionOnServer()) {
                        return;
                    }
                    this.execSQL(null, "commit", -1, null, 1003, 1007, false, this.database, null, false);
                }
                catch (SQLException sqlException) {
                    if (!"08S01".equals(sqlException.getSQLState())) throw sqlException;
                    throw SQLError.createSQLException(Messages.getString("Connection.4"), "08007", this.getExceptionInterceptor());
                }
                finally {
                    this.needsPing = this.reconnectAtTxEnd.getValue();
                }
                return;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void configureCharsetProperties() throws SQLException {
        if (this.characterEncoding.getValue() != null) {
            try {
                String testString = "abc";
                StringUtils.getBytes(testString, (String)this.characterEncoding.getValue());
            }
            catch (WrongArgumentException waEx) {
                String oldEncoding = (String)this.characterEncoding.getValue();
                try {
                    this.characterEncoding.setValue(CharsetMapping.getJavaEncodingForMysqlCharset(oldEncoding));
                }
                catch (RuntimeException ex) {
                    throw SQLError.createSQLException(ex.toString(), "S1009", ex, null);
                }
                if (this.characterEncoding.getValue() == null) {
                    throw SQLError.createSQLException(Messages.getString("Connection.5", new Object[]{oldEncoding}), "01S00", this.getExceptionInterceptor());
                }
                try {
                    String testString = "abc";
                    StringUtils.getBytes(testString, (String)this.characterEncoding.getValue());
                }
                catch (WrongArgumentException encodingEx) {
                    throw SQLError.createSQLException(encodingEx.getMessage(), "01S00", this.getExceptionInterceptor());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configureClientCharacterSet(boolean dontCheckServerMatch) throws SQLException {
        boolean characterSetAlreadyConfigured;
        block69: {
            block68: {
                String realJavaEncoding = (String)this.characterEncoding.getValue();
                ModifiableProperty<String> characterSetResults = this.getPropertySet().getModifiableProperty("characterSetResults");
                characterSetAlreadyConfigured = false;
                try {
                    String mysqlCharsetName;
                    characterSetAlreadyConfigured = true;
                    this.configureCharsetProperties();
                    realJavaEncoding = (String)this.characterEncoding.getValue();
                    try {
                        String serverEncodingToSet;
                        if (this.props != null && this.props.getProperty("com.mysql.cj.testsuite.faultInjection.serverCharsetIndex") != null) {
                            this.session.setServerDefaultCollationIndex(Integer.parseInt(this.props.getProperty("com.mysql.cj.testsuite.faultInjection.serverCharsetIndex")));
                        }
                        if ((serverEncodingToSet = CharsetMapping.getJavaEncodingForCollationIndex(this.session.getServerDefaultCollationIndex())) == null || serverEncodingToSet.length() == 0) {
                            if (realJavaEncoding != null) {
                                this.characterEncoding.setValue(realJavaEncoding);
                            } else {
                                throw SQLError.createSQLException(Messages.getString("Connection.6", new Object[]{this.session.getServerDefaultCollationIndex()}), "S1000", this.getExceptionInterceptor());
                            }
                        }
                        if ("ISO8859_1".equalsIgnoreCase(serverEncodingToSet)) {
                            serverEncodingToSet = "Cp1252";
                        }
                        if ("UnicodeBig".equalsIgnoreCase(serverEncodingToSet) || "UTF-16".equalsIgnoreCase(serverEncodingToSet) || "UTF-16LE".equalsIgnoreCase(serverEncodingToSet) || "UTF-32".equalsIgnoreCase(serverEncodingToSet)) {
                            serverEncodingToSet = "UTF-8";
                        }
                        this.characterEncoding.setValue(serverEncodingToSet);
                    }
                    catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                        if (realJavaEncoding != null) {
                            this.characterEncoding.setValue(realJavaEncoding);
                        }
                        throw SQLError.createSQLException(Messages.getString("Connection.6", new Object[]{this.session.getServerDefaultCollationIndex()}), "S1000", this.getExceptionInterceptor());
                    }
                    catch (SQLException ex) {
                        throw ex;
                    }
                    catch (RuntimeException ex) {
                        SQLException sqlEx = SQLError.createSQLException(ex.toString(), "S1009", null);
                        sqlEx.initCause(ex);
                        throw sqlEx;
                    }
                    if (this.characterEncoding.getValue() == null) {
                        this.characterEncoding.setValue("ISO8859_1");
                    }
                    if (realJavaEncoding != null) {
                        if (realJavaEncoding.equalsIgnoreCase("UTF-8") || realJavaEncoding.equalsIgnoreCase("UTF8")) {
                            boolean useutf8mb4 = CharsetMapping.UTF8MB4_INDEXES.contains(this.session.getServerDefaultCollationIndex());
                            if (!this.useOldUTF8Behavior.getValue().booleanValue()) {
                                if (dontCheckServerMatch || !this.session.characterSetNamesMatches("utf8") || !this.session.characterSetNamesMatches("utf8mb4")) {
                                    this.execSQL(null, "SET NAMES " + (useutf8mb4 ? "utf8mb4" : "utf8"), -1, null, 1003, 1007, false, this.database, null, false);
                                    this.session.getServerVariables().put("character_set_client", useutf8mb4 ? "utf8mb4" : "utf8");
                                    this.session.getServerVariables().put("character_set_connection", useutf8mb4 ? "utf8mb4" : "utf8");
                                }
                            } else {
                                this.execSQL(null, "SET NAMES latin1", -1, null, 1003, 1007, false, this.database, null, false);
                                this.session.getServerVariables().put("character_set_client", "latin1");
                                this.session.getServerVariables().put("character_set_connection", "latin1");
                            }
                            this.characterEncoding.setValue(realJavaEncoding);
                        } else {
                            mysqlCharsetName = CharsetMapping.getMysqlCharsetForJavaEncoding(realJavaEncoding.toUpperCase(Locale.ENGLISH), this.getServerVersion());
                            if (mysqlCharsetName != null && (dontCheckServerMatch || !this.session.characterSetNamesMatches(mysqlCharsetName))) {
                                this.execSQL(null, "SET NAMES " + mysqlCharsetName, -1, null, 1003, 1007, false, this.database, null, false);
                                this.session.getServerVariables().put("character_set_client", mysqlCharsetName);
                                this.session.getServerVariables().put("character_set_connection", mysqlCharsetName);
                            }
                            this.characterEncoding.setValue(realJavaEncoding);
                        }
                    } else if (this.characterEncoding.getValue() != null) {
                        block64: {
                            mysqlCharsetName = this.getSession().getServerCharset();
                            if (this.useOldUTF8Behavior.getValue().booleanValue()) {
                                mysqlCharsetName = "latin1";
                            }
                            boolean ucs2 = false;
                            if ("ucs2".equalsIgnoreCase(mysqlCharsetName) || "utf16".equalsIgnoreCase(mysqlCharsetName) || "utf16le".equalsIgnoreCase(mysqlCharsetName) || "utf32".equalsIgnoreCase(mysqlCharsetName)) {
                                mysqlCharsetName = "utf8";
                                ucs2 = true;
                                if (characterSetResults.getValue() == null) {
                                    characterSetResults.setValue("UTF-8");
                                }
                            }
                            if (dontCheckServerMatch || !this.session.characterSetNamesMatches(mysqlCharsetName) || ucs2) {
                                try {
                                    this.execSQL(null, "SET NAMES " + mysqlCharsetName, -1, null, 1003, 1007, false, this.database, null, false);
                                    this.session.getServerVariables().put("character_set_client", mysqlCharsetName);
                                    this.session.getServerVariables().put("character_set_connection", mysqlCharsetName);
                                }
                                catch (PasswordExpiredException ex) {
                                    if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                                        throw ex;
                                    }
                                }
                                catch (SQLException ex) {
                                    if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block64;
                                    throw ex;
                                }
                            }
                        }
                        realJavaEncoding = (String)this.characterEncoding.getValue();
                    }
                    String onServer = null;
                    boolean isNullOnServer = false;
                    if (this.session.getServerVariables() != null) {
                        onServer = this.session.getServerVariable("character_set_results");
                        boolean bl = isNullOnServer = onServer == null || "NULL".equalsIgnoreCase(onServer) || onServer.length() == 0;
                    }
                    if (characterSetResults.getValue() == null) {
                        if (!isNullOnServer) {
                            block65: {
                                try {
                                    this.execSQL(null, "SET character_set_results = NULL", -1, null, 1003, 1007, false, this.database, null, false);
                                }
                                catch (PasswordExpiredException ex) {
                                    if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                                        throw ex;
                                    }
                                }
                                catch (SQLException ex) {
                                    if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block65;
                                    throw ex;
                                }
                            }
                            this.session.getServerVariables().put(JDBC_LOCAL_CHARACTER_SET_RESULTS, null);
                        } else {
                            this.session.getServerVariables().put(JDBC_LOCAL_CHARACTER_SET_RESULTS, onServer);
                        }
                    } else {
                        block66: {
                            if (this.useOldUTF8Behavior.getValue().booleanValue()) {
                                try {
                                    this.execSQL(null, "SET NAMES latin1", -1, null, 1003, 1007, false, this.database, null, false);
                                    this.session.getServerVariables().put("character_set_client", "latin1");
                                    this.session.getServerVariables().put("character_set_connection", "latin1");
                                }
                                catch (PasswordExpiredException ex) {
                                    if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                                        throw ex;
                                    }
                                }
                                catch (SQLException ex) {
                                    if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block66;
                                    throw ex;
                                }
                            }
                        }
                        String charsetResults = (String)characterSetResults.getValue();
                        String mysqlEncodingName = null;
                        mysqlEncodingName = "UTF-8".equalsIgnoreCase(charsetResults) || "UTF8".equalsIgnoreCase(charsetResults) ? "utf8" : ("null".equalsIgnoreCase(charsetResults) ? "NULL" : CharsetMapping.getMysqlCharsetForJavaEncoding(charsetResults.toUpperCase(Locale.ENGLISH), this.getServerVersion()));
                        if (mysqlEncodingName == null) {
                            throw SQLError.createSQLException(Messages.getString("Connection.7", new Object[]{charsetResults}), "S1009", this.getExceptionInterceptor());
                        }
                        if (!mysqlEncodingName.equalsIgnoreCase(this.session.getServerVariable("character_set_results"))) {
                            block67: {
                                StringBuilder setBuf = new StringBuilder("SET character_set_results = ".length() + mysqlEncodingName.length());
                                setBuf.append("SET character_set_results = ").append(mysqlEncodingName);
                                try {
                                    this.execSQL(null, setBuf.toString(), -1, null, 1003, 1007, false, this.database, null, false);
                                }
                                catch (PasswordExpiredException ex) {
                                    if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                                        throw ex;
                                    }
                                }
                                catch (SQLException ex) {
                                    if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block67;
                                    throw ex;
                                }
                            }
                            this.session.getServerVariables().put(JDBC_LOCAL_CHARACTER_SET_RESULTS, mysqlEncodingName);
                            this.session.setErrorMessageEncoding(charsetResults);
                        } else {
                            this.session.getServerVariables().put(JDBC_LOCAL_CHARACTER_SET_RESULTS, onServer);
                        }
                    }
                    String connectionCollation = this.getPropertySet().getStringReadableProperty("connectionCollation").getStringValue();
                    if (connectionCollation == null) break block68;
                    StringBuilder setBuf = new StringBuilder("SET collation_connection = ".length() + connectionCollation.length());
                    setBuf.append("SET collation_connection = ").append(connectionCollation);
                    try {
                        this.execSQL(null, setBuf.toString(), -1, null, 1003, 1007, false, this.database, null, false);
                    }
                    catch (PasswordExpiredException ex) {
                        if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                            throw ex;
                        }
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() != 1820 || this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                            throw ex;
                        }
                    }
                }
                finally {
                    this.characterEncoding.setValue(realJavaEncoding);
                }
            }
            try {
                CharsetEncoder enc = Charset.forName((String)this.characterEncoding.getValue()).newEncoder();
                CharBuffer cbuf = CharBuffer.allocate(1);
                ByteBuffer bbuf = ByteBuffer.allocate(1);
                cbuf.put("\u00a5");
                cbuf.position(0);
                enc.encode(cbuf, bbuf, true);
                if (bbuf.get(0) == 92) {
                    this.requiresEscapingEncoder = true;
                } else {
                    cbuf.clear();
                    bbuf.clear();
                    cbuf.put("\u20a9");
                    cbuf.position(0);
                    enc.encode(cbuf, bbuf, true);
                    if (bbuf.get(0) == 92) {
                        this.requiresEscapingEncoder = true;
                    }
                }
            }
            catch (UnsupportedCharsetException ucex) {
                byte[] bbuf = StringUtils.getBytes("\u00a5", (String)this.characterEncoding.getValue());
                if (bbuf[0] == 92) {
                    this.requiresEscapingEncoder = true;
                }
                bbuf = StringUtils.getBytes("\u20a9", (String)this.characterEncoding.getValue());
                if (bbuf[0] != 92) break block69;
                this.requiresEscapingEncoder = true;
            }
        }
        return characterSetAlreadyConfigured;
    }

    private void createInitialHistogram(long[] breakpoints, long lowerBound, long upperBound) {
        double bucketSize = ((double)upperBound - (double)lowerBound) / 20.0 * 1.25;
        if (bucketSize < 1.0) {
            bucketSize = 1.0;
        }
        for (int i = 0; i < 20; ++i) {
            breakpoints[i] = lowerBound;
            lowerBound = (long)((double)lowerBound + bucketSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNewIO(boolean isForReconnect) {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                try {
                    Properties mergedProps = this.getPropertySet().exposeAsProperties(this.props);
                    if (!((Boolean)this.autoReconnect.getValue()).booleanValue()) {
                        this.connectOneTryOnly(isForReconnect, mergedProps);
                        return;
                    }
                    this.connectWithRetries(isForReconnect, mergedProps);
                }
                catch (SQLException ex) {
                    throw ExceptionFactory.createException(UnableToConnectException.class, ex.getMessage(), ex);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithRetries(boolean isForReconnect, Properties mergedProps) throws SQLException {
        double timeout = this.getPropertySet().getIntegerReadableProperty("initialTimeout").getValue().intValue();
        boolean connectionGood = false;
        Exception connectionException = null;
        for (int attemptCount = 0; attemptCount < this.getPropertySet().getIntegerReadableProperty("maxReconnects").getValue() && !connectionGood; ++attemptCount) {
            try {
                String oldCatalog;
                boolean oldReadOnly;
                int oldIsolationLevel;
                boolean oldAutoCommit;
                this.session.forceClose();
                this.session.connect(this.getProxy(), this.origConnectionString, mergedProps, this.user, this.password, this.database, DriverManager.getLoginTimeout() * 1000);
                this.pingInternal(false, 0);
                Object object = this.getConnectionMutex();
                synchronized (object) {
                    this.connectionId = this.session.getThreadId();
                    this.isClosed = false;
                    oldAutoCommit = this.getAutoCommit();
                    oldIsolationLevel = this.isolationLevel;
                    oldReadOnly = this.isReadOnly(false);
                    oldCatalog = this.getCatalog();
                    this.session.setStatementInterceptors(this.statementInterceptors);
                }
                this.initializePropsFromServer();
                if (isForReconnect) {
                    this.setAutoCommit(oldAutoCommit);
                    this.setTransactionIsolation(oldIsolationLevel);
                    this.setCatalog(oldCatalog);
                    this.setReadOnly(oldReadOnly);
                }
                connectionGood = true;
                break;
            }
            catch (Exception EEE2) {
                connectionException = EEE2;
                connectionGood = false;
                if (connectionGood) break;
                if (attemptCount <= 0) continue;
                try {
                    Thread.sleep((long)timeout * 1000L);
                }
                catch (InterruptedException EEE2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!connectionGood) {
            SQLException chainedEx = SQLError.createSQLException(Messages.getString("Connection.UnableToConnectWithRetries", new Object[]{this.getPropertySet().getIntegerReadableProperty("maxReconnects").getValue()}), "08001", connectionException, this.getExceptionInterceptor());
            throw chainedEx;
        }
        if (this.propertySet.getBooleanReadableProperty("paranoid").getValue().booleanValue() && !((Boolean)this.autoReconnect.getValue()).booleanValue()) {
            this.password = null;
            this.user = null;
        }
        if (isForReconnect) {
            Iterator<Statement> statementIter = this.openStatements.values().iterator();
            Stack<Statement> serverPreparedStatements = null;
            while (statementIter.hasNext()) {
                Statement statementObj = statementIter.next();
                if (!(statementObj instanceof ServerPreparedStatement)) continue;
                if (serverPreparedStatements == null) {
                    serverPreparedStatements = new Stack<Statement>();
                }
                serverPreparedStatements.add(statementObj);
            }
            if (serverPreparedStatements != null) {
                while (!serverPreparedStatements.isEmpty()) {
                    ((ServerPreparedStatement)serverPreparedStatements.pop()).rePrepare();
                }
            }
        }
    }

    private void connectOneTryOnly(boolean isForReconnect, Properties mergedProps) throws SQLException {
        Exception connectionNotEstablishedBecause = null;
        try {
            this.session.connect(this.getProxy(), this.origConnectionString, mergedProps, this.user, this.password, this.database, DriverManager.getLoginTimeout() * 1000);
            this.connectionId = this.session.getThreadId();
            this.isClosed = false;
            boolean oldAutoCommit = this.getAutoCommit();
            int oldIsolationLevel = this.isolationLevel;
            boolean oldReadOnly = this.isReadOnly(false);
            String oldCatalog = this.getCatalog();
            this.session.setStatementInterceptors(this.statementInterceptors);
            this.initializePropsFromServer();
            if (isForReconnect) {
                this.setAutoCommit(oldAutoCommit);
                this.setTransactionIsolation(oldIsolationLevel);
                this.setCatalog(oldCatalog);
                this.setReadOnly(oldReadOnly);
            }
            return;
        }
        catch (Exception EEE) {
            if ((EEE instanceof PasswordExpiredException || EEE instanceof SQLException && ((SQLException)EEE).getErrorCode() == 1820) && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                return;
            }
            if (this.session != null) {
                this.session.forceClose();
            }
            connectionNotEstablishedBecause = EEE;
            if (EEE instanceof SQLException) {
                throw (SQLException)EEE;
            }
            if (EEE.getCause() != null && EEE.getCause() instanceof SQLException) {
                throw (SQLException)EEE.getCause();
            }
            if (EEE instanceof CJException) {
                throw (CJException)EEE;
            }
            SQLException chainedEx = SQLError.createSQLException(Messages.getString("Connection.UnableToConnect"), "08001", this.getExceptionInterceptor());
            chainedEx.initCause(connectionNotEstablishedBecause);
            throw chainedEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPreparedStatementCaches() throws SQLException {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            int cacheSize = this.getPropertySet().getIntegerReadableProperty("prepStmtCacheSize").getValue();
            String parseInfoCacheFactory = this.getPropertySet().getStringReadableProperty("parseInfoCacheFactory").getValue();
            try {
                Class<?> factoryClass = Class.forName(parseInfoCacheFactory);
                CacheAdapterFactory cacheFactory = (CacheAdapterFactory)factoryClass.newInstance();
                this.cachedPreparedStatementParams = cacheFactory.getInstance(this, this.origConnectionString.getUrl(), cacheSize, this.prepStmtCacheSqlLimit.getValue(), this.props);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.CantFindCacheFactory", new Object[]{parseInfoCacheFactory, "parseInfoCacheFactory"}), this.getExceptionInterceptor());
                sqlEx.initCause(e);
                throw sqlEx;
            }
            catch (Exception e) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.CantLoadCacheFactory", new Object[]{parseInfoCacheFactory, "parseInfoCacheFactory"}), this.getExceptionInterceptor());
                sqlEx.initCause(e);
                throw sqlEx;
            }
            if (this.useServerPrepStmts.getValue().booleanValue()) {
                this.serverSideStatementCheckCache = new LRUCache(cacheSize);
                this.serverSideStatementCache = new LRUCache(cacheSize){
                    private static final long serialVersionUID = 7692318650375988114L;

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Object, Object> eldest) {
                        if (this.maxElements <= 1) {
                            return false;
                        }
                        boolean removeIt = super.removeEldestEntry(eldest);
                        if (removeIt) {
                            ServerPreparedStatement ps = (ServerPreparedStatement)eldest.getValue();
                            ps.isCached = false;
                            ps.setClosed(false);
                            try {
                                ps.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        return removeIt;
                    }
                };
            }
        }
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        try {
            return this.createStatement(1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkClosed();
            StatementImpl stmt = new StatementImpl(this.getMultiHostSafeProxy(), this.database);
            stmt.setResultSetType(resultSetType);
            stmt.setResultSetConcurrency(resultSetConcurrency);
            return stmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009", this.getExceptionInterceptor());
            }
            return this.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public JdbcConnection duplicate() throws SQLException {
        try {
            return new ConnectionImpl(this.origConnectionString, this.origHostToConnectTo, this.origPortToConnectTo, this.props);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSetInternalMethods execSQL(StatementImpl callingStatement, String sql, int maxRows, Buffer packet, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata) throws SQLException {
        try {
            return this.execSQL(callingStatement, sql, maxRows, packet, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata, false);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSetInternalMethods execSQL(StatementImpl callingStatement, String sql, int maxRows, Buffer packet, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata, boolean isBatch) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                long queryStartTime = 0L;
                int endOfQueryPacketPosition = 0;
                if (packet != null) {
                    endOfQueryPacketPosition = packet.getPosition();
                }
                if (this.gatherPerfMetrics.getValue().booleanValue()) {
                    queryStartTime = System.currentTimeMillis();
                }
                this.lastQueryFinishedTime = 0L;
                if (((Boolean)this.autoReconnect.getValue()).booleanValue() && (this.autoCommit || this.autoReconnectForPools.getValue().booleanValue()) && this.needsPing && !isBatch) {
                    try {
                        this.pingInternal(false, 0);
                        this.needsPing = false;
                    }
                    catch (Exception Ex) {
                        this.createNewIO(true);
                    }
                }
                try {
                    if (packet == null) {
                        String encoding = (String)this.characterEncoding.getValue();
                        ResultSetInternalMethods resultSetInternalMethods = this.session.sqlQueryDirect(callingStatement, sql, encoding, null, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata);
                        return resultSetInternalMethods;
                    }
                    ResultSetInternalMethods encoding = this.session.sqlQueryDirect(callingStatement, null, null, packet, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata);
                    return encoding;
                }
                catch (CJException sqlE) {
                    SQLException cause = SQLExceptionsMapping.translateException(sqlE, this.getExceptionInterceptor());
                    if (this.getPropertySet().getBooleanReadableProperty("dumpQueriesOnException").getValue().booleanValue()) {
                        String extractedSql = MysqlaUtils.extractSqlFromPacket(sql, packet, endOfQueryPacketPosition, this.getPropertySet().getIntegerReadableProperty("maxQuerySizeToLog").getValue());
                        StringBuilder messageBuf = new StringBuilder(extractedSql.length() + 32);
                        messageBuf.append("\n\nQuery being executed when exception was thrown:\n");
                        messageBuf.append(extractedSql);
                        messageBuf.append("\n\n");
                        cause = ConnectionImpl.appendMessageToException(cause, messageBuf.toString(), this.getExceptionInterceptor());
                    }
                    if (((Boolean)this.autoReconnect.getValue()).booleanValue()) {
                        this.needsPing = true;
                        throw cause;
                    }
                    String sqlState = cause.getSQLState();
                    if (sqlState == null) throw cause;
                    if (!sqlState.equals("08S01")) throw cause;
                    this.cleanup(cause);
                    throw cause;
                }
                catch (Exception ex) {
                    if (((Boolean)this.autoReconnect.getValue()).booleanValue()) {
                        this.needsPing = true;
                    }
                    SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.UnexpectedException"), "S1000", this.getExceptionInterceptor());
                    sqlEx.initCause(ex);
                    throw sqlEx;
                }
                finally {
                    if (this.maintainTimeStats.getValue().booleanValue()) {
                        this.lastQueryFinishedTime = System.currentTimeMillis();
                    }
                    if (this.gatherPerfMetrics.getValue().booleanValue()) {
                        long queryTime = System.currentTimeMillis() - queryStartTime;
                        this.registerQueryExecutionTime(queryTime);
                    }
                }
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public StringBuilder generateConnectionCommentBlock(StringBuilder buf) {
        buf.append("/* conn id ");
        buf.append(this.getId());
        buf.append(" clock: ");
        buf.append(System.currentTimeMillis());
        buf.append(" */ ");
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveStatementCount() {
        if (this.openStatements != null) {
            Map<Statement, Statement> map = this.openStatements;
            synchronized (map) {
                return this.openStatements.size();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                return this.autoCommit;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                return this.database;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCharacterSetMetadata() {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            return this.characterSetMetadata;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return 2;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long getId() {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getIdleFor() {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            if (this.lastQueryFinishedTime == 0L) {
                return 0L;
            }
            long now = System.currentTimeMillis();
            long idleTime = now - this.lastQueryFinishedTime;
            return idleTime;
        }
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getMetaData(true, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private java.sql.DatabaseMetaData getMetaData(boolean checkClosed, boolean checkForInfoSchema) throws SQLException {
        try {
            if (checkClosed) {
                this.checkClosed();
            }
            return DatabaseMetaData.getInstance(this.getMultiHostSafeProxy(), this.database, checkForInfoSchema);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Statement getMetadataSafeStatement() throws SQLException {
        try {
            java.sql.Statement stmt = this.createStatement();
            if (stmt.getMaxRows() != 0) {
                stmt.setMaxRows(0);
            }
            stmt.setEscapeProcessing(false);
            if (stmt.getFetchSize() != 0) {
                stmt.setFetchSize(0);
            }
            return stmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.session.getServerVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (!this.useLocalSessionState.getValue().booleanValue()) {
                    java.sql.Statement stmt = null;
                    ResultSet rs = null;
                    try {
                        stmt = this.getMetadataSafeStatement();
                        rs = stmt.executeQuery("SELECT @@session.tx_isolation");
                        if (rs.next()) {
                            Integer intTI;
                            String s = rs.getString(1);
                            if (s != null && (intTI = mapTransIsolationNameToValue.get(s)) != null) {
                                int n = intTI;
                                return n;
                            }
                            throw SQLError.createSQLException(Messages.getString("Connection.12", new Object[]{s}), "S1000", this.getExceptionInterceptor());
                        }
                        throw SQLError.createSQLException(Messages.getString("Connection.13"), "S1000", this.getExceptionInterceptor());
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {}
                            rs = null;
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception exception) {}
                            stmt = null;
                        }
                    }
                }
                return this.isolationLevel;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (this.typeMap == null) {
                    this.typeMap = new HashMap();
                }
                return this.typeMap;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getURL() {
        return this.origConnectionString.getUrl();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean hasSameProperties(JdbcConnection c) {
        return this.props.equals(c.getProperties());
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    @Deprecated
    public boolean hasTriedMaster() {
        return this.hasTriedMasterFlag;
    }

    @Override
    public void incrementNumberOfPreparedExecutes() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            ++this.numberOfPreparedExecutes;
            ++this.numberOfQueriesIssued;
        }
    }

    @Override
    public void incrementNumberOfPrepares() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            ++this.numberOfPrepares;
        }
    }

    @Override
    public void incrementNumberOfResultSetsCreated() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            ++this.numberOfResultSetsCreated;
        }
    }

    private void initializeDriverProperties(Properties info) throws SQLException {
        this.getPropertySet().initializeProperties(info);
        String exceptionInterceptorClasses = this.getPropertySet().getStringReadableProperty("exceptionInterceptors").getStringValue();
        if (exceptionInterceptorClasses != null && !"".equals(exceptionInterceptorClasses)) {
            this.exceptionInterceptor = new ExceptionInterceptorChain(exceptionInterceptorClasses);
        }
        this.session.setLog(LogFactory.getLogger(this.getPropertySet().getStringReadableProperty("logger").getStringValue(), "MySQL", this.getExceptionInterceptor()));
        if (((Boolean)this.profileSQL.getValue()).booleanValue() || this.useUsageAdvisor.getValue().booleanValue()) {
            ProfilerEventHandlerFactory.getInstance(this.getMultiHostSafeProxy());
        }
        if (this.cachePrepStmts.getValue().booleanValue()) {
            this.createPreparedStatementCaches();
        }
        if (this.getPropertySet().getBooleanReadableProperty("cacheCallableStmts").getValue().booleanValue()) {
            this.parsedCallableStatementCache = new LRUCache(this.getPropertySet().getIntegerReadableProperty("callableStmtCacheSize").getValue());
        }
        if (this.getPropertySet().getBooleanReadableProperty("allowMultiQueries").getValue().booleanValue()) {
            this.getPropertySet().getModifiableProperty("cacheResultSetMetadata").setValue(false);
        }
        if (this.getPropertySet().getBooleanReadableProperty("cacheResultSetMetadata").getValue().booleanValue()) {
            this.resultSetMetadataCache = new LRUCache(this.getPropertySet().getIntegerReadableProperty("metadataCacheSize").getValue());
        }
        if (this.getPropertySet().getStringReadableProperty("socksProxyHost").getStringValue() != null) {
            this.getPropertySet().getJdbcModifiableProperty("socketFactory").setValue(SocksProxySocketFactory.class.getName());
        }
    }

    private void initializePropsFromServer() throws SQLException {
        block24: {
            String connectionInterceptorClasses = this.getPropertySet().getStringReadableProperty("connectionLifecycleInterceptors").getStringValue();
            this.connectionLifecycleInterceptors = null;
            if (connectionInterceptorClasses != null) {
                try {
                    this.connectionLifecycleInterceptors = Util.loadExtensions(this, this.props, connectionInterceptorClasses, "Connection.badLifecycleInterceptor", this.getExceptionInterceptor(), this.session.getLog());
                }
                catch (CJException e) {
                    throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
                }
            }
            this.setSessionVariables();
            if (this.useServerPrepStmts.getValue().booleanValue()) {
                this.useServerPreparedStmts = true;
            }
            this.loadServerVariables();
            this.autoIncrementIncrement = this.session.getServerVariable("auto_increment_increment", 1);
            this.buildCollationMapping();
            try {
                LicenseConfiguration.checkLicenseType(this.session.getServerVariables());
            }
            catch (CJException e) {
                throw SQLError.createSQLException(e.getMessage(), "08001", this.getExceptionInterceptor());
            }
            String lowerCaseTables = this.session.getServerVariable("lower_case_table_names");
            this.lowerCaseTableNames = "on".equalsIgnoreCase(lowerCaseTables) || "1".equalsIgnoreCase(lowerCaseTables) || "2".equalsIgnoreCase(lowerCaseTables);
            this.storesLowerCaseTableName = "1".equalsIgnoreCase(lowerCaseTables) || "on".equalsIgnoreCase(lowerCaseTables);
            this.session.configureTimezone();
            if (this.session.getServerVariables().containsKey("max_allowed_packet")) {
                int serverMaxAllowedPacket = this.session.getServerVariable("max_allowed_packet", -1);
                if (serverMaxAllowedPacket != -1 && (serverMaxAllowedPacket < (Integer)this.maxAllowedPacket.getValue() || (Integer)this.maxAllowedPacket.getValue() <= 0)) {
                    this.maxAllowedPacket.setValue(serverMaxAllowedPacket);
                } else if (serverMaxAllowedPacket == -1 && (Integer)this.maxAllowedPacket.getValue() == -1) {
                    this.maxAllowedPacket.setValue(65535);
                }
                if (this.useServerPrepStmts.getValue().booleanValue()) {
                    ModifiableProperty<Integer> blobSendChunkSize = this.getPropertySet().getModifiableProperty("blobSendChunkSize");
                    int preferredBlobSendChunkSize = (Integer)blobSendChunkSize.getValue();
                    int packetHeaderSize = 8203;
                    int allowedBlobSendChunkSize = Math.min(preferredBlobSendChunkSize, (Integer)this.maxAllowedPacket.getValue()) - packetHeaderSize;
                    if (allowedBlobSendChunkSize <= 0) {
                        throw SQLError.createSQLException(Messages.getString("Connection.15", new Object[]{packetHeaderSize}), "01S00", this.getExceptionInterceptor());
                    }
                    blobSendChunkSize.setValue(allowedBlobSendChunkSize);
                }
            }
            this.checkTransactionIsolationLevel();
            this.session.checkForCharsetMismatch();
            if (this.session.getServerVariables().containsKey("sql_mode")) {
                int sqlMode;
                block23: {
                    sqlMode = 0;
                    String sqlModeAsString = this.session.getServerVariable("sql_mode");
                    try {
                        sqlMode = Integer.parseInt(sqlModeAsString);
                    }
                    catch (NumberFormatException nfe) {
                        sqlMode = 0;
                        if (sqlModeAsString == null) break block23;
                        if (sqlModeAsString.indexOf("ANSI_QUOTES") != -1) {
                            sqlMode |= 4;
                        }
                        if (sqlModeAsString.indexOf("NO_BACKSLASH_ESCAPES") == -1) break block23;
                        this.noBackslashEscapes = true;
                    }
                }
                this.useAnsiQuotes = (sqlMode & 4) > 0;
            }
            boolean overrideDefaultAutocommit = this.isAutoCommitNonDefaultOnServer();
            this.configureClientCharacterSet(false);
            if (!overrideDefaultAutocommit) {
                try {
                    this.setAutoCommit(true);
                }
                catch (PasswordExpiredException ex) {
                    if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                        throw ex;
                    }
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block24;
                    throw ex;
                }
            }
        }
        this.session.resetMaxBuf();
        String characterSetResultsOnServerMysql = this.session.getServerVariable(JDBC_LOCAL_CHARACTER_SET_RESULTS);
        if (characterSetResultsOnServerMysql == null || StringUtils.startsWithIgnoreCaseAndWs(characterSetResultsOnServerMysql, "NULL") || characterSetResultsOnServerMysql.length() == 0) {
            String defaultMetadataCharsetMysql = this.session.getServerVariable("character_set_system");
            String defaultMetadataCharset = null;
            defaultMetadataCharset = defaultMetadataCharsetMysql != null ? CharsetMapping.getJavaEncodingForMysqlCharset(defaultMetadataCharsetMysql) : "UTF-8";
            this.characterSetMetadata = defaultMetadataCharset;
            this.session.setErrorMessageEncoding("UTF-8");
        } else {
            this.characterSetMetadata = this.characterSetResultsOnServer = CharsetMapping.getJavaEncodingForMysqlCharset(characterSetResultsOnServerMysql);
            this.session.setErrorMessageEncoding(this.characterSetResultsOnServer);
        }
        this.setupServerForTruncationChecks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAutoCommitNonDefaultOnServer() throws SQLException {
        try {
            boolean overrideDefaultAutocommit = false;
            String initConnectValue = this.session.getServerVariable("init_connect");
            if (initConnectValue == null) return overrideDefaultAutocommit;
            if (initConnectValue.length() <= 0) return overrideDefaultAutocommit;
            if (!this.getPropertySet().getBooleanReadableProperty("elideSetAutoCommits").getValue().booleanValue()) {
                ResultSet rs = null;
                java.sql.Statement stmt = null;
                try {
                    stmt = this.getMetadataSafeStatement();
                    rs = stmt.executeQuery("SELECT @@session.autocommit");
                    if (!rs.next()) return overrideDefaultAutocommit;
                    this.autoCommit = rs.getBoolean(1);
                    if (this.autoCommit) return overrideDefaultAutocommit;
                    overrideDefaultAutocommit = true;
                    return overrideDefaultAutocommit;
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            if (!this.getSession().isSetNeededForAutoCommitMode(true)) return overrideDefaultAutocommit;
            this.autoCommit = false;
            return true;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return this.isClosed;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isInGlobalTx() {
        return this.isInGlobalTx;
    }

    @Override
    public boolean isMasterConnection() {
        return false;
    }

    @Override
    public boolean isNoBackslashEscapesSet() {
        return this.noBackslashEscapes;
    }

    @Override
    public boolean isReadInfoMsgEnabled() {
        return this.readInfoMsg;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.isReadOnly(true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isReadOnly(boolean useSessionStatus) throws SQLException {
        try {
            block20: {
                boolean bl;
                java.sql.Statement stmt;
                block21: {
                    if (!useSessionStatus) return this.readOnly;
                    if (this.isClosed) return this.readOnly;
                    if (this.useLocalSessionState.getValue() != false) return this.readOnly;
                    if (this.readOnlyPropagatesToServer.getValue() == false) return this.readOnly;
                    stmt = null;
                    ResultSet rs = null;
                    try {
                        stmt = this.getMetadataSafeStatement();
                        rs = stmt.executeQuery("select @@session.tx_read_only");
                        if (!rs.next()) break block20;
                        boolean bl2 = bl = rs.getInt(1) != 0;
                        if (rs == null) break block21;
                    }
                    catch (PasswordExpiredException ex) {
                        if (this.disconnectOnExpiredPasswords.getValue() == false) return this.readOnly;
                        throw SQLError.createSQLException(Messages.getString("Connection.16"), "S1000", ex, this.getExceptionInterceptor());
                    }
                    catch (SQLException ex1) {
                        if (ex1.getErrorCode() != 1820) throw SQLError.createSQLException(Messages.getString("Connection.16"), "S1000", ex1, this.getExceptionInterceptor());
                        if (this.disconnectOnExpiredPasswords.getValue() == false) return this.readOnly;
                        throw SQLError.createSQLException(Messages.getString("Connection.16"), "S1000", ex1, this.getExceptionInterceptor());
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rs = null;
                }
                if (stmt == null) return bl;
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stmt = null;
                return bl;
            }
            return this.readOnly;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameResource(JdbcConnection otherConnection) {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            if (otherConnection == null) {
                return false;
            }
            boolean directCompare = true;
            String otherHost = ((ConnectionImpl)otherConnection).origHostToConnectTo;
            String otherOrigDatabase = ((ConnectionImpl)otherConnection).origConnectionString.getDatabase();
            String otherCurrentCatalog = ((ConnectionImpl)otherConnection).database;
            if (!ConnectionImpl.nullSafeCompare(otherHost, this.origHostToConnectTo)) {
                directCompare = false;
            } else if (otherHost != null && otherHost.indexOf(44) == -1 && otherHost.indexOf(58) == -1) {
                boolean bl = directCompare = ((ConnectionImpl)otherConnection).origPortToConnectTo == this.origPortToConnectTo;
            }
            if (!(!directCompare || ConnectionImpl.nullSafeCompare(otherOrigDatabase, this.origConnectionString.getDatabase()) && ConnectionImpl.nullSafeCompare(otherCurrentCatalog, this.database))) {
                directCompare = false;
            }
            if (directCompare) {
                return true;
            }
            String otherResourceId = ((ConnectionImpl)otherConnection).getPropertySet().getStringReadableProperty("resourceId").getValue();
            String myResourceId = this.getPropertySet().getStringReadableProperty("resourceId").getValue();
            return (otherResourceId != null || myResourceId != null) && (directCompare = ConnectionImpl.nullSafeCompare(otherResourceId, myResourceId));
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConfigCacheIfNeeded() throws SQLException {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            if (this.serverConfigCache != null) {
                return;
            }
            try {
                Class<?> factoryClass = Class.forName(this.getPropertySet().getStringReadableProperty("serverConfigCacheFactory").getStringValue());
                CacheAdapterFactory cacheFactory = (CacheAdapterFactory)factoryClass.newInstance();
                this.serverConfigCache = cacheFactory.getInstance(this, this.origConnectionString.getUrl(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.props);
                ExceptionInterceptor evictOnCommsError = new ExceptionInterceptor(){

                    @Override
                    public void init(MysqlConnection conn, Properties config, Log log) {
                    }

                    @Override
                    public void destroy() {
                    }

                    @Override
                    public Exception interceptException(Exception sqlEx, MysqlConnection conn) {
                        if (sqlEx instanceof SQLException && ((SQLException)sqlEx).getSQLState() != null && ((SQLException)sqlEx).getSQLState().startsWith("08")) {
                            ConnectionImpl.this.serverConfigCache.invalidate(ConnectionImpl.this.getURL());
                        }
                        return null;
                    }
                };
                if (this.exceptionInterceptor == null) {
                    this.exceptionInterceptor = evictOnCommsError;
                } else {
                    ((ExceptionInterceptorChain)this.exceptionInterceptor).addRingZero(evictOnCommsError);
                }
            }
            catch (ClassNotFoundException e) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.CantFindCacheFactory", new Object[]{this.getPropertySet().getStringReadableProperty("parseInfoCacheFactory").getValue(), "parseInfoCacheFactory"}), this.getExceptionInterceptor());
                sqlEx.initCause(e);
                throw sqlEx;
            }
            catch (CJException | IllegalAccessException | InstantiationException e) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.CantLoadCacheFactory", new Object[]{this.getPropertySet().getStringReadableProperty("parseInfoCacheFactory").getValue(), "parseInfoCacheFactory"}), this.getExceptionInterceptor());
                sqlEx.initCause(e);
                throw sqlEx;
            }
        }
    }

    private void loadServerVariables() throws SQLException {
        if (this.cacheServerConfiguration.getValue().booleanValue()) {
            this.createConfigCacheIfNeeded();
            Map<String, String> cachedVariableMap = this.serverConfigCache.get(this.getURL());
            if (cachedVariableMap != null) {
                String cachedServerVersion = cachedVariableMap.get(SERVER_VERSION_STRING_VAR_NAME);
                if (cachedServerVersion != null && this.getServerVersion() != null && cachedServerVersion.equals(this.getServerVersion().toString())) {
                    this.session.setServerVariables(cachedVariableMap);
                    return;
                }
                this.serverConfigCache.invalidate(this.getURL());
            }
        }
        java.sql.Statement stmt = null;
        ResultSet results = null;
        try {
            block32: {
                stmt = this.getMetadataSafeStatement();
                String version = this.dbmd.getDriverVersion();
                if (version != null && version.indexOf(42) != -1) {
                    StringBuilder buf = new StringBuilder(version.length() + 10);
                    for (int i = 0; i < version.length(); ++i) {
                        char c = version.charAt(i);
                        if (c == '*') {
                            buf.append("[star]");
                            continue;
                        }
                        buf.append(c);
                    }
                    version = buf.toString();
                }
                String versionComment = this.propertySet.getBooleanReadableProperty("paranoid").getValue() != false || version == null ? "" : "/* " + version + " */";
                this.session.setServerVariables(new HashMap<String, String>());
                try {
                    if (this.versionMeetsMinimum(5, 1, 0)) {
                        StringBuilder queryBuf = new StringBuilder(versionComment).append("SELECT");
                        queryBuf.append("  @@session.auto_increment_increment AS auto_increment_increment");
                        queryBuf.append(", @@character_set_client AS character_set_client");
                        queryBuf.append(", @@character_set_connection AS character_set_connection");
                        queryBuf.append(", @@character_set_results AS character_set_results");
                        queryBuf.append(", @@character_set_server AS character_set_server");
                        queryBuf.append(", @@init_connect AS init_connect");
                        queryBuf.append(", @@interactive_timeout AS interactive_timeout");
                        if (!this.versionMeetsMinimum(5, 5, 0)) {
                            queryBuf.append(", @@language AS language");
                        }
                        queryBuf.append(", @@license AS license");
                        queryBuf.append(", @@lower_case_table_names AS lower_case_table_names");
                        queryBuf.append(", @@max_allowed_packet AS max_allowed_packet");
                        queryBuf.append(", @@net_buffer_length AS net_buffer_length");
                        queryBuf.append(", @@net_write_timeout AS net_write_timeout");
                        queryBuf.append(", @@query_cache_size AS query_cache_size");
                        queryBuf.append(", @@query_cache_type AS query_cache_type");
                        queryBuf.append(", @@sql_mode AS sql_mode");
                        queryBuf.append(", @@system_time_zone AS system_time_zone");
                        queryBuf.append(", @@time_zone AS time_zone");
                        queryBuf.append(", @@tx_isolation AS tx_isolation");
                        queryBuf.append(", @@wait_timeout AS wait_timeout");
                        results = stmt.executeQuery(queryBuf.toString());
                        if (results.next()) {
                            ResultSetMetaData rsmd = results.getMetaData();
                            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                                this.session.getServerVariables().put(rsmd.getColumnLabel(i), results.getString(i));
                            }
                        }
                    } else {
                        results = stmt.executeQuery(versionComment + "SHOW VARIABLES");
                        while (results.next()) {
                            this.session.getServerVariables().put(results.getString(1), results.getString(2));
                        }
                    }
                    results.close();
                    results = null;
                }
                catch (PasswordExpiredException ex) {
                    if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                        throw ex;
                    }
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block32;
                    throw ex;
                }
            }
            if (this.cacheServerConfiguration.getValue().booleanValue()) {
                this.session.getServerVariables().put(SERVER_VERSION_STRING_VAR_NAME, this.getServerVersion().toString());
                this.serverConfigCache.put(this.getURL(), this.session.getServerVariables());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public int getAutoIncrementIncrement() {
        return this.autoIncrementIncrement;
    }

    @Override
    public boolean lowerCaseTableNames() {
        return this.lowerCaseTableNames;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            if (sql == null) {
                return null;
            }
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.getMultiHostSafeProxy().getSession().getDefaultTimeZone(), this.getExceptionInterceptor());
            if (escapedSqlResult instanceof String) {
                return (String)escapedSqlResult;
            }
            return ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private CallableStatement parseCallableStatement(String sql) throws SQLException {
        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.getMultiHostSafeProxy().getSession().getDefaultTimeZone(), this.getExceptionInterceptor());
        boolean isFunctionCall = false;
        String parsedSql = null;
        if (escapedSqlResult instanceof EscapeProcessorResult) {
            parsedSql = ((EscapeProcessorResult)escapedSqlResult).escapedSql;
            isFunctionCall = ((EscapeProcessorResult)escapedSqlResult).callingStoredFunction;
        } else {
            parsedSql = (String)escapedSqlResult;
            isFunctionCall = false;
        }
        return CallableStatement.getInstance(this.getMultiHostSafeProxy(), parsedSql, this.database, isFunctionCall);
    }

    @Override
    public void ping() throws SQLException {
        try {
            this.pingInternal(true, 0);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void pingInternal(boolean checkForClosedConnection, int timeoutMillis) throws SQLException {
        try {
            if (checkForClosedConnection) {
                this.checkClosed();
            }
            long pingMillisLifetime = this.getPropertySet().getIntegerReadableProperty("selfDestructOnPingSecondsLifetime").getValue().intValue();
            int pingMaxOperations = this.getPropertySet().getIntegerReadableProperty("selfDestructOnPingMaxOperations").getValue();
            if (pingMillisLifetime > 0L && System.currentTimeMillis() - this.connectionCreationTimeMillis > pingMillisLifetime || pingMaxOperations > 0 && pingMaxOperations <= this.session.getCommandCount()) {
                this.close();
                throw SQLError.createSQLException(Messages.getString("Connection.exceededConnectionLifetime"), "08S01", this.getExceptionInterceptor());
            }
            this.session.sendCommand(14, null, null, false, null, timeoutMillis);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.prepareCall(sql, 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            CallableStatement cStmt = null;
            if (!this.getPropertySet().getBooleanReadableProperty("cacheCallableStmts").getValue().booleanValue()) {
                cStmt = this.parseCallableStatement(sql);
            } else {
                LRUCache lRUCache = this.parsedCallableStatementCache;
                synchronized (lRUCache) {
                    CompoundCacheKey key = new CompoundCacheKey(this.getCatalog(), sql);
                    CallableStatement.CallableStatementParamInfo cachedParamInfo = (CallableStatement.CallableStatementParamInfo)this.parsedCallableStatementCache.get(key);
                    if (cachedParamInfo != null) {
                        cStmt = CallableStatement.getInstance(this.getMultiHostSafeProxy(), cachedParamInfo);
                    } else {
                        CallableStatement callableStatement = cStmt = this.parseCallableStatement(sql);
                        synchronized (callableStatement) {
                            cachedParamInfo = cStmt.paramInfo;
                        }
                        this.parsedCallableStatementCache.put(key, cachedParamInfo);
                    }
                }
            }
            cStmt.setResultSetType(resultSetType);
            cStmt.setResultSetConcurrency(resultSetConcurrency);
            return cStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException(Messages.getString("Connection.17"), "S1009", this.getExceptionInterceptor());
            }
            CallableStatement cStmt = (CallableStatement)this.prepareCall(sql, resultSetType, resultSetConcurrency);
            return cStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.prepareStatement(sql, 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
            ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                String nativeSql;
                this.checkClosed();
                PreparedStatement pStmt = null;
                boolean canServerPrepare = true;
                String string = nativeSql = this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
                if (this.useServerPreparedStmts && this.emulateUnsupportedPstmts.getValue().booleanValue()) {
                    canServerPrepare = this.canHandleAsServerPreparedStatement(nativeSql);
                }
                if (this.useServerPreparedStmts && canServerPrepare) {
                    if (this.cachePrepStmts.getValue().booleanValue()) {
                        LRUCache lRUCache = this.serverSideStatementCache;
                        synchronized (lRUCache) {
                            pStmt = (ServerPreparedStatement)this.serverSideStatementCache.remove(sql);
                            if (pStmt != null) {
                                ((ServerPreparedStatement)pStmt).setClosed(false);
                                pStmt.clearParameters();
                            }
                            if (pStmt == null) {
                                try {
                                    pStmt = ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.database, resultSetType, resultSetConcurrency);
                                    if (sql.length() < this.prepStmtCacheSqlLimit.getValue()) {
                                        ((ServerPreparedStatement)pStmt).isCached = true;
                                    }
                                    pStmt.setResultSetType(resultSetType);
                                    pStmt.setResultSetConcurrency(resultSetConcurrency);
                                }
                                catch (SQLException sqlEx) {
                                    if (this.emulateUnsupportedPstmts.getValue().booleanValue()) {
                                        pStmt = (PreparedStatement)this.clientPrepareStatement(nativeSql, resultSetType, resultSetConcurrency, false);
                                        if (sql.length() < this.prepStmtCacheSqlLimit.getValue()) {
                                            this.serverSideStatementCheckCache.put(sql, Boolean.FALSE);
                                        }
                                    }
                                    throw sqlEx;
                                }
                            }
                        }
                    }
                    try {
                        pStmt = ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.database, resultSetType, resultSetConcurrency);
                        pStmt.setResultSetType(resultSetType);
                        pStmt.setResultSetConcurrency(resultSetConcurrency);
                    }
                    catch (SQLException sqlEx) {
                        if (this.emulateUnsupportedPstmts.getValue().booleanValue()) {
                            pStmt = (PreparedStatement)this.clientPrepareStatement(nativeSql, resultSetType, resultSetConcurrency, false);
                        }
                        throw sqlEx;
                    }
                } else {
                    pStmt = (PreparedStatement)this.clientPrepareStatement(nativeSql, resultSetType, resultSetConcurrency, false);
                }
                return pStmt;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException(Messages.getString("Connection.17"), "S1009", this.getExceptionInterceptor());
            }
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
            ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
            ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void realClose(boolean calledExplicitly, boolean issueRollback, boolean skipLocalTeardown, Throwable reason) throws SQLException {
        try {
            SQLException sqlEx = null;
            if (this.isClosed()) {
                return;
            }
            this.forceClosedReason = reason;
            try {
                if (!skipLocalTeardown) {
                    if (!this.getAutoCommit() && issueRollback) {
                        try {
                            this.rollback();
                        }
                        catch (SQLException ex) {
                            sqlEx = ex;
                        }
                    }
                    this.reportMetrics();
                    if (this.useUsageAdvisor.getValue().booleanValue()) {
                        long connectionLifeTime;
                        if (!calledExplicitly) {
                            this.session.getProfilerEventHandler().consumeEvent(new ProfilerEventImpl(0, "", this.getCatalog(), this.getId(), -1, -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, Messages.getString("Connection.18")));
                        }
                        if ((connectionLifeTime = System.currentTimeMillis() - this.connectionCreationTimeMillis) < 500L) {
                            this.session.getProfilerEventHandler().consumeEvent(new ProfilerEventImpl(0, "", this.getCatalog(), this.getId(), -1, -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, Messages.getString("Connection.19")));
                        }
                    }
                    try {
                        this.closeAllOpenStatements();
                    }
                    catch (SQLException ex) {
                        sqlEx = ex;
                    }
                    this.session.quit();
                } else {
                    this.session.forceClose();
                }
                if (this.statementInterceptors != null) {
                    for (int i = 0; i < this.statementInterceptors.size(); ++i) {
                        this.statementInterceptors.get(i).destroy();
                    }
                }
                if (this.exceptionInterceptor != null) {
                    this.exceptionInterceptor.destroy();
                }
            }
            finally {
                ProfilerEventHandlerFactory.removeInstance(this);
                this.openStatements = null;
                this.statementInterceptors = null;
                this.exceptionInterceptor = null;
                Object object = this.getConnectionMutex();
                synchronized (object) {
                    if (this.cancelTimer != null) {
                        this.cancelTimer.cancel();
                    }
                }
                this.isClosed = true;
            }
            if (sqlEx != null) {
                throw sqlEx;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recachePreparedStatement(ServerPreparedStatement pstmt) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (pstmt.isPoolable()) {
                    LRUCache lRUCache = this.serverSideStatementCache;
                    synchronized (lRUCache) {
                        this.serverSideStatementCache.put(pstmt.originalSql, pstmt);
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decachePreparedStatement(ServerPreparedStatement pstmt) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (pstmt.isPoolable()) {
                    LRUCache lRUCache = this.serverSideStatementCache;
                    synchronized (lRUCache) {
                        this.serverSideStatementCache.remove(pstmt.originalSql);
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void registerQueryExecutionTime(long queryTimeMs) {
        if (queryTimeMs > this.longestQueryTimeMs) {
            this.longestQueryTimeMs = queryTimeMs;
            this.repartitionPerformanceHistogram();
        }
        this.addToPerformanceHistogram(queryTimeMs, 1);
        if (queryTimeMs < this.shortestQueryTimeMs) {
            this.shortestQueryTimeMs = queryTimeMs == 0L ? 1L : queryTimeMs;
        }
        ++this.numberOfQueriesIssued;
        this.totalQueryTimeMs += (double)queryTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStatement(Statement stmt) {
        Map<Statement, Statement> map = this.openStatements;
        synchronized (map) {
            this.openStatements.put(stmt, stmt);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void repartitionHistogram(int[] histCounts, long[] histBreakpoints, long currentLowerBound, long currentUpperBound) {
        if (this.oldHistCounts == null) {
            this.oldHistCounts = new int[histCounts.length];
            this.oldHistBreakpoints = new long[histBreakpoints.length];
        }
        System.arraycopy(histCounts, 0, this.oldHistCounts, 0, histCounts.length);
        System.arraycopy(histBreakpoints, 0, this.oldHistBreakpoints, 0, histBreakpoints.length);
        this.createInitialHistogram(histBreakpoints, currentLowerBound, currentUpperBound);
        for (int i = 0; i < 20; ++i) {
            this.addToHistogram(histCounts, histBreakpoints, this.oldHistBreakpoints[i], this.oldHistCounts[i], currentLowerBound, currentUpperBound);
        }
    }

    private void repartitionPerformanceHistogram() {
        this.checkAndCreatePerformanceHistogram();
        this.repartitionHistogram(this.perfMetricsHistCounts, this.perfMetricsHistBreakpoints, this.shortestQueryTimeMs == Long.MAX_VALUE ? 0L : this.shortestQueryTimeMs, this.longestQueryTimeMs);
    }

    private void repartitionTablesAccessedHistogram() {
        this.checkAndCreateTablesAccessedHistogram();
        this.repartitionHistogram(this.numTablesMetricsHistCounts, this.numTablesMetricsHistBreakpoints, this.minimumNumberTablesAccessed == Long.MAX_VALUE ? 0L : this.minimumNumberTablesAccessed, this.maximumNumberTablesAccessed);
    }

    private void reportMetrics() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            int j;
            int numPointsToGraph;
            int i;
            int highestCount;
            int maxNumPoints;
            StringBuilder logMessage = new StringBuilder(256);
            logMessage.append("** Performance Metrics Report **\n");
            logMessage.append("\nLongest reported query: " + this.longestQueryTimeMs + " ms");
            logMessage.append("\nShortest reported query: " + this.shortestQueryTimeMs + " ms");
            logMessage.append("\nAverage query execution time: " + this.totalQueryTimeMs / (double)this.numberOfQueriesIssued + " ms");
            logMessage.append("\nNumber of statements executed: " + this.numberOfQueriesIssued);
            logMessage.append("\nNumber of result sets created: " + this.numberOfResultSetsCreated);
            logMessage.append("\nNumber of statements prepared: " + this.numberOfPrepares);
            logMessage.append("\nNumber of prepared statement executions: " + this.numberOfPreparedExecutes);
            if (this.perfMetricsHistBreakpoints != null) {
                logMessage.append("\n\n\tTiming Histogram:\n");
                maxNumPoints = 20;
                highestCount = Integer.MIN_VALUE;
                for (i = 0; i < 20; ++i) {
                    if (this.perfMetricsHistCounts[i] <= highestCount) continue;
                    highestCount = this.perfMetricsHistCounts[i];
                }
                if (highestCount == 0) {
                    highestCount = 1;
                }
                for (i = 0; i < 19; ++i) {
                    if (i == 0) {
                        logMessage.append("\n\tless than " + this.perfMetricsHistBreakpoints[i + 1] + " ms: \t" + this.perfMetricsHistCounts[i]);
                    } else {
                        logMessage.append("\n\tbetween " + this.perfMetricsHistBreakpoints[i] + " and " + this.perfMetricsHistBreakpoints[i + 1] + " ms: \t" + this.perfMetricsHistCounts[i]);
                    }
                    logMessage.append("\t");
                    numPointsToGraph = (int)((double)maxNumPoints * ((double)this.perfMetricsHistCounts[i] / (double)highestCount));
                    for (j = 0; j < numPointsToGraph; ++j) {
                        logMessage.append("*");
                    }
                    if (this.longestQueryTimeMs < (long)this.perfMetricsHistCounts[i + 1]) break;
                }
                if (this.perfMetricsHistBreakpoints[18] < this.longestQueryTimeMs) {
                    logMessage.append("\n\tbetween ");
                    logMessage.append(this.perfMetricsHistBreakpoints[18]);
                    logMessage.append(" and ");
                    logMessage.append(this.perfMetricsHistBreakpoints[19]);
                    logMessage.append(" ms: \t");
                    logMessage.append(this.perfMetricsHistCounts[19]);
                }
            }
            if (this.numTablesMetricsHistBreakpoints != null) {
                logMessage.append("\n\n\tTable Join Histogram:\n");
                maxNumPoints = 20;
                highestCount = Integer.MIN_VALUE;
                for (i = 0; i < 20; ++i) {
                    if (this.numTablesMetricsHistCounts[i] <= highestCount) continue;
                    highestCount = this.numTablesMetricsHistCounts[i];
                }
                if (highestCount == 0) {
                    highestCount = 1;
                }
                for (i = 0; i < 19; ++i) {
                    if (i == 0) {
                        logMessage.append("\n\t" + this.numTablesMetricsHistBreakpoints[i + 1] + " tables or less: \t\t" + this.numTablesMetricsHistCounts[i]);
                    } else {
                        logMessage.append("\n\tbetween " + this.numTablesMetricsHistBreakpoints[i] + " and " + this.numTablesMetricsHistBreakpoints[i + 1] + " tables: \t" + this.numTablesMetricsHistCounts[i]);
                    }
                    logMessage.append("\t");
                    numPointsToGraph = (int)((double)maxNumPoints * ((double)this.numTablesMetricsHistCounts[i] / (double)highestCount));
                    for (j = 0; j < numPointsToGraph; ++j) {
                        logMessage.append("*");
                    }
                    if (this.maximumNumberTablesAccessed < this.numTablesMetricsHistBreakpoints[i + 1]) break;
                }
                if (this.numTablesMetricsHistBreakpoints[18] < this.maximumNumberTablesAccessed) {
                    logMessage.append("\n\tbetween ");
                    logMessage.append(this.numTablesMetricsHistBreakpoints[18]);
                    logMessage.append(" and ");
                    logMessage.append(this.numTablesMetricsHistBreakpoints[19]);
                    logMessage.append(" tables: ");
                    logMessage.append(this.numTablesMetricsHistCounts[19]);
                }
            }
            this.session.getLog().logInfo(logMessage);
            this.metricsLastReportedMs = System.currentTimeMillis();
        }
    }

    protected void reportMetricsIfNeeded() {
        if (this.gatherPerfMetrics.getValue().booleanValue() && System.currentTimeMillis() - this.metricsLastReportedMs > (long)this.getPropertySet().getIntegerReadableProperty("reportMetricsIntervalMillis").getValue().intValue()) {
            this.reportMetrics();
        }
    }

    @Override
    public void reportNumberOfTablesAccessed(int numTablesAccessed) {
        if ((long)numTablesAccessed < this.minimumNumberTablesAccessed) {
            this.minimumNumberTablesAccessed = numTablesAccessed;
        }
        if ((long)numTablesAccessed > this.maximumNumberTablesAccessed) {
            this.maximumNumberTablesAccessed = numTablesAccessed;
            this.repartitionTablesAccessedHistogram();
        }
        this.addToTablesAccessedHistogram(numTablesAccessed, 1);
    }

    @Override
    public void resetServerState() throws SQLException {
        try {
            if (!this.propertySet.getBooleanReadableProperty("paranoid").getValue().booleanValue() && this.session != null) {
                this.changeUser(this.user, this.password);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                try {
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock<Extension> iter = new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                            @Override
                            void forEach(Extension each) throws SQLException {
                                if (!((ConnectionLifecycleInterceptor)each).rollback()) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            return;
                        }
                    }
                    if (this.autoCommit) {
                        throw SQLError.createSQLException(Messages.getString("Connection.20"), "08003", this.getExceptionInterceptor());
                    }
                    try {
                        this.rollbackNoChecks();
                    }
                    catch (SQLException sqlEx) {
                        if (this.ignoreNonTxTables.getInitialValue().booleanValue() && sqlEx.getErrorCode() == 1196) {
                            this.needsPing = this.reconnectAtTxEnd.getValue();
                            return;
                        }
                        try {
                            throw sqlEx;
                        }
                        catch (SQLException sqlException) {
                            if ("08S01".equals(sqlException.getSQLState())) {
                                throw SQLError.createSQLException(Messages.getString("Connection.21"), "08007", this.getExceptionInterceptor());
                            }
                            throw sqlException;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.needsPing = this.reconnectAtTxEnd.getValue();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(final Savepoint savepoint) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                try {
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock<Extension> iter = new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                            @Override
                            void forEach(Extension each) throws SQLException {
                                if (!((ConnectionLifecycleInterceptor)each).rollback(savepoint)) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            return;
                        }
                    }
                    StringBuilder rollbackQuery = new StringBuilder("ROLLBACK TO SAVEPOINT ");
                    rollbackQuery.append('`');
                    rollbackQuery.append(savepoint.getSavepointName());
                    rollbackQuery.append('`');
                    java.sql.Statement stmt = null;
                    try {
                        stmt = this.getMetadataSafeStatement();
                        stmt.executeUpdate(rollbackQuery.toString());
                    }
                    catch (SQLException sqlEx) {
                        int indexOfError153;
                        String msg;
                        int errno = sqlEx.getErrorCode();
                        if (errno == 1181 && (msg = sqlEx.getMessage()) != null && (indexOfError153 = msg.indexOf("153")) != -1) {
                            throw SQLError.createSQLException(Messages.getString("Connection.22", new Object[]{savepoint.getSavepointName()}), "S1009", errno, this.getExceptionInterceptor());
                        }
                        if (this.ignoreNonTxTables.getValue().booleanValue() && sqlEx.getErrorCode() != 1196) {
                            throw sqlEx;
                        }
                        if ("08S01".equals(sqlEx.getSQLState())) {
                            throw SQLError.createSQLException(Messages.getString("Connection.23"), "08007", this.getExceptionInterceptor());
                        }
                        throw sqlEx;
                    }
                    finally {
                        this.closeStatement(stmt);
                    }
                }
                finally {
                    this.needsPing = this.reconnectAtTxEnd.getValue();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void rollbackNoChecks() throws SQLException {
        if (this.useLocalTransactionState.getValue().booleanValue() && !this.session.inTransactionOnServer()) {
            return;
        }
        this.execSQL(null, "rollback", -1, null, 1003, 1007, false, this.database, null, false);
    }

    @Override
    public java.sql.PreparedStatement serverPrepareStatement(String sql) throws SQLException {
        try {
            String nativeSql = this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            return ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.getCatalog(), 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement serverPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            String nativeSql = this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            ServerPreparedStatement pStmt = ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.getCatalog(), 1003, 1007);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String nativeSql = this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            return ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.getCatalog(), resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException(Messages.getString("Connection.17"), "S1009", this.getExceptionInterceptor());
            }
            return this.serverPrepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement serverPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            PreparedStatement pStmt = (PreparedStatement)this.serverPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.PreparedStatement serverPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            PreparedStatement pStmt = (PreparedStatement)this.serverPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(final boolean autoCommitFlag) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                if (this.connectionLifecycleInterceptors != null) {
                    IterateBlock<Extension> iter = new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                        @Override
                        void forEach(Extension each) throws SQLException {
                            if (!((ConnectionLifecycleInterceptor)each).setAutoCommit(autoCommitFlag)) {
                                this.stopIterating = true;
                            }
                        }
                    };
                    iter.doForAll();
                    if (!iter.fullIteration()) {
                        return;
                    }
                }
                if (this.autoReconnectForPools.getValue().booleanValue()) {
                    this.autoReconnect.setValue(true);
                }
                try {
                    boolean needsSetOnServer = true;
                    if (this.useLocalSessionState.getValue().booleanValue() && this.autoCommit == autoCommitFlag) {
                        needsSetOnServer = false;
                    } else if (!((Boolean)this.autoReconnect.getValue()).booleanValue()) {
                        needsSetOnServer = this.getSession().isSetNeededForAutoCommitMode(autoCommitFlag);
                    }
                    this.autoCommit = autoCommitFlag;
                    if (needsSetOnServer) {
                        this.execSQL(null, autoCommitFlag ? "SET autocommit=1" : "SET autocommit=0", -1, null, 1003, 1007, false, this.database, null, false);
                    }
                }
                finally {
                    if (this.autoReconnectForPools.getValue().booleanValue()) {
                        this.autoReconnect.setValue(false);
                    }
                }
                return;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(final String catalog) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                String quotedId;
                this.checkClosed();
                if (catalog == null) {
                    throw SQLError.createSQLException("Catalog can not be null", "S1009", this.getExceptionInterceptor());
                }
                if (this.connectionLifecycleInterceptors != null) {
                    IterateBlock<Extension> iter = new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                        @Override
                        void forEach(Extension each) throws SQLException {
                            if (!((ConnectionLifecycleInterceptor)each).setCatalog(catalog)) {
                                this.stopIterating = true;
                            }
                        }
                    };
                    iter.doForAll();
                    if (!iter.fullIteration()) {
                        return;
                    }
                }
                if (this.useLocalSessionState.getValue().booleanValue()) {
                    if (this.lowerCaseTableNames) {
                        if (this.database.equalsIgnoreCase(catalog)) {
                            return;
                        }
                    } else if (this.database.equals(catalog)) {
                        return;
                    }
                }
                if ((quotedId = this.dbmd.getIdentifierQuoteString()) == null || quotedId.equals(" ")) {
                    quotedId = "";
                }
                StringBuilder query = new StringBuilder("USE ");
                query.append(StringUtils.quoteIdentifier(catalog, quotedId, this.pedantic.getValue()));
                this.execSQL(null, query.toString(), -1, null, 1003, 1007, false, this.database, null, false);
                this.database = catalog;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFailedOver(boolean flag) {
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setInGlobalTx(boolean flag) {
        this.isInGlobalTx = flag;
    }

    @Override
    public void setReadInfoMsgEnabled(boolean flag) {
        this.readInfoMsg = flag;
    }

    @Override
    public void setReadOnly(boolean readOnlyFlag) throws SQLException {
        try {
            this.checkClosed();
            this.setReadOnlyInternal(readOnlyFlag);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setReadOnlyInternal(boolean readOnlyFlag) throws SQLException {
        try {
            if (this.readOnlyPropagatesToServer.getValue().booleanValue() && (!this.useLocalSessionState.getValue().booleanValue() || readOnlyFlag != this.readOnly)) {
                this.execSQL(null, "set session transaction " + (readOnlyFlag ? "read only" : "read write"), -1, null, 1003, 1007, false, this.database, null, false);
            }
            this.readOnly = readOnlyFlag;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            MysqlSavepoint savepoint = new MysqlSavepoint(this.getExceptionInterceptor());
            this.setSavepoint(savepoint);
            return savepoint;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSavepoint(MysqlSavepoint savepoint) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                StringBuilder savePointQuery = new StringBuilder("SAVEPOINT ");
                savePointQuery.append('`');
                savePointQuery.append(savepoint.getSavepointName());
                savePointQuery.append('`');
                java.sql.Statement stmt = null;
                try {
                    stmt = this.getMetadataSafeStatement();
                    stmt.executeUpdate(savePointQuery.toString());
                }
                finally {
                    this.closeStatement(stmt);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                MysqlSavepoint savepoint = new MysqlSavepoint(name, this.getExceptionInterceptor());
                this.setSavepoint(savepoint);
                return savepoint;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionVariables() throws SQLException {
        String sessionVariables = this.getPropertySet().getStringReadableProperty("sessionVariables").getValue();
        if (sessionVariables != null) {
            List<String> variablesToSet = StringUtils.split(sessionVariables, ",", "\"'", "\"'", false);
            int numVariablesToSet = variablesToSet.size();
            try (java.sql.Statement stmt = null;){
                stmt = this.getMetadataSafeStatement();
                for (int i = 0; i < numVariablesToSet; ++i) {
                    String variableValuePair = variablesToSet.get(i);
                    if (variableValuePair.startsWith("@")) {
                        stmt.executeUpdate("SET " + variableValuePair);
                        continue;
                    }
                    stmt.executeUpdate("SET SESSION " + variableValuePair);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                String sql = null;
                boolean shouldSendSet = false;
                if (this.getPropertySet().getBooleanReadableProperty("alwaysSendSetIsolation").getValue().booleanValue()) {
                    shouldSendSet = true;
                } else if (level != this.isolationLevel) {
                    shouldSendSet = true;
                }
                if (this.useLocalSessionState.getValue().booleanValue()) {
                    boolean bl = shouldSendSet = this.isolationLevel != level;
                }
                if (shouldSendSet) {
                    switch (level) {
                        case 0: {
                            throw SQLError.createSQLException(Messages.getString("Connection.24"), this.getExceptionInterceptor());
                        }
                        case 2: {
                            sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ COMMITTED";
                            break;
                        }
                        case 1: {
                            sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ UNCOMMITTED";
                            break;
                        }
                        case 4: {
                            sql = "SET SESSION TRANSACTION ISOLATION LEVEL REPEATABLE READ";
                            break;
                        }
                        case 8: {
                            sql = "SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE";
                            break;
                        }
                        default: {
                            throw SQLError.createSQLException(Messages.getString("Connection.25", new Object[]{level}), "S1C00", this.getExceptionInterceptor());
                        }
                    }
                    this.execSQL(null, sql, -1, null, 1003, 1007, false, this.database, null, false);
                    this.isolationLevel = level;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.typeMap = map;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void setupServerForTruncationChecks() throws SQLException {
        ModifiableProperty<Boolean> jdbcCompliantTruncation = this.getPropertySet().getModifiableProperty("jdbcCompliantTruncation");
        if (((Boolean)jdbcCompliantTruncation.getValue()).booleanValue()) {
            boolean strictTransTablesIsSet;
            String currentSqlMode = this.session.getServerVariable("sql_mode");
            boolean bl = strictTransTablesIsSet = StringUtils.indexOfIgnoreCase(currentSqlMode, "STRICT_TRANS_TABLES") != -1;
            if (currentSqlMode == null || currentSqlMode.length() == 0 || !strictTransTablesIsSet) {
                StringBuilder commandBuf = new StringBuilder("SET sql_mode='");
                if (currentSqlMode != null && currentSqlMode.length() > 0) {
                    commandBuf.append(currentSqlMode);
                    commandBuf.append(",");
                }
                commandBuf.append("STRICT_TRANS_TABLES'");
                this.execSQL(null, commandBuf.toString(), -1, null, 1003, 1007, false, this.database, null, false);
                jdbcCompliantTruncation.setValue(false);
            } else if (strictTransTablesIsSet) {
                jdbcCompliantTruncation.setValue(false);
            }
        }
    }

    @Override
    public void shutdownServer() throws SQLException {
        try {
            try {
                this.session.shutdownServer();
            }
            catch (CJException ex) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.UnhandledExceptionDuringShutdown"), "S1000", this.getExceptionInterceptor());
                sqlEx.initCause(ex);
                throw sqlEx;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterStatement(Statement stmt) {
        if (this.openStatements != null) {
            Map<Statement, Statement> map = this.openStatements;
            synchronized (map) {
                this.openStatements.remove(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean useAnsiQuotedIdentifiers() {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            return this.useAnsiQuotes;
        }
    }

    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        try {
            this.checkClosed();
            return this.session.versionMeetsMinimum(major, minor, subminor);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedResultSetMetaData getCachedMetaData(String sql) {
        if (this.resultSetMetadataCache != null) {
            LRUCache lRUCache = this.resultSetMetadataCache;
            synchronized (lRUCache) {
                return (CachedResultSetMetaData)this.resultSetMetadataCache.get(sql);
            }
        }
        return null;
    }

    @Override
    public void initializeResultsMetadataFromCache(String sql, CachedResultSetMetaData cachedMetaData, ResultSetInternalMethods resultSet) throws SQLException {
        try {
            if (cachedMetaData == null) {
                cachedMetaData = new CachedResultSetMetaData();
                resultSet.buildIndexMapping();
                resultSet.initializeWithMetadata();
                if (resultSet instanceof UpdatableResultSet) {
                    ((UpdatableResultSet)resultSet).checkUpdatability();
                }
                resultSet.populateCachedMetaData(cachedMetaData);
                this.resultSetMetadataCache.put(sql, cachedMetaData);
            } else {
                resultSet.initializeFromCachedMetaData(cachedMetaData);
                resultSet.initializeWithMetadata();
                if (resultSet instanceof UpdatableResultSet) {
                    ((UpdatableResultSet)resultSet).checkUpdatability();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getStatementComment() {
        return this.statementComment;
    }

    @Override
    public void setStatementComment(String comment) {
        this.statementComment = comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportQueryTime(long millisOrNanos) {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            ++this.queryTimeCount;
            this.queryTimeSum += (double)millisOrNanos;
            this.queryTimeSumSquares += (double)(millisOrNanos * millisOrNanos);
            this.queryTimeMean = (this.queryTimeMean * (double)(this.queryTimeCount - 1L) + (double)millisOrNanos) / (double)this.queryTimeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAbonormallyLongQuery(long millisOrNanos) {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            if (this.queryTimeCount < 15L) {
                return false;
            }
            double stddev = Math.sqrt((this.queryTimeSumSquares - this.queryTimeSum * this.queryTimeSum / (double)this.queryTimeCount) / (double)(this.queryTimeCount - 1L));
            boolean bl = (double)millisOrNanos > this.queryTimeMean + 5.0 * stddev;
            return bl;
        }
    }

    @Override
    public void initializeExtension(Extension ex) {
        ex.init(this, this.props, this.session.getLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionBegun() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (this.connectionLifecycleInterceptors != null) {
                    IterateBlock<Extension> iter = new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                        @Override
                        void forEach(Extension each) throws SQLException {
                            ((ConnectionLifecycleInterceptor)each).transactionBegun();
                        }
                    };
                    iter.doForAll();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionCompleted() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (this.connectionLifecycleInterceptors != null) {
                    IterateBlock<Extension> iter = new IterateBlock<Extension>(this.connectionLifecycleInterceptors.iterator()){

                        @Override
                        void forEach(Extension each) throws SQLException {
                            ((ConnectionLifecycleInterceptor)each).transactionCompleted();
                        }
                    };
                    iter.doForAll();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesLowerCaseTableName() {
        return this.storesLowerCaseTableName;
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public boolean getRequiresEscapingEncoder() {
        return this.requiresEscapingEncoder;
    }

    @Override
    public boolean isServerLocal() throws SQLException {
        try {
            try {
                return this.session.isServerLocal(this);
            }
            catch (CJException ex) {
                SQLException sqlEx = SQLExceptionsMapping.translateException(ex, this.getExceptionInterceptor());
                throw sqlEx;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionMaxRows() {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            return this.session.getSessionMaxRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionMaxRows(int max) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (this.session.getSessionMaxRows() != max) {
                    this.session.setSessionMaxRows(max);
                    this.execSQL(null, "SET SQL_SELECT_LIMIT=" + (this.session.getSessionMaxRows() == -1 ? "DEFAULT" : Integer.valueOf(this.session.getSessionMaxRows())), -1, null, 1003, 1007, false, this.database, null, false);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                return null;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            SecurityManager sec = System.getSecurityManager();
            if (sec != null) {
                sec.checkPermission(ABORT_PERM);
            }
            if (executor == null) {
                throw SQLError.createSQLException(Messages.getString("Connection.26"), "S1009", this.getExceptionInterceptor());
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionImpl.this.abortInternal();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                SecurityManager sec = System.getSecurityManager();
                if (sec != null) {
                    sec.checkPermission(SET_NETWORK_TIMEOUT_PERM);
                }
                if (executor == null) {
                    throw SQLError.createSQLException(Messages.getString("Connection.26"), "S1009", this.getExceptionInterceptor());
                }
                this.checkClosed();
                this.session.setSocketTimeout(executor, milliseconds);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                return this.session.getSocketTimeout();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Clob createClob() {
        try {
            return new Clob(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Blob createBlob() {
        try {
            return new Blob(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.NClob createNClob() {
        try {
            return new NClob(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return new MysqlSQLXML(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (this.isClosed()) {
                    return false;
                }
                try {
                    try {
                        this.pingInternal(false, timeout * 1000);
                    }
                    catch (Throwable t) {
                        try {
                            this.abortInternal();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return false;
                    }
                }
                catch (Throwable t) {
                    return false;
                }
                return true;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientInfoProvider getClientInfoProviderImpl() throws SQLException {
        try {
            Object object = this.getConnectionMutex();
            synchronized (object) {
                if (this.infoProvider == null) {
                    block12: {
                        String clientInfoProvider = this.getPropertySet().getStringReadableProperty("clientInfoProvider").getStringValue();
                        try {
                            try {
                                this.infoProvider = (ClientInfoProvider)Util.getInstance(clientInfoProvider, new Class[0], new Object[0], this.getExceptionInterceptor());
                            }
                            catch (CJException ex) {
                                if (!(ex.getCause() instanceof ClassCastException)) break block12;
                                try {
                                    this.infoProvider = (ClientInfoProvider)Util.getInstance("com.mysql.cj.jdbc." + clientInfoProvider, new Class[0], new Object[0], this.getExceptionInterceptor());
                                }
                                catch (CJException e) {
                                    throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
                                }
                            }
                        }
                        catch (ClassCastException cce) {
                            throw SQLError.createSQLException(Messages.getString("Connection.ClientInfoNotImplemented", new Object[]{clientInfoProvider}), "S1009", this.getExceptionInterceptor());
                        }
                    }
                    this.infoProvider.initialize(this, this.props);
                }
                return this.infoProvider;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, name, value);
        }
        catch (SQLClientInfoException ciEx) {
            throw ciEx;
        }
        catch (CJException | SQLException sqlEx) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(sqlEx);
            throw clientInfoEx;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, properties);
        }
        catch (SQLClientInfoException ciEx) {
            throw ciEx;
        }
        catch (CJException | SQLException sqlEx) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(sqlEx);
            throw clientInfoEx;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.getClientInfoProviderImpl().getClientInfo(this, name);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getClientInfoProviderImpl().getClientInfo(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.checkClosed();
            return iface.isInstance(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProcessHost() {
        try {
            long threadId = this.getId();
            String processHost = null;
            try (java.sql.Statement processListStmt = this.getMetadataSafeStatement();){
                processHost = ConnectionImpl.findProcessHost(threadId, processListStmt);
                if (processHost == null) {
                    this.session.getLog().logWarn(String.format("Connection id %d not found in \"SHOW PROCESSLIST\", assuming 32-bit overflow, using SELECT CONNECTION_ID() instead", threadId));
                    ResultSet rs = processListStmt.executeQuery("SELECT CONNECTION_ID()");
                    if (rs.next()) {
                        threadId = rs.getLong(1);
                        processHost = ConnectionImpl.findProcessHost(threadId, processListStmt);
                    } else {
                        this.session.getLog().logError("No rows returned for statement \"SELECT CONNECTION_ID()\", local connection check will most likely be incorrect");
                    }
                }
            }
            if (processHost == null) {
                this.session.getLog().logWarn(String.format("Cannot find process listing for connection %d in SHOW PROCESSLIST output, unable to determine if locally connected", threadId));
            }
            return processHost;
        }
        catch (SQLException ex) {
            throw ExceptionFactory.createException(ex.getMessage(), ex, this.exceptionInterceptor);
        }
    }

    private static String findProcessHost(long threadId, java.sql.Statement processListStmt) throws SQLException {
        String processHost = null;
        ResultSet rs = processListStmt.executeQuery("SHOW PROCESSLIST");
        while (rs.next()) {
            long id = rs.getLong(1);
            if (threadId != id) continue;
            processHost = rs.getString(3);
            break;
        }
        return processHost;
    }

    @Override
    public MysqlaSession getSession() {
        return this.session;
    }

    static {
        DEFAULT_LOGGER_CLASS = StandardLogger.class.getName();
        mapTransIsolationNameToValue = null;
        dynamicIndexToCollationMapByUrl = new HashMap<String, Map<Long, String>>();
        dynamicIndexToCharsetMapByUrl = new HashMap<String, Map<Integer, String>>();
        customIndexToCharsetMapByUrl = new HashMap<String, Map<Integer, String>>();
        customCharsetToMblenMapByUrl = new HashMap<String, Map<String, Integer>>();
        mapTransIsolationNameToValue = new HashMap<String, Integer>(8);
        mapTransIsolationNameToValue.put("READ-UNCOMMITED", 1);
        mapTransIsolationNameToValue.put("READ-UNCOMMITTED", 1);
        mapTransIsolationNameToValue.put("READ-COMMITTED", 2);
        mapTransIsolationNameToValue.put("REPEATABLE-READ", 4);
        mapTransIsolationNameToValue.put("SERIALIZABLE", 8);
        random = new Random();
    }

    static class CompoundCacheKey {
        String componentOne;
        String componentTwo;
        int hashCode;

        CompoundCacheKey(String partOne, String partTwo) {
            this.componentOne = partOne;
            this.componentTwo = partTwo;
            this.hashCode = ((this.componentOne != null ? this.componentOne : "") + this.componentTwo).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompoundCacheKey) {
                CompoundCacheKey another = (CompoundCacheKey)obj;
                boolean firstPartEqual = false;
                firstPartEqual = this.componentOne == null ? another.componentOne == null : this.componentOne.equals(another.componentOne);
                return firstPartEqual && this.componentTwo.equals(another.componentTwo);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public class ExceptionInterceptorChain
    implements ExceptionInterceptor {
        List<Extension> interceptors;

        ExceptionInterceptorChain(String interceptorClasses) {
            this.interceptors = Util.loadExtensions(ConnectionImpl.this, ConnectionImpl.this.props, interceptorClasses, "Connection.BadExceptionInterceptor", this, ConnectionImpl.this.getSession().getLog());
        }

        void addRingZero(ExceptionInterceptor interceptor) throws SQLException {
            this.interceptors.add(0, interceptor);
        }

        @Override
        public Exception interceptException(Exception sqlEx, MysqlConnection conn) {
            if (this.interceptors != null) {
                Iterator<Extension> iter = this.interceptors.iterator();
                while (iter.hasNext()) {
                    sqlEx = ((ExceptionInterceptor)iter.next()).interceptException(sqlEx, ConnectionImpl.this);
                }
            }
            return sqlEx;
        }

        @Override
        public void destroy() {
            if (this.interceptors != null) {
                Iterator<Extension> iter = this.interceptors.iterator();
                while (iter.hasNext()) {
                    ((ExceptionInterceptor)iter.next()).destroy();
                }
            }
        }

        @Override
        public void init(MysqlConnection conn, Properties properties, Log log) {
            if (this.interceptors != null) {
                Iterator<Extension> iter = this.interceptors.iterator();
                while (iter.hasNext()) {
                    ((ExceptionInterceptor)iter.next()).init(conn, properties, log);
                }
            }
        }

        public List<Extension> getInterceptors() {
            return this.interceptors;
        }
    }
}

