/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.protocol.x;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.mysql.cj.exceptions.CJCommunicationsException;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.protocol.FullReadInputStream;
import com.mysql.cj.protocol.MessageReader;
import com.mysql.cj.protocol.x.MessageConstants;
import com.mysql.cj.protocol.x.XMessage;
import com.mysql.cj.protocol.x.XMessageHeader;
import com.mysql.cj.protocol.x.XProtocolError;
import com.mysql.cj.x.protobuf.Mysqlx;
import java.io.IOException;
import java.util.Optional;

public class SyncMessageReader
implements MessageReader<XMessageHeader, XMessage> {
    private FullReadInputStream inputStream;
    private boolean hasReadHeader = false;
    private XMessageHeader header;

    public SyncMessageReader(FullReadInputStream inputStream) {
        this.inputStream = inputStream;
    }

    private void readMessageHeader() throws IOException {
        byte[] len = new byte[5];
        this.inputStream.readFully(len);
        this.header = new XMessageHeader(len);
        this.hasReadHeader = true;
    }

    private void clearHeader() {
        this.hasReadHeader = false;
        this.header = null;
    }

    @Override
    public XMessageHeader readHeader() throws IOException {
        int type;
        Class<? extends GeneratedMessage> messageClass;
        if (!this.hasReadHeader) {
            try {
                this.readMessageHeader();
            }
            catch (IOException ex) {
                throw new CJCommunicationsException("Cannot read packet header", ex);
            }
        }
        if ((messageClass = MessageConstants.getMessageClassForType(type = this.header.getMessageType())) == Mysqlx.Error.class) {
            throw new XProtocolError((Mysqlx.Error)this.readAndParse(MessageConstants.MESSAGE_CLASS_TO_PARSER.get(Mysqlx.Error.class)));
        }
        return this.header;
    }

    private <T extends GeneratedMessage> T readAndParse(Parser<T> parser) {
        byte[] packet = new byte[this.header.getMessageSize()];
        try {
            this.inputStream.readFully(packet);
        }
        catch (IOException ex) {
            throw new CJCommunicationsException("Cannot read packet payload", ex);
        }
        try {
            GeneratedMessage ex = (GeneratedMessage)parser.parseFrom(packet);
            return (T)ex;
        }
        catch (InvalidProtocolBufferException ex) {
            throw new WrongArgumentException(ex);
        }
        finally {
            this.clearHeader();
        }
    }

    @Override
    public XMessage readMessage(Optional<XMessage> reuse, XMessageHeader hdr) throws IOException {
        Class<? extends GeneratedMessage> messageClass = MessageConstants.getMessageClassForType(hdr.getMessageType());
        return new XMessage((Message)this.readAndParse(messageClass));
    }

    @Override
    public XMessage readMessage(Optional<XMessage> reuse, int expectedType) throws IOException {
        try {
            Class<? extends GeneratedMessage> messageClass = MessageConstants.getMessageClassForType(this.readHeader().getMessageType());
            Class<? extends GeneratedMessage> expectedClass = MessageConstants.getMessageClassForType(expectedType);
            if (expectedClass != messageClass) {
                throw new WrongArgumentException("Unexpected message class. Expected '" + expectedClass.getSimpleName() + "' but actually received '" + messageClass.getSimpleName() + "'");
            }
            return new XMessage((Message)this.readAndParse(messageClass));
        }
        catch (IOException e) {
            throw new XProtocolError(e.getMessage(), e);
        }
    }

    private <T extends GeneratedMessage> T readAndParse(Class<T> messageClass) {
        return (T)this.readAndParse(MessageConstants.MESSAGE_CLASS_TO_PARSER.get(messageClass));
    }
}

