/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.builder.LambdaFactory;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.NexusAccessor;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.ExceptionMethod;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMatcher;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.JavaType;

public interface AgentBuilder {
    public AgentBuilder with(ByteBuddy var1);

    public AgentBuilder with(Listener var1);

    public AgentBuilder with(CircularityLock var1);

    public AgentBuilder with(PoolStrategy var1);

    public AgentBuilder with(LocationStrategy var1);

    public AgentBuilder with(TypeStrategy var1);

    public AgentBuilder with(InitializationStrategy var1);

    public RedefinitionListenable.WithoutBatchStrategy with(RedefinitionStrategy var1);

    public AgentBuilder with(LambdaInstrumentationStrategy var1);

    public AgentBuilder with(DescriptionStrategy var1);

    public AgentBuilder with(InstallationStrategy var1);

    public AgentBuilder with(FallbackStrategy var1);

    public AgentBuilder enableBootstrapInjection(Instrumentation var1, File var2);

    public AgentBuilder enableNativeMethodPrefix(String var1);

    public AgentBuilder disableNativeMethodPrefix();

    public AgentBuilder disableBootstrapInjection();

    public AgentBuilder disableClassFormatChanges();

    public AgentBuilder assureReadEdgeTo(Instrumentation var1, Class<?> ... var2);

    public AgentBuilder assureReadEdgeTo(Instrumentation var1, JavaModule ... var2);

    public AgentBuilder assureReadEdgeTo(Instrumentation var1, Collection<? extends JavaModule> var2);

    public AgentBuilder assureReadEdgeFromAndTo(Instrumentation var1, Class<?> ... var2);

    public AgentBuilder assureReadEdgeFromAndTo(Instrumentation var1, JavaModule ... var2);

    public AgentBuilder assureReadEdgeFromAndTo(Instrumentation var1, Collection<? extends JavaModule> var2);

    public Identified.Narrowable type(ElementMatcher<? super TypeDescription> var1);

    public Identified.Narrowable type(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

    public Identified.Narrowable type(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

    public Identified.Narrowable type(RawMatcher var1);

    public Ignored ignore(ElementMatcher<? super TypeDescription> var1);

    public Ignored ignore(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

    public Ignored ignore(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

    public Ignored ignore(RawMatcher var1);

    public ResettableClassFileTransformer makeRaw();

    public ResettableClassFileTransformer installOn(Instrumentation var1);

    public ResettableClassFileTransformer installOnByteBuddyAgent();

    public static class Default
    implements AgentBuilder {
        private static final String INSTALLER_TYPE = "net.bytebuddy.agent.Installer";
        private static final String INSTRUMENTATION_FIELD = "instrumentation";
        private static final Object STATIC_FIELD = null;
        private static final byte[] NO_TRANSFORMATION = null;
        private static final Class<?> NO_LOADED_TYPE = null;
        private static final CircularityLock DEFAULT_LOCK = new CircularityLock.Default();
        protected final ByteBuddy byteBuddy;
        protected final Listener listener;
        protected final CircularityLock circularityLock;
        protected final PoolStrategy poolStrategy;
        protected final TypeStrategy typeStrategy;
        protected final LocationStrategy locationStrategy;
        protected final NativeMethodStrategy nativeMethodStrategy;
        protected final InitializationStrategy initializationStrategy;
        protected final RedefinitionStrategy redefinitionStrategy;
        protected final RedefinitionStrategy.BatchAllocator redefinitionBatchAllocator;
        protected final RedefinitionStrategy.Listener redefinitionListener;
        protected final BootstrapInjectionStrategy bootstrapInjectionStrategy;
        protected final LambdaInstrumentationStrategy lambdaInstrumentationStrategy;
        protected final DescriptionStrategy descriptionStrategy;
        protected final InstallationStrategy installationStrategy;
        protected final FallbackStrategy fallbackStrategy;
        protected final RawMatcher ignoredTypeMatcher;
        protected final Transformation transformation;

        public Default() {
            this(new ByteBuddy());
        }

        public Default(ByteBuddy byteBuddy) {
            this(byteBuddy, Listener.NoOp.INSTANCE, DEFAULT_LOCK, PoolStrategy.Default.FAST, TypeStrategy.Default.REBASE, LocationStrategy.ForClassLoader.STRONG, NativeMethodStrategy.Disabled.INSTANCE, new InitializationStrategy.SelfInjection.Split(), RedefinitionStrategy.DISABLED, RedefinitionStrategy.BatchAllocator.ForTotal.INSTANCE, RedefinitionStrategy.Listener.NoOp.INSTANCE, BootstrapInjectionStrategy.Disabled.INSTANCE, LambdaInstrumentationStrategy.DISABLED, DescriptionStrategy.Default.HYBRID, InstallationStrategy.Default.ESCALATING, FallbackStrategy.ByThrowableType.ofOptionalTypes(), new RawMatcher.Disjunction(new RawMatcher.ForElementMatchers(ElementMatchers.any(), ElementMatchers.isBootstrapClassLoader(), ElementMatchers.any()), new RawMatcher.ForElementMatchers(ElementMatchers.nameStartsWith("net.bytebuddy.").or(ElementMatchers.nameStartsWith("sun.reflect.")).or(ElementMatchers.isSynthetic()), ElementMatchers.any(), ElementMatchers.any())), Transformation.Ignored.INSTANCE);
        }

        protected Default(ByteBuddy byteBuddy, Listener listener, CircularityLock circularityLock, PoolStrategy poolStrategy, TypeStrategy typeStrategy, LocationStrategy locationStrategy, NativeMethodStrategy nativeMethodStrategy, InitializationStrategy initializationStrategy, RedefinitionStrategy redefinitionStrategy, RedefinitionStrategy.BatchAllocator redefinitionBatchAllocator, RedefinitionStrategy.Listener redefinitionListener, BootstrapInjectionStrategy bootstrapInjectionStrategy, LambdaInstrumentationStrategy lambdaInstrumentationStrategy, DescriptionStrategy descriptionStrategy, InstallationStrategy installationStrategy, FallbackStrategy fallbackStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation) {
            this.byteBuddy = byteBuddy;
            this.listener = listener;
            this.circularityLock = circularityLock;
            this.poolStrategy = poolStrategy;
            this.typeStrategy = typeStrategy;
            this.locationStrategy = locationStrategy;
            this.nativeMethodStrategy = nativeMethodStrategy;
            this.initializationStrategy = initializationStrategy;
            this.redefinitionStrategy = redefinitionStrategy;
            this.redefinitionBatchAllocator = redefinitionBatchAllocator;
            this.redefinitionListener = redefinitionListener;
            this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
            this.lambdaInstrumentationStrategy = lambdaInstrumentationStrategy;
            this.descriptionStrategy = descriptionStrategy;
            this.installationStrategy = installationStrategy;
            this.fallbackStrategy = fallbackStrategy;
            this.ignoredTypeMatcher = ignoredTypeMatcher;
            this.transformation = transformation;
        }

        public static AgentBuilder of(Plugin ... plugin) {
            return Default.of(Arrays.asList(plugin));
        }

        public static AgentBuilder of(List<? extends Plugin> plugins) {
            return Default.of((EntryPoint)EntryPoint.Default.REBASE, plugins);
        }

        public static AgentBuilder of(EntryPoint entryPoint, Plugin ... plugin) {
            return Default.of(entryPoint, Arrays.asList(plugin));
        }

        public static AgentBuilder of(EntryPoint entryPoint, List<? extends Plugin> plugins) {
            AgentBuilder agentBuilder = new Default(entryPoint.getByteBuddy()).with(new TypeStrategy.ForBuildEntryPoint(entryPoint));
            for (Plugin plugin : plugins) {
                agentBuilder = agentBuilder.type(plugin).transform(new Transformer.ForBuildPlugin(plugin));
            }
            return agentBuilder;
        }

        @Override
        public AgentBuilder with(ByteBuddy byteBuddy) {
            return new Default(byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(Listener listener) {
            return new Default(this.byteBuddy, new Listener.Compound(this.listener, listener), this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(CircularityLock circularityLock) {
            return new Default(this.byteBuddy, this.listener, circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(TypeStrategy typeStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(PoolStrategy poolStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(LocationStrategy locationStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder enableNativeMethodPrefix(String prefix) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, NativeMethodStrategy.ForPrefix.of(prefix), this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder disableNativeMethodPrefix() {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, NativeMethodStrategy.Disabled.INSTANCE, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public RedefinitionListenable.WithoutBatchStrategy with(RedefinitionStrategy redefinitionStrategy) {
            return new Redefining(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(InitializationStrategy initializationStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(LambdaInstrumentationStrategy lambdaInstrumentationStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(DescriptionStrategy descriptionStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(InstallationStrategy installationStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(FallbackStrategy fallbackStrategy) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder enableBootstrapInjection(Instrumentation instrumentation, File folder) {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, new BootstrapInjectionStrategy.Enabled(folder, instrumentation), this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder disableBootstrapInjection() {
            return new Default(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, BootstrapInjectionStrategy.Disabled.INSTANCE, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder disableClassFormatChanges() {
            return new Default(this.byteBuddy.with(Implementation.Context.Disabled.Factory.INSTANCE), this.listener, this.circularityLock, this.poolStrategy, TypeStrategy.Default.REDEFINE_DECLARED_ONLY, this.locationStrategy, NativeMethodStrategy.Disabled.INSTANCE, InitializationStrategy.NoOp.INSTANCE, this.redefinitionStrategy, this.redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder assureReadEdgeTo(Instrumentation instrumentation, Class<?> ... type) {
            return JavaModule.isSupported() ? this.with(Listener.ModuleReadEdgeCompleting.of(instrumentation, false, type)) : this;
        }

        @Override
        public AgentBuilder assureReadEdgeTo(Instrumentation instrumentation, JavaModule ... module) {
            return this.assureReadEdgeTo(instrumentation, Arrays.asList(module));
        }

        @Override
        public AgentBuilder assureReadEdgeTo(Instrumentation instrumentation, Collection<? extends JavaModule> modules) {
            return this.with(new Listener.ModuleReadEdgeCompleting(instrumentation, false, new HashSet<JavaModule>(modules)));
        }

        @Override
        public AgentBuilder assureReadEdgeFromAndTo(Instrumentation instrumentation, Class<?> ... type) {
            return JavaModule.isSupported() ? this.with(Listener.ModuleReadEdgeCompleting.of(instrumentation, true, type)) : this;
        }

        @Override
        public AgentBuilder assureReadEdgeFromAndTo(Instrumentation instrumentation, JavaModule ... module) {
            return this.assureReadEdgeFromAndTo(instrumentation, Arrays.asList(module));
        }

        @Override
        public AgentBuilder assureReadEdgeFromAndTo(Instrumentation instrumentation, Collection<? extends JavaModule> modules) {
            return this.with(new Listener.ModuleReadEdgeCompleting(instrumentation, true, new HashSet<JavaModule>(modules)));
        }

        @Override
        public Identified.Narrowable type(RawMatcher matcher) {
            return new Transforming(matcher, Transformer.NoOp.INSTANCE, false);
        }

        @Override
        public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher) {
            return this.type(typeMatcher, ElementMatchers.any());
        }

        @Override
        public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
            return this.type(typeMatcher, classLoaderMatcher, ElementMatchers.any());
        }

        @Override
        public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
            return this.type(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, ElementMatchers.not(ElementMatchers.supportsModules()).or(moduleMatcher)));
        }

        @Override
        public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher) {
            return this.ignore(typeMatcher, ElementMatchers.any());
        }

        @Override
        public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
            return this.ignore(typeMatcher, classLoaderMatcher, ElementMatchers.any());
        }

        @Override
        public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
            return this.ignore(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, ElementMatchers.not(ElementMatchers.supportsModules()).or(moduleMatcher)));
        }

        @Override
        public Ignored ignore(RawMatcher rawMatcher) {
            return new Ignoring(rawMatcher);
        }

        @Override
        public ResettableClassFileTransformer makeRaw() {
            return ExecutingTransformer.FACTORY.make(this.byteBuddy, this.listener, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation, this.circularityLock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResettableClassFileTransformer installOn(Instrumentation instrumentation) {
            if (!this.circularityLock.acquire()) {
                throw new IllegalStateException("Could not acquire the circularity lock upon installation.");
            }
            try {
                ResettableClassFileTransformer classFileTransformer = this.makeRaw();
                instrumentation.addTransformer(classFileTransformer, this.redefinitionStrategy.isRetransforming(instrumentation));
                try {
                    Object collector;
                    if (this.nativeMethodStrategy.isEnabled(instrumentation)) {
                        instrumentation.setNativeMethodPrefix(classFileTransformer, this.nativeMethodStrategy.getPrefix());
                    }
                    this.lambdaInstrumentationStrategy.apply(this.byteBuddy, instrumentation, classFileTransformer);
                    if (this.redefinitionStrategy.isEnabled()) {
                        collector = this.redefinitionStrategy.make(this.transformation);
                        for (Class type : instrumentation.getAllLoadedClasses()) {
                            if (!this.lambdaInstrumentationStrategy.isInstrumented(type)) continue;
                            JavaModule module = JavaModule.ofType(type);
                            try {
                                TypePool typePool = this.poolStrategy.typePool(this.locationStrategy.classFileLocator(type.getClassLoader(), module), type.getClassLoader());
                                try {
                                    ((RedefinitionStrategy.Collector)collector).consider(this.ignoredTypeMatcher, this.listener, this.descriptionStrategy.apply(TypeDescription.ForLoadedType.getName(type), type, typePool, this.circularityLock, type.getClassLoader(), module), type, type, module, !instrumentation.isModifiableClass(type));
                                }
                                catch (Throwable throwable) {
                                    if (this.descriptionStrategy.isLoadedFirst() && this.fallbackStrategy.isFallback(type, throwable)) {
                                        ((RedefinitionStrategy.Collector)collector).consider(this.ignoredTypeMatcher, this.listener, typePool.describe(TypeDescription.ForLoadedType.getName(type)).resolve(), type, module);
                                        continue;
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    try {
                                        this.listener.onError(TypeDescription.ForLoadedType.getName(type), type.getClassLoader(), module, throwable);
                                    }
                                    finally {
                                        this.listener.onComplete(TypeDescription.ForLoadedType.getName(type), type.getClassLoader(), module);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                        }
                        ((RedefinitionStrategy.Collector)collector).apply(instrumentation, this.circularityLock, this.locationStrategy, this.listener, this.redefinitionBatchAllocator, this.redefinitionListener);
                    }
                    collector = classFileTransformer;
                    return collector;
                }
                catch (Throwable throwable) {
                    ResettableClassFileTransformer resettableClassFileTransformer = this.installationStrategy.onError(instrumentation, classFileTransformer, throwable);
                    this.circularityLock.release();
                    return resettableClassFileTransformer;
                }
            }
            finally {
                this.circularityLock.release();
            }
        }

        @Override
        public ResettableClassFileTransformer installOnByteBuddyAgent() {
            try {
                Instrumentation instrumentation = (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getDeclaredField(INSTRUMENTATION_FIELD).get(STATIC_FIELD);
                if (instrumentation == null) {
                    throw new IllegalStateException("The Byte Buddy agent is not installed");
                }
                return this.installOn(instrumentation);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.byteBuddy.equals(aDefault.byteBuddy) && this.listener.equals(aDefault.listener) && this.circularityLock.equals(aDefault.circularityLock) && this.poolStrategy.equals(aDefault.poolStrategy) && this.nativeMethodStrategy.equals(aDefault.nativeMethodStrategy) && this.typeStrategy.equals(aDefault.typeStrategy) && this.locationStrategy.equals(aDefault.locationStrategy) && this.initializationStrategy.equals(aDefault.initializationStrategy) && this.redefinitionStrategy == aDefault.redefinitionStrategy && this.redefinitionBatchAllocator.equals(aDefault.redefinitionBatchAllocator) && this.redefinitionListener.equals(aDefault.redefinitionListener) && this.bootstrapInjectionStrategy.equals(aDefault.bootstrapInjectionStrategy) && this.lambdaInstrumentationStrategy.equals((Object)aDefault.lambdaInstrumentationStrategy) && this.descriptionStrategy.equals(aDefault.descriptionStrategy) && this.installationStrategy.equals(aDefault.installationStrategy) && this.fallbackStrategy.equals(aDefault.fallbackStrategy) && this.ignoredTypeMatcher.equals(aDefault.ignoredTypeMatcher) && this.transformation.equals(aDefault.transformation);
        }

        public int hashCode() {
            int result = this.byteBuddy.hashCode();
            result = 31 * result + this.listener.hashCode();
            result = 31 * result + this.circularityLock.hashCode();
            result = 31 * result + this.poolStrategy.hashCode();
            result = 31 * result + this.typeStrategy.hashCode();
            result = 31 * result + this.locationStrategy.hashCode();
            result = 31 * result + this.nativeMethodStrategy.hashCode();
            result = 31 * result + this.initializationStrategy.hashCode();
            result = 31 * result + this.redefinitionStrategy.hashCode();
            result = 31 * result + this.redefinitionBatchAllocator.hashCode();
            result = 31 * result + this.redefinitionListener.hashCode();
            result = 31 * result + this.bootstrapInjectionStrategy.hashCode();
            result = 31 * result + this.lambdaInstrumentationStrategy.hashCode();
            result = 31 * result + this.descriptionStrategy.hashCode();
            result = 31 * result + this.installationStrategy.hashCode();
            result = 31 * result + this.fallbackStrategy.hashCode();
            result = 31 * result + this.ignoredTypeMatcher.hashCode();
            result = 31 * result + this.transformation.hashCode();
            return result;
        }

        public String toString() {
            return "AgentBuilder.Default{byteBuddy=" + this.byteBuddy + ", listener=" + this.listener + ", circularityLock=" + this.circularityLock + ", poolStrategy=" + this.poolStrategy + ", typeStrategy=" + this.typeStrategy + ", locationStrategy=" + this.locationStrategy + ", nativeMethodStrategy=" + this.nativeMethodStrategy + ", initializationStrategy=" + this.initializationStrategy + ", redefinitionStrategy=" + (Object)((Object)this.redefinitionStrategy) + ", redefinitionBatchAllocator=" + this.redefinitionBatchAllocator + ", redefinitionListener=" + this.redefinitionListener + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", lambdaInstrumentationStrategy=" + (Object)((Object)this.lambdaInstrumentationStrategy) + ", descriptionStrategy=" + this.descriptionStrategy + ", installationStrategy=" + this.installationStrategy + ", fallbackStrategy=" + this.fallbackStrategy + ", ignoredTypeMatcher=" + this.ignoredTypeMatcher + ", transformation=" + this.transformation + '}';
        }

        protected class Transforming
        extends Delegator<Identified.Narrowable>
        implements Identified.Extendable,
        Identified.Narrowable {
            private final RawMatcher rawMatcher;
            private final Transformer transformer;
            private final boolean decorator;

            protected Transforming(RawMatcher rawMatcher, Transformer transformer, boolean decorator) {
                this.rawMatcher = rawMatcher;
                this.transformer = transformer;
                this.decorator = decorator;
            }

            @Override
            protected AgentBuilder materialize() {
                return new Default(Default.this.byteBuddy, Default.this.listener, Default.this.circularityLock, Default.this.poolStrategy, Default.this.typeStrategy, Default.this.locationStrategy, Default.this.nativeMethodStrategy, Default.this.initializationStrategy, Default.this.redefinitionStrategy, Default.this.redefinitionBatchAllocator, Default.this.redefinitionListener, Default.this.bootstrapInjectionStrategy, Default.this.lambdaInstrumentationStrategy, Default.this.descriptionStrategy, Default.this.installationStrategy, Default.this.fallbackStrategy, Default.this.ignoredTypeMatcher, new Transformation.Compound(new Transformation.Simple(this.rawMatcher, this.transformer, this.decorator), Default.this.transformation));
            }

            @Override
            public Identified.Extendable transform(Transformer transformer) {
                return new Transforming(this.rawMatcher, new Transformer.Compound(this.transformer, transformer), this.decorator);
            }

            @Override
            public AgentBuilder asDecorator() {
                return new Transforming(this.rawMatcher, this.transformer, true);
            }

            @Override
            public Identified.Narrowable and(RawMatcher rawMatcher) {
                return new Transforming(new RawMatcher.Conjunction(this.rawMatcher, rawMatcher), this.transformer, this.decorator);
            }

            @Override
            public Identified.Narrowable or(RawMatcher rawMatcher) {
                return new Transforming(new RawMatcher.Disjunction(this.rawMatcher, rawMatcher), this.transformer, this.decorator);
            }

            private Default getOuter() {
                return Default.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.decorator == ((Transforming)other).decorator && this.rawMatcher.equals(((Transforming)other).rawMatcher) && this.transformer.equals(((Transforming)other).transformer) && Default.this.equals(((Transforming)other).getOuter());
            }

            public int hashCode() {
                int result = this.rawMatcher.hashCode();
                result = 31 * result + (this.decorator ? 1 : 0);
                result = 31 * result + this.transformer.hashCode();
                result = 31 * result + Default.this.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.Transforming{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + ", decorator=" + this.decorator + ", agentBuilder=" + Default.this + '}';
            }
        }

        protected static class Redefining
        extends Default
        implements RedefinitionListenable.WithoutBatchStrategy {
            protected Redefining(ByteBuddy byteBuddy, Listener listener, CircularityLock circularityLock, PoolStrategy poolStrategy, TypeStrategy typeStrategy, LocationStrategy locationStrategy, NativeMethodStrategy nativeMethodStrategy, InitializationStrategy initializationStrategy, RedefinitionStrategy redefinitionStrategy, RedefinitionStrategy.BatchAllocator redefinitionBatchAllocator, RedefinitionStrategy.Listener redefinitionListener, BootstrapInjectionStrategy bootstrapInjectionStrategy, LambdaInstrumentationStrategy lambdaInstrumentationStrategy, DescriptionStrategy descriptionStrategy, InstallationStrategy installationStrategy, FallbackStrategy fallbackStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation) {
                super(byteBuddy, listener, circularityLock, poolStrategy, typeStrategy, locationStrategy, nativeMethodStrategy, initializationStrategy, redefinitionStrategy, redefinitionBatchAllocator, redefinitionListener, bootstrapInjectionStrategy, lambdaInstrumentationStrategy, descriptionStrategy, installationStrategy, fallbackStrategy, ignoredTypeMatcher, transformation);
            }

            @Override
            public RedefinitionListenable with(RedefinitionStrategy.BatchAllocator redefinitionBatchAllocator) {
                return new Redefining(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, redefinitionBatchAllocator, this.redefinitionListener, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
            }

            @Override
            public RedefinitionListenable with(RedefinitionStrategy.Listener redefinitionListener) {
                return new Redefining(this.byteBuddy, this.listener, this.circularityLock, this.poolStrategy, this.typeStrategy, this.locationStrategy, this.nativeMethodStrategy, this.initializationStrategy, this.redefinitionStrategy, this.redefinitionBatchAllocator, new RedefinitionStrategy.Listener.Compound(this.redefinitionListener, redefinitionListener), this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.descriptionStrategy, this.installationStrategy, this.fallbackStrategy, this.ignoredTypeMatcher, this.transformation);
            }

            @Override
            public String toString() {
                return "AgentBuilder.Default.Redefining{byteBuddy=" + this.byteBuddy + ", listener=" + this.listener + ", poolStrategy=" + this.poolStrategy + ", typeStrategy=" + this.typeStrategy + ", locationStrategy=" + this.locationStrategy + ", nativeMethodStrategy=" + this.nativeMethodStrategy + ", initializationStrategy=" + this.initializationStrategy + ", redefinitionStrategy=" + (Object)((Object)this.redefinitionStrategy) + ", redefinitionBatchAllocator=" + this.redefinitionBatchAllocator + ", redefinitionListener=" + this.redefinitionListener + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", lambdaInstrumentationStrategy=" + (Object)((Object)this.lambdaInstrumentationStrategy) + ", descriptionStrategy=" + this.descriptionStrategy + ", installationStrategy=" + this.installationStrategy + ", fallbackStrategy=" + this.fallbackStrategy + ", ignoredTypeMatcher=" + this.ignoredTypeMatcher + ", transformation=" + this.transformation + '}';
            }
        }

        protected class Ignoring
        extends Delegator<Ignored>
        implements Ignored {
            private final RawMatcher rawMatcher;

            protected Ignoring(RawMatcher rawMatcher) {
                this.rawMatcher = rawMatcher;
            }

            @Override
            protected AgentBuilder materialize() {
                return new Default(Default.this.byteBuddy, Default.this.listener, Default.this.circularityLock, Default.this.poolStrategy, Default.this.typeStrategy, Default.this.locationStrategy, Default.this.nativeMethodStrategy, Default.this.initializationStrategy, Default.this.redefinitionStrategy, Default.this.redefinitionBatchAllocator, Default.this.redefinitionListener, Default.this.bootstrapInjectionStrategy, Default.this.lambdaInstrumentationStrategy, Default.this.descriptionStrategy, Default.this.installationStrategy, Default.this.fallbackStrategy, this.rawMatcher, Default.this.transformation);
            }

            @Override
            public Ignored and(RawMatcher rawMatcher) {
                return new Ignoring(new RawMatcher.Conjunction(this.rawMatcher, rawMatcher));
            }

            @Override
            public Ignored or(RawMatcher rawMatcher) {
                return new Ignoring(new RawMatcher.Disjunction(this.rawMatcher, rawMatcher));
            }

            private Default getOuter() {
                return Default.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.rawMatcher.equals(((Ignoring)other).rawMatcher) && Default.this.equals(((Ignoring)other).getOuter());
            }

            public int hashCode() {
                int result = this.rawMatcher.hashCode();
                result = 31 * result + Default.this.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.Ignoring{rawMatcher=" + this.rawMatcher + ", agentBuilder=" + Default.this + '}';
            }
        }

        protected abstract class Delegator<T extends Matchable<T>>
        extends Matchable.AbstractBase<T>
        implements AgentBuilder {
            protected Delegator() {
            }

            protected abstract AgentBuilder materialize();

            @Override
            public AgentBuilder with(ByteBuddy byteBuddy) {
                return this.materialize().with(byteBuddy);
            }

            @Override
            public AgentBuilder with(Listener listener) {
                return this.materialize().with(listener);
            }

            @Override
            public AgentBuilder with(CircularityLock circularityLock) {
                return this.materialize().with(circularityLock);
            }

            @Override
            public AgentBuilder with(TypeStrategy typeStrategy) {
                return this.materialize().with(typeStrategy);
            }

            @Override
            public AgentBuilder with(PoolStrategy poolStrategy) {
                return this.materialize().with(poolStrategy);
            }

            @Override
            public AgentBuilder with(LocationStrategy locationStrategy) {
                return this.materialize().with(locationStrategy);
            }

            @Override
            public AgentBuilder with(InitializationStrategy initializationStrategy) {
                return this.materialize().with(initializationStrategy);
            }

            @Override
            public RedefinitionListenable.WithoutBatchStrategy with(RedefinitionStrategy redefinitionStrategy) {
                return this.materialize().with(redefinitionStrategy);
            }

            @Override
            public AgentBuilder with(LambdaInstrumentationStrategy lambdaInstrumentationStrategy) {
                return this.materialize().with(lambdaInstrumentationStrategy);
            }

            @Override
            public AgentBuilder with(DescriptionStrategy descriptionStrategy) {
                return this.materialize().with(descriptionStrategy);
            }

            @Override
            public AgentBuilder with(InstallationStrategy installationStrategy) {
                return this.materialize().with(installationStrategy);
            }

            @Override
            public AgentBuilder with(FallbackStrategy fallbackStrategy) {
                return this.materialize().with(fallbackStrategy);
            }

            @Override
            public AgentBuilder enableBootstrapInjection(Instrumentation instrumentation, File folder) {
                return this.materialize().enableBootstrapInjection(instrumentation, folder);
            }

            @Override
            public AgentBuilder disableBootstrapInjection() {
                return this.materialize().disableBootstrapInjection();
            }

            @Override
            public AgentBuilder enableNativeMethodPrefix(String prefix) {
                return this.materialize().enableNativeMethodPrefix(prefix);
            }

            @Override
            public AgentBuilder disableNativeMethodPrefix() {
                return this.materialize().disableNativeMethodPrefix();
            }

            @Override
            public AgentBuilder disableClassFormatChanges() {
                return this.materialize().disableClassFormatChanges();
            }

            @Override
            public AgentBuilder assureReadEdgeTo(Instrumentation instrumentation, Class<?> ... type) {
                return this.materialize().assureReadEdgeTo(instrumentation, type);
            }

            @Override
            public AgentBuilder assureReadEdgeTo(Instrumentation instrumentation, JavaModule ... module) {
                return this.materialize().assureReadEdgeTo(instrumentation, module);
            }

            @Override
            public AgentBuilder assureReadEdgeTo(Instrumentation instrumentation, Collection<? extends JavaModule> modules) {
                return this.materialize().assureReadEdgeTo(instrumentation, modules);
            }

            @Override
            public AgentBuilder assureReadEdgeFromAndTo(Instrumentation instrumentation, Class<?> ... type) {
                return this.materialize().assureReadEdgeFromAndTo(instrumentation, type);
            }

            @Override
            public AgentBuilder assureReadEdgeFromAndTo(Instrumentation instrumentation, JavaModule ... module) {
                return this.materialize().assureReadEdgeFromAndTo(instrumentation, module);
            }

            @Override
            public AgentBuilder assureReadEdgeFromAndTo(Instrumentation instrumentation, Collection<? extends JavaModule> modules) {
                return this.materialize().assureReadEdgeFromAndTo(instrumentation, modules);
            }

            @Override
            public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.materialize().type(typeMatcher);
            }

            @Override
            public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.materialize().type(typeMatcher, classLoaderMatcher);
            }

            @Override
            public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return this.materialize().type(typeMatcher, classLoaderMatcher, moduleMatcher);
            }

            @Override
            public Identified.Narrowable type(RawMatcher matcher) {
                return this.materialize().type(matcher);
            }

            @Override
            public Ignored ignore(ElementMatcher<? super TypeDescription> ignoredTypes) {
                return this.materialize().ignore(ignoredTypes);
            }

            @Override
            public Ignored ignore(ElementMatcher<? super TypeDescription> ignoredTypes, ElementMatcher<? super ClassLoader> ignoredClassLoaders) {
                return this.materialize().ignore(ignoredTypes, ignoredClassLoaders);
            }

            @Override
            public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return this.materialize().ignore(typeMatcher, classLoaderMatcher, moduleMatcher);
            }

            @Override
            public Ignored ignore(RawMatcher rawMatcher) {
                return this.materialize().ignore(rawMatcher);
            }

            @Override
            public ResettableClassFileTransformer makeRaw() {
                return this.materialize().makeRaw();
            }

            @Override
            public ResettableClassFileTransformer installOn(Instrumentation instrumentation) {
                return this.materialize().installOn(instrumentation);
            }

            @Override
            public ResettableClassFileTransformer installOnByteBuddyAgent() {
                return this.materialize().installOnByteBuddyAgent();
            }
        }

        protected static class ExecutingTransformer
        extends ResettableClassFileTransformer.AbstractBase {
            protected static final Factory FACTORY = AccessController.doPrivileged(Factory.CreationAction.INSTANCE);
            private final ByteBuddy byteBuddy;
            private final PoolStrategy poolStrategy;
            private final TypeStrategy typeStrategy;
            private final Listener listener;
            private final NativeMethodStrategy nativeMethodStrategy;
            private final InitializationStrategy initializationStrategy;
            private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
            private final LambdaInstrumentationStrategy lambdaInstrumentationStrategy;
            private final DescriptionStrategy descriptionStrategy;
            private final LocationStrategy locationStrategy;
            private final FallbackStrategy fallbackStrategy;
            private final RawMatcher ignoredTypeMatcher;
            private final Transformation transformation;
            private final CircularityLock circularityLock;
            private final AccessControlContext accessControlContext;

            public ExecutingTransformer(ByteBuddy byteBuddy, Listener listener, PoolStrategy poolStrategy, TypeStrategy typeStrategy, LocationStrategy locationStrategy, NativeMethodStrategy nativeMethodStrategy, InitializationStrategy initializationStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, LambdaInstrumentationStrategy lambdaInstrumentationStrategy, DescriptionStrategy descriptionStrategy, FallbackStrategy fallbackStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation, CircularityLock circularityLock) {
                this.byteBuddy = byteBuddy;
                this.typeStrategy = typeStrategy;
                this.poolStrategy = poolStrategy;
                this.locationStrategy = locationStrategy;
                this.listener = listener;
                this.nativeMethodStrategy = nativeMethodStrategy;
                this.initializationStrategy = initializationStrategy;
                this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
                this.lambdaInstrumentationStrategy = lambdaInstrumentationStrategy;
                this.descriptionStrategy = descriptionStrategy;
                this.fallbackStrategy = fallbackStrategy;
                this.ignoredTypeMatcher = ignoredTypeMatcher;
                this.transformation = transformation;
                this.circularityLock = circularityLock;
                this.accessControlContext = AccessController.getContext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                if (this.circularityLock.acquire()) {
                    try {
                        byte[] byArray = AccessController.doPrivileged(new LegacyVmDispatcher(classLoader, internalTypeName, classBeingRedefined, protectionDomain, binaryRepresentation), this.accessControlContext);
                        return byArray;
                    }
                    finally {
                        this.circularityLock.release();
                    }
                }
                return NO_TRANSFORMATION;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected byte[] transform(Object rawModule, ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                if (this.circularityLock.acquire()) {
                    try {
                        byte[] byArray = AccessController.doPrivileged(new Java9CapableVmDispatcher(rawModule, classLoader, internalTypeName, classBeingRedefined, protectionDomain, binaryRepresentation), this.accessControlContext);
                        return byArray;
                    }
                    finally {
                        this.circularityLock.release();
                    }
                }
                return NO_TRANSFORMATION;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte[] transform(JavaModule module, ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                if (internalTypeName == null || !this.lambdaInstrumentationStrategy.isInstrumented(classBeingRedefined)) {
                    return NO_TRANSFORMATION;
                }
                String typeName = internalTypeName.replace('/', '.');
                try {
                    ClassFileLocator classFileLocator = ClassFileLocator.Simple.of(typeName, binaryRepresentation, this.locationStrategy.classFileLocator(classLoader, module));
                    TypePool typePool = this.poolStrategy.typePool(classFileLocator, classLoader);
                    try {
                        byte[] byArray = this.doTransform(module, classLoader, typeName, classBeingRedefined, protectionDomain, typePool, classFileLocator);
                        return byArray;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            if (classBeingRedefined == null || !this.descriptionStrategy.isLoadedFirst() || !this.fallbackStrategy.isFallback(classBeingRedefined, throwable)) break block10;
                            byte[] byArray = this.doTransform(module, classLoader, typeName, NO_LOADED_TYPE, protectionDomain, typePool, classFileLocator);
                            this.listener.onComplete(typeName, classLoader, module);
                            return byArray;
                        }
                        try {
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            this.listener.onError(typeName, classLoader, module, throwable2);
                            byte[] byArray = NO_TRANSFORMATION;
                            return byArray;
                        }
                    }
                }
                finally {
                    this.listener.onComplete(typeName, classLoader, module);
                }
            }

            private byte[] doTransform(JavaModule module, ClassLoader classLoader, String typeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, TypePool typePool, ClassFileLocator classFileLocator) {
                return this.resolve(module, classLoader, typeName, classBeingRedefined, protectionDomain, typePool).apply(this.initializationStrategy, classFileLocator, this.typeStrategy, this.byteBuddy, this.nativeMethodStrategy, this.bootstrapInjectionStrategy, this.accessControlContext, this.listener);
            }

            private Transformation.Resolution resolve(JavaModule module, ClassLoader classLoader, String typeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, TypePool typePool) {
                TypeDescription typeDescription = this.descriptionStrategy.apply(typeName, classBeingRedefined, typePool, this.circularityLock, classLoader, module);
                return this.ignoredTypeMatcher.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) ? new Transformation.Resolution.Unresolved(typeDescription, classLoader, module) : this.transformation.resolve(typeDescription, classLoader, module, classBeingRedefined, protectionDomain, typePool);
            }

            @Override
            public synchronized ResettableClassFileTransformer.Reset reset(Instrumentation instrumentation, RedefinitionStrategy redefinitionStrategy, RedefinitionStrategy.BatchAllocator redefinitionBatchAllocator, RedefinitionStrategy.Listener redefinitionListener) {
                if (instrumentation.removeTransformer(this)) {
                    if (!redefinitionStrategy.isEnabled()) {
                        return ResettableClassFileTransformer.Reset.Simple.ACTIVE;
                    }
                    redefinitionStrategy.isRetransforming(instrumentation);
                    HashMap failures = new HashMap();
                    RedefinitionStrategy.Collector collector = redefinitionStrategy.make(this.transformation);
                    for (Class type : instrumentation.getAllLoadedClasses()) {
                        if (!this.lambdaInstrumentationStrategy.isInstrumented(type)) continue;
                        JavaModule module = JavaModule.ofType(type);
                        try {
                            collector.consider(this.ignoredTypeMatcher, Listener.NoOp.INSTANCE, this.descriptionStrategy.apply(TypeDescription.ForLoadedType.getName(type), type, this.poolStrategy.typePool(this.locationStrategy.classFileLocator(type.getClassLoader(), module), type.getClassLoader()), this.circularityLock, type.getClassLoader(), module), type, type, module, !instrumentation.isModifiableClass(type));
                        }
                        catch (Throwable throwable) {
                            try {
                                if (this.descriptionStrategy.isLoadedFirst() && this.fallbackStrategy.isFallback(type, throwable)) {
                                    collector.consider(this.ignoredTypeMatcher, Listener.NoOp.INSTANCE, this.descriptionStrategy.apply(TypeDescription.ForLoadedType.getName(type), NO_LOADED_TYPE, this.poolStrategy.typePool(this.locationStrategy.classFileLocator(type.getClassLoader(), module), type.getClassLoader()), this.circularityLock, type.getClassLoader(), module), type, module);
                                    continue;
                                }
                                failures.put(type, throwable);
                            }
                            catch (Throwable fallback) {
                                failures.put(type, fallback);
                            }
                        }
                    }
                    collector.apply(instrumentation, CircularityLock.Inactive.INSTANCE, this.locationStrategy, Listener.NoOp.INSTANCE, RedefinitionStrategy.BatchAllocator.ForTotal.INSTANCE, new RedefinitionStrategy.Listener.Compound(new FailureCollectingListener(failures), redefinitionListener));
                    return ResettableClassFileTransformer.Reset.WithErrors.ofPotentiallyErroneous(failures);
                }
                return ResettableClassFileTransformer.Reset.Simple.INACTIVE;
            }

            public String toString() {
                return "AgentBuilder.Default." + this.getClass().getSimpleName() + "{byteBuddy=" + this.byteBuddy + ", listener=" + this.listener + ", poolStrategy=" + this.poolStrategy + ", typeStrategy=" + this.typeStrategy + ", locationStrategy=" + this.locationStrategy + ", initializationStrategy=" + this.initializationStrategy + ", nativeMethodStrategy=" + this.nativeMethodStrategy + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", lambdaInstrumentationStrategy=" + (Object)((Object)this.lambdaInstrumentationStrategy) + ", descriptionStrategy=" + this.descriptionStrategy + ", fallbackStrategy=" + this.fallbackStrategy + ", ignoredTypeMatcher=" + this.ignoredTypeMatcher + ", transformation=" + this.transformation + ", circularityLock=" + this.circularityLock + ", accessControlContext=" + this.accessControlContext + '}';
            }

            protected static class FailureCollectingListener
            extends RedefinitionStrategy.Listener.Adapter {
                private final Map<Class<?>, Throwable> failures;

                protected FailureCollectingListener(Map<Class<?>, Throwable> failures) {
                    this.failures = failures;
                }

                @Override
                public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                    for (Class<?> type : batch) {
                        this.failures.put(type, throwable);
                    }
                    return Collections.emptyList();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    FailureCollectingListener that = (FailureCollectingListener)object;
                    return this.failures.equals(that.failures);
                }

                public int hashCode() {
                    return this.failures.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.ExecutingTransformer.FailureCollectingListener{failures=" + this.failures + '}';
                }
            }

            protected class Java9CapableVmDispatcher
            implements PrivilegedAction<byte[]> {
                private final Object rawModule;
                private final ClassLoader classLoader;
                private final String internalTypeName;
                private final Class<?> classBeingRedefined;
                private final ProtectionDomain protectionDomain;
                private final byte[] binaryRepresentation;

                protected Java9CapableVmDispatcher(Object rawModule, ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                    this.rawModule = rawModule;
                    this.classLoader = classLoader;
                    this.internalTypeName = internalTypeName;
                    this.classBeingRedefined = classBeingRedefined;
                    this.protectionDomain = protectionDomain;
                    this.binaryRepresentation = binaryRepresentation;
                }

                @Override
                public byte[] run() {
                    return ExecutingTransformer.this.transform(JavaModule.of(this.rawModule), this.classLoader, this.internalTypeName, this.classBeingRedefined, this.protectionDomain, this.binaryRepresentation);
                }

                private ExecutingTransformer getOuter() {
                    return ExecutingTransformer.this;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Java9CapableVmDispatcher that = (Java9CapableVmDispatcher)object;
                    return this.rawModule.equals(that.rawModule) && (this.classLoader != null ? this.classLoader.equals(that.classLoader) : that.classLoader == null) && (this.internalTypeName != null ? this.internalTypeName.equals(that.internalTypeName) : that.internalTypeName == null) && (this.classBeingRedefined != null ? this.classBeingRedefined.equals(that.classBeingRedefined) : that.classBeingRedefined == null) && this.protectionDomain.equals(that.protectionDomain) && ExecutingTransformer.this.equals(that.getOuter()) && Arrays.equals(this.binaryRepresentation, that.binaryRepresentation);
                }

                public int hashCode() {
                    int result = this.rawModule.hashCode();
                    result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                    result = 31 * result + (this.internalTypeName != null ? this.internalTypeName.hashCode() : 0);
                    result = 31 * result + (this.classBeingRedefined != null ? this.classBeingRedefined.hashCode() : 0);
                    result = 31 * result + this.protectionDomain.hashCode();
                    result = 31 * result + ExecutingTransformer.this.hashCode();
                    result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.ExecutingTransformer.Java9CapableVmDispatcher{outer=" + ExecutingTransformer.this + ", rawModule=" + this.rawModule + ", classLoader=" + this.classLoader + ", internalTypeName='" + this.internalTypeName + '\'' + ", classBeingRedefined=" + this.classBeingRedefined + ", protectionDomain=" + this.protectionDomain + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
                }
            }

            protected class LegacyVmDispatcher
            implements PrivilegedAction<byte[]> {
                private final ClassLoader classLoader;
                private final String internalTypeName;
                private final Class<?> classBeingRedefined;
                private final ProtectionDomain protectionDomain;
                private final byte[] binaryRepresentation;

                protected LegacyVmDispatcher(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                    this.classLoader = classLoader;
                    this.internalTypeName = internalTypeName;
                    this.classBeingRedefined = classBeingRedefined;
                    this.protectionDomain = protectionDomain;
                    this.binaryRepresentation = binaryRepresentation;
                }

                @Override
                public byte[] run() {
                    return ExecutingTransformer.this.transform(JavaModule.UNSUPPORTED, this.classLoader, this.internalTypeName, this.classBeingRedefined, this.protectionDomain, this.binaryRepresentation);
                }

                private ExecutingTransformer getOuter() {
                    return ExecutingTransformer.this;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    LegacyVmDispatcher that = (LegacyVmDispatcher)object;
                    return (this.classLoader != null ? this.classLoader.equals(that.classLoader) : that.classLoader == null) && (this.internalTypeName != null ? this.internalTypeName.equals(that.internalTypeName) : that.internalTypeName == null) && (this.classBeingRedefined != null ? this.classBeingRedefined.equals(that.classBeingRedefined) : that.classBeingRedefined == null) && this.protectionDomain.equals(that.protectionDomain) && ExecutingTransformer.this.equals(that.getOuter()) && Arrays.equals(this.binaryRepresentation, that.binaryRepresentation);
                }

                public int hashCode() {
                    int result = this.classLoader != null ? this.classLoader.hashCode() : 0;
                    result = 31 * result + (this.internalTypeName != null ? this.internalTypeName.hashCode() : 0);
                    result = 31 * result + (this.classBeingRedefined != null ? this.classBeingRedefined.hashCode() : 0);
                    result = 31 * result + this.protectionDomain.hashCode();
                    result = 31 * result + ExecutingTransformer.this.hashCode();
                    result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.ExecutingTransformer.LegacyVmDispatcher{outer=" + ExecutingTransformer.this + ", classLoader=" + this.classLoader + ", internalTypeName='" + this.internalTypeName + '\'' + ", classBeingRedefined=" + this.classBeingRedefined + ", protectionDomain=" + this.protectionDomain + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
                }
            }

            protected static interface Factory {
                public ResettableClassFileTransformer make(ByteBuddy var1, Listener var2, PoolStrategy var3, TypeStrategy var4, LocationStrategy var5, NativeMethodStrategy var6, InitializationStrategy var7, BootstrapInjectionStrategy var8, LambdaInstrumentationStrategy var9, DescriptionStrategy var10, FallbackStrategy var11, RawMatcher var12, Transformation var13, CircularityLock var14);

                public static enum ForLegacyVm implements Factory
                {
                    INSTANCE;


                    @Override
                    public ResettableClassFileTransformer make(ByteBuddy byteBuddy, Listener listener, PoolStrategy poolStrategy, TypeStrategy typeStrategy, LocationStrategy locationStrategy, NativeMethodStrategy nativeMethodStrategy, InitializationStrategy initializationStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, LambdaInstrumentationStrategy lambdaInstrumentationStrategy, DescriptionStrategy descriptionStrategy, FallbackStrategy fallbackStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation, CircularityLock circularityLock) {
                        return new ExecutingTransformer(byteBuddy, listener, poolStrategy, typeStrategy, locationStrategy, nativeMethodStrategy, initializationStrategy, bootstrapInjectionStrategy, lambdaInstrumentationStrategy, descriptionStrategy, fallbackStrategy, ignoredTypeMatcher, transformation, circularityLock);
                    }

                    public String toString() {
                        return "AgentBuilder.Default.ExecutingTransformer.Factory.ForLegacyVm." + this.name();
                    }
                }

                public static class ForJava9CapableVm
                implements Factory {
                    private final Constructor<? extends ResettableClassFileTransformer> executingTransformer;

                    protected ForJava9CapableVm(Constructor<? extends ResettableClassFileTransformer> executingTransformer) {
                        this.executingTransformer = executingTransformer;
                    }

                    @Override
                    public ResettableClassFileTransformer make(ByteBuddy byteBuddy, Listener listener, PoolStrategy poolStrategy, TypeStrategy typeStrategy, LocationStrategy locationStrategy, NativeMethodStrategy nativeMethodStrategy, InitializationStrategy initializationStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, LambdaInstrumentationStrategy lambdaInstrumentationStrategy, DescriptionStrategy descriptionStrategy, FallbackStrategy fallbackStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation, CircularityLock circularityLock) {
                        try {
                            return this.executingTransformer.newInstance(new Object[]{byteBuddy, listener, poolStrategy, typeStrategy, locationStrategy, nativeMethodStrategy, initializationStrategy, bootstrapInjectionStrategy, lambdaInstrumentationStrategy, descriptionStrategy, fallbackStrategy, ignoredTypeMatcher, transformation, circularityLock});
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access " + this.executingTransformer, exception);
                        }
                        catch (InstantiationException exception) {
                            throw new IllegalStateException("Cannot instantiate " + this.executingTransformer.getDeclaringClass(), exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Cannot invoke " + this.executingTransformer, exception.getCause());
                        }
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForJava9CapableVm that = (ForJava9CapableVm)object;
                        return this.executingTransformer.equals(that.executingTransformer);
                    }

                    public int hashCode() {
                        return this.executingTransformer.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.Default.ExecutingTransformer.Factory.ForJava9CapableVm{executingTransformer=" + this.executingTransformer + '}';
                    }
                }

                public static enum CreationAction implements PrivilegedAction<Factory>
                {
                    INSTANCE;


                    @Override
                    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                    public Factory run() {
                        try {
                            return new ForJava9CapableVm(new ByteBuddy().subclass(ExecutingTransformer.class).name(ExecutingTransformer.class.getName() + "$ByteBuddy$ModuleSupport").method(ElementMatchers.named("transform").and(ElementMatchers.takesArgument(0, JavaType.MODULE.load()))).intercept(MethodCall.invoke(ExecutingTransformer.class.getMethod("transform", Object.class, ClassLoader.class, String.class, Class.class, ProtectionDomain.class, byte[].class)).onSuper().withAllArguments()).make().load(ExecutingTransformer.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER_PERSISTENT.with(ExecutingTransformer.class.getProtectionDomain())).getLoaded().getDeclaredConstructor(ByteBuddy.class, Listener.class, PoolStrategy.class, TypeStrategy.class, LocationStrategy.class, NativeMethodStrategy.class, InitializationStrategy.class, BootstrapInjectionStrategy.class, LambdaInstrumentationStrategy.class, DescriptionStrategy.class, FallbackStrategy.class, RawMatcher.class, Transformation.class, CircularityLock.class));
                        }
                        catch (Exception ignored) {
                            return ForLegacyVm.INSTANCE;
                        }
                    }

                    public String toString() {
                        return "AgentBuilder.Default.ExecutingTransformer.Factory.CreationAction." + this.name();
                    }
                }
            }
        }

        protected static interface Transformation
        extends RawMatcher {
            public Resolution resolve(TypeDescription var1, ClassLoader var2, JavaModule var3, Class<?> var4, ProtectionDomain var5, TypePool var6);

            public static class Compound
            implements Transformation {
                private final List<Transformation> transformations = new ArrayList<Transformation>();

                protected Compound(Transformation ... transformation) {
                    this(Arrays.asList(transformation));
                }

                protected Compound(List<? extends Transformation> transformations) {
                    for (Transformation transformation : transformations) {
                        if (transformation instanceof Compound) {
                            this.transformations.addAll(((Compound)transformation).transformations);
                            continue;
                        }
                        if (transformation instanceof Ignored) continue;
                        this.transformations.add(transformation);
                    }
                }

                @Override
                public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                    for (Transformation transformation : this.transformations) {
                        if (!transformation.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, TypePool typePool) {
                    Resolution current = new Resolution.Unresolved(typeDescription, classLoader, module);
                    block5: for (Transformation transformation : this.transformations) {
                        Resolution resolution = transformation.resolve(typeDescription, classLoader, module, classBeingRedefined, protectionDomain, typePool);
                        switch (resolution.getSort()) {
                            case TERMINAL: {
                                return current.asDecoratorOf(resolution);
                            }
                            case DECORATOR: {
                                current = current.asDecoratorOf(resolution);
                                continue block5;
                            }
                            case UNDEFINED: {
                                continue block5;
                            }
                        }
                        throw new IllegalStateException("Unexpected resolution type: " + (Object)((Object)resolution.getSort()));
                    }
                    return current;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.transformations.equals(((Compound)other).transformations);
                }

                public int hashCode() {
                    return this.transformations.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Compound{transformations=" + this.transformations + '}';
                }
            }

            public static class Simple
            implements Transformation {
                private final RawMatcher rawMatcher;
                private final Transformer transformer;
                private final boolean decorator;

                protected Simple(RawMatcher rawMatcher, Transformer transformer, boolean decorator) {
                    this.rawMatcher = rawMatcher;
                    this.transformer = transformer;
                    this.decorator = decorator;
                }

                @Override
                public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                    return this.rawMatcher.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain);
                }

                @Override
                public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, TypePool typePool) {
                    return this.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) ? new Resolution(typeDescription, classLoader, module, protectionDomain, typePool, this.transformer, this.decorator) : new Resolution.Unresolved(typeDescription, classLoader, module);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.decorator == ((Simple)other).decorator && this.rawMatcher.equals(((Simple)other).rawMatcher) && this.transformer.equals(((Simple)other).transformer);
                }

                public int hashCode() {
                    int result = this.rawMatcher.hashCode();
                    result = 31 * result + (this.decorator ? 1 : 0);
                    result = 31 * result + this.transformer.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Simple{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + ", decorator=" + this.decorator + '}';
                }

                protected static class Resolution
                implements Resolution.Decoratable {
                    private final TypeDescription typeDescription;
                    private final ClassLoader classLoader;
                    private final JavaModule module;
                    private final ProtectionDomain protectionDomain;
                    private final TypePool typePool;
                    private final Transformer transformer;
                    private final boolean decorator;

                    protected Resolution(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, ProtectionDomain protectionDomain, TypePool typePool, Transformer transformer, boolean decorator) {
                        this.typeDescription = typeDescription;
                        this.classLoader = classLoader;
                        this.module = module;
                        this.protectionDomain = protectionDomain;
                        this.typePool = typePool;
                        this.transformer = transformer;
                        this.decorator = decorator;
                    }

                    @Override
                    public Resolution.Sort getSort() {
                        return this.decorator ? Resolution.Sort.DECORATOR : Resolution.Sort.TERMINAL;
                    }

                    @Override
                    public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution asDecoratorOf(net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution resolution) {
                        return resolution.prepend(this);
                    }

                    @Override
                    public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution prepend(Resolution.Decoratable resolution) {
                        return resolution.append(this.transformer);
                    }

                    @Override
                    public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution append(Transformer transformer) {
                        return new Resolution(this.typeDescription, this.classLoader, this.module, this.protectionDomain, this.typePool, new Transformer.Compound(this.transformer, transformer), this.decorator);
                    }

                    @Override
                    public byte[] apply(InitializationStrategy initializationStrategy, ClassFileLocator classFileLocator, TypeStrategy typeStrategy, ByteBuddy byteBuddy, NativeMethodStrategy methodNameTransformer, BootstrapInjectionStrategy bootstrapInjectionStrategy, AccessControlContext accessControlContext, Listener listener) {
                        InitializationStrategy.Dispatcher dispatcher = initializationStrategy.dispatcher();
                        DynamicType.Unloaded<?> dynamicType = dispatcher.apply(this.transformer.transform(typeStrategy.builder(this.typeDescription, byteBuddy, classFileLocator, methodNameTransformer.resolve()), this.typeDescription, this.classLoader)).make(TypeResolutionStrategy.Disabled.INSTANCE, this.typePool);
                        dispatcher.register(dynamicType, this.classLoader, new BootstrapClassLoaderCapableInjectorFactory(bootstrapInjectionStrategy, this.classLoader, this.protectionDomain));
                        listener.onTransformation(this.typeDescription, this.classLoader, this.module, dynamicType);
                        return dynamicType.getBytes();
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null) return false;
                        if (this.getClass() != other.getClass()) {
                            return false;
                        }
                        Resolution that = (Resolution)other;
                        if (!this.typeDescription.equals(that.typeDescription)) return false;
                        if (this.decorator != that.decorator) return false;
                        if (this.classLoader != null) {
                            if (!this.classLoader.equals(that.classLoader)) {
                                return false;
                            }
                        } else if (that.classLoader != null) return false;
                        if (this.module != null) {
                            if (!this.module.equals(that.module)) {
                                return false;
                            }
                        } else if (that.module != null) return false;
                        if (this.protectionDomain != null) {
                            if (!this.protectionDomain.equals(that.protectionDomain)) {
                                return false;
                            }
                        } else if (that.protectionDomain != null) return false;
                        if (!this.typePool.equals(that.typePool)) return false;
                        if (!this.transformer.equals(that.transformer)) return false;
                        return true;
                    }

                    public int hashCode() {
                        int result = this.typeDescription.hashCode();
                        result = 31 * result + (this.decorator ? 1 : 0);
                        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
                        result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
                        result = 31 * result + this.transformer.hashCode();
                        result = 31 * result + this.typePool.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Simple.Resolution{typeDescription=" + this.typeDescription + ", classLoader=" + this.classLoader + ", module=" + this.module + ", protectionDomain=" + this.protectionDomain + ", typePool=" + this.typePool + ", transformer=" + this.transformer + ", decorator=" + this.decorator + '}';
                    }

                    protected static class BootstrapClassLoaderCapableInjectorFactory
                    implements InitializationStrategy.Dispatcher.InjectorFactory {
                        private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
                        private final ClassLoader classLoader;
                        private final ProtectionDomain protectionDomain;

                        protected BootstrapClassLoaderCapableInjectorFactory(BootstrapInjectionStrategy bootstrapInjectionStrategy, ClassLoader classLoader, ProtectionDomain protectionDomain) {
                            this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
                            this.classLoader = classLoader;
                            this.protectionDomain = protectionDomain;
                        }

                        @Override
                        public ClassInjector resolve() {
                            return this.classLoader == null ? this.bootstrapInjectionStrategy.make(this.protectionDomain) : new ClassInjector.UsingReflection(this.classLoader, this.protectionDomain);
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            BootstrapClassLoaderCapableInjectorFactory that = (BootstrapClassLoaderCapableInjectorFactory)other;
                            return this.bootstrapInjectionStrategy.equals(that.bootstrapInjectionStrategy) && !(this.classLoader == null ? that.classLoader != null : !this.classLoader.equals(that.classLoader)) && !(this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain));
                        }

                        public int hashCode() {
                            int result = this.bootstrapInjectionStrategy.hashCode();
                            result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
                            result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                            return result;
                        }

                        public String toString() {
                            return "AgentBuilder.Default.Transformation.Simple.Resolution.BootstrapClassLoaderCapableInjectorFactory{bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", classLoader=" + this.classLoader + ", protectionDomain=" + this.protectionDomain + '}';
                        }
                    }
                }
            }

            public static enum Ignored implements Transformation
            {
                INSTANCE;


                @Override
                public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                    return false;
                }

                @Override
                public Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, TypePool typePool) {
                    return new Resolution.Unresolved(typeDescription, classLoader, module);
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Ignored." + this.name();
                }
            }

            public static interface Resolution {
                public Sort getSort();

                public Resolution asDecoratorOf(Resolution var1);

                public Resolution prepend(Decoratable var1);

                public byte[] apply(InitializationStrategy var1, ClassFileLocator var2, TypeStrategy var3, ByteBuddy var4, NativeMethodStrategy var5, BootstrapInjectionStrategy var6, AccessControlContext var7, Listener var8);

                public static class Unresolved
                implements Resolution {
                    private final TypeDescription typeDescription;
                    private final ClassLoader classLoader;
                    private final JavaModule module;

                    protected Unresolved(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                        this.typeDescription = typeDescription;
                        this.classLoader = classLoader;
                        this.module = module;
                    }

                    @Override
                    public Sort getSort() {
                        return Sort.UNDEFINED;
                    }

                    @Override
                    public Resolution asDecoratorOf(Resolution resolution) {
                        return resolution;
                    }

                    @Override
                    public Resolution prepend(Decoratable resolution) {
                        return resolution;
                    }

                    @Override
                    public byte[] apply(InitializationStrategy initializationStrategy, ClassFileLocator classFileLocator, TypeStrategy typeStrategy, ByteBuddy byteBuddy, NativeMethodStrategy methodNameTransformer, BootstrapInjectionStrategy bootstrapInjectionStrategy, AccessControlContext accessControlContext, Listener listener) {
                        listener.onIgnored(this.typeDescription, this.classLoader, this.module);
                        return NO_TRANSFORMATION;
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        Unresolved that = (Unresolved)object;
                        return this.typeDescription.equals(that.typeDescription) && (this.classLoader != null ? this.classLoader.equals(that.classLoader) : that.classLoader == null) && (this.module != null ? this.module.equals(that.module) : that.module == null);
                    }

                    public int hashCode() {
                        int result = this.typeDescription.hashCode();
                        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Resolution.Unresolved{typeDescription=" + this.typeDescription + ", classLoader=" + this.classLoader + ", module=" + this.module + '}';
                    }
                }

                public static interface Decoratable
                extends Resolution {
                    public Resolution append(Transformer var1);
                }

                public static enum Sort {
                    TERMINAL(true),
                    DECORATOR(true),
                    UNDEFINED(false);

                    private final boolean alive;

                    private Sort(boolean alive) {
                        this.alive = alive;
                    }

                    protected boolean isAlive() {
                        return this.alive;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Resolution.Sort." + this.name();
                    }
                }
            }
        }

        protected static interface NativeMethodStrategy {
            public boolean isEnabled(Instrumentation var1);

            public MethodNameTransformer resolve();

            public String getPrefix();

            public static class ForPrefix
            implements NativeMethodStrategy {
                private final String prefix;

                protected ForPrefix(String prefix) {
                    this.prefix = prefix;
                }

                protected static NativeMethodStrategy of(String prefix) {
                    if (prefix.length() == 0) {
                        throw new IllegalArgumentException("A method name prefix must not be the empty string");
                    }
                    return new ForPrefix(prefix);
                }

                @Override
                public MethodNameTransformer resolve() {
                    return new MethodNameTransformer.Prefixing(this.prefix);
                }

                @Override
                public boolean isEnabled(Instrumentation instrumentation) {
                    if (!instrumentation.isNativeMethodPrefixSupported()) {
                        throw new IllegalArgumentException("A prefix for native methods is not supported: " + instrumentation);
                    }
                    return true;
                }

                @Override
                public String getPrefix() {
                    return this.prefix;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((ForPrefix)other).prefix);
                }

                public int hashCode() {
                    return this.prefix.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.NativeMethodStrategy.ForPrefix{prefix='" + this.prefix + '\'' + '}';
                }
            }

            public static enum Disabled implements NativeMethodStrategy
            {
                INSTANCE;


                @Override
                public MethodNameTransformer resolve() {
                    return MethodNameTransformer.Suffixing.withRandomSuffix();
                }

                @Override
                public boolean isEnabled(Instrumentation instrumentation) {
                    return false;
                }

                @Override
                public String getPrefix() {
                    throw new IllegalStateException("A disabled native method strategy does not define a method name prefix");
                }

                public String toString() {
                    return "AgentBuilder.Default.NativeMethodStrategy.Disabled." + this.name();
                }
            }
        }

        protected static interface BootstrapInjectionStrategy {
            public ClassInjector make(ProtectionDomain var1);

            public static class Enabled
            implements BootstrapInjectionStrategy {
                private final File folder;
                private final Instrumentation instrumentation;

                public Enabled(File folder, Instrumentation instrumentation) {
                    this.folder = folder;
                    this.instrumentation = instrumentation;
                }

                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Enabled enabled = (Enabled)other;
                    return this.folder.equals(enabled.folder) && this.instrumentation.equals(enabled.instrumentation);
                }

                public int hashCode() {
                    int result = this.folder.hashCode();
                    result = 31 * result + this.instrumentation.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Enabled{folder=" + this.folder + ", instrumentation=" + this.instrumentation + '}';
                }
            }

            public static enum Disabled implements BootstrapInjectionStrategy
            {
                INSTANCE;


                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    throw new IllegalStateException("Injecting classes into the bootstrap class loader was not enabled");
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Disabled." + this.name();
                }
            }
        }
    }

    public static enum LambdaInstrumentationStrategy {
        ENABLED{

            @Override
            protected void apply(ByteBuddy byteBuddy, Instrumentation instrumentation, ClassFileTransformer classFileTransformer) {
                if (LambdaFactory.register(classFileTransformer, new LambdaInstanceFactory(byteBuddy), LambdaInjector.INSTANCE)) {
                    Class<?> lambdaMetaFactory;
                    try {
                        lambdaMetaFactory = Class.forName("java.lang.invoke.LambdaMetafactory");
                    }
                    catch (ClassNotFoundException ignored) {
                        return;
                    }
                    byteBuddy.with(Implementation.Context.Disabled.Factory.INSTANCE).redefine(lambdaMetaFactory).visit(new AsmVisitorWrapper.ForDeclaredMethods().method(ElementMatchers.named("metafactory"), MetaFactoryRedirection.INSTANCE).method(ElementMatchers.named("altMetafactory"), AlternativeMetaFactoryRedirection.INSTANCE)).make().load(lambdaMetaFactory.getClassLoader(), ClassReloadingStrategy.of(instrumentation));
                }
            }

            @Override
            protected boolean isInstrumented(Class<?> type) {
                return true;
            }
        }
        ,
        DISABLED{

            @Override
            protected void apply(ByteBuddy byteBuddy, Instrumentation instrumentation, ClassFileTransformer classFileTransformer) {
            }

            @Override
            protected boolean isInstrumented(Class<?> type) {
                return type == null || !type.getName().contains("/");
            }
        };

        private static final String UNSAFE_CLASS;
        protected static final MethodVisitor IGNORE_ORIGINAL;

        public static void release(ClassFileTransformer classFileTransformer, Instrumentation instrumentation) {
            if (LambdaFactory.release(classFileTransformer)) {
                try {
                    ClassReloadingStrategy.of(instrumentation).reset(Class.forName("java.lang.invoke.LambdaMetafactory"));
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Could not release lambda transformer", exception);
                }
            }
        }

        public static LambdaInstrumentationStrategy of(boolean enabled) {
            return enabled ? ENABLED : DISABLED;
        }

        protected abstract void apply(ByteBuddy var1, Instrumentation var2, ClassFileTransformer var3);

        public boolean isEnabled() {
            return this == ENABLED;
        }

        protected abstract boolean isInstrumented(Class<?> var1);

        public String toString() {
            return "AgentBuilder.LambdaInstrumentationStrategy." + this.name();
        }

        static {
            UNSAFE_CLASS = ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V6).isAtLeast(ClassFileVersion.JAVA_V9) ? "jdk/internal/misc/Unsafe" : "sun/misc/Unsafe";
            IGNORE_ORIGINAL = null;
        }

        protected static enum AlternativeMetaFactoryRedirection implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper
        {
            INSTANCE;


            @Override
            public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(6);
                methodVisitor.visitInsn(50);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                methodVisitor.visitVarInsn(54, 4);
                methodVisitor.visitInsn(7);
                methodVisitor.visitVarInsn(54, 5);
                methodVisitor.visitVarInsn(21, 4);
                methodVisitor.visitInsn(5);
                methodVisitor.visitInsn(126);
                Label markerInterfaceLoop = new Label();
                methodVisitor.visitJumpInsn(153, markerInterfaceLoop);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitIincInsn(5, 1);
                methodVisitor.visitInsn(50);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                methodVisitor.visitVarInsn(54, 7);
                methodVisitor.visitVarInsn(21, 7);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitVarInsn(58, 6);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(21, 7);
                methodVisitor.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitVarInsn(21, 7);
                methodVisitor.visitInsn(96);
                methodVisitor.visitVarInsn(54, 5);
                Label markerInterfaceExit = new Label();
                methodVisitor.visitJumpInsn(167, markerInterfaceExit);
                methodVisitor.visitLabel(markerInterfaceLoop);
                methodVisitor.visitFrame(1, 2, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER}, 0, null);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitVarInsn(58, 6);
                methodVisitor.visitLabel(markerInterfaceExit);
                methodVisitor.visitFrame(1, 1, new Object[]{"[Ljava/lang/Class;"}, 0, null);
                methodVisitor.visitVarInsn(21, 4);
                methodVisitor.visitInsn(7);
                methodVisitor.visitInsn(126);
                Label additionalBridgesLoop = new Label();
                methodVisitor.visitJumpInsn(153, additionalBridgesLoop);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitIincInsn(5, 1);
                methodVisitor.visitInsn(50);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                methodVisitor.visitVarInsn(54, 8);
                methodVisitor.visitVarInsn(21, 8);
                methodVisitor.visitTypeInsn(189, "java/lang/invoke/MethodType");
                methodVisitor.visitVarInsn(58, 7);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(21, 8);
                methodVisitor.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
                Label additionalBridgesExit = new Label();
                methodVisitor.visitJumpInsn(167, additionalBridgesExit);
                methodVisitor.visitLabel(additionalBridgesLoop);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/invoke/MethodType");
                methodVisitor.visitVarInsn(58, 7);
                methodVisitor.visitLabel(additionalBridgesExit);
                methodVisitor.visitFrame(1, 1, new Object[]{"[Ljava/lang/invoke/MethodType;"}, 0, null);
                methodVisitor.visitMethodInsn(184, UNSAFE_CLASS, "getUnsafe", "()L" + UNSAFE_CLASS + ";", false);
                methodVisitor.visitVarInsn(58, 8);
                methodVisitor.visitVarInsn(25, 8);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "lookupClass", "()Ljava/lang/Class;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
                methodVisitor.visitLdcInsn("net.bytebuddy.agent.builder.LambdaFactory");
                methodVisitor.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                methodVisitor.visitLdcInsn("make");
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/String;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
                methodVisitor.visitInsn(1);
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(4);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(5);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitVarInsn(21, 4);
                methodVisitor.visitInsn(4);
                methodVisitor.visitInsn(126);
                Label callSiteConditional = new Label();
                methodVisitor.visitJumpInsn(153, callSiteConditional);
                methodVisitor.visitInsn(4);
                Label callSiteAlternative = new Label();
                methodVisitor.visitJumpInsn(167, callSiteAlternative);
                methodVisitor.visitLabel(callSiteConditional);
                methodVisitor.visitFrame(0, 9, new Object[]{"java/lang/invoke/MethodHandles$Lookup", "java/lang/String", "java/lang/invoke/MethodType", "[Ljava/lang/Object;", Opcodes.INTEGER, Opcodes.INTEGER, "[Ljava/lang/Class;", "[Ljava/lang/invoke/MethodType;", UNSAFE_CLASS}, 7, new Object[]{UNSAFE_CLASS, "java/lang/Class", "java/lang/reflect/Method", Opcodes.NULL, "[Ljava/lang/Object;", "[Ljava/lang/Object;", Opcodes.INTEGER});
                methodVisitor.visitInsn(3);
                methodVisitor.visitLabel(callSiteAlternative);
                methodVisitor.visitFrame(0, 9, new Object[]{"java/lang/invoke/MethodHandles$Lookup", "java/lang/String", "java/lang/invoke/MethodType", "[Ljava/lang/Object;", Opcodes.INTEGER, Opcodes.INTEGER, "[Ljava/lang/Class;", "[Ljava/lang/invoke/MethodType;", UNSAFE_CLASS}, 8, new Object[]{UNSAFE_CLASS, "java/lang/Class", "java/lang/reflect/Method", Opcodes.NULL, "[Ljava/lang/Object;", "[Ljava/lang/Object;", Opcodes.INTEGER, Opcodes.INTEGER});
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitTypeInsn(192, "[B");
                methodVisitor.visitInsn(1);
                methodVisitor.visitMethodInsn(182, UNSAFE_CLASS, "defineAnonymousClass", "(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(58, 9);
                methodVisitor.visitVarInsn(25, 8);
                methodVisitor.visitVarInsn(25, 9);
                methodVisitor.visitMethodInsn(182, UNSAFE_CLASS, "ensureClassInitialized", "(Ljava/lang/Class;)V", false);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "parameterCount", "()I", false);
                Label callSiteJump = new Label();
                methodVisitor.visitJumpInsn(154, callSiteJump);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "returnType", "()Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(25, 9);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", false);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "constant", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                Label callSiteExit = new Label();
                methodVisitor.visitJumpInsn(167, callSiteExit);
                methodVisitor.visitLabel(callSiteJump);
                methodVisitor.visitFrame(1, 1, new Object[]{"java/lang/Class"}, 0, null);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitFieldInsn(178, "java/lang/invoke/MethodHandles$Lookup", "IMPL_LOOKUP", "Ljava/lang/invoke/MethodHandles$Lookup;");
                methodVisitor.visitVarInsn(25, 9);
                methodVisitor.visitLdcInsn("get$Lambda");
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                methodVisitor.visitLabel(callSiteExit);
                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/invoke/CallSite"});
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(9, 10);
                methodVisitor.visitEnd();
                return IGNORE_ORIGINAL;
            }

            public String toString() {
                return "AgentBuilder.LambdaInstrumentationStrategy.AlternativeMetaFactoryRedirection." + this.name();
            }
        }

        protected static enum MetaFactoryRedirection implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper
        {
            INSTANCE;


            @Override
            public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
                methodVisitor.visitCode();
                methodVisitor.visitMethodInsn(184, UNSAFE_CLASS, "getUnsafe", "()L" + UNSAFE_CLASS + ";", false);
                methodVisitor.visitVarInsn(58, 6);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "lookupClass", "()Ljava/lang/Class;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
                methodVisitor.visitLdcInsn("net.bytebuddy.agent.builder.LambdaFactory");
                methodVisitor.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                methodVisitor.visitLdcInsn("make");
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/String;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
                methodVisitor.visitInsn(1);
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitVarInsn(25, 5);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitInsn(3);
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitTypeInsn(192, "[B");
                methodVisitor.visitInsn(1);
                methodVisitor.visitMethodInsn(182, UNSAFE_CLASS, "defineAnonymousClass", "(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(58, 7);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitMethodInsn(182, UNSAFE_CLASS, "ensureClassInitialized", "(Ljava/lang/Class;)V", false);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "parameterCount", "()I", false);
                Label conditionalDefault = new Label();
                methodVisitor.visitJumpInsn(154, conditionalDefault);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "returnType", "()Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", false);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "constant", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                Label conditionalAlternative = new Label();
                methodVisitor.visitJumpInsn(167, conditionalAlternative);
                methodVisitor.visitLabel(conditionalDefault);
                methodVisitor.visitFrame(1, 2, new Object[]{UNSAFE_CLASS, "java/lang/Class"}, 0, null);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitFieldInsn(178, "java/lang/invoke/MethodHandles$Lookup", "IMPL_LOOKUP", "Ljava/lang/invoke/MethodHandles$Lookup;");
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitLdcInsn("get$Lambda");
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                methodVisitor.visitLabel(conditionalAlternative);
                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/invoke/CallSite"});
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(8, 8);
                methodVisitor.visitEnd();
                return IGNORE_ORIGINAL;
            }

            public String toString() {
                return "AgentBuilder.LambdaInstrumentationStrategy.MetaFactoryRedirection." + this.name();
            }
        }

        protected static class LambdaInstanceFactory {
            private static final String LAMBDA_FACTORY = "get$Lambda";
            private static final String FIELD_PREFIX = "arg$";
            private static final String LAMBDA_TYPE_INFIX = "$$Lambda$ByteBuddy$";
            private static final Class<?> NOT_PREVIOUSLY_DEFINED = null;
            private static final AtomicInteger LAMBDA_NAME_COUNTER = new AtomicInteger();
            private final ByteBuddy byteBuddy;

            protected LambdaInstanceFactory(ByteBuddy byteBuddy) {
                this.byteBuddy = byteBuddy;
            }

            public byte[] make(Object targetTypeLookup, String lambdaMethodName, Object factoryMethodType, Object lambdaMethodType, Object targetMethodHandle, Object specializedLambdaMethodType, boolean serializable, List<Class<?>> markerInterfaces, List<?> additionalBridges, Collection<? extends ClassFileTransformer> classFileTransformers) {
                JavaConstant.MethodType factoryMethod = JavaConstant.MethodType.ofLoaded(factoryMethodType);
                JavaConstant.MethodType lambdaMethod = JavaConstant.MethodType.ofLoaded(lambdaMethodType);
                JavaConstant.MethodHandle targetMethod = JavaConstant.MethodHandle.ofLoaded(targetMethodHandle, targetTypeLookup);
                JavaConstant.MethodType specializedLambdaMethod = JavaConstant.MethodType.ofLoaded(specializedLambdaMethodType);
                Class<?> targetType = JavaConstant.MethodHandle.lookupType(targetTypeLookup);
                String lambdaClassName = targetType.getName() + LAMBDA_TYPE_INFIX + LAMBDA_NAME_COUNTER.incrementAndGet();
                DynamicType.Builder<Object> builder = this.byteBuddy.subclass(factoryMethod.getReturnType(), (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).modifiers(TypeManifestation.FINAL, Visibility.PUBLIC).implement(markerInterfaces).name(lambdaClassName).defineConstructor(Visibility.PUBLIC).withParameters(factoryMethod.getParameterTypes()).intercept(ConstructorImplementation.INSTANCE).method(ElementMatchers.named(lambdaMethodName).and(ElementMatchers.takesArguments(lambdaMethod.getParameterTypes())).and(ElementMatchers.returns(lambdaMethod.getReturnType()))).intercept(new LambdaMethodImplementation(targetMethod, specializedLambdaMethod));
                int index = 0;
                for (TypeDescription capturedType : factoryMethod.getParameterTypes()) {
                    builder = builder.defineField(FIELD_PREFIX + ++index, (TypeDefinition)capturedType, Visibility.PRIVATE, FieldManifestation.FINAL);
                }
                if (!factoryMethod.getParameterTypes().isEmpty()) {
                    builder = builder.defineMethod(LAMBDA_FACTORY, (TypeDefinition)factoryMethod.getReturnType(), Visibility.PRIVATE, Ownership.STATIC).withParameters(factoryMethod.getParameterTypes()).intercept(FactoryImplementation.INSTANCE);
                }
                if (serializable) {
                    if (!markerInterfaces.contains(Serializable.class)) {
                        builder = builder.implement(new java.lang.reflect.Type[]{Serializable.class});
                    }
                    builder = builder.defineMethod("writeReplace", (java.lang.reflect.Type)((Object)Object.class), Visibility.PRIVATE).intercept(new SerializationImplementation(new TypeDescription.ForLoadedType(targetType), factoryMethod.getReturnType(), lambdaMethodName, lambdaMethod, targetMethod, JavaConstant.MethodType.ofLoaded(specializedLambdaMethodType)));
                } else if (factoryMethod.getReturnType().isAssignableTo(Serializable.class)) {
                    builder = builder.defineMethod("readObject", Void.TYPE, Visibility.PRIVATE).withParameters(new java.lang.reflect.Type[]{ObjectInputStream.class}).throwing(new java.lang.reflect.Type[]{NotSerializableException.class}).intercept(ExceptionMethod.throwing(NotSerializableException.class, "Non-serializable lambda")).defineMethod("writeObject", Void.TYPE, Visibility.PRIVATE).withParameters(new java.lang.reflect.Type[]{ObjectOutputStream.class}).throwing(new java.lang.reflect.Type[]{NotSerializableException.class}).intercept(ExceptionMethod.throwing(NotSerializableException.class, "Non-serializable lambda"));
                }
                for (Object additionalBridgeType : additionalBridges) {
                    JavaConstant.MethodType methodType = JavaConstant.MethodType.ofLoaded(additionalBridgeType);
                    builder = builder.defineMethod(lambdaMethodName, (TypeDefinition)methodType.getReturnType(), MethodManifestation.BRIDGE, Visibility.PUBLIC).withParameters(methodType.getParameterTypes()).intercept(new BridgeMethodImplementation(lambdaMethodName, lambdaMethod));
                }
                byte[] classFile = builder.make().getBytes();
                for (ClassFileTransformer classFileTransformer : classFileTransformers) {
                    try {
                        byte[] transformedClassFile = classFileTransformer.transform(targetType.getClassLoader(), lambdaClassName.replace('.', '/'), NOT_PREVIOUSLY_DEFINED, targetType.getProtectionDomain(), classFile);
                        classFile = transformedClassFile == null ? classFile : transformedClassFile;
                    }
                    catch (Throwable throwable) {}
                }
                return classFile;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.byteBuddy.equals(((LambdaInstanceFactory)other).byteBuddy);
            }

            public int hashCode() {
                return this.byteBuddy.hashCode();
            }

            public String toString() {
                return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory{byteBuddy=" + this.byteBuddy + '}';
            }

            protected static class BridgeMethodImplementation
            implements Implementation {
                private final String lambdaMethodName;
                private final JavaConstant.MethodType lambdaMethod;

                protected BridgeMethodImplementation(String lambdaMethodName, JavaConstant.MethodType lambdaMethod) {
                    this.lambdaMethodName = lambdaMethodName;
                    this.lambdaMethod = lambdaMethod;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.invokeSuper(new MethodDescription.SignatureToken(this.lambdaMethodName, this.lambdaMethod.getReturnType(), this.lambdaMethod.getParameterTypes())));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    BridgeMethodImplementation that = (BridgeMethodImplementation)other;
                    return this.lambdaMethodName.equals(that.lambdaMethodName) && this.lambdaMethod.equals(that.lambdaMethod);
                }

                public int hashCode() {
                    int result = this.lambdaMethodName.hashCode();
                    result = 31 * result + this.lambdaMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.BridgeMethodImplementation{lambdaMethodName='" + this.lambdaMethodName + '\'' + ", lambdaMethod=" + this.lambdaMethod + '}';
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final Implementation.SpecialMethodInvocation bridgeTargetInvocation;

                    protected Appender(Implementation.SpecialMethodInvocation bridgeTargetInvocation) {
                        this.bridgeTargetInvocation = bridgeTargetInvocation;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        return new ByteCodeAppender.Compound(new ByteCodeAppender.Simple(MethodVariableAccess.allArgumentsOf(instrumentedMethod).asBridgeOf(this.bridgeTargetInvocation.getMethodDescription()).prependThisReference(), this.bridgeTargetInvocation, this.bridgeTargetInvocation.getMethodDescription().getReturnType().asErasure().isAssignableTo(instrumentedMethod.getReturnType().asErasure()) ? StackManipulation.Trivial.INSTANCE : TypeCasting.to(instrumentedMethod.getReceiverType()), MethodReturn.of(instrumentedMethod.getReturnType()))).apply(methodVisitor, implementationContext, instrumentedMethod);
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.bridgeTargetInvocation.equals(((Appender)other).bridgeTargetInvocation);
                    }

                    public int hashCode() {
                        return this.bridgeTargetInvocation.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.BridgeMethodImplementation.Appender{bridgeTargetInvocation=" + this.bridgeTargetInvocation + '}';
                    }
                }
            }

            protected static class SerializationImplementation
            implements Implementation {
                private final TypeDescription targetType;
                private final TypeDescription lambdaType;
                private final String lambdaMethodName;
                private final JavaConstant.MethodType lambdaMethod;
                private final JavaConstant.MethodHandle targetMethod;
                private final JavaConstant.MethodType specializedMethod;

                protected SerializationImplementation(TypeDescription targetType, TypeDescription lambdaType, String lambdaMethodName, JavaConstant.MethodType lambdaMethod, JavaConstant.MethodHandle targetMethod, JavaConstant.MethodType specializedMethod) {
                    this.targetType = targetType;
                    this.lambdaType = lambdaType;
                    this.lambdaMethodName = lambdaMethodName;
                    this.lambdaMethod = lambdaMethod;
                    this.targetMethod = targetMethod;
                    this.specializedMethod = specializedMethod;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    TypeDescription.ForLoadedType serializedLambda;
                    try {
                        serializedLambda = new TypeDescription.ForLoadedType(Class.forName("java.lang.invoke.SerializedLambda"));
                    }
                    catch (ClassNotFoundException exception) {
                        throw new IllegalStateException("Cannot find class for lambda serialization", exception);
                    }
                    ArrayList<StackManipulation.Compound> lambdaArguments = new ArrayList<StackManipulation.Compound>(implementationTarget.getInstrumentedType().getDeclaredFields().size());
                    for (FieldDescription.InDefinedShape fieldDescription : implementationTarget.getInstrumentedType().getDeclaredFields()) {
                        lambdaArguments.add(new StackManipulation.Compound(MethodVariableAccess.loadThis(), FieldAccess.forField(fieldDescription).read(), Assigner.DEFAULT.assign(fieldDescription.getType(), TypeDescription.Generic.OBJECT, Assigner.Typing.STATIC)));
                    }
                    return new ByteCodeAppender.Simple(new StackManipulation.Compound(TypeCreation.of(serializedLambda), Duplication.SINGLE, ClassConstant.of(this.targetType), new TextConstant(this.lambdaType.getInternalName()), new TextConstant(this.lambdaMethodName), new TextConstant(this.lambdaMethod.getDescriptor()), IntegerConstant.forValue(this.targetMethod.getHandleType().getIdentifier()), new TextConstant(this.targetMethod.getOwnerType().getInternalName()), new TextConstant(this.targetMethod.getName()), new TextConstant(this.targetMethod.getDescriptor()), new TextConstant(this.specializedMethod.getDescriptor()), ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(lambdaArguments), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)serializedLambda.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), MethodReturn.REFERENCE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    SerializationImplementation that = (SerializationImplementation)other;
                    return this.targetType.equals(that.targetType) && this.lambdaType.equals(that.lambdaType) && this.lambdaMethodName.equals(that.lambdaMethodName) && this.lambdaMethod.equals(that.lambdaMethod) && this.targetMethod.equals(that.targetMethod) && this.specializedMethod.equals(that.specializedMethod);
                }

                public int hashCode() {
                    int result = this.targetType.hashCode();
                    result = 31 * result + this.lambdaType.hashCode();
                    result = 31 * result + this.lambdaMethodName.hashCode();
                    result = 31 * result + this.lambdaMethod.hashCode();
                    result = 31 * result + this.targetMethod.hashCode();
                    result = 31 * result + this.specializedMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.SerializationImplementation{targetType=" + this.targetType + ", lambdaType=" + this.lambdaType + ", lambdaMethodName='" + this.lambdaMethodName + '\'' + ", lambdaMethod=" + this.lambdaMethod + ", targetMethod=" + this.targetMethod + ", specializedMethod=" + this.specializedMethod + '}';
                }
            }

            protected static class LambdaMethodImplementation
            implements Implementation {
                private final JavaConstant.MethodHandle targetMethod;
                private final JavaConstant.MethodType specializedLambdaMethod;

                protected LambdaMethodImplementation(JavaConstant.MethodHandle targetMethod, JavaConstant.MethodType specializedLambdaMethod) {
                    this.targetMethod = targetMethod;
                    this.specializedLambdaMethod = specializedLambdaMethod;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender((MethodDescription)((MethodList)this.targetMethod.getOwnerType().getDeclaredMethods().filter(ElementMatchers.named(this.targetMethod.getName()).and(ElementMatchers.returns(this.targetMethod.getReturnType())).and(ElementMatchers.takesArguments(this.targetMethod.getParameterTypes())))).getOnly(), this.specializedLambdaMethod, implementationTarget.getInstrumentedType().getDeclaredFields());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    LambdaMethodImplementation that = (LambdaMethodImplementation)other;
                    return this.targetMethod.equals(that.targetMethod) && this.specializedLambdaMethod.equals(that.specializedLambdaMethod);
                }

                public int hashCode() {
                    int result = this.targetMethod.hashCode();
                    result = 31 * result + this.specializedLambdaMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.LambdaMethodImplementation{targetMethod=" + this.targetMethod + ", specializedLambdaMethod=" + this.specializedLambdaMethod + '}';
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final MethodDescription targetMethod;
                    private final JavaConstant.MethodType specializedLambdaMethod;
                    private final List<FieldDescription.InDefinedShape> declaredFields;

                    protected Appender(MethodDescription targetMethod, JavaConstant.MethodType specializedLambdaMethod, List<FieldDescription.InDefinedShape> declaredFields) {
                        this.targetMethod = targetMethod;
                        this.specializedLambdaMethod = specializedLambdaMethod;
                        this.declaredFields = declaredFields;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        ArrayList<StackManipulation> fieldAccess = new ArrayList<StackManipulation>(this.declaredFields.size() * 2);
                        for (FieldDescription.InDefinedShape fieldDescription : this.declaredFields) {
                            fieldAccess.add(MethodVariableAccess.loadThis());
                            fieldAccess.add(FieldAccess.forField(fieldDescription).read());
                        }
                        ArrayList<StackManipulation> parameterAccess = new ArrayList<StackManipulation>(instrumentedMethod.getParameters().size() * 2);
                        for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                            parameterAccess.add(MethodVariableAccess.load(parameterDescription));
                            parameterAccess.add(Assigner.DEFAULT.assign(parameterDescription.getType(), ((TypeDescription)this.specializedLambdaMethod.getParameterTypes().get(parameterDescription.getIndex())).asGenericType(), Assigner.Typing.DYNAMIC));
                        }
                        return new ByteCodeAppender.Size(new StackManipulation.Compound(new StackManipulation.Compound(fieldAccess), new StackManipulation.Compound(parameterAccess), MethodInvocation.invoke(this.targetMethod), MethodReturn.of(this.targetMethod.getReturnType())).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Appender appender = (Appender)other;
                        return this.targetMethod.equals(appender.targetMethod) && this.declaredFields.equals(appender.declaredFields) && this.specializedLambdaMethod.equals(appender.specializedLambdaMethod);
                    }

                    public int hashCode() {
                        int result = this.targetMethod.hashCode();
                        result = 31 * result + this.declaredFields.hashCode();
                        result = 31 * result + this.specializedLambdaMethod.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.LambdaMethodImplementation.Appender{targetMethod=" + this.targetMethod + ", specializedLambdaMethod=" + this.specializedLambdaMethod + ", declaredFields=" + this.declaredFields + '}';
                    }
                }
            }

            protected static enum FactoryImplementation implements Implementation
            {
                INSTANCE;


                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.getInstrumentedType());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.FactoryImplementation." + this.name();
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    protected Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        return new ByteCodeAppender.Size(new StackManipulation.Compound(TypeCreation.of(this.instrumentedType), Duplication.SINGLE, MethodVariableAccess.allArgumentsOf(instrumentedMethod), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)this.instrumentedType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), MethodReturn.REFERENCE).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
                    }

                    public int hashCode() {
                        return this.instrumentedType.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.FactoryImplementation.Appender{instrumentedType=" + this.instrumentedType + '}';
                    }
                }
            }

            @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="An enumeration does not serialize fields")
            protected static enum ConstructorImplementation implements Implementation
            {
                INSTANCE;

                private final MethodDescription.InDefinedShape objectConstructor = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.OBJECT.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.getInstrumentedType().getDeclaredFields());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.ConstructorImplementation." + this.name();
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final List<FieldDescription.InDefinedShape> declaredFields;

                    protected Appender(List<FieldDescription.InDefinedShape> declaredFields) {
                        this.declaredFields = declaredFields;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        ArrayList<StackManipulation> fieldAssignments = new ArrayList<StackManipulation>(this.declaredFields.size() * 3);
                        for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                            fieldAssignments.add(MethodVariableAccess.loadThis());
                            fieldAssignments.add(MethodVariableAccess.load(parameterDescription));
                            fieldAssignments.add(FieldAccess.forField(this.declaredFields.get(parameterDescription.getIndex())).write());
                        }
                        return new ByteCodeAppender.Size(new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodInvocation.invoke(INSTANCE.objectConstructor), new StackManipulation.Compound(fieldAssignments), MethodReturn.VOID).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.declaredFields.equals(((Appender)other).declaredFields);
                    }

                    public int hashCode() {
                        return this.declaredFields.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.ConstructorImplementation.Appender{declaredFields=" + this.declaredFields + '}';
                    }
                }
            }
        }

        protected static enum LambdaInjector implements Callable<Class<?>>
        {
            INSTANCE;


            @Override
            public Class<?> call() throws Exception {
                TypeDescription.ForLoadedType lambdaFactory = new TypeDescription.ForLoadedType(LambdaFactory.class);
                return ClassInjector.UsingReflection.ofSystemClassLoader().inject(Collections.singletonMap(lambdaFactory, ClassFileLocator.ForClassLoader.read(LambdaFactory.class).resolve())).get(lambdaFactory);
            }

            public String toString() {
                return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInjector." + this.name();
            }
        }
    }

    public static enum RedefinitionStrategy {
        DISABLED(false){

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                return false;
            }

            @Override
            protected Collector make(Default.Transformation transformation) {
                throw new IllegalStateException("A disabled redefinition strategy cannot create a collector");
            }
        }
        ,
        REDEFINITION(true){

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    throw new IllegalArgumentException("Cannot redefine classes: " + instrumentation);
                }
                return false;
            }

            @Override
            protected Collector make(Default.Transformation transformation) {
                return new Collector.ForRedefinition(transformation);
            }
        }
        ,
        RETRANSFORMATION(true){

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                if (!instrumentation.isRetransformClassesSupported()) {
                    throw new IllegalArgumentException("Cannot retransform classes: " + instrumentation);
                }
                return true;
            }

            @Override
            protected Collector make(Default.Transformation transformation) {
                return new Collector.ForRetransformation(transformation);
            }
        };

        private final boolean enabled;

        private RedefinitionStrategy(boolean enabled) {
            this.enabled = enabled;
        }

        protected abstract boolean isRetransforming(Instrumentation var1);

        protected boolean isEnabled() {
            return this.enabled;
        }

        protected abstract Collector make(Default.Transformation var1);

        public String toString() {
            return "AgentBuilder.RedefinitionStrategy." + this.name();
        }

        protected static abstract class Collector {
            private static final Class<?> NO_LOADED_TYPE = null;
            protected final Default.Transformation transformation;
            protected final List<Class<?>> types;

            protected Collector(Default.Transformation transformation) {
                this.transformation = transformation;
                this.types = new ArrayList();
            }

            protected void consider(RawMatcher ignoredTypeMatcher, net.bytebuddy.agent.builder.AgentBuilder$Listener listener, TypeDescription typeDescription, Class<?> type, JavaModule module) {
                this.consider(ignoredTypeMatcher, listener, typeDescription, type, NO_LOADED_TYPE, module, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void consider(RawMatcher ignoredTypeMatcher, net.bytebuddy.agent.builder.AgentBuilder$Listener listener, TypeDescription typeDescription, Class<?> type, Class<?> classBeingRedefined, JavaModule module, boolean unmodifiable) {
                if (unmodifiable || ignoredTypeMatcher.matches(typeDescription, type.getClassLoader(), module, classBeingRedefined, type.getProtectionDomain()) || !this.transformation.matches(typeDescription, type.getClassLoader(), module, classBeingRedefined, type.getProtectionDomain()) || !this.types.add(type)) {
                    try {
                        try {
                            listener.onIgnored(typeDescription, type.getClassLoader(), module);
                        }
                        finally {
                            listener.onComplete(typeDescription.getName(), type.getClassLoader(), module);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }

            protected void apply(Instrumentation instrumentation, CircularityLock circularityLock, LocationStrategy locationStrategy, net.bytebuddy.agent.builder.AgentBuilder$Listener listener, BatchAllocator redefinitionBatchAllocator, Listener redefinitionListener) {
                int index = 0;
                HashMap failures = new HashMap();
                PrependableIterator prepanedableIterator = new PrependableIterator(redefinitionBatchAllocator.batch(this.types));
                while (prepanedableIterator.hasNext()) {
                    Object types = prepanedableIterator.next();
                    redefinitionListener.onBatch(index, (List<Class<?>>)types, this.types);
                    try {
                        this.doApply(instrumentation, circularityLock, (List<Class<?>>)types, locationStrategy, listener);
                    }
                    catch (Throwable throwable) {
                        prepanedableIterator.prepend(redefinitionListener.onError(index, (List<Class<?>>)types, throwable, this.types));
                        failures.put((List<Class<?>>)types, throwable);
                    }
                    ++index;
                }
                redefinitionListener.onComplete(index, this.types, failures);
            }

            protected abstract void doApply(Instrumentation var1, CircularityLock var2, List<Class<?>> var3, LocationStrategy var4, net.bytebuddy.agent.builder.AgentBuilder$Listener var5) throws UnmodifiableClassException, ClassNotFoundException;

            public String toString() {
                return " AgentBuilder.RedefinitionStrategy.Collector." + this.getClass().getSimpleName() + "{transformation=" + this.transformation + ", types=" + this.types + '}';
            }

            protected static class ForRetransformation
            extends Collector {
                protected ForRetransformation(Default.Transformation transformation) {
                    super(transformation);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doApply(Instrumentation instrumentation, CircularityLock circularityLock, List<Class<?>> types, LocationStrategy locationStrategy, net.bytebuddy.agent.builder.AgentBuilder$Listener listener) throws UnmodifiableClassException {
                    if (!types.isEmpty()) {
                        circularityLock.release();
                        try {
                            instrumentation.retransformClasses(types.toArray(new Class[types.size()]));
                        }
                        finally {
                            circularityLock.acquire();
                        }
                    }
                }

                @Override
                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Collector.ForRetransformation{transformation=" + this.transformation + ", types=" + this.types + "}";
                }
            }

            protected static class ForRedefinition
            extends Collector {
                protected ForRedefinition(Default.Transformation transformation) {
                    super(transformation);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doApply(Instrumentation instrumentation, CircularityLock circularityLock, List<Class<?>> types, LocationStrategy locationStrategy, net.bytebuddy.agent.builder.AgentBuilder$Listener listener) throws UnmodifiableClassException, ClassNotFoundException {
                    ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>(types.size());
                    for (Class<?> type : types) {
                        try {
                            try {
                                classDefinitions.add(new ClassDefinition(type, locationStrategy.classFileLocator(type.getClassLoader(), JavaModule.ofType(type)).locate(TypeDescription.ForLoadedType.getName(type)).resolve()));
                            }
                            catch (Throwable throwable) {
                                JavaModule module = JavaModule.ofType(type);
                                try {
                                    listener.onError(TypeDescription.ForLoadedType.getName(type), type.getClassLoader(), module, throwable);
                                }
                                finally {
                                    listener.onComplete(TypeDescription.ForLoadedType.getName(type), type.getClassLoader(), module);
                                }
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    if (!classDefinitions.isEmpty()) {
                        circularityLock.release();
                        try {
                            instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[classDefinitions.size()]));
                        }
                        finally {
                            circularityLock.acquire();
                        }
                    }
                }

                @Override
                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Collector.ForRedefinition{transformation=" + this.transformation + ", types=" + this.types + "}";
                }
            }

            protected static class PrependableIterator
            implements Iterator<List<Class<?>>> {
                private Iterator<? extends List<Class<?>>> current;
                private final Deque<Iterator<? extends List<Class<?>>>> backlog;

                protected PrependableIterator(Iterable<? extends List<Class<?>>> origin) {
                    this.current = origin.iterator();
                    this.backlog = new ArrayDeque();
                }

                public void prepend(Iterable<? extends List<Class<?>>> iterable) {
                    if (this.current.hasNext()) {
                        this.backlog.addLast(this.current);
                    }
                    this.current = iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.current.hasNext();
                }

                @Override
                public List<Class<?>> next() {
                    try {
                        List<Class<?>> list = this.current.next();
                        return list;
                    }
                    finally {
                        while (!this.backlog.isEmpty() && !this.current.hasNext()) {
                            this.current = this.backlog.removeLast();
                        }
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Collector.PrependableIterator{current=" + this.current + ", backlog=" + this.backlog + '}';
                }
            }
        }

        public static interface Listener {
            public void onBatch(int var1, List<Class<?>> var2, List<Class<?>> var3);

            public Iterable<? extends List<Class<?>>> onError(int var1, List<Class<?>> var2, Throwable var3, List<Class<?>> var4);

            public void onComplete(int var1, List<Class<?>> var2, Map<List<Class<?>>, Throwable> var3);

            public static class Compound
            implements Listener {
                private final List<Listener> listeners = new ArrayList<Listener>();

                protected Compound(Listener ... listener) {
                    this(Arrays.asList(listener));
                }

                protected Compound(List<? extends Listener> listeners) {
                    for (Listener listener : listeners) {
                        if (listener instanceof Compound) {
                            this.listeners.addAll(((Compound)listener).listeners);
                            continue;
                        }
                        if (listener instanceof NoOp) continue;
                        this.listeners.add(listener);
                    }
                }

                @Override
                public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
                    for (Listener listener : this.listeners) {
                        listener.onBatch(index, batch, types);
                    }
                }

                @Override
                public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                    ArrayList reattempts = new ArrayList();
                    for (Listener listener : this.listeners) {
                        reattempts.add(listener.onError(index, batch, throwable, types));
                    }
                    return new CompoundIterable(reattempts);
                }

                @Override
                public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
                    for (Listener listener : this.listeners) {
                        listener.onComplete(amount, types, failures);
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Compound compound = (Compound)object;
                    return this.listeners.equals(compound.listeners);
                }

                public int hashCode() {
                    return this.listeners.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Listener.Compound{listeners=" + this.listeners + '}';
                }

                protected static class CompoundIterable
                implements Iterable<List<Class<?>>> {
                    private final List<Iterable<? extends List<Class<?>>>> iterables;

                    protected CompoundIterable(List<Iterable<? extends List<Class<?>>>> iterables) {
                        this.iterables = iterables;
                    }

                    @Override
                    public Iterator<List<Class<?>>> iterator() {
                        return new CompoundIterator(new ArrayList(this.iterables));
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        CompoundIterable lists = (CompoundIterable)object;
                        return this.iterables.equals(lists.iterables);
                    }

                    public int hashCode() {
                        return this.iterables.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.RedefinitionStrategy.Listener.Compound.CompoundIterable{iterables=" + this.iterables + '}';
                    }

                    protected static class CompoundIterator
                    implements Iterator<List<Class<?>>> {
                        private Iterator<? extends List<Class<?>>> current;
                        private final List<Iterable<? extends List<Class<?>>>> backlog;

                        protected CompoundIterator(List<Iterable<? extends List<Class<?>>>> iterables) {
                            this.backlog = iterables;
                            this.forward();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.current != null && this.current.hasNext();
                        }

                        @Override
                        public List<Class<?>> next() {
                            try {
                                if (this.current != null) {
                                    List<Class<?>> list = this.current.next();
                                    return list;
                                }
                                throw new NoSuchElementException();
                            }
                            finally {
                                this.forward();
                            }
                        }

                        private void forward() {
                            while (!(this.current != null && this.current.hasNext() || this.backlog.isEmpty())) {
                                this.current = this.backlog.remove(0).iterator();
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        public String toString() {
                            return "AgentBuilder.RedefinitionStrategy.Listener.Compound.CompoundIterable.CompoundIterator{current=" + this.current + ", backlog=" + this.backlog + '}';
                        }
                    }
                }
            }

            public static class StreamWriting
            implements Listener {
                private final PrintStream printStream;

                public StreamWriting(PrintStream printStream) {
                    this.printStream = printStream;
                }

                public static Listener toSystemOut() {
                    return new StreamWriting(System.out);
                }

                public static Listener toSystemError() {
                    return new StreamWriting(System.err);
                }

                @Override
                public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
                    this.printStream.printf("[Byte Buddy] REDEFINE BATCH #%d [%d of %d type(s)]%n", index, batch.size(), types.size());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                    PrintStream printStream = this.printStream;
                    synchronized (printStream) {
                        this.printStream.printf("[Byte Buddy] REDEFINE ERROR #%d [%d of %d type(s)]%n", index, batch.size(), types.size());
                        throwable.printStackTrace(this.printStream);
                    }
                    return Collections.emptyList();
                }

                @Override
                public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
                    this.printStream.printf("[Byte Buddy] REDEFINE COMPLETE #%d batch(es) containing %d types [%d failed batch(es)]%n", amount, types.size(), failures.size());
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    StreamWriting streamWriting = (StreamWriting)object;
                    return this.printStream.equals(streamWriting.printStream);
                }

                public int hashCode() {
                    return this.printStream.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Listener.StreamWriting{printStream=" + this.printStream + '}';
                }
            }

            public static class Pausing
            extends Adapter {
                private final long value;

                protected Pausing(long value) {
                    this.value = value;
                }

                public static Listener of(long value, TimeUnit timeUnit) {
                    if (value > 0L) {
                        return new Pausing(timeUnit.toMillis(value));
                    }
                    if (value == 0L) {
                        return NoOp.INSTANCE;
                    }
                    throw new IllegalArgumentException("Cannot sleep for a non-positive amount of time: " + value);
                }

                @Override
                public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
                    if (index > 0) {
                        try {
                            Thread.sleep(this.value);
                        }
                        catch (InterruptedException exception) {
                            throw new RuntimeException("Sleep was interrupted", exception);
                        }
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Pausing pausing = (Pausing)object;
                    return this.value == pausing.value;
                }

                public int hashCode() {
                    return (int)(this.value ^ this.value >>> 32);
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Listener.Pausing{value=" + this.value + '}';
                }
            }

            public static class BatchReallocator
            extends Adapter {
                private final BatchAllocator batchAllocator;

                public BatchReallocator(BatchAllocator batchAllocator) {
                    this.batchAllocator = batchAllocator;
                }

                public static Listener splitting() {
                    return new BatchReallocator(new BatchAllocator.Partitioning(2));
                }

                @Override
                public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                    return batch.size() < 2 ? Collections.emptyList() : this.batchAllocator.batch(batch);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    BatchReallocator that = (BatchReallocator)object;
                    return this.batchAllocator.equals(that.batchAllocator);
                }

                public int hashCode() {
                    return this.batchAllocator.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Listener.BatchReallocator{batchAllocator=" + this.batchAllocator + '}';
                }
            }

            public static abstract class Adapter
            implements Listener {
                @Override
                public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
                }

                @Override
                public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                    return Collections.emptyList();
                }

                @Override
                public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
                }
            }

            public static enum ErrorEscalating implements Listener
            {
                FAIL_FAST{

                    @Override
                    public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                        throw new IllegalStateException("Could not transform any of " + batch, throwable);
                    }

                    @Override
                    public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
                    }
                }
                ,
                FAIL_LAST{

                    @Override
                    public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                        return Collections.emptyList();
                    }

                    @Override
                    public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
                        if (!failures.isEmpty()) {
                            throw new IllegalStateException("Could not transform any of " + failures);
                        }
                    }
                };


                @Override
                public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Listener.ErrorEscalating." + this.name();
                }
            }

            public static enum Yielding implements Listener
            {
                INSTANCE;


                @Override
                public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
                    if (index > 0) {
                        Thread.yield();
                    }
                }

                @Override
                public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                    return Collections.emptyList();
                }

                @Override
                public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Listener.Yielding." + this.name();
                }
            }

            public static enum NoOp implements Listener
            {
                INSTANCE;


                @Override
                public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
                }

                @Override
                public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                    return Collections.emptyList();
                }

                @Override
                public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Listener.NoOp." + this.name();
                }
            }
        }

        public static interface BatchAllocator {
            public Iterable<? extends List<Class<?>>> batch(List<Class<?>> var1);

            public static class Partitioning
            implements BatchAllocator {
                private final int parts;

                protected Partitioning(int parts) {
                    this.parts = parts;
                }

                public static BatchAllocator of(int parts) {
                    if (parts < 1) {
                        throw new IllegalArgumentException("A batch size must be positive: " + parts);
                    }
                    return new Partitioning(parts);
                }

                @Override
                public Iterable<? extends List<Class<?>>> batch(List<Class<?>> types) {
                    int reminder;
                    if (types.isEmpty()) {
                        return Collections.emptyList();
                    }
                    ArrayList batches = new ArrayList();
                    int size = types.size() / this.parts;
                    for (int index = reminder = types.size() % this.parts; index < types.size(); index += size) {
                        batches.add(new ArrayList(types.subList(index, index + size)));
                    }
                    if (batches.isEmpty()) {
                        return Collections.singletonList(types);
                    }
                    ((List)batches.get(0)).addAll(0, types.subList(0, reminder));
                    return batches;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Partitioning that = (Partitioning)object;
                    return this.parts == that.parts;
                }

                public int hashCode() {
                    return this.parts;
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.BatchAllocator.Partitioning{parts=" + this.parts + '}';
                }
            }

            public static class Slicing
            implements BatchAllocator {
                private final int minimum;
                private final int maximum;
                private final BatchAllocator batchAllocator;

                protected Slicing(int minimum, int maximum, BatchAllocator batchAllocator) {
                    this.minimum = minimum;
                    this.maximum = maximum;
                    this.batchAllocator = batchAllocator;
                }

                public static BatchAllocator withMinimum(int minimum, BatchAllocator batchAllocator) {
                    return Slicing.withinRange(minimum, Integer.MAX_VALUE, batchAllocator);
                }

                public static BatchAllocator withMaximum(int maximum, BatchAllocator batchAllocator) {
                    return Slicing.withinRange(1, maximum, batchAllocator);
                }

                public static BatchAllocator withinRange(int minimum, int maximum, BatchAllocator batchAllocator) {
                    if (minimum <= 0) {
                        throw new IllegalArgumentException("Minimum must be a positive number: " + minimum);
                    }
                    if (minimum > maximum) {
                        throw new IllegalArgumentException("Minimum must not be bigger than maximum: " + minimum + " >" + maximum);
                    }
                    return new Slicing(minimum, maximum, batchAllocator);
                }

                @Override
                public Iterable<? extends List<Class<?>>> batch(List<Class<?>> types) {
                    return new SlicingIterable(this.minimum, this.maximum, this.batchAllocator.batch(types));
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Slicing slicing = (Slicing)object;
                    return this.minimum == slicing.minimum && this.maximum == slicing.maximum && this.batchAllocator.equals(slicing.batchAllocator);
                }

                public int hashCode() {
                    int result = this.minimum;
                    result = 31 * result + this.maximum;
                    result = 31 * result + this.batchAllocator.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.BatchAllocator.Slicing{minimum=" + this.minimum + ", maximum=" + this.maximum + ", batchAllocator=" + this.batchAllocator + '}';
                }

                protected static class SlicingIterable
                implements Iterable<List<Class<?>>> {
                    private final int minimum;
                    private final int maximum;
                    private final Iterable<? extends List<Class<?>>> iterable;

                    protected SlicingIterable(int minimum, int maximum, Iterable<? extends List<Class<?>>> iterable) {
                        this.minimum = minimum;
                        this.maximum = maximum;
                        this.iterable = iterable;
                    }

                    @Override
                    public Iterator<List<Class<?>>> iterator() {
                        return new SlicingIterator(this.minimum, this.maximum, this.iterable.iterator());
                    }

                    public String toString() {
                        return "AgentBuilder.RedefinitionStrategy.BatchAllocator.Slicing.SlicingIterable{minimum=" + this.minimum + ", maximum=" + this.maximum + ", iterable=" + this.iterable + '}';
                    }

                    protected static class SlicingIterator
                    implements Iterator<List<Class<?>>> {
                        private final int minimum;
                        private final int maximum;
                        private final Iterator<? extends List<Class<?>>> iterator;
                        private List<Class<?>> buffer;

                        protected SlicingIterator(int minimum, int maximum, Iterator<? extends List<Class<?>>> iterator) {
                            this.minimum = minimum;
                            this.maximum = maximum;
                            this.iterator = iterator;
                            this.buffer = Collections.emptyList();
                        }

                        @Override
                        public boolean hasNext() {
                            return !this.buffer.isEmpty() || this.iterator.hasNext();
                        }

                        @Override
                        public List<Class<?>> next() {
                            if (this.buffer.isEmpty()) {
                                this.buffer = this.iterator.next();
                            }
                            while (this.buffer.size() < this.minimum && this.iterator.hasNext()) {
                                this.buffer.addAll((Collection)this.iterator.next());
                            }
                            if (this.buffer.size() > this.maximum) {
                                try {
                                    List<Class<?>> list = this.buffer.subList(0, this.maximum);
                                    return list;
                                }
                                finally {
                                    this.buffer = this.buffer.subList(this.maximum, this.buffer.size());
                                }
                            }
                            try {
                                List<Class<?>> list = this.buffer;
                                return list;
                            }
                            finally {
                                this.buffer = Collections.emptyList();
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        public String toString() {
                            return "AgentBuilder.RedefinitionStrategy.BatchAllocator.Slicing.SlicingIterable.SlicingIterator{minimum=" + this.minimum + ", maximum=" + this.maximum + ", iterator=" + this.iterator + ", buffer=" + this.buffer + '}';
                        }
                    }
                }
            }

            public static class ForMatchedGrouping
            implements BatchAllocator {
                private final Collection<? extends ElementMatcher<? super TypeDescription>> matchers;

                public ForMatchedGrouping(ElementMatcher<? super TypeDescription> ... matcher) {
                    this(new LinkedHashSet<ElementMatcher<? super TypeDescription>>(Arrays.asList(matcher)));
                }

                public ForMatchedGrouping(Collection<? extends ElementMatcher<? super TypeDescription>> matchers) {
                    this.matchers = matchers;
                }

                public BatchAllocator withMinimum(int threshold) {
                    return Slicing.withMinimum(threshold, this);
                }

                public BatchAllocator withMaximum(int threshold) {
                    return Slicing.withMaximum(threshold, this);
                }

                public BatchAllocator withinRange(int minimum, int maximum) {
                    return Slicing.withinRange(minimum, maximum, this);
                }

                @Override
                public Iterable<? extends List<Class<?>>> batch(List<Class<?>> types) {
                    LinkedHashMap matched = new LinkedHashMap();
                    ArrayList<Class> unmatched = new ArrayList<Class>();
                    for (ElementMatcher<? super TypeDescription> elementMatcher : this.matchers) {
                        matched.put(elementMatcher, new ArrayList());
                    }
                    block1: for (Class clazz : types) {
                        for (ElementMatcher<? super TypeDescription> elementMatcher : this.matchers) {
                            if (!elementMatcher.matches(new TypeDescription.ForLoadedType(clazz))) continue;
                            ((List)matched.get(elementMatcher)).add(clazz);
                            continue block1;
                        }
                        unmatched.add(clazz);
                    }
                    ArrayList<List> batches = new ArrayList<List>(this.matchers.size() + 1);
                    for (List batch : matched.values()) {
                        if (batch.isEmpty()) continue;
                        batches.add(batch);
                    }
                    if (!unmatched.isEmpty()) {
                        batches.add(unmatched);
                    }
                    return batches;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForMatchedGrouping that = (ForMatchedGrouping)object;
                    return this.matchers.equals(that.matchers);
                }

                public int hashCode() {
                    return this.matchers.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.BatchAllocator.ForMatchedGrouping{matchers=" + this.matchers + '}';
                }
            }

            public static class ForFixedSize
            implements BatchAllocator {
                private final int size;

                protected ForFixedSize(int size) {
                    this.size = size;
                }

                public static BatchAllocator ofSize(int size) {
                    if (size > 0) {
                        return new ForFixedSize(size);
                    }
                    if (size == 0) {
                        return ForTotal.INSTANCE;
                    }
                    throw new IllegalArgumentException("Cannot define a batch with a negative size: " + size);
                }

                @Override
                public Iterable<? extends List<Class<?>>> batch(List<Class<?>> types) {
                    ArrayList batches = new ArrayList();
                    for (int index = 0; index < types.size(); index += this.size) {
                        batches.add(new ArrayList(types.subList(index, Math.min(types.size(), index + this.size))));
                    }
                    return batches;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForFixedSize that = (ForFixedSize)object;
                    return this.size == that.size;
                }

                public int hashCode() {
                    return this.size;
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.BatchAllocator.ForFixedSize{size=" + this.size + '}';
                }
            }

            public static enum ForTotal implements BatchAllocator
            {
                INSTANCE;


                @Override
                public Iterable<? extends List<Class<?>>> batch(List<Class<?>> types) {
                    return types.isEmpty() ? Collections.emptySet() : Collections.singleton(types);
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.BatchAllocator.ForTotal." + this.name();
                }
            }
        }
    }

    public static interface FallbackStrategy {
        public boolean isFallback(Class<?> var1, Throwable var2);

        public static class ByThrowableType
        implements FallbackStrategy {
            private final Set<? extends Class<? extends Throwable>> types;

            public ByThrowableType(Class<? extends Throwable> ... type) {
                this(new HashSet<Class<? extends Throwable>>(Arrays.asList(type)));
            }

            public ByThrowableType(Set<? extends Class<? extends Throwable>> types) {
                this.types = types;
            }

            public static FallbackStrategy ofOptionalTypes() {
                return new ByThrowableType(LinkageError.class, TypeNotPresentException.class);
            }

            @Override
            public boolean isFallback(Class<?> type, Throwable throwable) {
                for (Class<? extends Throwable> clazz : this.types) {
                    if (!clazz.isInstance(throwable)) continue;
                    return true;
                }
                return false;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ByThrowableType byType = (ByThrowableType)object;
                return this.types.equals(byType.types);
            }

            public int hashCode() {
                return this.types.hashCode();
            }

            public String toString() {
                return "AgentBuilder.FallbackStrategy.ByThrowableType{types=" + this.types + '}';
            }
        }

        public static enum Simple implements FallbackStrategy
        {
            ENABLED(true),
            DISABLED(false);

            private final boolean enabled;

            private Simple(boolean enabled) {
                this.enabled = enabled;
            }

            @Override
            public boolean isFallback(Class<?> type, Throwable throwable) {
                return this.enabled;
            }

            public String toString() {
                return "AgentBuilder.FallbackStrategy.Simple." + this.name();
            }
        }
    }

    public static interface LocationStrategy {
        public ClassFileLocator classFileLocator(ClassLoader var1, JavaModule var2);

        public static class Compound
        implements LocationStrategy {
            private final List<LocationStrategy> locationStrategies = new ArrayList<LocationStrategy>();

            public Compound(LocationStrategy ... locationStrategy) {
                this(Arrays.asList(locationStrategy));
            }

            public Compound(List<? extends LocationStrategy> locationStrategies) {
                for (LocationStrategy locationStrategy : locationStrategies) {
                    if (locationStrategy instanceof Compound) {
                        this.locationStrategies.addAll(((Compound)locationStrategy).locationStrategies);
                        continue;
                    }
                    if (locationStrategy instanceof NoOp) continue;
                    this.locationStrategies.add(locationStrategy);
                }
            }

            @Override
            public ClassFileLocator classFileLocator(ClassLoader classLoader, JavaModule module) {
                ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>(this.locationStrategies.size());
                for (LocationStrategy locationStrategy : this.locationStrategies) {
                    classFileLocators.add(locationStrategy.classFileLocator(classLoader, module));
                }
                return new ClassFileLocator.Compound(classFileLocators);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Compound compound = (Compound)object;
                return this.locationStrategies.equals(compound.locationStrategies);
            }

            public int hashCode() {
                return this.locationStrategies.hashCode();
            }

            public String toString() {
                return "AgentBuilder.LocationStrategy.Compound{locationStrategies=" + this.locationStrategies + '}';
            }
        }

        public static class Simple
        implements LocationStrategy {
            private final ClassFileLocator classFileLocator;

            public Simple(ClassFileLocator classFileLocator) {
                this.classFileLocator = classFileLocator;
            }

            @Override
            public ClassFileLocator classFileLocator(ClassLoader classLoader, JavaModule module) {
                return this.classFileLocator;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Simple simple = (Simple)object;
                return this.classFileLocator.equals(simple.classFileLocator);
            }

            public int hashCode() {
                return this.classFileLocator.hashCode();
            }

            public String toString() {
                return "AgentBuilder.LocationStrategy.Simple{classFileLocator=" + this.classFileLocator + '}';
            }
        }

        public static enum ForClassLoader implements LocationStrategy
        {
            STRONG{

                @Override
                public ClassFileLocator classFileLocator(ClassLoader classLoader, JavaModule module) {
                    return ClassFileLocator.ForClassLoader.of(classLoader);
                }
            }
            ,
            WEAK{

                @Override
                public ClassFileLocator classFileLocator(ClassLoader classLoader, JavaModule module) {
                    return ClassFileLocator.ForClassLoader.WeaklyReferenced.of(classLoader);
                }
            };


            public LocationStrategy withFallbackTo(ClassFileLocator ... classFileLocator) {
                return this.withFallbackTo((Collection<? extends ClassFileLocator>)Arrays.asList(classFileLocator));
            }

            public LocationStrategy withFallbackTo(Collection<? extends ClassFileLocator> classFileLocators) {
                ArrayList<Simple> locationStrategies = new ArrayList<Simple>(classFileLocators.size());
                for (ClassFileLocator classFileLocator : classFileLocators) {
                    locationStrategies.add(new Simple(classFileLocator));
                }
                return this.withFallbackTo((List<? extends LocationStrategy>)locationStrategies);
            }

            public LocationStrategy withFallbackTo(LocationStrategy ... locationStrategy) {
                return this.withFallbackTo(Arrays.asList(locationStrategy));
            }

            public LocationStrategy withFallbackTo(List<? extends LocationStrategy> locationStrategies) {
                ArrayList<? extends LocationStrategy> allLocationStrategies = new ArrayList<LocationStrategy>(locationStrategies.size() + 1);
                allLocationStrategies.add(this);
                allLocationStrategies.addAll(locationStrategies);
                return new Compound(allLocationStrategies);
            }

            public String toString() {
                return "AgentBuilder.LocationStrategy.ForClassLoader." + this.name();
            }
        }

        public static enum NoOp implements LocationStrategy
        {
            INSTANCE;


            @Override
            public ClassFileLocator classFileLocator(ClassLoader classLoader, JavaModule module) {
                return ClassFileLocator.NoOp.INSTANCE;
            }

            public String toString() {
                return "AgentBuilder.LocationStrategy.NoOp." + this.name();
            }
        }
    }

    public static interface InstallationStrategy {
        public ResettableClassFileTransformer onError(Instrumentation var1, ResettableClassFileTransformer var2, Throwable var3);

        public static enum Default implements InstallationStrategy
        {
            ESCALATING{

                @Override
                public ResettableClassFileTransformer onError(Instrumentation instrumentation, ResettableClassFileTransformer classFileTransformer, Throwable throwable) {
                    instrumentation.removeTransformer(classFileTransformer);
                    throw new IllegalStateException("Could not install class file transformer", throwable);
                }
            }
            ,
            SUPPRESSING{

                @Override
                public ResettableClassFileTransformer onError(Instrumentation instrumentation, ResettableClassFileTransformer classFileTransformer, Throwable throwable) {
                    return classFileTransformer;
                }
            };


            public String toString() {
                return "AgentBuilder.InstallationStrategy.Default." + this.name();
            }
        }
    }

    public static interface DescriptionStrategy {
        public TypeDescription apply(String var1, Class<?> var2, TypePool var3, CircularityLock var4, ClassLoader var5, JavaModule var6);

        public boolean isLoadedFirst();

        public static class SuperTypeLoading
        implements DescriptionStrategy {
            private final DescriptionStrategy delegate;

            public SuperTypeLoading(DescriptionStrategy delegate) {
                this.delegate = delegate;
            }

            @Override
            public TypeDescription apply(String typeName, Class<?> type, TypePool typePool, CircularityLock circularityLock, ClassLoader classLoader, JavaModule module) {
                TypeDescription typeDescription = this.delegate.apply(typeName, type, typePool, circularityLock, classLoader, module);
                return typeDescription instanceof TypeDescription.ForLoadedType ? typeDescription : new TypeDescription.SuperTypeLoading(typeDescription, classLoader, new UnlockingClassLoadingDelegate(circularityLock));
            }

            @Override
            public boolean isLoadedFirst() {
                return this.delegate.isLoadedFirst();
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                SuperTypeLoading that = (SuperTypeLoading)object;
                return this.delegate.equals(that.delegate);
            }

            public int hashCode() {
                return this.delegate.hashCode();
            }

            public String toString() {
                return "AgentBuilder.DescriptionStrategy.SuperTypeLoading{delegate=" + this.delegate + '}';
            }

            protected static class UnlockingClassLoadingDelegate
            implements TypeDescription.SuperTypeLoading.ClassLoadingDelegate {
                private final CircularityLock circularityLock;

                protected UnlockingClassLoadingDelegate(CircularityLock circularityLock) {
                    this.circularityLock = circularityLock;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Class<?> load(String name, ClassLoader classLoader) throws ClassNotFoundException {
                    this.circularityLock.release();
                    try {
                        Class<?> clazz = Class.forName(name, false, classLoader);
                        return clazz;
                    }
                    finally {
                        this.circularityLock.acquire();
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    UnlockingClassLoadingDelegate that = (UnlockingClassLoadingDelegate)object;
                    return this.circularityLock.equals(that.circularityLock);
                }

                public int hashCode() {
                    return this.circularityLock.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.DescriptionStrategy.SuperTypeLoading.UnlockingClassLoadingDelegate{circularityLock=" + this.circularityLock + '}';
                }
            }
        }

        public static enum Default implements DescriptionStrategy
        {
            HYBRID(true){

                @Override
                public TypeDescription apply(String typeName, Class<?> type, TypePool typePool, CircularityLock circularityLock, ClassLoader classLoader, JavaModule module) {
                    return type == null ? typePool.describe(typeName).resolve() : new TypeDescription.ForLoadedType(type);
                }
            }
            ,
            POOL_ONLY(false){

                @Override
                public TypeDescription apply(String typeName, Class<?> type, TypePool typePool, CircularityLock circularityLock, ClassLoader classLoader, JavaModule module) {
                    return typePool.describe(typeName).resolve();
                }
            }
            ,
            POOL_FIRST(false){

                @Override
                public TypeDescription apply(String typeName, Class<?> type, TypePool typePool, CircularityLock circularityLock, ClassLoader classLoader, JavaModule module) {
                    TypePool.Resolution resolution = typePool.describe(typeName);
                    return resolution.isResolved() || type == null ? resolution.resolve() : new TypeDescription.ForLoadedType(type);
                }
            };

            private final boolean loadedFirst;

            private Default(boolean loadedFirst) {
                this.loadedFirst = loadedFirst;
            }

            public DescriptionStrategy withSuperTypeLoading() {
                return new SuperTypeLoading(this);
            }

            @Override
            public boolean isLoadedFirst() {
                return this.loadedFirst;
            }

            public String toString() {
                return "AgentBuilder.DescriptionStrategy.Default." + this.name();
            }
        }
    }

    public static interface InitializationStrategy {
        public Dispatcher dispatcher();

        public static abstract class SelfInjection
        implements InitializationStrategy {
            protected final NexusAccessor nexusAccessor;

            protected SelfInjection(NexusAccessor nexusAccessor) {
                this.nexusAccessor = nexusAccessor;
            }

            @Override
            @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="Avoiding synchronization without security concerns")
            public net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher() {
                return this.dispatcher(new Random().nextInt());
            }

            protected abstract net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher(int var1);

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                SelfInjection that = (SelfInjection)object;
                return this.nexusAccessor.equals(that.nexusAccessor);
            }

            public int hashCode() {
                return this.nexusAccessor.hashCode();
            }

            public static class Eager
            extends SelfInjection {
                public Eager() {
                    this(new NexusAccessor());
                }

                public Eager(NexusAccessor nexusAccessor) {
                    super(nexusAccessor);
                }

                @Override
                protected net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher(int identification) {
                    return new Dispatcher(this.nexusAccessor, identification);
                }

                public String toString() {
                    return "AgentBuilder.InitializationStrategy.SelfInjection.Eager{nexusAccessor=" + this.nexusAccessor + "}";
                }

                protected static class Dispatcher
                extends net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$SelfInjection$Dispatcher {
                    protected Dispatcher(NexusAccessor nexusAccessor, int identification) {
                        super(nexusAccessor, identification);
                    }

                    @Override
                    public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                        Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                        Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                        if (!auxiliaryTypes.isEmpty()) {
                            for (Map.Entry<TypeDescription, Class<?>> entry : injectorFactory.resolve().inject(auxiliaryTypes).entrySet()) {
                                loadedTypeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                            }
                        }
                        LoadedTypeInitializer loadedTypeInitializer = loadedTypeInitializers.get(dynamicType.getTypeDescription());
                        this.nexusAccessor.register(dynamicType.getTypeDescription().getName(), classLoader, this.identification, loadedTypeInitializer);
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Eager.Dispatcher{nexusAccessor=" + this.nexusAccessor + ", identification=" + this.identification + "}";
                    }
                }
            }

            public static class Lazy
            extends SelfInjection {
                public Lazy() {
                    this(new NexusAccessor());
                }

                public Lazy(NexusAccessor nexusAccessor) {
                    super(nexusAccessor);
                }

                @Override
                protected net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher(int identification) {
                    return new Dispatcher(this.nexusAccessor, identification);
                }

                public String toString() {
                    return "AgentBuilder.InitializationStrategy.SelfInjection.Lazy{nexusAccessor=" + this.nexusAccessor + "}";
                }

                protected static class Dispatcher
                extends net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$SelfInjection$Dispatcher {
                    protected Dispatcher(NexusAccessor nexusAccessor, int identification) {
                        super(nexusAccessor, identification);
                    }

                    @Override
                    public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                        Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                        LoadedTypeInitializer loadedTypeInitializer = auxiliaryTypes.isEmpty() ? dynamicType.getLoadedTypeInitializers().get(dynamicType.getTypeDescription()) : new Dispatcher.InjectingInitializer(dynamicType.getTypeDescription(), auxiliaryTypes, dynamicType.getLoadedTypeInitializers(), injectorFactory.resolve());
                        this.nexusAccessor.register(dynamicType.getTypeDescription().getName(), classLoader, this.identification, loadedTypeInitializer);
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Lazy.Dispatcher{nexusAccessor=" + this.nexusAccessor + ", identification=" + this.identification + "}";
                    }
                }
            }

            public static class Split
            extends SelfInjection {
                public Split() {
                    this(new NexusAccessor());
                }

                public Split(NexusAccessor nexusAccessor) {
                    super(nexusAccessor);
                }

                @Override
                protected net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher(int identification) {
                    return new Dispatcher(this.nexusAccessor, identification);
                }

                public String toString() {
                    return "AgentBuilder.InitializationStrategy.SelfInjection.Split{nexusAccessor=" + this.nexusAccessor + "}";
                }

                protected static class Dispatcher
                extends net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$SelfInjection$Dispatcher {
                    protected Dispatcher(NexusAccessor nexusAccessor, int identification) {
                        super(nexusAccessor, identification);
                    }

                    @Override
                    public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                        LoadedTypeInitializer loadedTypeInitializer;
                        Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                        if (!auxiliaryTypes.isEmpty()) {
                            TypeDescription instrumentedType = dynamicType.getTypeDescription();
                            ClassInjector classInjector = injectorFactory.resolve();
                            LinkedHashMap<TypeDescription, byte[]> independentTypes = new LinkedHashMap<TypeDescription, byte[]>(auxiliaryTypes);
                            LinkedHashMap<TypeDescription, byte[]> dependentTypes = new LinkedHashMap<TypeDescription, byte[]>(auxiliaryTypes);
                            for (TypeDescription typeDescription : auxiliaryTypes.keySet()) {
                                (typeDescription.getDeclaredAnnotations().isAnnotationPresent(AuxiliaryType.SignatureRelevant.class) ? dependentTypes : independentTypes).remove(typeDescription);
                            }
                            Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                            if (!independentTypes.isEmpty()) {
                                for (Map.Entry<TypeDescription, Class<?>> entry : classInjector.inject(independentTypes).entrySet()) {
                                    loadedTypeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                                }
                            }
                            HashMap<TypeDescription, LoadedTypeInitializer> hashMap = new HashMap<TypeDescription, LoadedTypeInitializer>(loadedTypeInitializers);
                            loadedTypeInitializers.keySet().removeAll(independentTypes.keySet());
                            loadedTypeInitializer = hashMap.size() > 1 ? new Dispatcher.InjectingInitializer(instrumentedType, dependentTypes, hashMap, classInjector) : (LoadedTypeInitializer)hashMap.get(instrumentedType);
                        } else {
                            loadedTypeInitializer = dynamicType.getLoadedTypeInitializers().get(dynamicType.getTypeDescription());
                        }
                        this.nexusAccessor.register(dynamicType.getTypeDescription().getName(), classLoader, this.identification, loadedTypeInitializer);
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Split.Dispatcher{nexusAccessor=" + this.nexusAccessor + ", identification=" + this.identification + "}";
                    }
                }
            }

            protected static abstract class Dispatcher
            implements net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher {
                protected final NexusAccessor nexusAccessor;
                protected final int identification;

                protected Dispatcher(NexusAccessor nexusAccessor, int identification) {
                    this.nexusAccessor = nexusAccessor;
                    this.identification = identification;
                }

                @Override
                public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                    return builder.initializer(new NexusAccessor.InitializationAppender(this.identification));
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.identification == ((Dispatcher)other).identification && this.nexusAccessor == ((Dispatcher)other).nexusAccessor;
                }

                public int hashCode() {
                    return this.identification + 31 * this.nexusAccessor.hashCode();
                }

                protected static class InjectingInitializer
                implements LoadedTypeInitializer {
                    private final TypeDescription instrumentedType;
                    private final Map<TypeDescription, byte[]> rawAuxiliaryTypes;
                    private final Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers;
                    private final ClassInjector classInjector;

                    protected InjectingInitializer(TypeDescription instrumentedType, Map<TypeDescription, byte[]> rawAuxiliaryTypes, Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers, ClassInjector classInjector) {
                        this.instrumentedType = instrumentedType;
                        this.rawAuxiliaryTypes = rawAuxiliaryTypes;
                        this.loadedTypeInitializers = loadedTypeInitializers;
                        this.classInjector = classInjector;
                    }

                    @Override
                    public void onLoad(Class<?> type) {
                        for (Map.Entry<TypeDescription, Class<?>> auxiliary : this.classInjector.inject(this.rawAuxiliaryTypes).entrySet()) {
                            this.loadedTypeInitializers.get(auxiliary.getKey()).onLoad(auxiliary.getValue());
                        }
                        this.loadedTypeInitializers.get(this.instrumentedType).onLoad(type);
                    }

                    @Override
                    public boolean isAlive() {
                        return true;
                    }

                    public boolean equals(Object o) {
                        if (this == o) {
                            return true;
                        }
                        if (o == null || this.getClass() != o.getClass()) {
                            return false;
                        }
                        InjectingInitializer that = (InjectingInitializer)o;
                        return this.classInjector.equals(that.classInjector) && this.instrumentedType.equals(that.instrumentedType) && this.rawAuxiliaryTypes.equals(that.rawAuxiliaryTypes) && this.loadedTypeInitializers.equals(that.loadedTypeInitializers);
                    }

                    public int hashCode() {
                        int result = this.instrumentedType.hashCode();
                        result = 31 * result + this.rawAuxiliaryTypes.hashCode();
                        result = 31 * result + this.loadedTypeInitializers.hashCode();
                        result = 31 * result + this.classInjector.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Dispatcher.InjectingInitializer{instrumentedType=" + this.instrumentedType + ", rawAuxiliaryTypes=" + this.rawAuxiliaryTypes + ", loadedTypeInitializers=" + this.loadedTypeInitializers + ", classInjector=" + this.classInjector + '}';
                    }
                }
            }
        }

        public static enum Minimal implements InitializationStrategy,
        Dispatcher
        {
            INSTANCE;


            @Override
            public Dispatcher dispatcher() {
                return this;
            }

            @Override
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                return builder;
            }

            @Override
            public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                LinkedHashMap<TypeDescription, byte[]> independentTypes = new LinkedHashMap<TypeDescription, byte[]>(auxiliaryTypes);
                for (TypeDescription auxiliaryType : auxiliaryTypes.keySet()) {
                    if (auxiliaryType.getDeclaredAnnotations().isAnnotationPresent(AuxiliaryType.SignatureRelevant.class)) continue;
                    independentTypes.remove(auxiliaryType);
                }
                if (!independentTypes.isEmpty()) {
                    ClassInjector classInjector = injectorFactory.resolve();
                    Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                    for (Map.Entry<TypeDescription, Class<?>> entry : classInjector.inject(independentTypes).entrySet()) {
                        loadedTypeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                    }
                }
            }

            public String toString() {
                return "AgentBuilder.InitializationStrategy.Minimal." + this.name();
            }
        }

        public static enum NoOp implements InitializationStrategy,
        Dispatcher
        {
            INSTANCE;


            @Override
            public Dispatcher dispatcher() {
                return this;
            }

            @Override
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                return builder;
            }

            @Override
            public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
            }

            public String toString() {
                return "AgentBuilder.InitializationStrategy.NoOp." + this.name();
            }
        }

        public static interface Dispatcher {
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> var1);

            public void register(DynamicType var1, ClassLoader var2, InjectorFactory var3);

            public static interface InjectorFactory {
                public ClassInjector resolve();
            }
        }
    }

    public static interface PoolStrategy {
        public TypePool typePool(ClassFileLocator var1, ClassLoader var2);

        public static abstract class WithTypePoolCache
        implements PoolStrategy {
            protected final TypePool.Default.ReaderMode readerMode;

            protected WithTypePoolCache(TypePool.Default.ReaderMode readerMode) {
                this.readerMode = readerMode;
            }

            @Override
            public TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
                return new TypePool.Default.WithLazyResolution(this.locate(classLoader), classFileLocator, this.readerMode);
            }

            protected abstract TypePool.CacheProvider locate(ClassLoader var1);

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WithTypePoolCache that = (WithTypePoolCache)object;
                return this.readerMode == that.readerMode;
            }

            public int hashCode() {
                return this.readerMode.hashCode();
            }

            public static class Simple
            extends WithTypePoolCache {
                private final ConcurrentMap<? super ClassLoader, TypePool.CacheProvider> cacheProviders;

                public Simple(ConcurrentMap<? super ClassLoader, TypePool.CacheProvider> cacheProviders) {
                    this(TypePool.Default.ReaderMode.FAST, cacheProviders);
                }

                public Simple(TypePool.Default.ReaderMode readerMode, ConcurrentMap<? super ClassLoader, TypePool.CacheProvider> cacheProviders) {
                    super(readerMode);
                    this.cacheProviders = cacheProviders;
                }

                @Override
                protected TypePool.CacheProvider locate(ClassLoader classLoader) {
                    classLoader = classLoader == null ? this.getBootstrapMarkerLoader() : classLoader;
                    TypePool.CacheProvider cacheProvider = (TypePool.CacheProvider)this.cacheProviders.get(classLoader);
                    while (cacheProvider == null) {
                        cacheProvider = TypePool.CacheProvider.Simple.withObjectType();
                        TypePool.CacheProvider previous = this.cacheProviders.putIfAbsent(classLoader, cacheProvider);
                        if (previous == null) continue;
                        cacheProvider = previous;
                    }
                    return cacheProvider;
                }

                protected ClassLoader getBootstrapMarkerLoader() {
                    return ClassLoader.getSystemClassLoader();
                }

                @Override
                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!super.equals(object)) {
                        return false;
                    }
                    Simple simple = (Simple)object;
                    return this.cacheProviders.equals(simple.cacheProviders);
                }

                @Override
                public int hashCode() {
                    int result = super.hashCode();
                    result = 31 * result + this.cacheProviders.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.PoolStrategy.WithTypePoolCache.Simple{cacheProviders=" + this.cacheProviders + '}';
                }
            }
        }

        public static enum ClassLoading implements PoolStrategy
        {
            EXTENDED(TypePool.Default.ReaderMode.EXTENDED),
            FAST(TypePool.Default.ReaderMode.FAST);

            private final TypePool.Default.ReaderMode readerMode;

            private ClassLoading(TypePool.Default.ReaderMode readerMode) {
                this.readerMode = readerMode;
            }

            @Override
            public TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
                return TypePool.ClassLoading.of(classLoader, new TypePool.Default.WithLazyResolution(TypePool.CacheProvider.Simple.withObjectType(), classFileLocator, this.readerMode));
            }

            public String toString() {
                return "AgentBuilder.PoolStrategy.ClassLoading." + this.name();
            }
        }

        public static enum Eager implements PoolStrategy
        {
            EXTENDED(TypePool.Default.ReaderMode.EXTENDED),
            FAST(TypePool.Default.ReaderMode.FAST);

            private final TypePool.Default.ReaderMode readerMode;

            private Eager(TypePool.Default.ReaderMode readerMode) {
                this.readerMode = readerMode;
            }

            @Override
            public TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
                return new TypePool.Default(TypePool.CacheProvider.Simple.withObjectType(), classFileLocator, this.readerMode);
            }

            public String toString() {
                return "AgentBuilder.PoolStrategy.Eager." + this.name();
            }
        }

        public static enum Default implements PoolStrategy
        {
            EXTENDED(TypePool.Default.ReaderMode.EXTENDED),
            FAST(TypePool.Default.ReaderMode.FAST);

            private final TypePool.Default.ReaderMode readerMode;

            private Default(TypePool.Default.ReaderMode readerMode) {
                this.readerMode = readerMode;
            }

            @Override
            public TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
                return new TypePool.Default.WithLazyResolution(TypePool.CacheProvider.Simple.withObjectType(), classFileLocator, this.readerMode);
            }

            public String toString() {
                return "AgentBuilder.PoolStrategy.Default." + this.name();
            }
        }
    }

    public static interface Transformer {
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> var1, TypeDescription var2, ClassLoader var3);

        public static class Compound
        implements Transformer {
            private final List<Transformer> transformers = new ArrayList<Transformer>();

            public Compound(Transformer ... transformer) {
                this(Arrays.asList(transformer));
            }

            public Compound(List<? extends Transformer> transformers) {
                for (Transformer transformer : transformers) {
                    if (transformer instanceof Compound) {
                        this.transformers.addAll(((Compound)transformer).transformers);
                        continue;
                    }
                    if (transformer instanceof NoOp) continue;
                    this.transformers.add(transformer);
                }
            }

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader) {
                for (Transformer transformer : this.transformers) {
                    builder = transformer.transform(builder, typeDescription, classLoader);
                }
                return builder;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.transformers.equals(((Compound)other).transformers);
            }

            public int hashCode() {
                return this.transformers.hashCode();
            }

            public String toString() {
                return "AgentBuilder.Transformer.Compound{transformers=" + this.transformers + '}';
            }
        }

        public static class ForBuildPlugin
        implements Transformer {
            private final Plugin plugin;

            public ForBuildPlugin(Plugin plugin) {
                this.plugin = plugin;
            }

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader) {
                return this.plugin.apply(builder, typeDescription);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForBuildPlugin that = (ForBuildPlugin)object;
                return this.plugin.equals(that.plugin);
            }

            public int hashCode() {
                return this.plugin.hashCode();
            }

            public String toString() {
                return "AgentBuilder.Transformer.ForBuildPlugin{plugin=" + this.plugin + '}';
            }
        }

        public static enum NoOp implements Transformer
        {
            INSTANCE;


            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader) {
                return builder;
            }

            public String toString() {
                return "AgentBuilder.Transformer.NoOp." + this.name();
            }
        }
    }

    public static interface TypeStrategy {
        public DynamicType.Builder<?> builder(TypeDescription var1, ByteBuddy var2, ClassFileLocator var3, MethodNameTransformer var4);

        public static class ForBuildEntryPoint
        implements TypeStrategy {
            private final EntryPoint entryPoint;

            public ForBuildEntryPoint(EntryPoint entryPoint) {
                this.entryPoint = entryPoint;
            }

            @Override
            public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                return this.entryPoint.transform(typeDescription, byteBuddy, classFileLocator, methodNameTransformer);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForBuildEntryPoint that = (ForBuildEntryPoint)object;
                return this.entryPoint.equals(that.entryPoint);
            }

            public int hashCode() {
                return this.entryPoint.hashCode();
            }

            public String toString() {
                return "AgentBuilder.TypeStrategy.ForBuildEntryPoint{entryPoint=" + this.entryPoint + '}';
            }
        }

        public static enum Default implements TypeStrategy
        {
            REBASE{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.rebase(typeDescription, classFileLocator, methodNameTransformer);
                }
            }
            ,
            REDEFINE{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.redefine(typeDescription, classFileLocator);
                }
            }
            ,
            REDEFINE_DECLARED_ONLY{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.redefine(typeDescription, classFileLocator).ignoreAlso(LatentMatcher.ForSelfDeclaredMethod.NOT_DECLARED);
                }
            };


            public String toString() {
                return "AgentBuilder.TypeStrategy.Default." + this.name();
            }
        }
    }

    public static interface CircularityLock {
        public boolean acquire();

        public void release();

        public static class Default
        extends ThreadLocal<Boolean>
        implements CircularityLock {
            private static final Boolean NOT_ACQUIRED = null;

            @Override
            public boolean acquire() {
                if (this.get() == NOT_ACQUIRED) {
                    this.set(true);
                    return true;
                }
                return false;
            }

            @Override
            public void release() {
                this.set(NOT_ACQUIRED);
            }

            public String toString() {
                return "AgentBuilder.CircularityLock.Default{acquired=" + (this.get() != NOT_ACQUIRED) + "}";
            }
        }

        public static enum Inactive implements CircularityLock
        {
            INSTANCE;


            @Override
            public boolean acquire() {
                return true;
            }

            @Override
            public void release() {
            }

            public String toString() {
                return "AgentBuilder.CircularityLock.Inactive." + this.name();
            }
        }
    }

    public static interface Listener {
        public void onTransformation(TypeDescription var1, ClassLoader var2, JavaModule var3, DynamicType var4);

        public void onIgnored(TypeDescription var1, ClassLoader var2, JavaModule var3);

        public void onError(String var1, ClassLoader var2, JavaModule var3, Throwable var4);

        public void onComplete(String var1, ClassLoader var2, JavaModule var3);

        public static class Compound
        implements Listener {
            private final List<Listener> listeners = new ArrayList<Listener>();

            public Compound(Listener ... listener) {
                this(Arrays.asList(listener));
            }

            public Compound(List<? extends Listener> listeners) {
                for (Listener listener : listeners) {
                    if (listener instanceof Compound) {
                        this.listeners.addAll(((Compound)listener).listeners);
                        continue;
                    }
                    if (listener instanceof NoOp) continue;
                    this.listeners.add(listener);
                }
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
                for (Listener listener : this.listeners) {
                    listener.onTransformation(typeDescription, classLoader, module, dynamicType);
                }
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                for (Listener listener : this.listeners) {
                    listener.onIgnored(typeDescription, classLoader, module);
                }
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
                for (Listener listener : this.listeners) {
                    listener.onError(typeName, classLoader, module, throwable);
                }
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
                for (Listener listener : this.listeners) {
                    listener.onComplete(typeName, classLoader, module);
                }
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.listeners.equals(((Compound)other).listeners);
            }

            public int hashCode() {
                return this.listeners.hashCode();
            }

            public String toString() {
                return "AgentBuilder.Listener.Compound{listeners=" + this.listeners + '}';
            }
        }

        public static class ModuleReadEdgeCompleting
        extends Adapter {
            private final Instrumentation instrumentation;
            private final boolean addTargetEdge;
            private final Set<? extends JavaModule> modules;

            public ModuleReadEdgeCompleting(Instrumentation instrumentation, boolean addTargetEdge, Set<? extends JavaModule> modules) {
                this.instrumentation = instrumentation;
                this.addTargetEdge = addTargetEdge;
                this.modules = modules;
            }

            protected static Listener of(Instrumentation instrumentation, boolean addTargetEdge, Class<?> ... type) {
                HashSet<JavaModule> modules = new HashSet<JavaModule>();
                for (Class<?> aType : type) {
                    JavaModule module = JavaModule.ofType(aType);
                    if (!module.isNamed()) continue;
                    modules.add(module);
                }
                return modules.isEmpty() ? NoOp.INSTANCE : new ModuleReadEdgeCompleting(instrumentation, addTargetEdge, modules);
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
                if (module != null && module.isNamed()) {
                    for (JavaModule javaModule : this.modules) {
                        if (!module.canRead(javaModule)) {
                            module.addReads(this.instrumentation, javaModule);
                        }
                        if (!this.addTargetEdge || javaModule.canRead(module)) continue;
                        javaModule.addReads(this.instrumentation, module);
                    }
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ModuleReadEdgeCompleting that = (ModuleReadEdgeCompleting)object;
                return this.instrumentation.equals(that.instrumentation) && this.addTargetEdge == that.addTargetEdge && this.modules.equals(that.modules);
            }

            public int hashCode() {
                int result = this.instrumentation.hashCode();
                result = 31 * result + this.modules.hashCode();
                result = 31 * result + (this.addTargetEdge ? 1 : 0);
                return result;
            }

            public String toString() {
                return "AgentBuilder.Listener.ModuleReadEdgeCompleting{instrumentation=" + this.instrumentation + ", addTargetEdge=" + this.addTargetEdge + ", modules=" + this.modules + '}';
            }
        }

        public static class Filtering
        implements Listener {
            private final ElementMatcher<? super String> matcher;
            private final Listener delegate;

            public Filtering(ElementMatcher<? super String> matcher, Listener delegate) {
                this.matcher = matcher;
                this.delegate = delegate;
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
                if (this.matcher.matches(typeDescription.getName())) {
                    this.delegate.onTransformation(typeDescription, classLoader, module, dynamicType);
                }
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                if (this.matcher.matches(typeDescription.getName())) {
                    this.delegate.onIgnored(typeDescription, classLoader, module);
                }
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
                if (this.matcher.matches(typeName)) {
                    this.delegate.onError(typeName, classLoader, module, throwable);
                }
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
                if (this.matcher.matches(typeName)) {
                    this.delegate.onComplete(typeName, classLoader, module);
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Filtering filtering = (Filtering)object;
                return this.matcher.equals(filtering.matcher) && this.delegate.equals(filtering.delegate);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.delegate.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Listener.Filtering{matcher=" + this.matcher + ", delegate=" + this.delegate + '}';
            }
        }

        public static class StreamWriting
        implements Listener {
            protected static final String PREFIX = "[Byte Buddy]";
            private final PrintStream printStream;

            public StreamWriting(PrintStream printStream) {
                this.printStream = printStream;
            }

            public static Listener toSystemOut() {
                return new StreamWriting(System.out);
            }

            public static Listener toSystemError() {
                return new StreamWriting(System.err);
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
                this.printStream.printf("[Byte Buddy] TRANSFORM %s [%s, %s]%n", typeDescription.getName(), classLoader, module);
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                this.printStream.printf("[Byte Buddy] IGNORE %s [%s, %s]%n", typeDescription.getName(), classLoader, module);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
                PrintStream printStream = this.printStream;
                synchronized (printStream) {
                    this.printStream.printf("[Byte Buddy] ERROR %s [%s, %s]%n", typeName, classLoader, module);
                    throwable.printStackTrace(this.printStream);
                }
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
                this.printStream.printf("[Byte Buddy] COMPLETE %s [%s, %s]%n", typeName, classLoader, module);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.printStream.equals(((StreamWriting)other).printStream);
            }

            public int hashCode() {
                return this.printStream.hashCode();
            }

            public String toString() {
                return "AgentBuilder.Listener.StreamWriting{printStream=" + this.printStream + '}';
            }
        }

        public static abstract class Adapter
        implements Listener {
            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
            }
        }

        public static enum NoOp implements Listener
        {
            INSTANCE;


            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
            }

            public String toString() {
                return "AgentBuilder.Listener.NoOp." + this.name();
            }
        }
    }

    public static interface RawMatcher {
        public boolean matches(TypeDescription var1, ClassLoader var2, JavaModule var3, Class<?> var4, ProtectionDomain var5);

        public static class ForElementMatchers
        implements RawMatcher {
            private final ElementMatcher<? super TypeDescription> typeMatcher;
            private final ElementMatcher<? super ClassLoader> classLoaderMatcher;
            private final ElementMatcher<? super JavaModule> moduleMatcher;

            public ForElementMatchers(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                this.typeMatcher = typeMatcher;
                this.classLoaderMatcher = classLoaderMatcher;
                this.moduleMatcher = moduleMatcher;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.moduleMatcher.matches(module) && this.classLoaderMatcher.matches(classLoader) && this.typeMatcher.matches(typeDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.classLoaderMatcher.equals(((ForElementMatchers)other).classLoaderMatcher) && this.moduleMatcher.equals(((ForElementMatchers)other).moduleMatcher) && this.typeMatcher.equals(((ForElementMatchers)other).typeMatcher);
            }

            public int hashCode() {
                int result = this.typeMatcher.hashCode();
                result = 31 * result + this.classLoaderMatcher.hashCode();
                result = 31 * result + this.moduleMatcher.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.ForElementMatchers{typeMatcher=" + this.typeMatcher + ", classLoaderMatcher=" + this.classLoaderMatcher + ", moduleMatcher=" + this.moduleMatcher + '}';
            }
        }

        public static class Disjunction
        implements RawMatcher {
            private final RawMatcher left;
            private final RawMatcher right;

            protected Disjunction(RawMatcher left, RawMatcher right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.left.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) || this.right.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Disjunction that = (Disjunction)object;
                return this.left.equals(that.left) && this.right.equals(that.right);
            }

            public int hashCode() {
                int result = this.left.hashCode();
                result = 31 * result + this.right.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.Disjunction{left=" + this.left + ", right=" + this.right + '}';
            }
        }

        public static class Conjunction
        implements RawMatcher {
            private final RawMatcher left;
            private final RawMatcher right;

            protected Conjunction(RawMatcher left, RawMatcher right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.left.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) && this.right.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Conjunction that = (Conjunction)object;
                return this.left.equals(that.left) && this.right.equals(that.right);
            }

            public int hashCode() {
                int result = this.left.hashCode();
                result = 31 * result + this.right.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.Conjunction{left=" + this.left + ", right=" + this.right + '}';
            }
        }

        public static enum ForLoadState implements RawMatcher
        {
            LOADED(false),
            UNLOADED(true);

            private final boolean unloaded;

            private ForLoadState(boolean unloaded) {
                this.unloaded = unloaded;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return classBeingRedefined == null == this.unloaded;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.ForLoadState." + this.name();
            }
        }
    }

    public static interface Identified {
        public Extendable transform(Transformer var1);

        public static interface Extendable
        extends AgentBuilder,
        Identified {
            public AgentBuilder asDecorator();
        }

        public static interface Narrowable
        extends Matchable<Narrowable>,
        Identified {
        }
    }

    public static interface RedefinitionListenable
    extends AgentBuilder {
        public RedefinitionListenable with(RedefinitionStrategy.Listener var1);

        public static interface WithoutBatchStrategy
        extends RedefinitionListenable {
            public RedefinitionListenable with(RedefinitionStrategy.BatchAllocator var1);
        }
    }

    public static interface Ignored
    extends Matchable<Ignored>,
    AgentBuilder {
    }

    public static interface Matchable<T extends Matchable<T>> {
        public T and(ElementMatcher<? super TypeDescription> var1);

        public T and(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

        public T and(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

        public T and(RawMatcher var1);

        public T or(ElementMatcher<? super TypeDescription> var1);

        public T or(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

        public T or(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

        public T or(RawMatcher var1);

        public static abstract class AbstractBase<S extends Matchable<S>>
        implements Matchable<S> {
            @Override
            public S and(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.and(typeMatcher, ElementMatchers.any());
            }

            @Override
            public S and(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.and(typeMatcher, classLoaderMatcher, ElementMatchers.any());
            }

            @Override
            public S and(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return (S)this.and(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, moduleMatcher));
            }

            @Override
            public S or(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.or(typeMatcher, ElementMatchers.any());
            }

            @Override
            public S or(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.or(typeMatcher, classLoaderMatcher, ElementMatchers.any());
            }

            @Override
            public S or(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return (S)this.or(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, moduleMatcher));
            }
        }
    }
}

