/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;

public interface AsmVisitorWrapper {
    public static final int NO_FLAGS = 0;

    public int mergeWriter(int var1);

    public int mergeReader(int var1);

    public ClassVisitor wrap(TypeDescription var1, ClassVisitor var2, Implementation.Context var3, TypePool var4, FieldList<FieldDescription.InDefinedShape> var5, MethodList<?> var6, int var7, int var8);

    public static class Compound
    implements AsmVisitorWrapper {
        private final List<AsmVisitorWrapper> asmVisitorWrappers = new ArrayList<AsmVisitorWrapper>();

        public Compound(AsmVisitorWrapper ... asmVisitorWrapper) {
            this(Arrays.asList(asmVisitorWrapper));
        }

        public Compound(List<? extends AsmVisitorWrapper> asmVisitorWrappers) {
            for (AsmVisitorWrapper asmVisitorWrapper : asmVisitorWrappers) {
                if (asmVisitorWrapper instanceof Compound) {
                    this.asmVisitorWrappers.addAll(((Compound)asmVisitorWrapper).asmVisitorWrappers);
                    continue;
                }
                if (asmVisitorWrapper instanceof NoOp) continue;
                this.asmVisitorWrappers.add(asmVisitorWrapper);
            }
        }

        @Override
        public int mergeWriter(int flags) {
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                flags = asmVisitorWrapper.mergeWriter(flags);
            }
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                flags = asmVisitorWrapper.mergeReader(flags);
            }
            return flags;
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                classVisitor = asmVisitorWrapper.wrap(instrumentedType, classVisitor, implementationContext, typePool, fields, methods, writerFlags, readerFlags);
            }
            return classVisitor;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.asmVisitorWrappers.equals(((Compound)other).asmVisitorWrappers);
        }

        public int hashCode() {
            return this.asmVisitorWrappers.hashCode();
        }

        public String toString() {
            return "AsmVisitorWrapper.Compound{asmVisitorWrappers=" + this.asmVisitorWrappers + '}';
        }
    }

    public static class ForDeclaredMethods
    implements AsmVisitorWrapper {
        private final List<Entry> entries;
        private final int writerFlags;
        private final int readerFlags;

        public ForDeclaredMethods() {
            this(Collections.emptyList(), 0, 0);
        }

        protected ForDeclaredMethods(List<Entry> entries, int writerFlags, int readerFlags) {
            this.entries = entries;
            this.writerFlags = writerFlags;
            this.readerFlags = readerFlags;
        }

        public ForDeclaredMethods method(ElementMatcher<? super MethodDescription> matcher, MethodVisitorWrapper ... methodVisitorWrapper) {
            return this.method(matcher, Arrays.asList(methodVisitorWrapper));
        }

        public ForDeclaredMethods method(ElementMatcher<? super MethodDescription> matcher, List<? extends MethodVisitorWrapper> methodVisitorWrappers) {
            return new ForDeclaredMethods(CompoundList.of(this.entries, new Entry(matcher, methodVisitorWrappers)), this.writerFlags, this.readerFlags);
        }

        public ForDeclaredMethods writerFlags(int flags) {
            return new ForDeclaredMethods(this.entries, this.writerFlags | flags, this.readerFlags);
        }

        public ForDeclaredMethods readerFlags(int flags) {
            return new ForDeclaredMethods(this.entries, this.writerFlags, this.readerFlags | flags);
        }

        @Override
        public int mergeWriter(int flags) {
            return flags | this.writerFlags;
        }

        @Override
        public int mergeReader(int flags) {
            return flags | this.readerFlags;
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            return new DispatchingVisitor(classVisitor, instrumentedType, implementationContext, typePool, methods, writerFlags, readerFlags);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.writerFlags == ((ForDeclaredMethods)other).writerFlags && this.readerFlags == ((ForDeclaredMethods)other).readerFlags && this.entries.equals(((ForDeclaredMethods)other).entries);
        }

        public int hashCode() {
            int result = this.entries.hashCode();
            result = 31 * result + this.writerFlags;
            result = 31 * result + this.readerFlags;
            return result;
        }

        public String toString() {
            return "AsmVisitorWrapper.ForDeclaredMethods{entries=" + this.entries + ", writerFlags=" + this.writerFlags + ", readerFlags=" + this.readerFlags + '}';
        }

        protected class DispatchingVisitor
        extends ClassVisitor {
            private final TypeDescription instrumentedType;
            private final Implementation.Context implementationContext;
            private final TypePool typePool;
            private final int writerFlags;
            private final int readerFlags;
            private final Map<String, MethodDescription> knownMethods;

            protected DispatchingVisitor(ClassVisitor classVisitor, TypeDescription instrumentedType, Implementation.Context implementationContext, TypePool typePool, MethodList<?> methods, int writerFlags, int readerFlags) {
                super(327680, classVisitor);
                this.instrumentedType = instrumentedType;
                this.implementationContext = implementationContext;
                this.typePool = typePool;
                this.writerFlags = writerFlags;
                this.readerFlags = readerFlags;
                this.knownMethods = new HashMap<String, MethodDescription>();
                for (MethodDescription methodDescription : methods) {
                    this.knownMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
                }
            }

            @Override
            public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(modifiers, internalName, descriptor, signature, exceptions);
                MethodDescription methodDescription = this.knownMethods.get(internalName + descriptor);
                for (Entry entry : ForDeclaredMethods.this.entries) {
                    if (!entry.matches(methodDescription)) continue;
                    methodVisitor = entry.wrap(this.instrumentedType, methodDescription, methodVisitor, this.implementationContext, this.typePool, this.writerFlags, this.readerFlags);
                }
                return methodVisitor;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredMethods.DispatchingVisitor{instrumentedType=" + this.instrumentedType + ", knownMethods=" + this.knownMethods + ", implementationContext=" + this.implementationContext + ", typePool=" + this.typePool + ", writerFlags=" + this.writerFlags + ", readerFlags=" + this.readerFlags + '}';
            }
        }

        protected static class Entry
        implements ElementMatcher<MethodDescription>,
        MethodVisitorWrapper {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final List<? extends MethodVisitorWrapper> methodVisitorWrappers;

            protected Entry(ElementMatcher<? super MethodDescription> matcher, List<? extends MethodVisitorWrapper> methodVisitorWrappers) {
                this.matcher = matcher;
                this.methodVisitorWrappers = methodVisitorWrappers;
            }

            @Override
            public boolean matches(MethodDescription target) {
                return target != null && this.matcher.matches(target);
            }

            @Override
            public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
                for (MethodVisitorWrapper methodVisitorWrapper : this.methodVisitorWrappers) {
                    methodVisitor = methodVisitorWrapper.wrap(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, typePool, writerFlags, readerFlags);
                }
                return methodVisitor;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.matcher.equals(entry.matcher) && this.methodVisitorWrappers.equals(entry.methodVisitorWrappers);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.methodVisitorWrappers.hashCode();
                return result;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredMethods.Entry{matcher=" + this.matcher + ", methodVisitorWrappers=" + this.methodVisitorWrappers + '}';
            }
        }

        public static interface MethodVisitorWrapper {
            public MethodVisitor wrap(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, TypePool var5, int var6, int var7);
        }
    }

    public static class ForDeclaredFields
    extends AbstractBase {
        private final List<Entry> entries;

        public ForDeclaredFields() {
            this(Collections.emptyList());
        }

        protected ForDeclaredFields(List<Entry> entries) {
            this.entries = entries;
        }

        public ForDeclaredFields field(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, FieldVisitorWrapper ... fieldVisitorWrapper) {
            return this.field(matcher, Arrays.asList(fieldVisitorWrapper));
        }

        public ForDeclaredFields field(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, List<? extends FieldVisitorWrapper> fieldVisitorWrappers) {
            return new ForDeclaredFields(CompoundList.of(this.entries, new Entry(matcher, fieldVisitorWrappers)));
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            return new DispatchingVisitor(classVisitor, instrumentedType, fields);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((ForDeclaredFields)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "AsmVisitorWrapper.ForDeclaredFields{entries=" + this.entries + '}';
        }

        protected class DispatchingVisitor
        extends ClassVisitor {
            private final TypeDescription instrumentedType;
            private final Map<String, FieldDescription.InDefinedShape> knownFields;

            protected DispatchingVisitor(ClassVisitor classVisitor, TypeDescription instrumentedType, FieldList<FieldDescription.InDefinedShape> fields) {
                super(327680, classVisitor);
                this.instrumentedType = instrumentedType;
                this.knownFields = new HashMap<String, FieldDescription.InDefinedShape>();
                for (FieldDescription.InDefinedShape fieldDescription : fields) {
                    this.knownFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
                }
            }

            @Override
            public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String signature, Object defaultValue) {
                FieldVisitor fieldVisitor = super.visitField(modifiers, internalName, descriptor, signature, defaultValue);
                FieldDescription.InDefinedShape fieldDescription = this.knownFields.get(internalName + descriptor);
                for (Entry entry : ForDeclaredFields.this.entries) {
                    if (!entry.matches(fieldDescription)) continue;
                    fieldVisitor = entry.wrap(this.instrumentedType, fieldDescription, fieldVisitor);
                }
                return fieldVisitor;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredFields.DispatchingVisitor{instrumentedType=" + this.instrumentedType + ", knownFields=" + this.knownFields + '}';
            }
        }

        protected static class Entry
        implements ElementMatcher<FieldDescription.InDefinedShape>,
        FieldVisitorWrapper {
            private final ElementMatcher<? super FieldDescription.InDefinedShape> matcher;
            private final List<? extends FieldVisitorWrapper> fieldVisitorWrappers;

            protected Entry(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, List<? extends FieldVisitorWrapper> fieldVisitorWrappers) {
                this.matcher = matcher;
                this.fieldVisitorWrappers = fieldVisitorWrappers;
            }

            @Override
            public boolean matches(FieldDescription.InDefinedShape target) {
                return target != null && this.matcher.matches(target);
            }

            @Override
            public FieldVisitor wrap(TypeDescription instrumentedType, FieldDescription.InDefinedShape fieldDescription, FieldVisitor fieldVisitor) {
                for (FieldVisitorWrapper fieldVisitorWrapper : this.fieldVisitorWrappers) {
                    fieldVisitor = fieldVisitorWrapper.wrap(instrumentedType, fieldDescription, fieldVisitor);
                }
                return fieldVisitor;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.matcher.equals(entry.matcher) && this.fieldVisitorWrappers.equals(entry.fieldVisitorWrappers);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.fieldVisitorWrappers.hashCode();
                return result;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredFields.Entry{matcher=" + this.matcher + ", fieldVisitorWrappers=" + this.fieldVisitorWrappers + '}';
            }
        }

        public static interface FieldVisitorWrapper {
            public FieldVisitor wrap(TypeDescription var1, FieldDescription.InDefinedShape var2, FieldVisitor var3);
        }
    }

    public static abstract class AbstractBase
    implements AsmVisitorWrapper {
        @Override
        public int mergeWriter(int flags) {
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            return flags;
        }
    }

    public static enum NoOp implements AsmVisitorWrapper
    {
        INSTANCE;


        @Override
        public int mergeWriter(int flags) {
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            return flags;
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            return classVisitor;
        }

        public String toString() {
            return "AsmVisitorWrapper.NoOp." + this.name();
        }
    }
}

