/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.auto.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

final class ServicesFiles {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    static Set<String> readServiceFile(InputStream input) throws IOException {
        HashSet<String> serviceClasses = new HashSet<String>();
        try (InputStreamReader isr = new InputStreamReader(input, UTF_8);){
            HashSet<String> hashSet;
            try (BufferedReader r = new BufferedReader(isr);){
                String line;
                while ((line = r.readLine()) != null) {
                    int commentStart = line.indexOf(35);
                    if (commentStart >= 0) {
                        line = line.substring(0, commentStart);
                    }
                    if ((line = line.trim()).isEmpty()) continue;
                    serviceClasses.add(line);
                }
                hashSet = serviceClasses;
            }
            return hashSet;
        }
    }

    static void writeServiceFile(Collection<String> services, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF_8));
        for (String service : services) {
            writer.write(service);
            writer.newLine();
        }
        writer.flush();
    }

    private ServicesFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

