/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.HexUtil;
import org.springframework.lang.Nullable;

public final class DigestUtil {
    public static byte[] md5(byte[] bytes) {
        return DigestUtil.digest("MD5", bytes);
    }

    public static byte[] md5(String data) {
        return DigestUtil.md5(data.getBytes(Charsets.UTF_8));
    }

    public static String md5Hex(String data) {
        return DigestUtil.encodeHex(DigestUtil.md5(data));
    }

    public static String md5Hex(byte[] bytes) {
        return DigestUtil.encodeHex(DigestUtil.md5(bytes));
    }

    public static byte[] sha1(String data) {
        return DigestUtil.sha1(data.getBytes(Charsets.UTF_8));
    }

    public static byte[] sha1(byte[] bytes) {
        return DigestUtil.digest("SHA-1", bytes);
    }

    public static String sha1Hex(String data) {
        return DigestUtil.encodeHex(DigestUtil.sha1(data.getBytes(Charsets.UTF_8)));
    }

    public static String sha1Hex(byte[] bytes) {
        return DigestUtil.encodeHex(DigestUtil.sha1(bytes));
    }

    public static byte[] sha224(String data) {
        return DigestUtil.sha224(data.getBytes(Charsets.UTF_8));
    }

    public static byte[] sha224(byte[] bytes) {
        return DigestUtil.digest("SHA-224", bytes);
    }

    public static String sha224Hex(String data) {
        return DigestUtil.encodeHex(DigestUtil.sha224(data.getBytes(Charsets.UTF_8)));
    }

    public static String sha224Hex(byte[] bytes) {
        return DigestUtil.encodeHex(DigestUtil.sha224(bytes));
    }

    public static byte[] sha256(String data) {
        return DigestUtil.sha256(data.getBytes(Charsets.UTF_8));
    }

    public static byte[] sha256(byte[] bytes) {
        return DigestUtil.digest("SHA-256", bytes);
    }

    public static String sha256Hex(String data) {
        return DigestUtil.encodeHex(DigestUtil.sha256(data.getBytes(Charsets.UTF_8)));
    }

    public static String sha256Hex(byte[] bytes) {
        return DigestUtil.encodeHex(DigestUtil.sha256(bytes));
    }

    public static byte[] sha384(String data) {
        return DigestUtil.sha384(data.getBytes(Charsets.UTF_8));
    }

    public static byte[] sha384(byte[] bytes) {
        return DigestUtil.digest("SHA-384", bytes);
    }

    public static String sha384Hex(String data) {
        return DigestUtil.encodeHex(DigestUtil.sha384(data.getBytes(Charsets.UTF_8)));
    }

    public static String sha384Hex(byte[] bytes) {
        return DigestUtil.encodeHex(DigestUtil.sha384(bytes));
    }

    public static byte[] sha512(String data) {
        return DigestUtil.sha512(data.getBytes(Charsets.UTF_8));
    }

    public static byte[] sha512(byte[] bytes) {
        return DigestUtil.digest("SHA-512", bytes);
    }

    public static String sha512Hex(String data) {
        return DigestUtil.encodeHex(DigestUtil.sha512(data.getBytes(Charsets.UTF_8)));
    }

    public static String sha512Hex(byte[] bytes) {
        return DigestUtil.encodeHex(DigestUtil.sha512(bytes));
    }

    public static byte[] digest(String algorithm, byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            return md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String digestHex(String algorithm, byte[] bytes) {
        return DigestUtil.encodeHex(DigestUtil.digest(algorithm, bytes));
    }

    public static byte[] hmacMd5(String data, String key) {
        return DigestUtil.hmacMd5(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacMd5(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacMD5", bytes, key);
    }

    public static String hmacMd5Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacMd5(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacMd5Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacMd5(bytes, key));
    }

    public static byte[] hmacSha1(String data, String key) {
        return DigestUtil.hmacSha1(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha1(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA1", bytes, key);
    }

    public static String hmacSha1Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha1(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha1Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha1(bytes, key));
    }

    public static byte[] hmacSha224(String data, String key) {
        return DigestUtil.hmacSha224(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha224(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA224", bytes, key);
    }

    public static String hmacSha224Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha224(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha224Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha224(bytes, key));
    }

    public static byte[] hmacSha256(String data, String key) {
        return DigestUtil.hmacSha256(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha256(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA256", bytes, key);
    }

    public static String hmacSha256Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha256(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha256Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha256(bytes, key));
    }

    public static byte[] hmacSha384(String data, String key) {
        return DigestUtil.hmacSha384(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha384(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA384", bytes, key);
    }

    public static String hmacSha384Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha384(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha384Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha384(bytes, key));
    }

    public static byte[] hmacSha512(String data, String key) {
        return DigestUtil.hmacSha512(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha512(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA512", bytes, key);
    }

    public static String hmacSha512Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha512(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha512Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha512(bytes, key));
    }

    public static String digestHmacHex(String algorithm, byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.digestHmac(algorithm, bytes, key));
    }

    public static byte[] digestHmac(String algorithm, byte[] bytes, String key) {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(Charsets.UTF_8), algorithm);
        try {
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return mac.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String encodeHex(byte[] bytes) {
        return HexUtil.encodeToString(bytes);
    }

    public static byte[] decodeHex(String hexStr) {
        return HexUtil.decode(hexStr);
    }

    public static boolean slowEquals(@Nullable String a, @Nullable String b) {
        if (a == null || b == null) {
            return false;
        }
        return DigestUtil.slowEquals(a.getBytes(Charsets.UTF_8), b.getBytes(Charsets.UTF_8));
    }

    public static boolean slowEquals(@Nullable byte[] a, @Nullable byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    private DigestUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

