/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.dreamlu.mica.core.utils.BeanUtil;
import org.springframework.beans.BeansException;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public final class ReflectUtil
extends ReflectionUtils {
    public static PropertyDescriptor[] getBeanGetters(Class type) {
        return ReflectUtil.getPropertyDescriptors(type, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class type) {
        return ReflectUtil.getPropertyDescriptors(type, false, true);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class type, boolean read, boolean write) {
        try {
            PropertyDescriptor[] all = BeanUtil.getPropertyDescriptors((Class)type);
            if (read && write) {
                return all;
            }
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(all.length);
            for (PropertyDescriptor pd : all) {
                if (read && pd.getReadMethod() != null) {
                    properties.add(pd);
                    continue;
                }
                if (!write || pd.getWriteMethod() == null) continue;
                properties.add(pd);
            }
            return properties.toArray(new PropertyDescriptor[0]);
        }
        catch (BeansException ex) {
            throw new CodeGenerationException((Throwable)ex);
        }
    }

    @Nullable
    public static Property getProperty(Class<?> propertyType, String propertyName) {
        PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(propertyType, (String)propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        return ReflectUtil.getProperty(propertyType, propertyDescriptor, propertyName);
    }

    public static Property getProperty(Class<?> propertyType, PropertyDescriptor propertyDescriptor, String propertyName) {
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        return new Property(propertyType, readMethod, writeMethod, propertyName);
    }

    @Nullable
    public static TypeDescriptor getTypeDescriptor(Class<?> propertyType, String propertyName) {
        Property property = ReflectUtil.getProperty(propertyType, propertyName);
        if (property == null) {
            return null;
        }
        return new TypeDescriptor(property);
    }

    public static TypeDescriptor getTypeDescriptor(Class<?> propertyType, PropertyDescriptor propertyDescriptor, String propertyName) {
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        Property property = new Property(propertyType, readMethod, writeMethod, propertyName);
        return new TypeDescriptor(property);
    }

    @Nullable
    public static Field getField(Class<?> clazz, String fieldName) {
        while (clazz != Object.class) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    @Nullable
    public static <T extends Annotation> T getAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        Field field = ReflectUtil.getField(clazz, fieldName);
        if (field == null) {
            return null;
        }
        return field.getAnnotation(annotationClass);
    }

    public static void setField(Field field, @Nullable Object target, @Nullable Object value) {
        ReflectUtil.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }

    @Nullable
    public static Object getField(Field field, @Nullable Object target) {
        ReflectUtil.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }

    @Nullable
    public static Object getField(String fieldName, @Nullable Object target) {
        if (target == null) {
            return null;
        }
        Class<?> targetClass = target.getClass();
        Field field = ReflectUtil.getField(targetClass, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(fieldName + " not in" + targetClass);
        }
        return ReflectUtil.getField(field, target);
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object target) {
        return ReflectUtil.invokeMethod(method, target, new Object[0]);
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object target, Object ... args) {
        ReflectUtil.makeAccessible((Method)method);
        return ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])args);
    }

    private ReflectUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

