/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.convert;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.dreamlu.mica.core.function.CheckedFunction;
import net.dreamlu.mica.core.utils.CollectionUtil;
import net.dreamlu.mica.core.utils.ConvertUtil;
import net.dreamlu.mica.core.utils.ReflectUtil;
import net.dreamlu.mica.core.utils.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.core.Converter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class MicaConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(MicaConverter.class);
    private static final ConcurrentMap<String, TypeDescriptor> TYPE_CACHE = new ConcurrentHashMap<String, TypeDescriptor>();
    private final Class<?> sourceClazz;
    private final Class<?> targetClazz;

    @Nullable
    public Object convert(@Nullable Object value, Class target, Object fieldName) {
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue((Class)target, (Object)value)) {
            return value;
        }
        try {
            TypeDescriptor targetDescriptor = MicaConverter.getTypeDescriptor(this.targetClazz, (String)fieldName);
            if (Map.class.isAssignableFrom(this.sourceClazz)) {
                return ConvertUtil.convert(value, targetDescriptor);
            }
            TypeDescriptor sourceDescriptor = MicaConverter.getTypeDescriptor(this.sourceClazz, (String)fieldName);
            return ConvertUtil.convert(value, sourceDescriptor, targetDescriptor);
        }
        catch (Throwable e) {
            log.warn("MicaConverter error", e);
            return null;
        }
    }

    private static TypeDescriptor getTypeDescriptor(Class<?> clazz, String fieldName) {
        String srcCacheKey = clazz.getName() + fieldName;
        CheckedFunction<String, TypeDescriptor> uncheckedFunction = key -> {
            Field field = ReflectUtil.getField(clazz, fieldName);
            if (field == null) {
                throw new NoSuchFieldException(fieldName);
            }
            return new TypeDescriptor(field);
        };
        return CollectionUtil.computeIfAbsent(TYPE_CACHE, srcCacheKey, Unchecked.function(uncheckedFunction));
    }

    public MicaConverter(Class<?> sourceClazz, Class<?> targetClazz) {
        this.sourceClazz = sourceClazz;
        this.targetClazz = targetClazz;
    }
}

