/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import net.dreamlu.mica.core.io.FastStringPrintWriter;

public class Exceptions {
    public static RuntimeException unchecked(Throwable e) {
        if (e instanceof Error) {
            Error error = (Error)e;
            throw error;
        }
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            InvocationTargetException exception = (InvocationTargetException)e;
            return (RuntimeException)Exceptions.runtime(exception.getTargetException());
        }
        if (e instanceof RuntimeException) {
            RuntimeException exception = (RuntimeException)e;
            return exception;
        }
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return (RuntimeException)Exceptions.runtime(e);
    }

    private static <T extends Throwable> T runtime(Throwable throwable) throws T {
        throw throwable;
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                InvocationTargetException exception = (InvocationTargetException)unwrapped;
                unwrapped = exception.getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            UndeclaredThrowableException exception = (UndeclaredThrowableException)unwrapped;
            unwrapped = exception.getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static String getStackTraceAsString(Throwable ex) {
        FastStringPrintWriter printWriter = new FastStringPrintWriter(512);
        ex.printStackTrace(printWriter);
        return printWriter.toString();
    }
}

